// ImageSearchDLL.h
// Header file for ImageSearchDLL.lib
// Author: Dao Van Trong - TRONG.PRO
// Last Updated: 2025-10-15

#ifndef IMAGESEARCHDLL_H
#define IMAGESEARCHDLL_H

#include <windows.h>

#ifdef IMAGESEARCHDLL_EXPORTS
#define IMAGESEARCHDLL_API __declspec(dllexport)
#else
#define IMAGESEARCHDLL_API __declspec(dllimport)
#endif

#ifdef __cplusplus
extern "C" {
#endif

// Mouse click on screen coordinates
IMAGESEARCHDLL_API int WINAPI ImageSearch_MouseClick(
    const wchar_t* sButton,
    int iX,
    int iY,
    int iClicks,
    int iSpeed,
    int iScreen
);

// Mouse click relative to window
IMAGESEARCHDLL_API int WINAPI ImageSearch_MouseClickWin(
    const wchar_t* sTitle,
    const wchar_t* sText,
    int iX,
    int iY,
    const wchar_t* sButton,
    int iClicks,
    int iSpeed
);

// Search for image on screen
IMAGESEARCHDLL_API const wchar_t* WINAPI ImageSearch(
    const wchar_t* sImageFile,
    int iLeft = 0,
    int iTop = 0,
    int iRight = 0,
    int iBottom = 0,
    int iScreen = 0,
    int iTolerance = 10,
    int iResults = 1,
    int iCenterPOS = 1,
    float fMinScale = 1.0f,
    float fMaxScale = 1.0f,
    float fScaleStep = 0.1f,
    int iReturnDebug = 0
);

// Search for image within another image file
IMAGESEARCHDLL_API const wchar_t* WINAPI ImageSearch_InImage(
    const wchar_t* sSourceImageFile,
    const wchar_t* sTargetImageFile,
    int iTolerance = 10,
    int iResults = 1,
    int iCenterPOS = 1,
    float fMinScale = 1.0f,
    float fMaxScale = 1.0f,
    float fScaleStep = 0.1f,
    int iReturnDebug = 0
);

// Search for image in HBITMAP
IMAGESEARCHDLL_API const wchar_t* WINAPI ImageSearch_hBitmap(
    HBITMAP hBitmapSource,
    HBITMAP hBitmapTarget,
    int iTolerance,
    int iLeft,
    int iTop,
    int iRight,
    int iBottom,
    int iResults = 1,
    int iCenter = 1,
    float fMinScale = 1.0f,
    float fMaxScale = 1.0f,
    float fScaleStep = 0.1f,
    int iReturnDebug = 0
);

// Capture screen region to HBITMAP
IMAGESEARCHDLL_API HBITMAP WINAPI ImageSearch_CaptureScreen(
    int iLeft = 0,
    int iTop = 0,
    int iRight = 0,
    int iBottom = 0,
    int iScreen = 0
);

// Load image file to HBITMAP with optional background color
IMAGESEARCHDLL_API HBITMAP WINAPI ImageSearch_hBitmapLoad(
    const wchar_t* sImageFile, 
    int iAlpha = 0,
    int iRed = 0,
    int iGreen = 0,
    int iBlue = 0
);

// Clear internal caches
IMAGESEARCHDLL_API void WINAPI ImageSearch_ClearCache();

// Get DLL version string
IMAGESEARCHDLL_API const wchar_t* WINAPI ImageSearch_GetVersion();

// Get system and CPU info
IMAGESEARCHDLL_API const wchar_t* WINAPI ImageSearch_GetSysInfo();

#ifdef __cplusplus
}
#endif

#endif // IMAGESEARCHDLL_H