#NoTrayIcon
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Outfile_x64=ClipBoard-ImageMonitoring.exe
#AutoIt3Wrapper_UseX64=y
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
;modified code from https://www.autoitscript.com/forum/topic/57053-updating-a-picture-control-without-a-file/?do=findComment&comment=514735
;#include <ScreenCapture.au3>
#include "GUIScrollbars_Ex.au3" ;https : / / www.autoitscript.com / forum / topic / 113723 - scrollbars - made - easy - new - version - 27 - jan - 22 /
#include "GUIScrollbars_Size.au3" ;https : / / www.autoitscript.com / forum / topic / 113723 - scrollbars - made - easy - new - version - 27 - jan - 22 /
#include <Array.au3>
#include <ButtonConstants.au3>
#include <Clipboard.au3>
#include <ComboConstants.au3>
#include <EditConstants.au3>
#include <GDIPlus.au3>
#include <GUIConstantsEx.au3>
#include <GuiListBox.au3>
#include <GuiMenu.au3>
#include <ListBoxConstants.au3>
#include <Misc.au3>
#include <SendMessage.au3>
#include <StaticConstants.au3>
#include <String.au3>
#include <StructureConstants.au3>
#include <WinAPIHObj.au3>
#include <WindowsConstants.au3>

Global $draw = 0, $hCanvas = 0
Global $autoAdd = 0
Global $mouseGX = -1, $mouseGY = -1
Global $fScale = 1.0
GUIRegisterMsg($WM_MOUSEWHEEL, "WM_MOUSEWHEEL") ;to resize image with mouse wheel

Global $colors[] = ["ff0000", "00FF00", "0000FF", "ffFFFF", "000000", "808080", "FFFF00", "FF00FF"]

Opt("GUIResizeMode", BitOR($GUI_DOCKWIDTH, $GUI_DOCKHEIGHT, $GUI_DOCKBOTTOM, $Gui_DOCKLEFT))
Opt("TrayMenuMode", 1)
Opt("TrayAutoPause", 0)

;Check if @scriptdir has a \, add it if not
$tmp = "\"
If StringRight(@ScriptDir, 1) = "\" Then $tmp = ""
Global $iniFile = @ScriptDir & $tmp & "ClipBoard-ImageMonitor.ini"      ;Prepare the ini file
Global $Foldername = @ScriptDir & $tmp & "IMG_"            ;Prepare the Folder names
Global $FNMax = 2                        ;Foldername maximum characters
Local $fnamelength = 3                    ;Length of the filenames (needed to read them into listbox)
$tmp = ""

Global $IdDel = 1000

Global $aFmt[][] = [["PNG", 0], ["JPG", 0], ["BMP", 0], ["GIF", 0], ["TIFF", 0]]
Global $DefaultMenuTypeFMT = IniRead($iniFile, "setting", "MenuFormatType", 0)

Global $aSaveSet[16][2]
Global $DefaultMenuSaveSet = IniRead($iniFile, "setting", "MenuSaveSetNr", 0)

Global $btnmax = IniRead($iniFile, "setting", "NumberOfButtons", 50)
If $btnmax < 2 Then $btnmax = 2
Global $CBTN[$btnmax][2]

Global $displayinfo = IniRead($iniFile, "setting", "DisplayInfo", 1)    ;0 = in the title, 1 = in the menue
If $displayinfo < 0 Or $displayinfo > 1 Then $displayinfo = 0

Global $hGUI = GUICreate("Clipboard Monitor", 450, 340, -1, -1, BitOR($WS_MAXIMIZEBOX, $WS_MINIMIZEBOX, $WS_SIZEBOX), $WS_EX_ACCEPTFILES)

Global $GUIMINWID = 450, $GUIMINHT = 250 ;set your restrictions here
GUIRegisterMsg($WM_GETMINMAXINFO, "WM_GETMINMAXINFO")


$idMenuFile = GUICtrlCreateMenu("File")
$idMenuOpenFolder = GUICtrlCreateMenuItem("Open the image Folder in File Explorer", $idMenuFile)
GUICtrlCreateMenuItem("", $idMenuFile)
$idMenuSave = GUICtrlCreateMenuItem("Save Images (overwrite)", $idMenuFile)
$idMenuSaveContinuously = GUICtrlCreateMenuItem("Save Images (add numbers) ", $idMenuFile)
GUICtrlCreateMenuItem("", $idMenuFile)
$idMenuSaveCurrent = GUICtrlCreateMenuItem("Save Current Image", $idMenuFile)
GUICtrlCreateMenuItem("", $idMenuFile)
$idMenuIniExample = GUICtrlCreateMenuItem("Ini example", $idMenuFile)
$idMenuIniEdit = GUICtrlCreateMenuItem("Edit the Ini file (usable after restart)", $idMenuFile)
GUICtrlCreateMenuItem("", $idMenuFile)
$idMenuExit = GUICtrlCreateMenuItem("Exit", $idMenuFile)

$idMenuOptions = GUICtrlCreateMenu("Options")
For $x = 0 To UBound($aFmt) - 1
	$aFmt[$x][1] = GUICtrlCreateMenuItem($aFmt[$x][0], $idMenuOptions, $idMenuSave, 1)
	If $x = $DefaultMenuTypeFMT Then GUICtrlSetState(-1, $gui_checked)
Next
GUICtrlCreateMenuItem("", $idMenuOptions)
$idMenuClearButtons = GUICtrlCreateMenuItem("Clear Buttons", $idMenuOptions)

GUICtrlCreateMenuItem("", $idMenuOptions)
$idMenuGuiOnTop = GUICtrlCreateMenuItem("Gui on TOP", $idMenuOptions)
GUICtrlCreateMenuItem("", $idMenuOptions)
$idBugFixMenuMain = GUICtrlCreateMenu("Bugfix", $idMenuOptions)
$idBugFixMenu = GUICtrlCreateMenuItem("Reassign as viewer", $idBugFixMenuMain)

$idMenuSet = GUICtrlCreateMenu("Image Set")
For $x = 0 To UBound($aSaveSet) - 1
	$tmp = _StringRepeat("0", $FNMax - StringLen($x)) & $x
	$aSaveSet[$x][0] = $tmp
	$tmp = ""
	If FileExists($Foldername & $aSaveSet[$x][0] & "\") = 0 Then $tmp = " (New)"
	$aSaveSet[$x][1] = GUICtrlCreateMenuItem($aSaveSet[$x][0] & $tmp, $idMenuSet, -1, 1)
	If $x = $DefaultMenuSaveSet Then GUICtrlSetState(-1, $gui_checked)
Next
$tmp = ""
$mDummymenu = GUICtrlCreateMenu("this menu control will be deleted")
$idMenuInfo = GUICtrlCreateMenuItem(" ", -1, -1, 1)
GUICtrlDelete($mDummymenu) ; <======================



;Create a child window which will get the scrollbar
Local $hChild = GUICreate("Scroll area", 628, 48, 0, 0, $WS_POPUP, $WS_EX_MDICHILD, $hGUI)

GUISwitch($hChild)
;Create Buttons
For $x = 0 To ($btnmax - 1)
	$CBTN[$x][0] = GUICtrlCreateButton($x, 1 + ($x * 21), 1, 21, 25)
	GUICtrlSetBkColor(-1, "0xFF7070")
Next

GUICtrlSetTip($CBTN[0][0], "A Copy of the last captured Image")
$WPos = WinGetPos($hGUI)
WinMove($hChild, "", $WPos[0] + 13, $WPos[1] + 54, $WPos[2] - 24, 54)
$WPos = ""
_GUIScrollbars_Generate($hChild, (($btnmax) * 21), 30)
GUISetState(@SW_SHOW, $hChild)
GUISwitch($hGUI)

$hListBox = GUICtrlCreateList("", 1, 60, 80, 220, BitOR($LBS_NOTIFY, $WS_VSCROLL, $WS_BORDER))
GUICtrlSetResizing(-1, BitOR($GUI_DOCKLEFT, $GUI_DOCKTOP, $GUI_DOCKBOTTOM, $GUI_DOCKWIDTH))
$hWndListBox = GUICtrlGetHandle($hListBox)

Local $idLabel = GUICtrlCreateLabel(@CRLF & @CRLF & @CRLF & @CRLF & @CRLF & @CRLF & @CRLF & "Drag and Drop files here", 85, 60, 360, 214, BitOR($WS_BORDER, $SS_SUNKEN, $SS_CENTER))
GUICtrlSetResizing(-1, BitOR($GUI_DOCKLEFT, $GUI_DOCKTOP, $GUI_DOCKBOTTOM, $GUI_DOCKBORDERS))
GUICtrlSetState($idLabel, $GUI_DROPACCEPTED)

$BtnRefresh = GUICtrlCreateButton("Refresh list", 3, 275, 57, 20)

$BtnAutoAdd = GUICtrlCreateButton(" ", 63, 275, 17, 20)
GUICtrlSetTip($BtnAutoAdd, "Turn on auto add images to the buttons", "Function")
GUICtrlSetBkColor($BtnAutoAdd, "0xFF0000")

$BtnRotL = GUICtrlCreateButton("RL", 85, 275, 25, 20)
GUICtrlSetTip($BtnRotL, "Rotate Left", "Image")
$BtnRotR = GUICtrlCreateButton("RR", 110, 275, 25, 20)
GUICtrlSetTip($BtnRotR, "Rotate Right", "Image")
$BtnFlip = GUICtrlCreateButton("Flip", 135, 275, 26, 20)
GUICtrlSetTip($BtnFlip, "Flip (Upside down)", "Image")
$BtnMirror = GUICtrlCreateButton("Mirror", 162, 275, 38, 20)
GUICtrlSetTip($BtnMirror, "Mirror (Left Right)", "Image")
$BtnResetIt = GUICtrlCreateButton("Redraw", 203, 275, 41, 20)
GUICtrlSetTip($BtnResetIt, "Redraw and Reset Zoom", "Image")

$BtnToClipBoard = GUICtrlCreateButton("Copy", 249, 275, 40, 20)
GUICtrlSetTip($BtnToClipBoard, "Copy to clipboard", "Image")

$BtnDraw = GUICtrlCreateButton("Draw", 293, 275, 35, 20)
GUICtrlSetTip($BtnDraw, "Turn the drawing mode on" & @CRLF & "On: Draw" & @CRLF & "Off: Zoom with mouse wheel" & @CRLF & "Drawing with the Right mouse button locks on the horizontal" & @CRLF & "Hold ctrl to switch to the vertical lock", "Paint")

$BtnCDisp = GUICtrlCreateButton("", 330, 275, 14, 20, BitOR($BS_FLAT, $BS_Bitmap))
GUICtrlSetTip($BtnCDisp, "Current drawing color" & @CRLF & "Click to select a color", "Paint")

$BtnCRed = GUICtrlCreateButton(" ", 347, 273, 14, 11, BitOR($BS_FLAT, $BS_Bitmap))
GUICtrlSetTip(-1, "Select this color", "Paint")

$BtnCGreen = GUICtrlCreateButton(" ", 362, 273, 14, 11, BitOR($BS_FLAT, $BS_Bitmap))
GUICtrlSetTip(-1, "Select this color", "Paint")

$BtnCBlue = GUICtrlCreateButton(" ", 377, 273, 14, 11, BitOR($BS_FLAT, $BS_Bitmap))
GUICtrlSetTip(-1, "Select this color", "Paint")

$BtnCYellow = GUICtrlCreateButton(" ", 393, 273, 14, 11, BitOR($BS_FLAT, $BS_Bitmap))
GUICtrlSetTip(-1, "Select this color", "Paint")

$BtnCWhite = GUICtrlCreateButton(" ", 347, 284, 14, 11, BitOR($BS_FLAT, $BS_Bitmap))
GUICtrlSetTip(-1, "Select this color", "Paint")

$BtnCBlack = GUICtrlCreateButton(" ", 362, 284, 14, 11, BitOR($BS_FLAT, $BS_Bitmap))
GUICtrlSetTip(-1, "Select this color", "Paint")

$BtnCGray = GUICtrlCreateButton(" ", 377, 284, 14, 11, BitOR($BS_FLAT, $BS_Bitmap))
GUICtrlSetTip(-1, "Select this color", "Paint")

$BtnCCustom = GUICtrlCreateButton(" ", 393, 284, 14, 11, BitOR($BS_FLAT, $BS_Bitmap))
GUICtrlSetTip(-1, "Select this color" & @CRLF & "Custom Selected color", "Paint")


GUICtrlSetBkColor($BtnCRed, Int("0x" & $colors[0]))
GUICtrlSetBkColor($BtnCGreen, Int("0x" & $colors[1]))
GUICtrlSetBkColor($BtnCBlue, Int("0x" & $colors[2]))
GUICtrlSetBkColor($BtnCWhite, Int("0x" & $colors[3]))
GUICtrlSetBkColor($BtnCBlack, Int("0x" & $colors[4]))
GUICtrlSetBkColor($BtnCGray, Int("0x" & $colors[5]))
GUICtrlSetBkColor($BtnCYellow, Int("0x" & $colors[6]))
GUICtrlSetBkColor($BtnCCustom, Int("0x" & $colors[7]))

$SizeCombo = GUICtrlCreateCombo("", 409, 273, 35, 20, $CBS_DROPDOWNLIST)
GUICtrlSetData($SizeCombo, "1|2|3|4|5|6|7|8|9|10|11|12|13|14|15|16|17|18|19|20", "1")
GUICtrlSetTip($SizeCombo, "Brush size", "Paint")
;Create listbox contextmenu
$hMenu = _GUICtrlMenu_CreatePopup()
_GUICtrlMenu_InsertMenuItem($hMenu, 0, "Delete", $IdDel)
GUIRegisterMsg($WM_CONTEXTMENU, "WM_CONTEXTMENU")

GUISetState()

If IniRead($iniFile, "setting", "WinOnTop", 0) = 1 Then
	GUICtrlSetState($idMenuGuiOnTop, $GUI_CHECKED)
	WinSetOnTop($hGUI, "", 1)
	WinActivate($hGUI)
EndIf

Global $hImage
Local $anmsg

;~ If Not _ClipBoard_IsFormatAvailable($CF_BITMAP) Then
;~     Send("{printscreen}")
;~ EndIf

Global $g_hNext = _ClipBoard_SetViewer($hGUI)
GUIRegisterMsg($WM_CHANGECBCHAIN, "WM_CHANGECBCHAIN")
GUIRegisterMsg($WM_DRAWCLIPBOARD, "WM_DRAWCLIPBOARD")

_GDIPlus_Startup()

;Global $hPen = _GDIPlus_PenCreate(int("0xFF" & $colors[2])) ;create a red pen (ARGB format)
Global $hBru = _GDIPlus_BrushCreateSolid(Int("0xFF" & $colors[2]))
GUICtrlSetBkColor($BtnCDisp, Int("0x" & $colors[2]))

ClipDrawBitmap()
PopulateListBox($DefaultMenuSaveSet)

UpdateTitle()
UpdateDraw()

GUIRegisterMsg($WM_COMMAND, "WM_COMMAND")
$sLastSel = ""
$fAction = 0

_Base64String(True)

Local $tmplockx

While 1

	$nMsg = GUIGetMsg()
	Switch $nMsg
		Case $BtnCRed
			GUICtrlSetBkColor($BtnCDisp, Int("0x" & $colors[0]))
			_GDIPlus_BrushSetSolidColor($hBru, Int("0xFF" & $colors[0]))
		Case $BtnCGreen
			GUICtrlSetBkColor($BtnCDisp, Int("0x" & $colors[1]))
			_GDIPlus_BrushSetSolidColor($hBru, Int("0xFF" & $colors[1]))
		Case $BtnCBlue
			GUICtrlSetBkColor($BtnCDisp, Int("0x" & $colors[2]))
			_GDIPlus_BrushSetSolidColor($hBru, Int("0xFF" & $colors[2]))
		Case $BtnCWhite
			GUICtrlSetBkColor($BtnCDisp, Int("0x" & $colors[3]))
			_GDIPlus_BrushSetSolidColor($hBru, Int("0xFF" & $colors[3]))
		Case $BtnCBlack
			GUICtrlSetBkColor($BtnCDisp, Int("0x" & $colors[4]))
			_GDIPlus_BrushSetSolidColor($hBru, Int("0xFF" & $colors[4]))
		Case $BtnCGray
			GUICtrlSetBkColor($BtnCDisp, Int("0x" & $colors[5]))
			_GDIPlus_BrushSetSolidColor($hBru, Int("0xFF" & $colors[5]))
		Case $BtnCYellow
			GUICtrlSetBkColor($BtnCDisp, Int("0x" & $colors[6]))
			_GDIPlus_BrushSetSolidColor($hBru, Int("0xFF" & $colors[6]))
		Case $BtnCCustom
			GUICtrlSetBkColor($BtnCDisp, Int("0x" & $colors[7]))
			_GDIPlus_BrushSetSolidColor($hBru, Int("0xFF" & $colors[7]))
		Case $BtnCDisp
			$tmp = _ChooseColor(2, Int("0x" & $colors[7]))
			If @error = 0 Then
				$colors[7] = StringReplace($tmp, "0x", "")
				ConsoleWrite($colors[7] & @CRLF)
				GUICtrlSetBkColor($BtnCCustom, Int("0x" & $colors[7]))
				GUICtrlSetBkColor($BtnCDisp, Int("0x" & $colors[7]))
				_GDIPlus_BrushSetSolidColor($hBru, Int("0xFF" & $colors[7]))
			EndIf
		Case $BtnDraw
			If $hImage > 0 Then
				$draw = Mod($draw + 1, 2)
			Else
				$draw = 0
			EndIf
			UpdateDraw()
			Sleep(50)
		Case $BtnToClipBoard
			_Bitmap2Clipboard()
		Case $BtnResetIt
			$fScale = 1.0
			ReDrawBitmap()
		Case $BtnFlip
			_GDIPlus_ImageRotateFlip($hImage, 2)
			_GDIPlus_ImageRotateFlip($hImage, 4)
			UpdateDraw(1)
		Case $BtnMirror
			_GDIPlus_ImageRotateFlip($hImage, 4)
			UpdateDraw(1)
		Case $BtnRotL
			_GDIPlus_ImageRotateFlip($hImage, 3)
			UpdateDraw(1)
		Case $BtnRotR
			_GDIPlus_ImageRotateFlip($hImage, 1)
			UpdateDraw(1)
		Case $GUI_EVENT_DROPPED
			; If the value of @GUI_DropId is $idLabel, then set the label of the dragged file.
			If @GUI_DropId = $idLabel Then
				LoadDroppedImage(@GUI_DragFile)
				UpdateDraw(1)
			EndIf
		Case $idBugFixMenu
			Bugfix()
		Case $BtnRefresh
			PopulateListBox($DefaultMenuSaveSet)
		Case $idMenuGuiOnTop
			If BitAND(GUICtrlRead($idMenuGuiOnTop), $GUI_CHECKED) = $GUI_CHECKED Then
				GUICtrlSetState($idMenuGuiOnTop, $GUI_UNCHECKED)
				WinSetOnTop($hGUI, "", 0)
				IniWrite($iniFile, "setting", "WinOnTop", 0)
			Else
				GUICtrlSetState($idMenuGuiOnTop, $GUI_CHECKED)
				WinSetOnTop($hGUI, "", 1)
				WinActivate($hGUI)
				IniWrite($iniFile, "setting", "WinOnTop", 1)
			EndIf
		Case $BtnAutoAdd
			$autoAdd = Mod($autoAdd + 1, 2)
			If $autoAdd = 0 Then
				GUICtrlSetBkColor($BtnAutoAdd, "0xFF0000")
			Else
				GUICtrlSetBkColor($BtnAutoAdd, "0x00FF00")
			EndIf


		Case $idMenuClearButtons
			$WPos = WinGetPos($hGUI)
			$iMsgBoxAnswer = MsgBoxButton("Warning ! ", " Do you really want to clear all buttons?", "Yes|No", 200, 80, $WPos[0] + 130, $WPos[1] + 50, 2)
			If $iMsgBoxAnswer = 1 Then ;Yes
				For $x = 1 To ($btnmax - 1)
					_GDIPlus_ImageDispose($CBTN[$x][1])
					$CBTN[$x][1] = 0
					GUICtrlSetBkColor($CBTN[$x][0], "0xFF7070")
				Next
			EndIf
			$WPos = ""
		Case $idMenuOpenFolder
			$tmp = $Foldername & $aSaveSet[$DefaultMenuSaveSet][0] & "\"
			If FileExists($tmp) Then ShellExecute($tmp)
			$tmp = ""
		Case $idMenuSaveCurrent
			If $hImage > 0 Then
				If BitAND(GUICtrlRead($idMenuGuiOnTop), $GUI_CHECKED) = $GUI_CHECKED Then WinSetOnTop($hGUI, "", 0)
				$tmpFN = FileSaveDialog("Save image", @WorkingDir, "Supported files (*.png;*.jpg;*.bmp;*.gif;*.tiff) | PNG (*.png)| JPG (*.jpg) | BMP (*.bmp) | GIF (*.gif) | TIFF (*.tiff)", BitOR($FD_PATHMUSTEXIST, $FD_PROMPTOVERWRITE))
				If $tmpFN <> "" Then
					_GDIPlus_ImageSaveToFile($hImage, $tmpFN)
				EndIf

				If BitAND(GUICtrlRead($idMenuGuiOnTop), $GUI_CHECKED) = $GUI_CHECKED Then
					WinSetOnTop($hGUI, "", 1)
					WinActivate($hGUI)
				EndIf
			EndIf
		Case $idMenuSave
			SaveImages($DefaultMenuSaveSet, $DefaultMenuTypeFMT)
			PopulateListBox($DefaultMenuSaveSet)
		Case $idMenuSaveContinuously
			SaveImages($DefaultMenuSaveSet, $DefaultMenuTypeFMT, 1)
			PopulateListBox($DefaultMenuSaveSet)
		Case $idMenuIniExample
			AboutWindow()
		Case $idMenuIniEdit
			ShellExecute($iniFile)
		Case $GUI_EVENT_CLOSE, $idMenuExit
			$WPos = WinGetPos($hGUI)
			$iMsgBoxAnswer = MsgBoxButton("Warning ! ", " Do you really want to end the program ?", "Yes|No", 200, 80, $WPos[0] + 130, $WPos[1] + 50, 2)
			If $iMsgBoxAnswer = 1 Then ;Yes
				_GDIPlus_ImageDispose($hImage)
				For $x = 0 To ($btnmax - 1)
					_GDIPlus_ImageDispose($CBTN[$x][1])
				Next
				;_GDIPlus_PenDispose($hPen)
				_GDIPlus_BrushDispose($hBru)
				If $hCanvas > 0 Then _GDIPlus_GraphicsDispose($hCanvas)
				_GDIPlus_Shutdown()
				; Shut down clipboard viewer
				_ClipBoard_ChangeChain($hGUI, $g_hNext)
				Exit
			EndIf
			$WPos = ""
		Case $GUI_EVENT_RESIZED, $GUI_EVENT_RESTORE, $GUI_EVENT_MAXIMIZE
			_GUIScrollBars_SetScrollInfoPos($hChild, $SB_Horz, 0)
			$WPos = WinGetPos($hGUI)
			WinMove($hChild, "", $WPos[0] + 13, $WPos[1] + 54, $WPos[2] - 24, 54)
			$WPos = ""
			_GUIScrollbars_Generate($hChild, (($btnmax) * 21), 30)
			;_GUIScrollbars_Restore($hChild, False, True)
			Sleep(20)
			ReDrawBitmap()
		Case $GUI_EVENT_SECONDARYUP
			$anmsg = GUIGetCursorInfo($hChild)
			If IsArray($anmsg) Then
				For $x = 0 To ($btnmax - 1)
					If $x > 0 Then
						If $anmsg[4] = $CBTN[$x][0] Then
							If $CBTN[$x][1] > 0 Then
								_GDIPlus_ImageDispose($CBTN[$x][1])
								GUICtrlSetBkColor($CBTN[$x][0], "0xFF7070")
								$CBTN[$x][1] = 0
								$fScale = 1.0
							EndIf
						EndIf
					EndIf
				Next
			EndIf
			$anmsg = ""
		Case Else
			If $nMsg > 0 Then
				;Loop through the Buttons
				For $x = 0 To ($btnmax - 1)
					If $nMsg = $CBTN[$x][0] Then
						$fScale = 1.0
						If $x > 0 Then
							If $CBTN[$x][1] = 0 And $hImage > 0 Then
								$CBTN[$x][1] = _GDIPlus_ImageClone($hImage)
								GUICtrlSetBkColor($CBTN[$x][0], "0x70FFFF")
								UpdateDraw(1)
							EndIf
						EndIf
						If $CBTN[$x][1] > 0 Then
							_GDIPlus_ImageDispose($hImage)
							$hImage = _GDIPlus_ImageClone($CBTN[$x][1])
							UpdateDraw(1)
						EndIf
					EndIf
				Next

				;Loop throgh the Set menu
				For $x = 0 To (UBound($aSaveSet) - 1)
					If $nMsg = $aSaveSet[$x][1] Then
						$DefaultMenuSaveSet = $x
						PopulateListBox($x)
						UpdateTitle()
						IniWrite($iniFile, "setting", "MenuSaveSetNr", $DefaultMenuSaveSet)
					EndIf
				Next

				;Loop throgh Option menu
				For $x = 0 To (UBound($aFmt) - 1)
					If $nMsg = $aFmt[$x][1] Then
						$DefaultMenuTypeFMT = $x
						UpdateTitle()
						IniWrite($iniFile, "setting", "MenuFormatType", $DefaultMenuTypeFMT)
					EndIf
				Next

			EndIf
	EndSwitch

	If GUICtrlRead($hListBox) <> $sLastSel Then                ;Code by melba23 - autoit forum
		$sLastSel = GUICtrlRead($hListBox)
		Sleep(150)
		If $fAction = 1 Then
			;Listbox Double Click
			LoadImage($sLastSel, $DefaultMenuSaveSet)
		Else
			;Listbox Single Click
			LoadImage($sLastSel, $DefaultMenuSaveSet)
		EndIf
		$fAction = 0

	Else
		If $fAction = 1 Then
			;Listbox Double Click
			LoadImage($sLastSel, $DefaultMenuSaveSet)
			$fAction = 0
		EndIf
	EndIf
	_GUIScrollbars_EventMonitor()

	If $draw = 1 Then
		GetMouseCoords()
		$cPos = GUIGetCursorInfo()
		If IsArray($cPos) = 1 Then
			If $cPos[2] = 1 And $cPos[3] = 0 Then                ;drawing on $himage used with the help of https://www.autoitscript.com/forum/topic/173962-drawing-linescirclesrectangles-to-file/#findComment-1258800

				If $mouseGX > -1 Then
					$tmp = GUICtrlRead($SizeCombo)
					;_GDIPlus_GraphicsDrawRect($hCanvas, $mouseGX, $mouseGY, $tmp, $tmp, $hPen)
					_GDIPlus_GraphicsFillRect($hCanvas, $mouseGX, $mouseGY, $tmp, $tmp, $hBru)
					ReDrawBitmap()
				EndIf
			ElseIf $cPos[2] = 0 And $cPos[3] = 1 Then
				If $tmplockx = 0 Then $tmplockx = 1

				If $mouseGX > -1 Then
					$tmp = GUICtrlRead($SizeCombo)
					If _IsPressed("11") Then
						If $tmplockx = 1 Then
							$tmpdx = $mouseGX
							$tmpdy = $mouseGY
							$tmplockx = 2
						EndIf
						_GDIPlus_GraphicsFillRect($hCanvas, $tmpdx, $mouseGY, $tmp, $tmp, $hBru)
					Else
						If $tmplockx = 2 Then
							$tmpdx = $mouseGX
							$tmpdy = $mouseGY
							$tmplockx = 1
						EndIf
						_GDIPlus_GraphicsFillRect($hCanvas, $mouseGX, $tmpdy, $tmp, $tmp, $hBru)
					EndIf
					ReDrawBitmap()
				EndIf

			Else
				$tmplockx = 0
				$tmpdx = $mouseGX
				$tmpdy = $mouseGY
			EndIf
		EndIf
	EndIf

WEnd


Func Bugfix()

	_ClipBoard_ChangeChain($hGUI, $g_hNext)
	$g_hNext = _ClipBoard_SetViewer($hGUI)
	GUIRegisterMsg($WM_CHANGECBCHAIN, "WM_CHANGECBCHAIN")
	GUIRegisterMsg($WM_DRAWCLIPBOARD, "WM_DRAWCLIPBOARD")

EndFunc   ;==>Bugfix

Func UpdateTitle()
	Local $tmp = ""
	Local $tmp1 = ""
	If $hImage > 0 Then
		$tmp = " Size: " & _GDIPlus_ImageGetWidth($hImage) & "/" & _GDIPlus_ImageGetHeight($hImage)
	EndIf
	$tmp1 = " ( " & $aFmt[$DefaultMenuTypeFMT][0] & " ) / ( " & $aSaveSet[$DefaultMenuSaveSet][0] & " )" & $tmp & " M=" & $mouseGX & "," & $mouseGY

	If $displayinfo = 1 Then
		GUICtrlSetData($idMenuInfo, "   " & $tmp1)
	Else
		WinSetTitle($hGUI, "", "Clipboard Monitor " & $tmp1)
	EndIf


EndFunc   ;==>UpdateTitle

Func UpdateDraw($cls = 0)
	If $cls = 0 Then
		Switch $draw
			Case 0
				GUICtrlSetBkColor($BtnDraw, 0xff0000)
				If $hCanvas > 0 Then _GDIPlus_GraphicsDispose($hCanvas)
			Case 1
				GUICtrlSetBkColor($BtnDraw, 0x00ff00)
				$hCanvas = _GDIPlus_ImageGetGraphicsContext($hImage) ;get the canvas
				ReDrawBitmap()
		EndSwitch
	Else
		If $hCanvas > 0 Then _GDIPlus_GraphicsDispose($hCanvas)
		$hCanvas = _GDIPlus_ImageGetGraphicsContext($hImage) ;get the canvas
		ReDrawBitmap()
	EndIf
EndFunc   ;==>UpdateDraw

Func LoadImage($FNa, $Nr)
	Local $tmp1 = $aSaveSet[$Nr][0]
	Local $tmpF = $Foldername & $tmp1 & "\" & $FNa
	Local $tmpH = 0
	If FileExists($tmpF) Then
		$tmpH = _GDIPlus_ImageLoadFromFile($tmpF)
		If $tmpH > 0 Then
			If $hImage > 0 Then _GDIPlus_ImageDispose($hImage)
			$hImage = _GDIPlus_ImageClone($tmpH)
			UpdateDraw(1)
			_GDIPlus_ImageDispose($tmpH)
			$tmpH = 0
		EndIf
	EndIf
EndFunc   ;==>LoadImage

Func LoadDroppedImage($Filename)
	If FileExists($Filename) Then
		$tmpH = _GDIPlus_ImageLoadFromFile($Filename)
		If $tmpH > 0 Then
			_GDIPlus_ImageDispose($hImage)
			ConsoleWrite("error = " & @error & " / " & @extended & @CRLF)
			$hImage = _GDIPlus_ImageClone($tmpH)
			_GDIPlus_ImageDispose($tmpH)
		Else
			ConsoleWrite("Loading file failed : " & $Filename)
		EndIf
	Else
		ConsoleWrite("File : '" & $Filename & "' does not exists" & @CRLF)
	EndIf
	ReDrawBitmap()
EndFunc   ;==>LoadDroppedImage

Func PopulateListBox($Nr = 0)
	Local $tmp = $aFmt[1][0]
	Local $tmp1 = $aSaveSet[$Nr][0]
	Local $tmpF = $Foldername & $tmp1 & "\"
	Local $tmpFN = "", $tmpFNa = ""
	Local $tmpfiles
	Local $x, $y
	Local $tmpBox = ""
	;GUICtrlSetData($hListBox, $tmpBox)
	_GUICtrlListBox_ResetContent($hListBox)

	For $y = 0 To UBound($aFmt) - 1
		$tmp = $aFmt[$y][0]
		For $x = 0 To 10 ^ $fnamelength
			$tmpFNa = _StringRepeat("0", $fnamelength - StringLen($x)) & $x & "." & $tmp
			$tmpFN = $tmpF & $tmpFNa
			If FileExists($tmpFN) Then
				$tmpBox = $tmpBox & $tmpFNa & "|"
			EndIf
		Next
	Next

	If StringLen($tmpBox) > 0 Then GUICtrlSetData($hListBox, $tmpBox)
EndFunc   ;==>PopulateListBox

Func SaveImages($Nr = 0, $typ = 0, $additive = 0)

	Local $tmp = $aFmt[$typ][0]
	Local $tmp1 = $aSaveSet[$Nr][0]
	Local $tmpF = $Foldername & $tmp1 & "\"
	Local $tmpFN = ""
	Local $tmpfiles
	Local $fnnr = 1
	Local $fnfnd

	If FileExists($tmpF) = 0 Then DirCreate($tmpF)

	$tmpexist = 0

	If $additive = 0 Then
		For $x = 1 To UBound($CBTN) - 1
			$tmpFNa = _StringRepeat("0", $fnamelength - StringLen($x)) & $x & "." & $tmp
			$tmpFN = $tmpF & $tmpFNa
			If FileExists($tmpFN) And $CBTN[$x][1] > 0 Then
				$tmpexist = $tmpexist + 1
				$tmpfiles = $tmpfiles & $tmpFNa & @CRLF
			EndIf
		Next


		If $tmpexist > 0 Then
			$WPos = WinGetPos($hGUI)
			If MsgBoxButton("Warning: File(s) exist", "Following files may be deleted from:" & @CRLF & $tmpF & @CRLF & @CRLF & $tmpfiles & "Do you wish to continue ?", "Yes|No", 220, 100, $WPos[0] + 130, $WPos[1] + 50, 2) = 1 Then $tmpexist = 0
		EndIf
	EndIf

	If $tmpexist = 0 Then
		For $x = 1 To UBound($CBTN) - 1
			If $additive = 0 Then
				$fnfnd = 1
				$tmpFN = $tmpF & _StringRepeat("0", $fnamelength - StringLen($x)) & $x & "." & $tmp
			Else
				$fnfnd = 0
				Do
					$tmpFN = $tmpF & _StringRepeat("0", $fnamelength - StringLen($fnnr)) & $fnnr & "." & $tmp
					If FileExists($tmpFN) = 0 Then
						$fnfnd = 1
					Else
						$fnnr = $fnnr + 1
					EndIf
					If $fnnr = (10 ^ $fnamelength) Then $fnfnd = 2
				Until $fnfnd > 0
			EndIf

			If $fnfnd = 1 Then
				If $CBTN[$x][1] > 0 Then _GDIPlus_ImageSaveToFile($CBTN[$x][1], $tmpFN)
			Else
				ExitLoop
			EndIf
		Next
		If $fnfnd = 2 Then
			$WPos = WinGetPos($hGUI)
			MsgBoxButton("Warning: Images are not saved", "Some of the files could not be saved, because the limit of the filename characters (" & ((10 ^ $fnamelength) - 1) & ") has been reached", "Ok", 220, 100, $WPos[0] + 130, $WPos[1] + 50, 2)
		EndIf
	EndIf

EndFunc   ;==>SaveImages

Func ReDrawBitmap($scale = 0)

	$WPos = WinGetPos($hGUI)
	$hGraphics = _GDIPlus_GraphicsCreateFromHWND($hGUI)
	If $scale = 0 Then
		_GDIPlus_DrawImagePoints($hGraphics, $hImage, 87, 62, $WPos[2] - 22, 62, 87, $WPos[3] - 82)
		_GDIPlus_GraphicsDispose($hGraphics)
	Else
		_WinAPI_RedrawWindow($hGUI)
		Sleep(5)
		;code snippet from https://www.autoitscript.com/forum/topic/180546-image-resize-with-mouse-wheel/
		$hWnd_bitmap = _GDIPlus_BitmapCreateFromGraphics($WPos[2] - 22, $WPos[3] - 82, $hGraphics)
		$hWnd_gdi_buffer = _GDIPlus_ImageGetGraphicsContext($hWnd_bitmap)
		Local $hBitmap_Scaled = _GDIPlus_ImageScale($hImage, $fScale, $fScale, $GDIP_INTERPOLATIONMODE_NEARESTNEIGHBOR)
		_GDIPlus_GraphicsClear($hImage, 0xFF000000)
		_GDIPlus_GraphicsDrawImageRectRect($hWnd_gdi_buffer, $hBitmap_Scaled, 0, 0, _GDIPlus_ImageGetWidth($hImage), _GDIPlus_ImageGetHeight($hImage), 87, 62, $WPos[2] - 22, $WPos[3] - 82)
		_GDIPlus_GraphicsDrawImage($hGraphics, $hWnd_bitmap, 0, 0)
		_GDIPlus_BitmapDispose($hBitmap_Scaled)
		_GDIPlus_BitmapDispose($hWnd_bitmap)
	EndIf

	_GDIPlus_GraphicsDispose($hGraphics)
	UpdateTitle()
EndFunc   ;==>ReDrawBitmap

Func ClipDrawBitmap()
	Local $WPos, $hBitmap, $hGraphics
	$WPos = WinGetPos($hGUI)

	_ClipBoard_Open($hGUI)
	$hBitmap = _ClipBoard_GetDataEx($CF_BITMAP)
	_ClipBoard_Close()

	If $hBitmap > 0 Then
		If $hImage > 0 Then _GDIPlus_ImageDispose($hImage)
		If $CBTN[0][1] > 0 Then _GDIPlus_ImageDispose($CBTN[0][1])

		$hImage = _GDIPlus_BitmapCreateFromHBITMAP($hBitmap)
		$CBTN[0][1] = _GDIPlus_ImageClone($hImage)
		GUICtrlSetBkColor($CBTN[0][0], "0x00FF00")
		_WinAPI_DeleteObject($hBitmap)

		If $autoAdd = 1 Then
			For $x = 1 To ($btnmax - 1)
				If $CBTN[$x][1] = 0 And $hImage > 0 Then
					$CBTN[$x][1] = _GDIPlus_ImageClone($hImage)
					GUICtrlSetBkColor($CBTN[$x][0], "0x70FFFF")
					ExitLoop 1
				EndIf
			Next
		EndIf
		UpdateDraw(1)
		sleep (30)			;This delay prevents adding double items from the clipboard !
	EndIf

EndFunc   ;==>ClipDrawBitmap

; Handle $WM_CHANGECBCHAIN messages
Func WM_CHANGECBCHAIN($hWnd, $iMsg, $wParam, $lParam)
	#forceref $hWnd, $iMsg
	; If the next window is closing, repair the chain
	If $wParam = $g_hNext Then
		$g_hNext = $lParam
		; Otherwise pass the message to the next viewer
	ElseIf $g_hNext <> 0 Then
		_SendMessage($g_hNext, $WM_CHANGECBCHAIN, $wParam, $lParam, 0, "hwnd", "hwnd")
	EndIf
EndFunc   ;==>WM_CHANGECBCHAIN

; Handle $WM_DRAWCLIPBOARD messages
Func WM_DRAWCLIPBOARD($hWnd, $iMsg, $wParam, $lParam)
	#forceref $hWnd, $iMsg
	; Display any image from clipboard
	ClipDrawBitmap()
	; Pass the message to the next viewer
	If $g_hNext <> 0 Then _SendMessage($g_hNext, $WM_DRAWCLIPBOARD, $wParam, $lParam)
EndFunc   ;==>WM_DRAWCLIPBOARD


Func MsgBoxButton($title = "MsgBox", $txt = "", $buttons = "Ok|Cancel", $width = 250, $height = 100, $xpos = -1, $ypos = -1, $defbtn = 1)
	;By Dan_555
	;Displays a custom message box with variable number of buttons
	;$title = Title text,  $txt=info text
	;$buttons = Add any number of buttons needed by entering their names. Buttons are separated by |  E.g. 'yes|no' will create two buttons. Button numbers start from 1
	;$Width, $height minimum of 250,100. Height is expanded by the amount of buttons.
	;Button width is dependant on the Gui-Width
	;$defbtn sets a button to act as default button - Acted upon return
	Local $hParentGui = WinGetHandle("", "")
	GUISetState(@SW_DISABLE, $hParentGui)
	Local $nMsg
	Local $btnnr = -1
	If StringLeft($buttons, 1) <> "|" Then $buttons = "|" & $buttons
	If StringRight($buttons, 1) <> "|" Then $buttons = $buttons & "|"
	Local $a_btn = _StringBetween($buttons, "|", "|")

	If @error = 0 Then
		For $x = UBound($a_btn) - 1 To 0 Step -1
			If $a_btn[$x] = "" Then _ArrayDelete($a_btn, $x)
		Next
	Else                                                            ;Error creating button array
		Local $a_btn[] = ["ok"]
	EndIf

	If $height < (UBound($a_btn)) * 20 Then $height = (UBound($a_btn)) * 20
	If $width < 250 Then $width = 250
	If $height < 100 Then $height = 100

	Local $ahBtn[UBound($a_btn)]

	Local $hMsgBoxGui = GUICreate($title, $width, $height, $xpos, $ypos, BitOR($WS_DLGFRAME, $WS_BORDER, $WS_VISIBLE), BitOR($WS_EX_TOPMOST, $WS_EX_APPWINDOW), $hParentGui)
	Local $hMsgBoxEdi = GUICtrlCreateEdit($txt, 0, 0, 195, $height, BitOR($WS_VSCROLL, $ES_AUTOVSCROLL, $ES_READONLY))
	;Local $hMsgBoxEdi = GUICtrlCreateEdit($txt, 0, 0, 195, $height, BitOR($WS_VSCROLL, $WS_HSCROLL, $ES_AUTOVSCROLL, $ES_AUTOHSCROLL, $ES_READONLY))
	;Local $hMsgBoxEdi = GUICtrlCreateLabel($txt, 2, 2, 195, $height-4,$SS_SUNKEN)
	Local $xs = $height - (20 * (UBound($a_btn) - 1)) - 20
	For $x = 0 To UBound($a_btn) - 1
		$deftyp = -1
		If $defbtn = $x + 1 Then $deftyp = $BS_DEFPUSHBUTTON
		$ahBtn[$x] = GUICtrlCreateButton($a_btn[$x], 198, $xs + ($x * 20), $width - 199, 20, $deftyp)
;~ 		$ahBtn[$x] = GUICtrlCreateButton($a_btn[$x], 198, (UBound($a_btn)-1 = 0) ? (($height/2)-10)+($x * 20) : (($height/UBound($a_btn))-20)+($x * 20) , $width-199, 20,$deftyp)
	Next
	GUISetState(@SW_SHOW)
	Do
		$nMsg = GUIGetMsg()
		If $nMsg > 0 Then
			For $x = 0 To UBound($ahBtn) - 1
				If $nMsg = $ahBtn[$x] Then $btnnr = $x + 1
			Next
		EndIf
	Until $btnnr > -1
	GUIDelete($hMsgBoxGui)
	GUISetState(@SW_ENABLE, $hParentGui)
	WinActivate($hParentGui)
	Return $btnnr
EndFunc   ;==>MsgBoxButton

Func AboutWindow()
	$tmp = "Ini file example:" & @CRLF & @CRLF & "[setting]" & @CRLF & "WinOnTop=0" & @CRLF & "MenuFormatType=0" & @CRLF & "MenuSaveSetNr=0" & @CRLF & "NumberOfButtons=50" & @CRLF & "DisplayInfo=1 " & @CRLF & "(PNG/Image Set)" & @CRLF & ";0 = in the title, 1 = in the menue"
	$WPos = WinGetPos($hGUI)
	MsgBoxButton("Info: ", $tmp, "Ok", 200, 150, $WPos[0] + 130, $WPos[1] + 50, 2)
	$WPos = ""
	$tmp = ""
EndFunc   ;==>AboutWindow


Func WM_COMMAND($hWnd, $iMsg, $wParam, $lParam)
	;code from https://www.autoitscript.com/forum/topic/119058-how-to-set-a-handler-function-for-listbox-double-click-action/?do=findComment&comment=827814
	#forceref $hWnd, $iMsg

	Local $tNMHDR = DllStructCreate($tagNMHDR, $lParam)

	$hWndFrom = $lParam
	$iCode = BitShift($wParam, 16) ; Hi Word

	Switch $hWndFrom
		Case $hWndListBox
			Switch $iCode
				Case $LBN_DBLCLK ; Sent when the user double-clicks a string in a list box
					$fAction = 1
			EndSwitch
	EndSwitch

EndFunc   ;==>WM_COMMAND

Func WM_CONTEXTMENU($hWnd, $Msg, $wParam, $lParam)
	;from https://www.autoitscript.com/forum/topic/71060-making-the-context-menu-only-on-the-listbox-items-but-not-the-whitespace/
	Local $tPoint = _WinAPI_GetMousePos(True, GUICtrlGetHandle($hListBox))
	Local $iY = DllStructGetData($tPoint, "Y")
	Local $iX = DllStructGetData($tPoint, "X")
	For $i = 0 To 500
		Local $aRect = _GUICtrlListBox_GetItemRect($hListBox, $i)
		If ($iY >= $aRect[1]) And ($iY <= $aRect[3]) And ($iX <= $aRect[2]) And ($iX >= $aRect[0]) Then
			_GUICtrlListBox_SetCurSel($hListBox, $i)
			If StringLen(GUICtrlRead($hListBox)) > 0 Then _ContextMenu($i)
		EndIf
	Next
	Return $GUI_RUNDEFMSG
EndFunc   ;==>WM_CONTEXTMENU


Func _ContextMenu($sItem)
	Switch _GUICtrlMenu_TrackPopupMenu($hMenu, GUICtrlGetHandle($hListBox), -1, -1, 1, 1, 2)
		Case $IdDel
			Local $FNa = GUICtrlRead($hListBox)
			Local $tmp1 = $aSaveSet[$DefaultMenuSaveSet][0]
			Local $tmpF = $Foldername & $tmp1 & "\" & $FNa
			LoadDroppedImage(@ScriptDir & "\" & "delete.png")
			Sleep(150)
			If FileDelete($tmpF) = 1 Then
				PopulateListBox($DefaultMenuSaveSet)
			Else
				ConsoleWrite("Delete failed at " & $tmpF & @CRLF)
			EndIf
	EndSwitch
EndFunc   ;==>_ContextMenu

;Code below was generated by: 'File to Base64 String' Code Generator v1.20 Build 2020-06-05

Func _Base64String($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $hFile, $tmp

	Local $Base64String
	$Base64String &= 'iVBORw0KGgoAAAANSUhEUgAAAGYAAAAWCAYAAAAy/emjAAAAB3RJTUUH6QMRFAcUHC7j1gAAAAlwSFlzAAAewQAAHsEBw2lUUwAAAARnQU1BAACxjwv8YQUAAAGTSURBVHja7ViJDYMwDASJ7bpEt+'
	$Base64String &= 'gM3aJLdD4KUpGM5fNHkqqST2oR5Byf8xicaSoUCoVCoQ/m/e/9eqyIcLs/50zHe59Z26vQfP9SVziI7QJ/2qRZfUZsM36ivjO6foWFiBYJ2+rqvsq+/f/Pah6Ahd5Ig6INGl15ngH18Lkfr00m+MOX5'
	$Base64String &= 'MPyy31anMOPeww921vi8BQotXn4UipFbVp6YhwzlTHeyd7yq2mO6NL8LFMCZBfRFQNTkcXn7dIzyQfiRIDsvVq9HK7LjC+6YxAfcaJ83nZFRzQO6xlqvxqvxEntGNZRN37Wphfo++i4RneoN770xGRS'
	$Base64String &= 'Rm8fo0B1kfTbNL70xCif1zNIIyF+1qYnwHshrUWLz5wYKgZ9WjKe6xTBw8/ajECregvFd5oYKWA6KUdH0gBpkxfhC182K9KCOCOAfGraI2OSPpJpVcdobQPrGFO3o+7yxOQek0uHmFp1HD0p0FKkpcVT'
	$Base64String &= 'YUu6kEbrmVT1S/0KvNOO1+Krc6nGMArQZu+mQgKeIxsLNXud4DnkLPwhPsrneljqB4oGAAAAAElFTkSuQmCC'
	Local $bString = _WinAPI_Base64Decode($Base64String)
	If @error Then Return SetError(1, 0, 0)
	$bString = Binary($bString)
	If $bSaveBinary Then
		$hFile = FileOpen($sSavePath & "\delete.png", 18)
		If $hFile = -1 Then
			Return SetError(2, 0, $bString)
			ConsoleWrite("saving delete image failed")
		EndIf
		$tmp = FileWrite($hFile, $bString)
		If $tmp = 0 Then ConsoleWrite(" writing not possible " & @CRLF)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Base64String

Func _WinAPI_Base64Decode($sB64String)
	Local $aCrypt = DllCall("Crypt32.dll", "bool", "CryptStringToBinaryA", "str", $sB64String, "dword", 0, "dword", 1, "ptr", 0, "dword*", 0, "ptr", 0, "ptr", 0)
	If @error Or Not $aCrypt[0] Then Return SetError(1, 0, "")
	Local $bBuffer = DllStructCreate("byte[" & $aCrypt[5] & "]")
	$aCrypt = DllCall("Crypt32.dll", "bool", "CryptStringToBinaryA", "str", $sB64String, "dword", 0, "dword", 1, "struct*", $bBuffer, "dword*", $aCrypt[5], "ptr", 0, "ptr", 0)
	If @error Or Not $aCrypt[0] Then Return SetError(2, 0, "")
	Return DllStructGetData($bBuffer, 1)
EndFunc   ;==>_WinAPI_Base64Decode

Func WM_GETMINMAXINFO($hWnd, $Msg, $wParam, $lParam)
	;https://www.autoitscript.com/forum/topic/114511-resize-limits-on-a-window/
	Switch $hWnd
		Case $hGUI
			$tagMaxinfo = DllStructCreate("int;int;int;int;int;int;int;int;int;int", $lParam)
			DllStructSetData($tagMaxinfo, 7, $GUIMINWID) ; min X
			DllStructSetData($tagMaxinfo, 8, $GUIMINHT) ; min Y
	EndSwitch
	Return $GUI_RUNDEFMSG
EndFunc   ;==>WM_GETMINMAXINFO

Func WM_MOUSEWHEEL($hWnd, $iMsg, $wParam, $lParam)
	#forceref $iMsg, $wParam
	; If no image is currently loaded)
	If (Not $hImage) Then Return $GUI_RUNDEFMSG

	Switch $hWnd
		Case $hGUI
			If $draw = 0 Then
				If BitShift($wParam, 16) > 0 Then ;Wheel up
					$fScale += .1
					ReDrawBitmap(1)
				Else ;-----------------------------Wheel down
					$fScale -= .1
					ReDrawBitmap(1)
				EndIf
			EndIf
	EndSwitch

	Return $GUI_RUNDEFMSG
EndFunc   ;==>WM_MOUSEWHEEL


Func _Bitmap2Clipboard()
	;from https://www.autoitscript.com/forum/topic/211014-placing-image-data-created-from-scratch-in-gdiplus-onto-the-windows-clipboard/#findComment-1525916
	Local $hBitmap1 = _GDIPlus_BitmapCreateHBITMAPFromBitmap($hImage)
	Local $hBitmap2 = _WinAPI_CopyImage($hBitmap1, $IMAGE_BITMAP, 0, 0, $LR_COPYDELETEORG + $LR_COPYRETURNORG)
	_WinAPI_DeleteObject($hBitmap1)
	_ClipBoard_Open(0)
	_ClipBoard_Empty()
	_ClipBoard_SetDataEx($hBitmap2, $CF_BITMAP)
	_ClipBoard_Close()
	_WinAPI_DeleteObject($hBitmap2)
EndFunc   ;==>_Bitmap2Clipboard

Func GetMouseCoords()        ;Call the function once in the main loop to get the mouse coordinates
	Local $a = GUIGetCursorInfo()
	If @error = 0 Then
		$mouseX = $a[0]
		$mouseY = $a[1]
		;_GDIPlus_DrawImagePoints($hGraphics, $hImage, 87, 62, $WPos[2] - 22, 62, 87, $WPos[3] - 82)
		Local $mx = $mouseX - 87
		Local $my = $mouseY - 62

		$WPos = WinGetPos($hGUI)
		$mouseGXM = $WPos[2] - 22
		$mouseGYM = $WPos[3] - 82

		If ($mx < 0 Or $mouseX > $mouseGXM) Or ($my < 0 Or $mouseY > $mouseGYM) Then
			$mouseGX = -1
			$mouseGY = -1
		Else
			$mouseGX = Int(($mx) * (_GDIPlus_ImageGetWidth($hImage) / ($mouseGXM - 87)))
			$mouseGY = Int(($my) * (_GDIPlus_ImageGetHeight($hImage) / ($mouseGYM - 62)))
		EndIf

	EndIf

EndFunc   ;==>GetMouseCoords


