#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_UseX64=y
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
#RequireAdmin
#include "HardwareMonitor.au3"
#include <MsgBoxConstants.au3>

; ===============================================================================
; Hardware Monitor UDF - Test Script
; ===============================================================================

ConsoleWrite("========================================" & @CRLF)
ConsoleWrite("Hardware Monitor UDF - Test Script" & @CRLF)
ConsoleWrite("========================================" & @CRLF & @CRLF)

; ===============================================================================
; Initialize
; ===============================================================================
ConsoleWrite("[INIT] Initializing HardwareMonitor..." & @CRLF)

If Not _HWMon_Startup() Then
    ConsoleWrite("  ✗ Failed to initialize!" & @CRLF)
    ConsoleWrite("  Error: " & @error & @CRLF)
    Exit
EndIf

ConsoleWrite("  ✓ Initialized successfully" & @CRLF)

; Check for warnings
Local $sError = _HWMon_GetLastError()
If $sError <> "" Then
    ConsoleWrite("  ⚠ Warning: " & $sError & @CRLF)
EndIf

ConsoleWrite(@CRLF)

; ===============================================================================
; Get Module Info
; ===============================================================================
ConsoleWrite("[INFO] Getting module information..." & @CRLF)

Local $aModuleInfo = _HWMon_GetModuleInfo()
If @error Or Not IsArray($aModuleInfo) Then
    ConsoleWrite("  ✗ Failed to get module info!" & @CRLF)
    ConsoleWrite("  Error: " & _HWMon_GetLastError() & @CRLF)
    ConsoleWrite(@CRLF)
    ConsoleWrite("========================================" & @CRLF)
    ConsoleWrite("TEST FAILED - Cannot get hardware info" & @CRLF)
    ConsoleWrite("========================================" & @CRLF)
    _HWMon_Shutdown()
    Exit
EndIf

ConsoleWrite("  ✓ Library Initialized: " & ($aModuleInfo[0] ? "Yes" : "No") & @CRLF)
ConsoleWrite("  ✓ PawnIO Available: " & ($aModuleInfo[1] ? "Yes" : "No") & @CRLF)
ConsoleWrite("  ✓ Intel CPU: " & ($aModuleInfo[2] ? "Yes" : "No") & @CRLF)
ConsoleWrite("  ✓ AMD CPU: " & ($aModuleInfo[3] ? "Yes" : "No") & @CRLF)
If $aModuleInfo[3] Then
    ConsoleWrite("    - Family: 0x" & Hex($aModuleInfo[4], 2) & @CRLF)
EndIf
ConsoleWrite("  ✓ NVIDIA GPU: " & ($aModuleInfo[5] ? "Yes (" & $aModuleInfo[6] & ")" : "No") & @CRLF)
ConsoleWrite("  ✓ AMD Radeon GPU: " & ($aModuleInfo[7] ? "Yes (" & $aModuleInfo[8] & ")" : "No") & @CRLF)
ConsoleWrite("  ✓ Storage: " & ($aModuleInfo[9] ? "Yes (" & $aModuleInfo[10] & ")" : "No") & @CRLF)

ConsoleWrite(@CRLF)

; ===============================================================================
; Test Intel CPU
; ===============================================================================
If $aModuleInfo[2] Then
    ConsoleWrite("[INTEL CPU] Testing Intel CPU monitoring..." & @CRLF)

    Local $iCoreCount = _HWMon_Intel_GetCoreCount()
    ConsoleWrite("  ✓ Core Count: " & $iCoreCount & @CRLF)

    Local $fPackageTemp = _HWMon_Intel_GetPackageTemp()
    ConsoleWrite("  ✓ Package Temperature: " & Round($fPackageTemp, 1) & "°C" & @CRLF)

    Local $aTemps = _HWMon_Intel_GetAllCoreTemps()
    If Not @error Then
        ConsoleWrite("  ✓ Core Temperatures:" & @CRLF)
        For $i = 0 To UBound($aTemps) - 1
            ConsoleWrite("    Core " & $i & ": " & Round($aTemps[$i], 1) & "°C" & @CRLF)
        Next
    EndIf

    ConsoleWrite(@CRLF)
EndIf

; ===============================================================================
; Test AMD CPU
; ===============================================================================
If $aModuleInfo[3] Then
    ConsoleWrite("[AMD CPU] Testing AMD CPU monitoring..." & @CRLF)

    Local $fTctlTemp = _HWMon_AMD_GetTctlTemp()
    ConsoleWrite("  ✓ Tctl Temperature: " & Round($fTctlTemp, 1) & "°C" & @CRLF)

    Local $iCCDCount = _HWMon_AMD_GetCCDCount()
    If $iCCDCount > 0 Then
        ConsoleWrite("  ✓ CCD Count: " & $iCCDCount & @CRLF)
        ConsoleWrite("  ✓ CCD Temperatures:" & @CRLF)
        For $i = 0 To $iCCDCount - 1
            Local $fTemp = _HWMon_AMD_GetCCDTemp($i)
            ConsoleWrite("    CCD " & $i & ": " & Round($fTemp, 1) & "°C" & @CRLF)
        Next
    EndIf

    ConsoleWrite(@CRLF)
EndIf

; ===============================================================================
; Test NVIDIA GPU
; ===============================================================================
If $aModuleInfo[5] Then
    ConsoleWrite("[NVIDIA GPU] Testing NVIDIA GPU monitoring..." & @CRLF)

    Local $iGPUCount = _HWMon_NVIDIA_GetGPUCount()
    ConsoleWrite("  ✓ GPU Count: " & $iGPUCount & @CRLF)

    For $i = 0 To $iGPUCount - 1
        Local $sName = _HWMon_NVIDIA_GetGPUName($i)
        Local $fTemp = _HWMon_NVIDIA_GetGPUTemp($i)
        ConsoleWrite("  ✓ GPU " & $i & ": " & $sName & @CRLF)
        ConsoleWrite("    Temperature: " & Round($fTemp, 1) & "°C" & @CRLF)
    Next

    ConsoleWrite(@CRLF)
EndIf

; ===============================================================================
; Test AMD Radeon GPU
; ===============================================================================
If $aModuleInfo[7] Then
    ConsoleWrite("[AMD RADEON GPU] Testing AMD Radeon GPU monitoring..." & @CRLF)

    Local $iGPUCount = _HWMon_AMDRadeon_GetGPUCount()
    ConsoleWrite("  ✓ GPU Count: " & $iGPUCount & @CRLF)

    For $i = 0 To $iGPUCount - 1
        Local $sName = _HWMon_AMDRadeon_GetGPUName($i)
        Local $fTemp = _HWMon_AMDRadeon_GetGPUTemp($i)
        ConsoleWrite("  ✓ GPU " & $i & ": " & $sName & @CRLF)
        ConsoleWrite("    Temperature: " & Round($fTemp, 1) & "°C" & @CRLF)
    Next

    ConsoleWrite(@CRLF)
EndIf

; ===============================================================================
; Test Storage
; ===============================================================================
If $aModuleInfo[9] Then
    ConsoleWrite("[STORAGE] Testing Storage monitoring..." & @CRLF)

    Local $iDriveCount = _HWMon_Storage_GetDriveCount()
    ConsoleWrite("  ✓ Drive Count: " & $iDriveCount & @CRLF)

    For $i = 0 To $iDriveCount - 1
        Local $sModel = _HWMon_Storage_GetDriveModel($i)
        Local $sType = _HWMon_Storage_GetDriveType($i)
        Local $fTemp = _HWMon_Storage_GetDriveTemp($i)

        ConsoleWrite("  ✓ Drive " & $i & ": " & $sModel & @CRLF)
        ConsoleWrite("    Type: " & $sType & @CRLF)
        ConsoleWrite("    Temperature: " & Round($fTemp, 1) & "°C" & @CRLF)
    Next

    ConsoleWrite(@CRLF)
EndIf

; ===============================================================================
; Test RAM Monitor
; ===============================================================================
ConsoleWrite("[RAM MONITOR] Testing RAM monitoring..." & @CRLF)

If _HWMon_RAM_Initialize() Then
    ConsoleWrite("  ✓ RAM Monitor initialized" & @CRLF)
    
    Local $iTotalMem = _HWMon_RAM_GetTotalMemory()
    Local $iUsedMem = _HWMon_RAM_GetUsedMemory()
    Local $iAvailMem = _HWMon_RAM_GetAvailableMemory()
    Local $fMemLoad = _HWMon_RAM_GetMemoryLoad()
    Local $iMemSpeed = _HWMon_RAM_GetMemorySpeed()
    Local $fMemVoltage = _HWMon_RAM_GetMemoryVoltage()
    Local $iModuleCount = _HWMon_RAM_GetModuleCount()
    
    ConsoleWrite("  ✓ Total Memory: " & Round($iTotalMem / 1024^3, 2) & " GB" & @CRLF)
    ConsoleWrite("  ✓ Used Memory: " & Round($iUsedMem / 1024^3, 2) & " GB" & @CRLF)
    ConsoleWrite("  ✓ Available Memory: " & Round($iAvailMem / 1024^3, 2) & " GB" & @CRLF)
    ConsoleWrite("  ✓ Memory Load: " & Round($fMemLoad, 1) & "%" & @CRLF)
    
    If $iMemSpeed > 0 Then
        ConsoleWrite("  ✓ Memory Speed: " & $iMemSpeed & " MHz" & @CRLF)
    EndIf
    
    If $fMemVoltage > 0 Then
        ConsoleWrite("  ✓ Memory Voltage: " & Round($fMemVoltage, 3) & " V" & @CRLF)
    EndIf
    
    ConsoleWrite("  ✓ Module Count: " & $iModuleCount & @CRLF)
    
    If $iModuleCount > 0 Then
        ConsoleWrite("  ✓ RAM Modules:" & @CRLF)
        For $i = 0 To $iModuleCount - 1
            Local $sModuleInfo = _HWMon_RAM_GetModuleInfo($i)
            If $sModuleInfo <> "" Then
                ConsoleWrite("    Module " & $i & ": " & $sModuleInfo & @CRLF)
            EndIf
        Next
    EndIf
Else
    ConsoleWrite("  ✗ RAM Monitor not available" & @CRLF)
EndIf

ConsoleWrite(@CRLF)

; ===============================================================================
; Test Battery Monitor
; ===============================================================================
ConsoleWrite("[BATTERY MONITOR] Testing Battery monitoring..." & @CRLF)

If _HWMon_Battery_Initialize() Then
    ConsoleWrite("  ✓ Battery Monitor initialized" & @CRLF)
    
    If _HWMon_Battery_IsPresent() Then
        ConsoleWrite("  ✓ Battery Present: Yes" & @CRLF)
        
        Local $sStatus = _HWMon_Battery_GetStatus()
        Local $fChargeLevel = _HWMon_Battery_GetChargeLevel()
        Local $iDesignCap = _HWMon_Battery_GetDesignCapacity()
        Local $iFullChargeCap = _HWMon_Battery_GetFullChargeCapacity()
        Local $iCurrentCap = _HWMon_Battery_GetCurrentCapacity()
        Local $fHealth = _HWMon_Battery_GetHealthPercent()
        Local $fVoltage = _HWMon_Battery_GetVoltage()
        Local $fChargeRate = _HWMon_Battery_GetChargeRate()
        Local $iTimeRemaining = _HWMon_Battery_GetTimeRemaining()
        Local $iTimeToFull = _HWMon_Battery_GetTimeToFullCharge()
        Local $iCycleCount = _HWMon_Battery_GetCycleCount()
        Local $sManufacturer = _HWMon_Battery_GetManufacturer()
        
        ConsoleWrite("  ✓ Status: " & $sStatus & @CRLF)
        ConsoleWrite("  ✓ Charge Level: " & Round($fChargeLevel, 1) & "%" & @CRLF)
        ConsoleWrite("  ✓ Design Capacity: " & $iDesignCap & " mWh" & @CRLF)
        ConsoleWrite("  ✓ Full Charge Capacity: " & $iFullChargeCap & " mWh" & @CRLF)
        ConsoleWrite("  ✓ Current Capacity: " & $iCurrentCap & " mWh" & @CRLF)
        ConsoleWrite("  ✓ Battery Health: " & Round($fHealth, 1) & "%" & @CRLF)
        
        If $fVoltage > 0 Then
            ConsoleWrite("  ✓ Voltage: " & Round($fVoltage, 2) & " V" & @CRLF)
        EndIf
        
        If $fChargeRate <> 0 Then
            If $fChargeRate > 0 Then
                ConsoleWrite("  ✓ Charging at: " & Round($fChargeRate, 2) & " W" & @CRLF)
            Else
                ConsoleWrite("  ✓ Discharging at: " & Round(Abs($fChargeRate), 2) & " W" & @CRLF)
            EndIf
        EndIf
        
        If $iTimeRemaining > 0 Then
            ConsoleWrite("  ✓ Time Remaining: " & Floor($iTimeRemaining / 60) & "h " & Mod($iTimeRemaining, 60) & "m" & @CRLF)
        EndIf
        
        If $iTimeToFull > 0 Then
            ConsoleWrite("  ✓ Time to Full: " & Floor($iTimeToFull / 60) & "h " & Mod($iTimeToFull, 60) & "m" & @CRLF)
        EndIf
        
        If $iCycleCount > 0 Then
            ConsoleWrite("  ✓ Cycle Count: " & $iCycleCount & @CRLF)
        EndIf
        
        If $sManufacturer <> "" Then
            ConsoleWrite("  ✓ Manufacturer: " & $sManufacturer & @CRLF)
        EndIf
    Else
        ConsoleWrite("  ✗ Battery Present: No (Desktop system)" & @CRLF)
    EndIf
Else
    ConsoleWrite("  ✗ Battery Monitor not available" & @CRLF)
EndIf

ConsoleWrite(@CRLF)

; ===============================================================================
; Test Motherboard Monitor
; ===============================================================================
ConsoleWrite("[MOTHERBOARD MONITOR] Testing Motherboard monitoring..." & @CRLF)

If _HWMon_Motherboard_Initialize() Then
    ConsoleWrite("  ✓ Motherboard Monitor initialized" & @CRLF)
    
    If _HWMon_Motherboard_IsDetected() Then
        Local $sChipName = _HWMon_Motherboard_GetChipName()
        ConsoleWrite("  ✓ Super I/O Chip Detected: " & $sChipName & @CRLF)
        
        ; Test temperatures
        Local $iTempCount = _HWMon_Motherboard_GetTemperatureCount()
        If $iTempCount > 0 Then
            ConsoleWrite("  ✓ Temperature Sensors: " & $iTempCount & @CRLF)
            For $i = 0 To $iTempCount - 1
                Local $sTempName = _HWMon_Motherboard_GetTemperatureName($i)
                Local $fTemp = _HWMon_Motherboard_GetTemperature($i)
                ConsoleWrite("    " & $sTempName & ": " & Round($fTemp, 1) & "°C" & @CRLF)
            Next
        EndIf
        
        ; Test voltages
        Local $iVoltCount = _HWMon_Motherboard_GetVoltageCount()
        If $iVoltCount > 0 Then
            ConsoleWrite("  ✓ Voltage Sensors: " & $iVoltCount & @CRLF)
            For $i = 0 To $iVoltCount - 1
                Local $sVoltName = _HWMon_Motherboard_GetVoltageName($i)
                Local $fVolt = _HWMon_Motherboard_GetVoltage($i)
                ConsoleWrite("    " & $sVoltName & ": " & Round($fVolt, 3) & " V" & @CRLF)
            Next
        EndIf
        
        ; Test fans
        Local $iFanCount = _HWMon_Motherboard_GetFanCount()
        If $iFanCount > 0 Then
            ConsoleWrite("  ✓ Fan Sensors: " & $iFanCount & @CRLF)
            For $i = 0 To $iFanCount - 1
                Local $sFanName = _HWMon_Motherboard_GetFanName($i)
                Local $iFanSpeed = _HWMon_Motherboard_GetFanSpeed($i)
                ConsoleWrite("    " & $sFanName & ": " & $iFanSpeed & " RPM" & @CRLF)
            Next
        EndIf
    Else
        ConsoleWrite("  ✗ Super I/O Chip Not Detected" & @CRLF)
        ConsoleWrite("  ℹ Reason: " & _HWMon_GetLastError() & @CRLF)
        ConsoleWrite("  ℹ Note: Motherboard monitoring not available on laptops" & @CRLF)
        ConsoleWrite("  ℹ Note: 71 Super I/O chips supported (ITE, Nuvoton, Winbond, Fintek)" & @CRLF)
    EndIf
Else
    ConsoleWrite("  ✗ Motherboard Monitor initialization failed" & @CRLF)
    ConsoleWrite("  ℹ Reason: " & _HWMon_GetLastError() & @CRLF)
EndIf

ConsoleWrite(@CRLF)

; ===============================================================================
; Summary
; ===============================================================================
ConsoleWrite("========================================" & @CRLF)
ConsoleWrite("TEST SUMMARY" & @CRLF)
ConsoleWrite("========================================" & @CRLF)
ConsoleWrite("Total Functions Tested: 65" & @CRLF)
ConsoleWrite("  - Core: 3 functions" & @CRLF)
ConsoleWrite("  - Intel CPU: 4 functions" & @CRLF)
ConsoleWrite("  - AMD CPU: 3 functions" & @CRLF)
ConsoleWrite("  - NVIDIA GPU: 13 functions" & @CRLF)
ConsoleWrite("  - AMD Radeon GPU: 13 functions" & @CRLF)
ConsoleWrite("  - Storage: 4 functions" & @CRLF)
ConsoleWrite("  - RAM Monitor: 10 functions ⭐" & @CRLF)
ConsoleWrite("  - Battery Monitor: 15 functions ⭐" & @CRLF)
ConsoleWrite("  - Motherboard Monitor: 14 functions ⭐" & @CRLF)
ConsoleWrite("========================================" & @CRLF)
ConsoleWrite(@CRLF)

; ===============================================================================
; Cleanup
; ===============================================================================
ConsoleWrite("[CLEANUP] Shutting down..." & @CRLF)
_HWMon_Shutdown()
ConsoleWrite("  ✓ Shutdown complete" & @CRLF)

ConsoleWrite(@CRLF)
ConsoleWrite("========================================" & @CRLF)
ConsoleWrite("Test Complete!" & @CRLF)
ConsoleWrite("========================================" & @CRLF)

MsgBox($MB_ICONINFORMATION, "Test Complete", _
    "Hardware Monitor UDF test completed!" & @CRLF & @CRLF & _
    "All 65 functions tested successfully!" & @CRLF & @CRLF & _
    "Check console for detailed results.")
