#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_UseX64=y
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
#RequireAdmin
#include "HardwareMonitor.au3"
#include <MsgBoxConstants.au3>
#pragma compile(x64, True)
; ===============================================================================
; Hardware Monitor UDF - Test Script by Dao Van Trong - TRONG.PRO
; ===============================================================================

ConsoleWrite("========================================" & @CRLF)
ConsoleWrite("Hardware Monitor UDF - Test Script" & @CRLF)
ConsoleWrite("========================================" & @CRLF & @CRLF)

; ===============================================================================
; Initialize
; ===============================================================================
ConsoleWrite("[INIT] Initializing HardwareMonitor..." & @CRLF)

If Not _HWMon_Startup() Then
    ConsoleWrite("  ✗ Failed to initialize!" & @CRLF)
    ConsoleWrite("  Error: " & @error & @CRLF)
    Exit
EndIf

ConsoleWrite("  ✓ Initialized successfully" & @CRLF)

; Check for warnings
Local $sError = _HWMon_GetLastError()
If $sError <> "" Then
    ConsoleWrite("  ⚠ Warning: " & $sError & @CRLF)
EndIf

ConsoleWrite(@CRLF)

; ===============================================================================
; Get Module Info
; ===============================================================================
ConsoleWrite("[INFO] Getting module information..." & @CRLF)

Local $aModuleInfo = _HWMon_GetModuleInfo()
If @error Then
    ConsoleWrite("  ✗ Failed to get module info!" & @CRLF)
Else
    ConsoleWrite("  ✓ Library Initialized: " & ($aModuleInfo[0] ? "Yes" : "No") & @CRLF)
    ConsoleWrite("  ✓ PawnIO Available: " & ($aModuleInfo[1] ? "Yes" : "No") & @CRLF)
    ConsoleWrite("  ✓ Intel CPU: " & ($aModuleInfo[2] ? "Yes" : "No") & @CRLF)
    ConsoleWrite("  ✓ AMD CPU: " & ($aModuleInfo[3] ? "Yes" : "No") & @CRLF)
    If $aModuleInfo[3] Then
        ConsoleWrite("    - Family: 0x" & Hex($aModuleInfo[4], 2) & @CRLF)
    EndIf
    ConsoleWrite("  ✓ NVIDIA GPU: " & ($aModuleInfo[5] ? "Yes (" & $aModuleInfo[6] & ")" : "No") & @CRLF)
    ConsoleWrite("  ✓ AMD Radeon GPU: " & ($aModuleInfo[7] ? "Yes (" & $aModuleInfo[8] & ")" : "No") & @CRLF)
    ConsoleWrite("  ✓ Storage: " & ($aModuleInfo[9] ? "Yes (" & $aModuleInfo[10] & ")" : "No") & @CRLF)
EndIf

ConsoleWrite(@CRLF)

; ===============================================================================
; Test Intel CPU
; ===============================================================================
If $aModuleInfo[2] Then
    ConsoleWrite("[INTEL CPU] Testing Intel CPU monitoring..." & @CRLF)

    Local $iCoreCount = _HWMon_Intel_GetCoreCount()
    ConsoleWrite("  ✓ Core Count: " & $iCoreCount & @CRLF)

    Local $fPackageTemp = _HWMon_Intel_GetPackageTemp()
    ConsoleWrite("  ✓ Package Temperature: " & Round($fPackageTemp, 1) & "°C" & @CRLF)

    Local $aTemps = _HWMon_Intel_GetAllCoreTemps()
    If Not @error Then
        ConsoleWrite("  ✓ Core Temperatures:" & @CRLF)
        For $i = 0 To UBound($aTemps) - 1
            ConsoleWrite("    Core " & $i & ": " & Round($aTemps[$i], 1) & "°C" & @CRLF)
        Next
    EndIf

    ConsoleWrite(@CRLF)
EndIf

; ===============================================================================
; Test AMD CPU
; ===============================================================================
If $aModuleInfo[3] Then
    ConsoleWrite("[AMD CPU] Testing AMD CPU monitoring..." & @CRLF)

    Local $fTctlTemp = _HWMon_AMD_GetTctlTemp()
    ConsoleWrite("  ✓ Tctl Temperature: " & Round($fTctlTemp, 1) & "°C" & @CRLF)

    Local $iCCDCount = _HWMon_AMD_GetCCDCount()
    If $iCCDCount > 0 Then
        ConsoleWrite("  ✓ CCD Count: " & $iCCDCount & @CRLF)
        ConsoleWrite("  ✓ CCD Temperatures:" & @CRLF)
        For $i = 0 To $iCCDCount - 1
            Local $fTemp = _HWMon_AMD_GetCCDTemp($i)
            ConsoleWrite("    CCD " & $i & ": " & Round($fTemp, 1) & "°C" & @CRLF)
        Next
    EndIf

    ConsoleWrite(@CRLF)
EndIf

; ===============================================================================
; Test NVIDIA GPU
; ===============================================================================
If $aModuleInfo[5] Then
    ConsoleWrite("[NVIDIA GPU] Testing NVIDIA GPU monitoring..." & @CRLF)

    Local $iGPUCount = _HWMon_NVIDIA_GetGPUCount()
    ConsoleWrite("  ✓ GPU Count: " & $iGPUCount & @CRLF)

    For $i = 0 To $iGPUCount - 1
        Local $sName = _HWMon_NVIDIA_GetGPUName($i)
        Local $fTemp = _HWMon_NVIDIA_GetGPUTemp($i)
        ConsoleWrite("  ✓ GPU " & $i & ": " & $sName & @CRLF)
        ConsoleWrite("    Temperature: " & Round($fTemp, 1) & "°C" & @CRLF)
    Next

    ConsoleWrite(@CRLF)
EndIf

; ===============================================================================
; Test AMD Radeon GPU
; ===============================================================================
If $aModuleInfo[7] Then
    ConsoleWrite("[AMD RADEON GPU] Testing AMD Radeon GPU monitoring..." & @CRLF)

    Local $iGPUCount = _HWMon_AMDRadeon_GetGPUCount()
    ConsoleWrite("  ✓ GPU Count: " & $iGPUCount & @CRLF)

    For $i = 0 To $iGPUCount - 1
        Local $sName = _HWMon_AMDRadeon_GetGPUName($i)
        Local $fTemp = _HWMon_AMDRadeon_GetGPUTemp($i)
        ConsoleWrite("  ✓ GPU " & $i & ": " & $sName & @CRLF)
        ConsoleWrite("    Temperature: " & Round($fTemp, 1) & "°C" & @CRLF)
    Next

    ConsoleWrite(@CRLF)
EndIf

; ===============================================================================
; Test Storage
; ===============================================================================
If $aModuleInfo[9] Then
    ConsoleWrite("[STORAGE] Testing Storage monitoring..." & @CRLF)

    Local $iDriveCount = _HWMon_Storage_GetDriveCount()
    ConsoleWrite("  ✓ Drive Count: " & $iDriveCount & @CRLF)

    For $i = 0 To $iDriveCount - 1
        Local $sModel = _HWMon_Storage_GetDriveModel($i)
        Local $sType = _HWMon_Storage_GetDriveType($i)
        Local $fTemp = _HWMon_Storage_GetDriveTemp($i)

        ConsoleWrite("  ✓ Drive " & $i & ": " & $sModel & @CRLF)
        ConsoleWrite("    Type: " & $sType & @CRLF)
        ConsoleWrite("    Temperature: " & Round($fTemp, 1) & "°C" & @CRLF)
    Next

    ConsoleWrite(@CRLF)
EndIf

; ===============================================================================
; Cleanup
; ===============================================================================
ConsoleWrite("[CLEANUP] Shutting down..." & @CRLF)
_HWMon_Shutdown()
ConsoleWrite("  ✓ Shutdown complete" & @CRLF)

ConsoleWrite(@CRLF)
ConsoleWrite("========================================" & @CRLF)
ConsoleWrite("Test Complete!" & @CRLF)
ConsoleWrite("========================================" & @CRLF)

MsgBox($MB_ICONINFORMATION, "Test Complete", _
    "Hardware Monitor UDF test completed!" & @CRLF & @CRLF & _
    "Check console for detailed results.")
