@echo off
echo ========================================
echo REBUILD JSON-C DLL - x86 and x64
echo ========================================
echo.

set MSBUILD="C:\Program Files\Microsoft Visual Studio\18\Enterprise\MSBuild\Current\Bin\amd64\MSBuild.exe"

if not exist %MSBUILD% (
    echo ERROR: MSBuild not found!
    pause
    exit /b 1
)

echo [1/4] Cleaning old binaries...
if exist bin\x86\json-c.dll del /q bin\x86\json-c.dll
if exist bin\x64\json-c.dll del /q bin\x64\json-c.dll
echo.

echo [2/4] Building x86 Release...
%MSBUILD% json-c.vcxproj /p:Configuration=Release /p:Platform=Win32 /t:Rebuild /v:minimal
if errorlevel 1 (
    echo ERROR: x86 build failed!
    pause
    exit /b 1
)
echo [OK] x86 built
echo.

echo [3/4] Building x64 Release...
%MSBUILD% json-c.vcxproj /p:Configuration=Release /p:Platform=x64 /t:Rebuild /v:minimal
if errorlevel 1 (
    echo ERROR: x64 build failed!
    pause
    exit /b 1
)
echo [OK] x64 built
echo.

echo [4/4] Verifying outputs...
if exist bin\x86\json-c.dll (
    echo [OK] bin\x86\json-c.dll created
    dir /b bin\x86\json-c.*
) else (
    echo [FAIL] x86 DLL not found
)
echo.

if exist bin\x64\json-c.dll (
    echo [OK] bin\x64\json-c.dll created
    dir /b bin\x64\json-c.*
) else (
    echo [FAIL] x64 DLL not found
)

echo.
echo ========================================
echo BUILD COMPLETE
echo ========================================
pause
