VERSION 5.00
Begin VB.Form Form1 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Neural net"
   ClientHeight    =   5265
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   5400
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   MouseIcon       =   "Form1.frx":0000
   ScaleHeight     =   5265
   ScaleWidth      =   5400
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton cmdNo 
      Caption         =   ""
      BeginProperty Font 
         Name            =   "Wingdings"
         Size            =   14.25
         Charset         =   2
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   2760
      TabIndex        =   4
      Top             =   4320
      Width           =   615
   End
   Begin VB.CommandButton cmdYes 
      Caption         =   ""
      BeginProperty Font 
         Name            =   "Wingdings"
         Size            =   14.25
         Charset         =   2
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   2040
      TabIndex        =   3
      Top             =   4320
      Width           =   615
   End
   Begin VB.CommandButton cmdNext 
      Caption         =   "Next"
      Height          =   375
      Left            =   120
      TabIndex        =   2
      Top             =   4800
      Width           =   855
   End
   Begin VB.CommandButton cmdReset 
      Caption         =   "Reset"
      Height          =   375
      Left            =   4320
      TabIndex        =   1
      Top             =   4320
      Width           =   975
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "Quit"
      Height          =   375
      Left            =   4320
      TabIndex        =   0
      Top             =   4800
      Width           =   975
   End
   Begin VB.Shape Shape1 
      BorderWidth     =   3
      Height          =   615
      Left            =   2280
      Top             =   3600
      Width           =   855
   End
   Begin VB.Shape shpStim 
      FillStyle       =   0  'Solid
      Height          =   375
      Index           =   2
      Left            =   3480
      Shape           =   4  'Rounded Rectangle
      Top             =   4320
      Width           =   255
   End
   Begin VB.Shape shpStim 
      FillStyle       =   0  'Solid
      Height          =   375
      Index           =   1
      Left            =   1680
      Shape           =   4  'Rounded Rectangle
      Top             =   4320
      Width           =   255
   End
   Begin VB.Label lblscore 
      Alignment       =   2  'Center
      BackColor       =   &H80000005&
      Caption         =   "0%"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   2280
      TabIndex        =   5
      Top             =   4800
      Width           =   975
   End
   Begin VB.Shape shpStim 
      FillStyle       =   0  'Solid
      Height          =   615
      Index           =   0
      Left            =   960
      Shape           =   4  'Rounded Rectangle
      Top             =   120
      Width           =   3495
   End
   Begin VB.Shape shpCell 
      BorderColor     =   &H00000000&
      BorderWidth     =   3
      FillColor       =   &H000000FF&
      FillStyle       =   0  'Solid
      Height          =   405
      Index           =   0
      Left            =   2400
      Shape           =   3  'Circle
      Top             =   2040
      Width           =   405
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

'Neural net
Option Explicit
'no of rows and cols
Dim irows As Integer, icols As Integer, isize As Integer
'Positions of cells
Dim ix() As Integer, iy() As Integer
' input connections to cells
Dim iNinMax As Integer
' Weights
Dim iWeights() As Integer
' threshold
Dim iTrig() As Integer
'Cell state and buffer
Dim iState() As Integer
Dim iOstate() As Integer
'cell links
Dim iLinks() As Integer
'maximum range
Dim iInputs As Integer, iOutputs As Integer
Dim igoes As Long, iscore As Long

Private Sub cmdExit_Click()
 End
End Sub

Private Sub cmdNext_Click()
Dim ii As Integer, ir As Integer, ig As Integer, ib As Integer
'randomise colour
ir = Rnd() * 255
ig = Rnd() * 255
ib = Rnd() * 255
 For ii = 0 To 2
  shpStim(ii).FillColor = RGB(ir, ig, ib)
Next
stimulate
propagate
End Sub

Private Sub cmdNo_Click()
Dim ic As Integer, iu As Integer
If iState(isize) = 0 Then
'light is off and this is wrong
For ic = 0 To isize
'check OFF cells
If iState(ic) = 0 Then
  'lower threshold of cell
  If iTrig(ic) > 0 Then iTrig(ic) = iTrig(ic) - 1
  'raise weighting for ON links
  If ic >= iInputs Then
   iu = 0
     Do
        If iState(iLinks(ic, iu)) = 1 And iWeights(ic, iu) < 255 Then iWeights(ic, iu) = iWeights(ic, iu) + 1
        iu = iu + 1
    Loop Until iLinks(ic, iu) = -1
  End If
End If
Next
Else
'light is on and this is wrong
For ic = 0 To isize
'check ON cells
If iState(ic) = 1 Then
  'raise threshold of cell
  If iTrig(ic) < 255 Then iTrig(ic) = iTrig(ic) + 1
  'Lower weighting for ON links
  If ic >= iInputs Then
    iu = 0
    Do
        If iState(iLinks(ic, iu)) = 1 And iWeights(ic, iu) > -255 Then iWeights(ic, iu) = iWeights(ic, iu) - 1
        iu = iu + 1
    Loop Until iLinks(ic, iu) = -1
  End If
End If
Next
End If
score
cmdNext_Click
End Sub

Private Sub cmdReset_Click()
Dim ii As Integer
For ii = 0 To isize
iState(ii) = 0
 shpCell(ii).BorderColor = QBColor(0)
 shpCell(ii).FillColor = RGB(255, 0, 0)
Next
 For ii = 0 To 2
 shpStim(ii).FillColor = QBColor(0)
 Next
init
End Sub

Private Sub cmdYes_Click()
Dim ic As Integer, id As Integer, iu As Integer
If iState(isize) = 1 Then
'light is on and it's right
For ic = 0 To isize
'check ON cells
If iState(ic) = 1 Then
  'lower threshold of cell
  If iTrig(ic) > 0 Then iTrig(ic) = iTrig(ic) - 1
  'raise weighting for ON links
  If ic >= iInputs Then
    iu = 0
    Do
        If iState(iLinks(ic, iu)) = 1 And iWeights(ic, iu) < 255 Then iWeights(ic, iu) = iWeights(ic, iu) + 1
        iu = iu + 1
    Loop Until iLinks(ic, iu) = -1
  End If
End If
Next
Else
' **** for some reason it seems to work better if these weights are left alone
'light is off and it's right
'For ic = 0 To isize
'check OFF cells
'If iState(ic) = 0 Then
  'raise threshold of cell
'  If iTrig(ic) < 255 Then iTrig(ic) = iTrig(ic) + 1
  'lower weighting for OFF links
 ' If ic >= iInputs Then
  '  iu = 0
  '  Do
   '     If iState(iLinks(ic, iu)) = 0 And iWeights(ic, iu) > 0 Then iWeights(ic, iu) = iWeights(ic, iu) - 1
        iu = iu + 1
   ' Loop Until iLinks(ic, iu) = -1
  'End If
'End If
'Next
End If
iscore = iscore + 1
score
cmdNext_Click
End Sub

Private Sub Form_Load()
 Dim iw As Integer, iv As Integer, ij As Integer
 Dim ik As Integer, il As Integer, im As Integer
 Dim iSrows As Integer, iScols As Integer
 iInputs = 3
 iOutputs = 1
 irows = 2
 icols = 8
 isize = irows * icols - 1 + iInputs + iOutputs
 iSrows = irows + 2
 ReDim ix(isize)
 ReDim iy(isize)
 ReDim iState(isize)
 ReDim iOstate(isize)
 ReDim iTrig(isize)
 ReDim iLinks(isize, icols)
 ReDim iWeights(isize, icols)
 iscore = 0
 igoes = 0
 'setup coordinates
 For im = 0 To isize
 'calculate row position
 If im < iInputs Then
   iScols = iInputs
   'column
   iv = im
   'row
   iw = 0
   ij = im
  
 ElseIf im >= iInputs And im <= isize - iOutputs Then
   ik = im - iInputs
   iScols = icols
   'Column
   iv = ik Mod iScols
   'row
   iw = ik \ iScols + 1
  
ElseIf im > isize - iOutputs Then

  ik = im - iInputs - irows * icols
   iScols = iOutputs
   'Column
   iv = ik Mod iScols
   'row
   iw = 1 + irows
 
 End If
   ix(im) = (Form1.ScaleWidth / iScols) * (iv + 0.5)
   iy(im) = ((Form1.ScaleHeight - 1500) / iSrows) * (iw + 0.5) + 600
  If im > 0 Then
   Load shpCell(im)
  End If
 shpCell(im).Left = ix(im) - 200
 shpCell(im).Top = iy(im) - 200
 shpCell(im).Visible = True
Next
init
End Sub


Public Sub stimulate()
'specific to this setup
Dim icolor(2) As Integer, ii As Integer
 Dim ir As Long, ig As Long, ib As Long
 For ii = 0 To 2
   icolor(ii) = shpStim(ii).FillColor / (256 ^ ii) And &HFF
   shpCell(ii).BorderColor = RGB(icolor(ii), icolor(ii), icolor(ii))
   If icolor(ii) > iTrig(ii) Then
     iState(ii) = 1
     shpCell(ii).FillColor = RGB(255, 255, 0)
   Else
     iState(ii) = 0
     shpCell(ii).FillColor = RGB(255, 0, 0)

   End If
   Next

End Sub

Public Sub propagate()
 Dim ic As Integer, id As Integer, it As Long, iu As Integer
 Dim iIn As Integer, iMax As Integer
 'copy current state to buffer
 'For ic = 0 To isize
  'iOstate(ic) = iState(ic)
 'Next
 'calc new states
For ic = iInputs To isize
  it = 0
  iIn = 0
  iMax = 0
  id = 0
  Do
  iu = iLinks(ic, id)
  iIn = iIn + 1
  
   If iu >= 0 Then
   it = it + iState(iu) * iWeights(ic, id)
   iMax = iMax + iWeights(ic, id)
  
  End If
  id = id + 1
  
  Loop Until iu < 0
  iIn = iIn * 256
  
 If it > iTrig(ic) Then
  iState(ic) = 1
  shpCell(ic).FillColor = RGB(255, 255, 0)
  Else
   iState(ic) = 0
   shpCell(ic).FillColor = RGB(255, 0, 0)
  End If
  If it > iIn Then it = iIn
  it = it / iMax * 255
 shpCell(ic).BorderColor = RGB(it, it, it)

 Next
End Sub

Public Sub init()
Dim iw As Integer, iv As Integer, ij As Integer
 Dim ik As Integer, il As Integer, im As Integer
 Dim iScols As Integer
  Randomize
 'set links and initial weights
  For im = 0 To iInputs - 1
  iTrig(im) = 64 + Rnd() * 128
  Next
  
  For im = iInputs To isize

    If im <= isize - iOutputs Then
    iTrig(im) = 64 + Rnd() * 128
      'do main cells first
      'calculate cell no in grid
      ik = im - iInputs
      'calculate row
      iw = ik \ icols
      If iw = 0 Then
        'cell links to inputs
        
         For il = 0 To iInputs - 1
            iLinks(im, il) = il
         
             iWeights(im, il) = 64 + Rnd() * 128
           Debug.Print "W"; iWeights(im, il); " ";
         Next
      
         iLinks(im, iInputs) = -1
      Else
         'cell links to row above
         'ik is position within grid
         'im is actiual cell number
         'iw is row in grid
         
         'Column
         'iv = ik Mod icols
         
         For il = 0 To icols - 1
            iLinks(im, il) = iInputs + (iw - 1) * icols + il
            iWeights(im, il) = 64 + Rnd() * 128
         Next
         iLinks(im, icols) = -1
     End If
    Else
     'cell is an output
     iw = irows
     For il = 0 To icols - 1
            iLinks(im, il) = iInputs + (iw - 1) * icols + il
            Debug.Print iLinks(im, il); " ";
            iWeights(im, il) = 64 + Rnd() * 128
     Next
         iLinks(im, icols) = -1
    End If
 'turn cell off
 iState(im) = 0
Next
Randomize
propagate
End Sub

Public Sub score()
 igoes = igoes + 1
 lblscore = Str$(Int(iscore * 100 / igoes)) & "%"
End Sub
