#NoTrayIcon
;=========================================================================
;Desktop Icons Restorator v 1.01
;This program designed for Saving and Restoring Desktop Icons positions!
;by G.Sandler (idea by trids).
;This source code requiers AutoIt version 3.2.4.9 (and higher) + libraries in "Resources" directory.
;=========================================================================

#Region Includes and Opt's
#include <Resources\A3LListView.au3>
#include <Resources\ListViewImageList.au3>
#include <Resources\FileSelectFolder_Incl.au3>
#include <Resources\DllCallBack.au3>
#include <Resources\InetGet_Incl.au3>
#include <Inet.au3>
#include <GuiConstants.au3>
#include <GuiListView.au3>
#include <GuiStatusBar.au3>
#include <Misc.au3>
Opt("TrayMenuMode", 1)
Opt("TrayOnEventMode", 1)
Opt("RunErrorsFatal", 0)
Opt("GuiOnEventMode", 1)
#EndRegion Includes and Opt's
;

#Region Variables Declaration
Global $GUI = WinGetHandle(""), $ListView, $StatusBar
Global $SetTransOnlyForGUI_CB

Global $DropFilesArr[1]
Global $InputGui = 0, $Trans_Precent_Label, $Trans_Slider
Global $RestoreNotify = False
Global $Prefs_Gui
Global $Editing_DSI_Gui
Global $Edit_Dsi_DoubleClickEvent = False
Global $Edit_LV
Global $InetErrObj

;CallBack Variables
Global $pTimerProc = 0, $uiTimer, $OriginalWindowProc

Global $AppName				= "Desktop Icons Restorator"
Global $AppVersion			= " - v1.02"
Global $Dsi_File			= ""
Global $Readme_File			= @ScriptDir & "\Readme.txt"
Global $MainIconFile		= @ScriptDir & "\Resources\Main_Icon.ico"
Global $MainIconID			= 0
Global $FilesIconFile		= @ScriptDir & "\Resources\Files_Icon.ico"
Global $FilesIconID			= 0
If @Compiled Then
	$MainIconFile 			= @AutoItExe
	$FilesIconFile 			= @AutoItExe
	$FilesIconID			= 1
EndIf

Global $ConfigFile 			= @ScriptDir & "\" & StringTrimRight(@ScriptName, 3) & "ini"
Global $LastSession			= 0
Global $Session_Date		= ""
Global $First_Sess_ID		= ""
Global $StatusBarShowTime	= 3000
Global $StatusBarTimer		= -1
Global $TrayTipTimer		= -1
Global $TrayTipWasShown 	= False
Global $Deff_AutoSessPath	= @ScriptDir & "\Auto-Saving_Sessions"

Global $Default_DSI_File	= "New_DSI_Session_File"
Global $FirstRun			= IniRead($ConfigFile, "Main Prefs", "First Run", 1)
Global $LastSessName		= IniRead($ConfigFile, "Main Prefs", "Last Session File", $Default_DSI_File)
Global $Last_AutoSessPath	= IniRead($ConfigFile, "Main Prefs", "Last Auto-Saving Session Path", $Deff_AutoSessPath)
Global $Auto_SessSavingTime	= IniRead($ConfigFile, "Main Prefs", "Auto-Saving Session Time", 0)
Global $AddToListOnAutoSave	= IniRead($ConfigFile, "Main Prefs", "Add To list When Auto-Saving Sessions", 0)
Global $Confirm_Restore 	= IniRead($ConfigFile, "Main Prefs", "Confirm Restore", 1)
Global $Confirm_Remove_All	= IniRead($ConfigFile, "Main Prefs", "Confirm Remove All From List", 1)
Global $Confirm_Delete_All	= IniRead($ConfigFile, "Main Prefs", "Confirm Delete All Sessions", 1)
Global $Confirm_Del_Sess	= IniRead($ConfigFile, "Main Prefs", "Confirm Delete Selected Session", 1)
Global $Add_DateToSess		= IniRead($ConfigFile, "Main Prefs", "Add Date/Time When Saving Session", 1)
Global $Show_Desk_On_Saving	= IniRead($ConfigFile, "Main Prefs", "Show Desktop When Saving Session", 1)
Global $QuickSavingPath		= IniRead($ConfigFile, "Main Prefs", "Quick Save Path", $Deff_AutoSessPath)
Global $QuickSaveSession	= IniRead($ConfigFile, "Main Prefs", "Quick Save Session", 0)
Global $SaveSoundPath		= IniRead($ConfigFile, "Main Prefs", "Save Sound Path", "!BeepSaveSound!")
Global $PlaySaveSound		= IniRead($ConfigFile, "Main Prefs", "Play Save Sound", 1)
Global $RestoreSoundPath	= IniRead($ConfigFile, "Main Prefs", "Restore Sound Path", "!BeepRestoreSound!")
Global $PlayRestoreSound	= IniRead($ConfigFile, "Main Prefs", "Play Restore Sound", 1)
Global $WaitSoundPlay		= 0

Global $SetTransForMainGUI	= IniRead($ConfigFile, "Main Window Prefs", "Set Transparency Only For Main Window", 1)
Global $Transparency		= IniRead($ConfigFile, "Main Window Prefs", "Transparency", 0)
Global $AppBkColor			= IniRead($ConfigFile, "Main Window Prefs", "Main Background Color", "0xF3F3F3")
Global $LV_BkColor			= IniRead($ConfigFile, "Main Window Prefs", "List Background Color", "0xF8F8FC")
Global $Main_Menu_Color		= IniRead($ConfigFile, "Main Window Prefs", "Main Menu Color", "0xC0C0C0")
Global $Context_Menu_Color	= IniRead($ConfigFile, "Main Window Prefs", "Context Menu Color", "0xBADCDC")
Global $OnTopRead			= IniRead($ConfigFile, "Main Window Prefs", "On Top", 1)
Global $MinimizeToTray 		= IniRead($ConfigFile, "Main Window Prefs", "Minimize To Tray", 0)
Global $AutoResizeColumns	= IniRead($ConfigFile, "Main Window Prefs", "Auto-Resize Columns", 1)

Global $ShowTrayIcon		= IniRead($ConfigFile, "Tray Prefs", "Show Tray Icon", 1)
Global $WhatClickShowMenu	= IniRead($ConfigFile, "Tray Prefs", "On What Click Show Menu", 2)
Global $ActionOnTrayClick	= IniRead($ConfigFile, "Tray Prefs", "Action On Tray Click", 1)
Global $TrayMenuClick		= 16

Global $GUI_STATE			= IniRead($ConfigFile, "Main Window Prefs", "Window State", "")
Global $GUI_LEFT 			= IniRead($ConfigFile, "Main Window Prefs", "Left", -1)
Global $GUI_TOP				= IniRead($ConfigFile, "Main Window Prefs", "Top", -1)
Global $GUI_WIDTH 			= IniRead($ConfigFile, "Main Window Prefs", "Width", 500)
Global $GUI_HEIGHT 			= IniRead($ConfigFile, "Main Window Prefs", "Height", 370)

If $GUI_WIDTH < 500 Then $GUI_WIDTH = 500
If $GUI_HEIGHT < 370 Then $GUI_HEIGHT = 370

#EndRegion Variables Declaration
;

#Region CmdLine Checking
If StringInStr($CmdLineRaw, ":Restore") Then
	$Sess_F_Name = StringRegExpReplace($CmdLineRaw, '(?i)(.*):Restore\s', '')
	$Sess_F_Name = StringTrimLeft(StringTrimRight($Sess_F_Name, 1), 1)
	
	$Session_Date = _GetFileDate($Sess_F_Name)
	
	Local $Sess_Files_Arr[3] = [2, $Sess_F_Name, $Session_Date]
	
	Local $WinWasVisible = _WinIsVisible($AppName & $AppVersion)
	If $WinWasVisible Then WinSetState($AppName & $AppVersion, "", @SW_MINIMIZE)
	
	$WaitSoundPlay = 1
	_RestoreSession($Sess_Files_Arr)
	
	If $WinWasVisible Then WinSetState($AppName & $AppVersion, "", @SW_RESTORE)
	Exit
EndIf

If StringInStr($CmdLineRaw, ":Create") Then
	$Sess_F_Name = _StringStripChars(StringRegExpReplace($CmdLineRaw, '(?i)(.*):Create\s', ''), '"', 3)
	$Sess_F_Path = StringLeft($Sess_F_Name, StringInStr($Sess_F_Name, "\", 0, -1))
	$DefaultName = $Default_DSI_File
	
	While 1
		$NewName = _InputBox($AppName, "Please type name for the session file:", _
			$DefaultName, 300, 150, WinGetHandle(""), 256, $MainIconFile)
		If @error Then Exit
		$CheckNewName = $NewName
		If StringRight($CheckNewName, 4) <> ".dsi" Then $CheckNewName &= ".dsi"
		
		If FileExists($Sess_F_Path & "\" & $CheckNewName) Then
			_GuiMsgBox(16, 1, $AppName & " - Error", "File with such name already exists." & @LF & _
				"Please type different name...", 300, 100, -1, 5, $Gui)
			$DefaultName = $NewName
			ContinueLoop
		ElseIf StringRight($NewName, 4) <> ".dsi" Then
			$NewName &= ".dsi"
		EndIf
		ExitLoop
	WEnd
	
	_Write_DSI_Session($Sess_F_Path & "\" & $NewName)
	Exit
EndIf

If _Singleton("DR", 1) = 0 Then
	If StringRegExp($CmdLineRaw, "(?i):Open|:Save") Then _AU3COM_SendData($CmdLineRaw, WinGetHandle($AppName & $AppVersion))
	Exit
EndIf

If StringInStr($CmdLineRaw, ":Save") Then
	$Sess_F_Name = StringRegExpReplace($CmdLineRaw, '(?i)(.*):Save\s', '')
	$Sess_F_Name = _StringStripChars($Sess_F_Name, '"', 3)
	$WaitSoundPlay = 1
	_SaveSession($Sess_F_Name, 0, 1)
	Exit
EndIf
#EndRegion CmdLine Checking
;

#Region Tray Stuff...
Global $Tray_Sessions_Items_Arr[1]

$Prefs_Dialog_TrayItem = TrayCreateItem("Preferences Dialog...")
TrayItemSetOnEvent(-1, "TrayMainEvents")

TrayCreateItem("")

$Tray_Sessions_Menu = TrayCreateMenu("Sessions")
TrayItemSetState($Tray_Sessions_Menu, 128)

$SaveSession_TrayItem = TrayCreateItem("Save Session...")
TrayItemSetOnEvent(-1, "TrayMainEvents")

$ShowDesktop_TrayItem = TrayCreateItem("Show Desktop")
TrayItemSetOnEvent(-1, "TrayMainEvents")

TrayCreateItem("")

$StopAutoSaving_TrayItem = TrayCreateItem("Stop Auto-Saving Sessions")
TrayItemSetOnEvent(-1, "TrayMainEvents")
If $Auto_SessSavingTime <= 0 Then TrayItemSetState(-1, $TRAY_DISABLE)

TrayCreateItem("")

$ActivateApp_TrayItem = TrayCreateItem("Activate/Show program window")
TrayItemSetOnEvent(-1, "TrayMainEvents")

TrayCreateItem("Exit program")
TrayItemSetOnEvent(-1, "Quit")

If $WhatClickShowMenu = 2 Then
	TraySetClick(16)
	TraySetOnEvent(-7, "TrayIconClickEvent")
Else
	$TrayMenuClick = 2
	TraySetClick(2)
	TraySetOnEvent(-9, "TrayIconClickEvent")
EndIf

TraySetToolTip($AppName & $AppVersion)
If $ShowTrayIcon = 1 Then
	TraySetIcon($MainIconFile)
Else
	TraySetState(2)
EndIf
#EndRegion Tray Stuff
;

#Region Gui Creation and RegisterMsg
$Gui = GuiCreate($AppName & $AppVersion, 500, 370, -1, -1, _
	$WS_SIZEBOX+$WS_MINIMIZEBOX+$WS_MAXIMIZEBOX+$WS_BORDER, $WS_EX_CLIENTEDGE+$WS_EX_ACCEPTFILES)
GUISetOnEvent($GUI_EVENT_CLOSE, "Quit")
GUISetOnEvent($GUI_EVENT_DROPPED, "DroppedInEvent")
SetTransparency($Gui)
GUISetBkColor($AppBkColor, $Gui)

GUIRegisterMsg(0x004E, "WM_NOTIFY_EVENTS")
GUIRegisterMsg(0x24, "WM_GETMINMAXINFO")
GUIRegisterMsg(0x233, "WM_DROPFILES_FUNC")
GUIRegisterMsg($WM_LBUTTONDOWN, "DRAG_COMMAND")
GUIRegisterMsg($WM_COPYDATA, "WM_SESS_FUNC")
GUIRegisterMsg($WM_SIZE, "WM_SIZE")
GUIRegisterMsg($WM_SYSCOMMAND, "WM_SYSCOMMAND")

GUISetIcon($MainIconFile)
#EndRegion Gui Creation and RegisterMsg
;

#Region Menu Stuff
;Menu IDs
$Options_Menu = GUICtrlCreateMenu("Options")
$Edit_Menu = GUICtrlCreateMenu("Edit")
$View_Menu = GUICtrlCreateMenu("View")
$Help_Menu = GUICtrlCreateMenu("Help")

;Options Menu...
$Dsi_Register_Item = GUICtrlCreateMenuItem("Regiser Application...	(F2)", $Options_Menu)
GUICtrlSetOnEvent(-1, "MainEvents")

GUICtrlCreateMenuItem("", $Options_Menu)

$AutoSaveSessions_Item = GUICtrlCreateMenuItem("Set Auto-Saving Sessions...	(F3)", $Options_Menu)
GUICtrlSetOnEvent(-1, "MainEvents")

GUICtrlCreateMenuItem("", $Options_Menu)

$Prefs_Dialog_Item = GUICtrlCreateMenuItem("Preferences Dialog...	(F4)", $Options_Menu)
GUICtrlSetOnEvent(-1, "MainEvents")

GUICtrlCreateMenuItem("", $Options_Menu)

$Exit_Item = GUICtrlCreateMenuItem("EXIT	(ESC)", $Options_Menu)
GUICtrlSetOnEvent(-1, "Quit")

;Edit Menu...
$RemoveNotExisted_Item = GUICtrlCreateMenuItem("Remove Not existing sessions from list	(CTRL+DEL)", $Edit_Menu)
GUICtrlSetOnEvent(-1, "MainEvents")

$RemoveDuplicates_Item = GUICtrlCreateMenuItem("Remove Duplicates	(SHIFT+D)", $Edit_Menu)
GUICtrlSetOnEvent(-1, "MainEvents")

GUICtrlCreateMenuItem("", $Edit_Menu)

$RemoveSelected_Item = GUICtrlCreateMenuItem("Remove selected from list	(DEL)", $Edit_Menu)
GUICtrlSetOnEvent(-1, "MainEvents")

$RemoveAll_Item = GUICtrlCreateMenuItem("Remove All from list	(SHIFT+DEL)", $Edit_Menu)
GUICtrlSetOnEvent(-1, "MainEvents")

GUICtrlCreateMenuItem("", $Edit_Menu)

$DeleteAllSessions_Item = GUICtrlCreateMenuItem("Delete All Sessions	(CTRL+SHIFT+DEL)", $Edit_Menu)
GUICtrlSetOnEvent(-1, "MainEvents")

;View Menu...
$ShowDesktop_Item = GUICtrlCreateMenuItem("Show Desktop	(F12)", $View_Menu)
GUICtrlSetOnEvent(-1, "MainEvents")

GUICtrlCreateMenuItem("", $View_Menu)

$OnTop_Item = GUICtrlCreateMenuItem("Always On Top", $View_Menu)
GUICtrlSetOnEvent(-1, "MainEvents")
If $OnTopRead = 1 Then
	GUICtrlSetState(-1, 1)
	WinSetOnTop($Gui, "", 1)
EndIf

$MinimizeToTray_Item = GUICtrlCreateMenuItem("Minimize to tray", $View_Menu)
GUICtrlSetOnEvent(-1, "MainEvents")
If $MinimizeToTray = 1 Then GUICtrlSetState(-1, 1)

GUICtrlCreateMenuItem("", $View_Menu)

$AutoResizeColumns_Item = GUICtrlCreateMenuItem("Auto-Resize Columns", $View_Menu)
GUICtrlSetOnEvent(-1, "MainEvents")
If $AutoResizeColumns = 1 Then GUICtrlSetState(-1, 1)

;Help Menu
$CheckUpdates_Item = GUICtrlCreateMenuItem("Check Updates..	(CTRL+U)", $Help_Menu)
GUICtrlSetOnEvent(-1, "MainEvents")

$AboutApp_Item = GUICtrlCreateMenuItem("About the program	(F1)", $Help_Menu)
GUICtrlSetOnEvent(-1, "MainEvents")

SetMenuColor($Options_Menu, RGB2BGR($Main_Menu_Color))
SetMenuColor($Edit_Menu, RGB2BGR($Main_Menu_Color))
SetMenuColor($View_Menu, RGB2BGR($Main_Menu_Color))
SetMenuColor($Help_Menu, RGB2BGR($Main_Menu_Color))
#EndRegion Menu Stuff
;

#Region List View Stuff (including Context menu)
$ListView = GUICtrlCreateListView("Session File Name|Session Date", 0, 0, 500, 250, _
	BitOr($GUI_SS_DEFAULT_LISTVIEW, $LVS_NOSORTHEADER), $LVS_EX_GRIDLINES+$LVS_EX_TRACKSELECT+$WS_EX_CLIENTEDGE)
GUICtrlSetState(-1, $GUI_DROPACCEPTED)
If $LV_BkColor <> -1 Then GUICtrlSetBkColor(-1, $LV_BkColor)

Global $h_LV = GUICtrlGetHandle($ListView)

$LV_Context_Menu = GUICtrlCreateContextMenu($ListView)

$SaveToSession_Context_Item = GUICtrlCreateMenuItem("Save Session Here	(SHIFT+S)", $LV_Context_Menu)
GUICtrlSetOnEvent(-1, "ContextMenuEvents")

$CleanNotExistInSess_Item = GUICtrlCreateMenuItem("Clean Not Existing Entries In Session File	(CTRL+SHIFT+D)", $LV_Context_Menu)
GUICtrlSetOnEvent(-1, "ContextMenuEvents")

GUICtrlCreateMenuItem("", $LV_Context_Menu)

$Edit_DSI_File_Context_Item = GUICtrlCreateMenuItem("Edit Session File...	(CTRL+E)", $LV_Context_Menu)
GUICtrlSetOnEvent(-1, "ContextMenuEvents")

$CopySessionToClip_Context_Item = GUICtrlCreateMenuItem("Copy Session file to Clipboard	(CTRL+C)", $LV_Context_Menu)
GUICtrlSetOnEvent(-1, "ContextMenuEvents")

$OpenSessionDir_Context_Item = GUICtrlCreateMenuItem("Open Dir with Session File	(CTRL+SHIFT+O)", $LV_Context_Menu)
GUICtrlSetOnEvent(-1, "ContextMenuEvents")

GUICtrlCreateMenuItem("", $LV_Context_Menu)

$DelSelectedSession_Context_Item = GUICtrlCreateMenuItem("Delete selected Session File...	(CTRL+D)", $LV_Context_Menu)
GUICtrlSetOnEvent(-1, "ContextMenuEvents")

$RenameSessionFile_Context_Item = GUICtrlCreateMenuItem("Rename selected Session file...	(CTRL+R)", $LV_Context_Menu)
GUICtrlSetOnEvent(-1, "ContextMenuEvents")

GUICtrlCreateMenuItem("", $LV_Context_Menu)

$RemoveSelected_Context_Item = GUICtrlCreateMenuItem("Remove selected from list	(DEL)", $LV_Context_Menu)
GUICtrlSetOnEvent(-1, "MainEvents")

SetImagesProc($h_LV, $FilesIconFile, $FilesIconID)
SetMenuColor($LV_Context_Menu, RGB2BGR($Context_Menu_Color))

#EndRegion List View Stuff
;

#Region Main Window Controls
$Add_Session_Files_Button = GUICtrlCreateButton("+", 20, 260, 20, 20)
GUICtrlSetOnEvent(-1, "MainEvents")
GUICtrlSetFont(-1, 13, 800)
GUICtrlSetTip(-1, "Add Session File(s)... (CTRL+A)")
GUICtrlSetResizing(-1, 2+768+64)

$SaveSession_Button = GUICtrlCreateButton("Save Session", 70, 260, 100, 20)
GUICtrlSetOnEvent(-1, "MainEvents")
GUICtrlSetTip(-1, "Save Session File (CTRL+S)")
GUICtrlSetResizing(-1, 2+768+64)

$RestoreSession_Button = GUICtrlCreateButton("Restore Session", 180, 260, 100, 20)
GUICtrlSetOnEvent(-1, "MainEvents")
GUICtrlSetTip(-1, "Restore Session File (ENTER)")
GUICtrlSetResizing(-1, 2+768+64)

$StopAutoSaving_Icon = GUICtrlCreateIcon(@SystemDir & "\gcdef.dll", -2, 400, 250, 24, 24)
GUICtrlSetOnEvent(-1, "MainEvents")
GUICtrlSetTip(-1, "Stop Auto-Saving Sessions (CTRL+SHIFT+S)")
GUICtrlSetResizing(-1, 4+768+64)
If $Auto_SessSavingTime <= 0 Then GUICtrlSetState(-1, $GUI_HIDE)

$StopAutoSaving_Label = GUICtrlCreateLabel("Stop Auto-Saving", 370, 270)
GUICtrlSetResizing(-1, 4+768+64)
GUICtrlSetFont(-1, 8)
If $Auto_SessSavingTime <= 0 Then GUICtrlSetState(-1, $GUI_HIDE)

$StatusBar = _GUICtrlStatusBarCreate($GUI, "", "")
_GUICtrlStatusBarSetSimple($StatusBar)
_GUICtrlStatusBarSetIcon($StatusBar, 255, "User32.dll", 4)
#EndRegion Main Window Controls
;

#Region Set Window State, Posiotions (and addition Calls as User Defined in Prefs)
;Set first parameters and Show the GUI
SetSessionItems()
SetColumnsWidth()

GUISetState(@SW_HIDE, $Gui)

If $GUI_LEFT = -1 Or $GUI_TOP = -1 Then
	$GuiPosArr = WinGetPos($Gui)
	If IsArray($GuiPosArr) Then
		$GUI_LEFT = $GuiPosArr[0]
		$GUI_TOP = $GuiPosArr[1]
	EndIf
EndIf
WinMove($Gui, "", $GUI_LEFT, $GUI_TOP, $GUI_WIDTH, $GUI_HEIGHT)

If BitAND($GUI_STATE, 32) = 32 And BitAND($GUI_STATE, 2) = 2 Then WinSetState($Gui, "", @SW_MAXIMIZE)

If BitAND($GUI_STATE, 2) = 2 Or $GUI_STATE = "" Then
	GUISetState(@SW_SHOW, $Gui)
Else
	TrayTip($AppName, "Program minimized to System Tray!" & @LF & @LF & _
		"* Click Left mouse button to show main window." & @LF & _
		"* Right mouse button to show menu.", 15, 1)
	$TrayTipWasShown = True
	$TrayTipTimer = TimerInit()
EndIf

If StringInStr($CmdLineRaw, ":Open") Then _AU3COM_SendData($CmdLineRaw, $Gui)

If $Auto_SessSavingTime > 0 Then
	$pTimerProc = _DllCallBack("_QuickSessionSave", "hwnd;uint;uint;dword")
	$uiTimer = DllCall("user32.dll", "uint", "SetTimer", "hwnd", 0, "uint", 0, "int", _
		$Auto_SessSavingTime*1000, "ptr", $pTimerProc)
	$uiTimer = $uiTimer[0]
EndIf

If $FirstRun = 1 Then
	IniWrite($ConfigFile, "Main Prefs", "First Run", 0)
	$AskRegistr = _GuiMsgBox(36, 2, $AppName & " - Wellcome!", _
		"It seems that this is the very first time you runing this program..." & @LF & _
		"Would you like to proceed to the <Registration Application File Types> Dialog?", 450, 120, -1, 0, $Gui, "Yes", "No")
	If $AskRegistr - BitAND($AskRegistr, 8) = 6 Then
		RegisterDialog()
	Else
		_GuiMsgBox(64, 1, $AppName & " - Info!", "It's OK, " & @LF & _
			"You can register the files type later from <Options> Menu ;) .", 370, 100, -1, 10, $Gui)
	EndIf
EndIf

FileChangeDir(@ScriptDir)

;Reduce Memory (After seting the begining parameters App Memory is increesed)
_ReduceMemory(@AutoItPID)
#EndRegion Set Window State, Posiotions (and addition Calls as User Defined in Prefs)
;

#Region Main Loop
While 1
	Sleep(100)
	If $TrayTipTimer <> -1 Then
		TraySetState(4)
		While TimerDiff($TrayTipTimer) < 10000 And _WinIsVisible("[CLASS:tooltips_class32]")
			Sleep(10)
		WEnd
		$TrayTipTimer = -1
		TraySetState(8)
	EndIf
	
	If $RestoreNotify Then
		$RestoreNotify = False
		_RestoreSession()
	EndIf
	
	If $StatusBarTimer <> -1 And TimerDiff($StatusBarTimer) >= $StatusBarShowTime Then SetStatusBarData()
	
	If WinActive($Gui) Then
		DroppedOutEvent()
		ToggleHotKeys(1)
	Else
		ToggleHotKeys(0)
	EndIf
WEnd
#EndRegion Main Loop
;

; Functions Goes bellow
Func MainEvents()
	ToggleHotKeys(0)
	SetStatusBarData()
	Switch @GUI_CtrlId
		Case $ShowDesktop_Item
			WinMinimizeAll()
		Case $Dsi_Register_Item
			RegisterDialog()
		Case $RemoveNotExisted_Item
			CallRemoveNotExistedProc()
		Case $RemoveDuplicates_Item
			CallRemoveDupsProc()
		Case $RemoveSelected_Item, $RemoveSelected_Context_Item
			CallRemoveSelectedProc()
		Case $RemoveAll_Item
			CallRemoveAllItemsProc()
		Case $DeleteAllSessions_Item
			CallDeleteAllSessProc()
		Case $AutoSaveSessions_Item
			AutoSaveSessDialog()
		Case $OnTop_Item
			If GUICtrlRead($OnTop_Item) = 65 Then
				GUICtrlSetState($OnTop_Item, 4)
				WinSetOnTop($Gui, "", 0)
			Else
				GUICtrlSetState($OnTop_Item, 1)
				WinSetOnTop($Gui, "", 1)
			EndIf
		Case $MinimizeToTray_Item
			If GUICtrlRead($MinimizeToTray_Item) = 65 Then
				GUICtrlSetState($MinimizeToTray_Item, 4)
				$MinimizeToTray = 0
			Else
				GUICtrlSetState($MinimizeToTray_Item, 1)
				$MinimizeToTray = 1
			EndIf
		Case $AutoResizeColumns_Item
			If GUICtrlRead($AutoResizeColumns_Item) = 65 Then
				GUICtrlSetState($AutoResizeColumns_Item, 4)
				$AutoResizeColumns = 0
			Else
				GUICtrlSetState($AutoResizeColumns_Item, 1)
				$AutoResizeColumns = 1
				SetColumnsWidth()
			EndIf
		Case $CheckUpdates_Item
			CallCheckUpdatesProc()
		Case $AboutApp_Item
			CallAboutProc()
		Case $Add_Session_Files_Button
			CallAddSessionProc()
		Case $SaveSession_Button
			CallSaveProc()
		Case $RestoreSession_Button
			CallRestoreProc()
		Case $StopAutoSaving_Icon
			CallStopAutoSavingProc()
		Case $Prefs_Dialog_Item
			CallPrefsProc()
	EndSwitch
EndFunc

Func DroppedInEvent()
	ToggleHotKeys(0)
	$DroppedSessionPath = @GUI_DragFile
	If StringRight($DroppedSessionPath, 3) <> "dsi" Then
		SetStatusBarData("The File Must be a *.DSI file Type")
		Return
	EndIf
	
	For $i = 1 To UBound($DropFilesArr)-1
		_AddSession($DropFilesArr[$i])
	Next
	TrayItemSetState($Tray_Sessions_Menu, 64)
EndFunc

Func DroppedOutEvent()
	ToggleHotKeys(0)
	Local $CurInfo = GUIGetCursorInfo($Gui)
	If IsArray($CurInfo) And $CurInfo[4] = $ListView Then
		Local $SelText = _LV_GetSelectedText($ListView, 0)
		While IsArray($CurInfo) And $CurInfo[2] = 1
			$CurInfo = GUIGetCursorInfo($Gui)
			Sleep(10)
		WEnd
		
		If $SelText <> "" And IsArray($CurInfo) And $CurInfo[4] = 0 Then
			MouseClick("LEFT")
			
			If WinActive("[CLASS:CabinetWClass]") Then
				$DestPath = ControlGetText("[CLASS:CabinetWClass]", "", "Edit1")
				_FileCopy($SelText, $DestPath & "\")
			Else
				$Old_Clip = ClipGet()
				ClipPut($SelText)
				Send("+{Insert}")
				ClipPut($Old_Clip)
			EndIf
		EndIf
	EndIf
EndFunc

Func ContextMenuEvents()
	ToggleHotKeys(0)
	SetStatusBarData()
	Switch @GUI_CtrlId
		Case $SaveToSession_Context_Item
			CallSaveHereProc()
		Case $CleanNotExistInSess_Item
			CallCleanNotExistInSessProc()
		Case $Edit_DSI_File_Context_Item
			CallEditDSIFileProc()
		Case $CopySessionToClip_Context_Item
			CallCopyToClipProc()
		Case $OpenSessionDir_Context_Item
			CallOpenSessDirProc()
		Case $DelSelectedSession_Context_Item
			CallDelSelectedSessProc()
		Case $RenameSessionFile_Context_Item
			CallRenameSessionProc()
	EndSwitch
EndFunc

Func TrayMainEvents()
	ToggleHotKeys(0)
	SetStatusBarData()
	Switch @TRAY_ID
		Case $Prefs_Dialog_TrayItem
			CallPrefsProc()
		Case $ShowDesktop_TrayItem
			WinMinimizeAll()
		Case $SaveSession_TrayItem
			CallSaveProc()
		Case $StopAutoSaving_TrayItem
			CallStopAutoSavingProc()
		Case $ActivateApp_TrayItem
			WinSetState($Gui, "", @SW_SHOW)
			WinActivate($Gui)
	EndSwitch
EndFunc

Func TrayIconClickEvent()
	ToggleHotKeys(0)
	If $ActionOnTrayClick = 1 Then
		WinSetState($Gui, "", @SW_SHOW)
		If BitAND($GUI_STATE, 32) Then WinSetState($Gui, "", @SW_MAXIMIZE)
		WinActivate($Gui)
	Else
		Local $LastSessToCheck = $LastSession
		Local $LastRestoredSession_File = IniRead($ConfigFile, "Sessions", "Session_" & $LastSessToCheck, "")
		While Not FileExists($LastRestoredSession_File)
			$LastSessToCheck -= 1
			$LastRestoredSession_File = IniRead($ConfigFile, "Sessions", "Session_" & $LastSessToCheck, "")
			If $LastSessToCheck <= 0 Then ExitLoop
		WEnd
		
		Local $LastRestoredSession_Date = _GetFileDate($LastRestoredSession_File)
		Local $Sess_File_Arr[3] = [2, $LastRestoredSession_File, $LastRestoredSession_Date]
		_RestoreSession($Sess_File_Arr)
	EndIf
EndFunc

Func TraySessionsEvents()
	ToggleHotKeys(0)
	Local $TrayItemText = TrayItemGetText(@TRAY_ID)
	Local $PassArray[3]
	Local $TrayItemTextArr = StringRegExp($TrayItemText, "(?i)(.*)\t\[(.*)\]", 1)
	
	If Not IsArray($TrayItemTextArr) Then
		Local $PassArray[3] = [2, $TrayItemText, ""]
	Else
		Local $PassArray[3] = [2, $TrayItemTextArr[0], $TrayItemTextArr[1]]
	EndIf
	_RestoreSession($PassArray)
EndFunc

Func HideToTrayProc()
	ToggleHotKeys(0)
	If $MinimizeToTray = 1 Then
		$GUI_STATE = WinGetState($Gui)
		If BitAND($GUI_STATE, 16) Then WinSetState($Gui, "", @SW_RESTORE)
		
		$GuiPosArr = WinGetPos($Gui)
		WinSetState($Gui, "", @SW_HIDE)
		
		IniWrite($ConfigFile, "Main Window Prefs", "Window State", $GUI_STATE + 2)
		
		If Not BitAND($GUI_STATE, 32) Then _Write_GUI_Pos($GuiPosArr)
		
		If Not $TrayTipWasShown Then
			Local $MainWinButton = "Left"
			Local $MenuButton = "Right"
			If $TrayMenuClick = 2 Then
				$MainWinButton = "Right"
				$MenuButton = "Left"
			EndIf
			TrayTip($AppName, "Program minimized to System Tray!" & @LF & @LF & _
				"* Click " & $MainWinButton & " mouse button to show main window." & @LF & _
				"* " & $MenuButton & " mouse button to show menu.", 15, 1)
			$TrayTipWasShown = True
			$TrayTipTimer = TimerInit()
		EndIf
	Else
		WinSetState($Gui, "", @SW_MINIMIZE)
	EndIf
EndFunc

Func MaximizeProc()
	If BitAND(WinGetState($Gui), 16) Then WinSetState($Gui, "", @SW_RESTORE)
	$GuiPosArr = WinGetPos($Gui)
	WinSetState($Gui, "", @SW_MAXIMIZE)
	_Write_GUI_Pos($GuiPosArr)
EndFunc

Func SetSessionItems()
	ToggleHotKeys(0)
	Local $SessionsArray = IniReadSection($ConfigFile, "Sessions")
	If Not IsArray($SessionsArray) Then Return
	
	For $iT = 1 To UBound($Tray_Sessions_Items_Arr)-1
		TrayItemDelete($Tray_Sessions_Items_Arr[$iT])
	Next
	
	TrayItemSetState($Tray_Sessions_Menu, 64)
	_GUICtrlListViewDeleteAllItems($ListView)
	
	Local $ItemIndex
	$LastSession = $SessionsArray[0][0]
	For $i = 1 To UBound($SessionsArray)-1
		$Session_Date = _GetFileDate($SessionsArray[$i][1])
		
		$ItemIndex = _GUICtrlListViewInsertItem($ListView, -1, $SessionsArray[$i][1] & "|" & $Session_Date)
		_GUICtrlListViewSetItemImage($h_LV, $ItemIndex, 0, 0)
		
		If $Session_Date <> "" Then $Session_Date = "	[" & $Session_Date & "]"
		ReDim $Tray_Sessions_Items_Arr[UBound($Tray_Sessions_Items_Arr)+1]
		$Tray_Sessions_Items_Arr[UBound($Tray_Sessions_Items_Arr)-1] = TrayCreateItem($SessionsArray[$i][1] & _
			$Session_Date, $Tray_Sessions_Menu)
		TrayItemSetOnEvent(-1, "TraySessionsEvents")
	Next
EndFunc

Func SetStatusBarData($Data="")
	If $Data = "" Then
		_GUICtrlStatusBarSetText($StatusBar, "", 255)
		$StatusBarTimer = -1
	Else
		$StatusBarTimer = TimerInit()
		_GUICtrlStatusBarSetText($StatusBar, $Data, 255)
	EndIf
EndFunc

Func SetColumnsWidth()
	Local $CountItems = _GUICtrlListViewGetItemCount($ListView)
	If $CountItems = 0 Then Return
	
	Local $GuiPosArr = WinGetPos($Gui)
	If Not IsArray($GuiPosArr) Then Return
	GUICtrlSendMsg($ListView, $LVM_SETCOLUMNWIDTH, 1, -1)
	Local $DateColumnWidth = _GUICtrlListViewGetColumnWidth($ListView, 1)
	GUICtrlSendMsg($ListView, $LVM_SETCOLUMNWIDTH, 0, $GuiPosArr[2]-$DateColumnWidth-20)
EndFunc

Func SetTransparency($hWnd)
	If $SetTransForMainGUI = 1 And $hWnd <> $Gui Then Return
	If $Transparency <> 0 And $Transparency <= 255 Then WinSetTrans($hWnd, "", 255-$Transparency)
EndFunc

Func SetMenuColor($nMenuID, $nColor)
	; Minimum OS are Windows98 and 2000 
	If @OSVersion = "WIN_95" Or @OSVersion = "WIN_NT4" Then Return
	
	Local Const $MIM_APPLYTOSUBMENUS   = 0x80000000
	Local Const $MIM_BACKGROUND        = 0x00000002
	Local $hMenu  = GUICtrlGetHandle($nMenuID)
	
	Local $hBrush = DllCall("gdi32.dll", "hwnd", "CreateSolidBrush", "int", $nColor)
	$hBrush = $hBrush[0]
	
	Local $stMenuInfo = DllStructCreate("dword;dword;dword;uint;dword;dword;ptr")
	DllStructSetData($stMenuInfo, 1, DllStructGetSize($stMenuInfo))
	DllStructSetData($stMenuInfo, 2, BitOr($MIM_APPLYTOSUBMENUS, $MIM_BACKGROUND))
	DllStructSetData($stMenuInfo, 5, $hBrush)
	
	DllCall("user32.dll", "int", "SetMenuInfo", "hwnd", $hMenu, "ptr", DllStructGetPtr($stMenuInfo))
	
	; release Struct not really needed as it is a local 
	$stMenuInfo = 0
EndFunc

Func RGB2BGR($RgbBgr)
	If StringLeft($RgbBgr, 2) = "0x" Then $RgbBgr = StringTrimLeft($RgbBgr, 2)
	
	Local $BB = StringRight($RgbBgr, 2)
	Local $GG = StringMid($RgbBgr, 3, 2)
	Local $RR = StringLeft($RgbBgr, 2)
	
	Return "0x" & $BB & $GG & $RR
EndFunc

Func ToggleHotKeys($OnOff=1)
	If $OnOff = 1 Then
		HotKeySet("{ESC}", "Quit")
		HotKeySet("{F1}", "CallAboutProc")
		HotKeySet("{F2}", "RegisterDialog")
		HotKeySet("{F3}", "AutoSaveSessDialog")
		HotKeySet("{F4}", "CallPrefsProc")
		HotKeySet("{F12}", "CallShowDesktopProc")
		HotKeySet("{Enter}", "CallRestoreProc")
		HotKeySet("{Del}", "CallRemoveSelectedProc")
		HotKeySet("^{Del}", "CallRemoveNotExistedProc")
		HotKeySet("+{Del}", "CallRemoveAllItemsProc")
		HotKeySet("^+{Del}", "CallDeleteAllSessProc")
		HotKeySet("^u", "CallCheckUpdatesProc")
		HotKeySet("+d", "CallRemoveDupsProc")
		HotKeySet("^d", "CallDelSelectedSessProc")
		HotKeySet("^a", "CallAddSessionProc")
		HotKeySet("^r", "CallRenameSessionProc")
		HotKeySet("^s", "CallSaveProc")
		HotKeySet("+s", "CallSaveHereProc")
		HotKeySet("^+d", "CallCleanNotExistInSessProc")
		HotKeySet("^e", "CallEditDSIFileProc")
		HotKeySet("^+s", "CallStopAutoSavingProc")
		HotKeySet("^c", "CallCopyToClipProc")
		HotKeySet("^+o", "CallOpenSessDirProc")
	Else
		HotKeySet("{ESC}")
		HotKeySet("{F1}")
		HotKeySet("{F2}")
		HotKeySet("{F3}")
		HotKeySet("{F4}")
		HotKeySet("{F12}")
		HotKeySet("{Enter}")
		HotKeySet("{Del}")
		HotKeySet("^{Del}")
		HotKeySet("+{Del}")
		HotKeySet("^+{Del}")
		HotKeySet("^u")
		HotKeySet("+d")
		HotKeySet("^d")
		HotKeySet("^a")
		HotKeySet("^r")
		HotKeySet("^s")
		HotKeySet("+s")
		HotKeySet("^+d")
		HotKeySet("^e")
		HotKeySet("^+s")
		HotKeySet("^c")
		HotKeySet("^+o")
	EndIf
EndFunc

Func CallShowDesktopProc()
	SetStatusBarData()
	WinMinimizeAll()
EndFunc

Func CallSaveProc()
	SetStatusBarData()
	ToggleHotKeys(0)
	TraySetClick(0)
	If $QuickSaveSession = 1 Then
		$Quick_Sess_File = $QuickSavingPath & "\Quick-Saved_Session [" & _GetDateTime() & "].dsi"
		_SaveSession($Quick_Sess_File, 1, 1)
		If @error Then _GuiMsgBox(16, 1, $AppName & " - Error", "There was an error to write session file:" & @LF & _
			_GetMidlePath($Quick_Sess_File), 300, 120, -1, 10, $Gui)
	Else
		If $Show_Desk_On_Saving = 1 Then WinMinimizeAll()
		_SaveSession()
		If $Show_Desk_On_Saving = 1 Then
			WinMinimizeAllUndo()
			If _WinIsVisible($Gui) Then WinActivate($Gui)
		EndIf
	EndIf
	TraySetClick($TrayMenuClick)
EndFunc

Func CallRestoreProc()
	SetStatusBarData()
	TraySetClick(0)
	_RestoreSession()
	TraySetClick($TrayMenuClick)
EndFunc

Func CallStopAutoSavingProc()
	SetStatusBarData()
	Local $CheckTimerProc = $pTimerProc
	_DllCallBack_Free($pTimerProc)
	DllCall("user32.dll", "int", "KillTimer", "hwnd", 0, "uint", $uiTimer)
	
	If $CheckTimerProc = 0 Then Return
	$pTimerProc = 0
	
	GUICtrlSetState($StopAutoSaving_Icon, $GUI_HIDE)
	GUICtrlSetState($StopAutoSaving_Label, $GUI_HIDE)
	TrayItemSetState($StopAutoSaving_TrayItem, $TRAY_DISABLE)
	$Auto_SessSavingTime = 0
	IniWrite($ConfigFile, "Main Prefs", "Auto-Saving Session Time", $Auto_SessSavingTime)
	_ReduceMemory(@AutoItPID)
EndFunc

Func CallAboutProc()
	SetStatusBarData()
	TraySetClick(0)
	_AboutBox($AppName & " - About", $Gui, $MainIconFile)
	TraySetClick($TrayMenuClick)
EndFunc

Func CallPrefsProc()
	SetStatusBarData()
	TraySetClick(0)
	PreferencesDialog($Gui)
	TraySetClick($TrayMenuClick)
EndFunc

Func CallAddSessionProc()
	SetStatusBarData()
	TraySetClick(0)
	_AddSessionFiles()
	TraySetClick($TrayMenuClick)
EndFunc

Func CallRemoveDupsProc()
	SetStatusBarData()
	Local $TotalItems = _GUICtrlListViewGetItemCount($ListView)
	Local $DuplsIsFound = False
	$LastSession = 0
	IniDelete($ConfigFile, "Sessions")
	
	For $i = $TotalItems - 1 To 0 Step -1
		$CurrentSessFile = _GUICtrlListViewGetItemText($ListView, $i, 0)
		$FindDuplicate = _FindLVItem($ListView, $CurrentSessFile, 0, $i)
		If $FindDuplicate <> -1 Then
			$DuplsIsFound = True
			TrayItemDelete($Tray_Sessions_Items_Arr[$FindDuplicate+1])
			_RemoveFromArray($Tray_Sessions_Items_Arr, $FindDuplicate+1)
			If @error = -1 Then TrayItemSetState($Tray_Sessions_Menu, 128)
			_GUICtrlListViewDeleteItem($ListView, $FindDuplicate)
		Else
			$LastSession += 1
			IniWrite($ConfigFile, "Sessions", "Session_" & $LastSession, $CurrentSessFile)
		EndIf
	Next
	
	If Not $DuplsIsFound Then SetStatusBarData("No duplicates found.")
EndFunc

Func CallRemoveNotExistedProc()
	SetStatusBarData()
	CheckSelectedSession(2)
	If @error Then Return
	
	Local $Sess_Files_Arr = IniReadSection($ConfigFile, "Sessions")
	If @error Then Return
	
	IniDelete($ConfigFile, "Sessions")
	$LastSession = 0
	
	Local $SessCounter = 1
	For $i = 1 To $Sess_Files_Arr[0][0]
		$Current_DSI_File = $Sess_Files_Arr[$i][1]
		If FileExists($Current_DSI_File) And StringRight($Current_DSI_File, 3) = "dsi" Then
			IniWrite($ConfigFile, "Sessions", "Session_" & $SessCounter, $Current_DSI_File)
			$SessCounter += 1
		EndIf
	Next
	
	If $SessCounter > 1 Then
		SetSessionItems()
	Else
		For $iT = 1 To UBound($Tray_Sessions_Items_Arr)-1
			TrayItemDelete($Tray_Sessions_Items_Arr[$iT])
		Next
		_GUICtrlListViewDeleteAllItems($ListView)
		TrayItemSetState($Tray_Sessions_Menu, 128)
	EndIf
EndFunc

Func CallRemoveSelectedProc()
	SetStatusBarData()
	Local $SelectedSession = CheckSelectedSession(1)
	If @error Then Return
	
	RemoveSelectedItem()
EndFunc

Func CallRemoveAllItemsProc()
	SetStatusBarData()
	CheckSelectedSession(2)
	If @error Then Return
	
	If $Confirm_Remove_All = 1 Then
		TraySetClick(0)
		Local $AskRemove = _GuiMsgBox(48, 2, $AppName & " - Attention", _
			"Are you sure that you want to remove all session items from the list?", 300, 100, _
			"Next time remove without promt", -1, $Gui, "Yes", "No")
		TraySetClick($TrayMenuClick)
		
		$CheckBitAnd = BitAND($AskRemove, 8)
		If $CheckBitAnd = 8 Then
			$Confirm_Remove_All = 0
			IniWrite($ConfigFile, "Main Prefs", "Confirm Remove All From List", 0)
		EndIf
		If $AskRemove - $CheckBitAnd = 7 Then Return
	EndIf
	
	RemoveAllItems(0)
EndFunc

Func CallDelSelectedSessProc()
	SetStatusBarData()
	Local $SelectedSession = CheckSelectedSession(1)
	If @error Then Return
	
	If $Confirm_Del_Sess = 1 Then
		TraySetClick(0)
		Local $AskDelete = _GuiMsgBox(48, 2, $AppName & " - Attention", _
			"Are you sure that you want to actualy remove session file?", 300, 100, _
			"Delete without promt", -1, $Gui, "Yes", "No")
		TraySetClick($TrayMenuClick)
		
		$CheckBitAnd = BitAND($AskDelete, 8)
		If $CheckBitAnd = 8 Then
			$Confirm_Del_Sess = 0
			IniWrite($ConfigFile, "Main Prefs", "Confirm Delete Selected Session", 0)
		EndIf
		If $AskDelete - $CheckBitAnd = 7 Then Return
	EndIf
	
	If Not FileDelete($SelectedSession) Then SetStatusBarData("Can Not Delete the session file")
	_GUICtrlListViewDeleteItemsSelected($ListView)
	RemoveSelectedItem()
EndFunc

Func CallDeleteAllSessProc()
	SetStatusBarData()
	CheckSelectedSession(2)
	If @error Then Return
	
	If $Confirm_Delete_All = 1 Then
		TraySetClick(0)
		Local $AskDelete = _GuiMsgBox(48, 2, $AppName & " - Attention", _
			"Are you sure that you want to actualy remove ALL session files?", 300, 100, _
			"Next time Delete without promt", -1, $Gui, "Yes", "No")
		TraySetClick($TrayMenuClick)
		
		$CheckBitAnd = BitAND($AskDelete, 8)
		If $CheckBitAnd = 8 Then
			$Confirm_Delete_All = 0
			IniWrite($ConfigFile, "Main Prefs", "Confirm Delete All Sessions", 0)
		EndIf
		If $AskDelete - $CheckBitAnd = 7 Then Return
	EndIf
	
	RemoveAllItems(1)
EndFunc

Func CallSaveHereProc()
	SetStatusBarData()
	Local $SelectedIndex = _GUICtrlListViewGetSelectedIndices($ListView, 0)
	Local $SelectedSession = CheckSelectedSession(0)
	If @error Then Return
	
	_SaveSession($SelectedSession, 0, $QuickSaveSession)
	If @error Then
		_GuiMsgBox(16, 1, $AppName & " - Error", "There was an error to write session file:" & @LF & _
			_GetMidlePath($SelectedSession), 300, 120, -1, 10, $Gui)
	Else
		_GUICtrlListViewSetItemText($ListView, $SelectedIndex, 1, _GetFileDate($SelectedSession))
	EndIf
EndFunc

Func CallCleanNotExistInSessProc()
	Local $SelectedSession = CheckSelectedSession(1)
	If @error Then Return
	
	Local $ItemsArr = IniReadSection($SelectedSession, "Icons")
	If @error Then
		_GuiMsgBox(16, 1, $AppName & " - Error", _
			"Incorrect Data in DSI File:" & @LF & @LF & _GetMidlePath($SelectedSession) & @LF & @LF & _
			"File are Demaged or it not include a correct Data Information", 420, 130, -1, 10, $Gui)
		Return
	EndIf
	
	Local $Search, $CountCleaned = 0
	For $i = 1 To $ItemsArr[0][0]
		$Search = FileFindFirstFile(@DesktopDir & "\" & $ItemsArr[$i][0] & ".*")
		If $Search = -1 Then
			$CountCleaned += 1
			IniDelete($SelectedSession, "Icons", $ItemsArr[$i][0])
		Else
			FileClose($Search)
		EndIf
	Next
	
	Local $StatusText = "Was Cleaned <" & $CountCleaned & "> Not Existing Items"
	If $CountCleaned = 0 Then $StatusText = "All Items in this session file currently exists"
	SetStatusBarData($StatusText)
EndFunc

Func CallEditDSIFileProc()
	SetStatusBarData()
	Local $SelectedIndex = _GUICtrlListViewGetSelectedIndices($ListView, 0)
	Local $SelectedSession = CheckSelectedSession(1)
	If @error Then Return
	
	ToggleHotKeys(0)
	Local $ItemsArr = IniReadSection($SelectedSession, "Icons")
	If @error Then
		_GuiMsgBox(16, 1, $AppName & " - Error", _
			"Incorrect Data in DSI File:" & @LF & @LF & _GetMidlePath($SelectedSession) & @LF & @LF & _
			"File are Demaged or it not include a correct Data Information", 420, 130, -1, 10, $Gui)
		Return
	EndIf
	Editing_DSI_Dialog($SelectedSession, $ItemsArr, $SelectedIndex, $Gui)
EndFunc

Func CallCopyToClipProc()
	SetStatusBarData()
	Local $SelectedSession = CheckSelectedSession(1)
	If @error Then Return
	_ClipPutFile($SelectedSession)
EndFunc

Func CallOpenSessDirProc()
	SetStatusBarData()
	Local $SelectedSession = CheckSelectedSession(1)
	If @error Then Return
	Local $SessionFileName = StringRegExpReplace($SelectedSession, "^.*\\", "")
	Local $SessionFileDir = StringLeft($SelectedSession, StringInStr($SelectedSession, "\", 0, -1)-1)
	
	Run('Explorer.exe "' & $SessionFileDir & '", /Select, "' & $SessionFileName & '"', $SessionFileDir)
EndFunc

Func CallRenameSessionProc()
	SetStatusBarData()
	Local $SelectedIndex = _GUICtrlListViewGetSelectedIndices($ListView, 0)
	Local $SelectedSession = CheckSelectedSession(1)
	If @error Then Return
	Local $SessionFileName = StringTrimRight(StringRegExpReplace($SelectedSession, "^.*\\", ""), 4)
	Local $SessionFileDir = StringTrimRight($SelectedSession, StringLen($SessionFileName)+5)
	Local $DefaultName = $SessionFileName
	
	While 1
		$NewName = _InputBox($AppName, "Please type new name for the session file:", _
			$DefaultName, 300, 150, $Gui, 256, $MainIconFile)
		If @error Then Return
		
		If $NewName <> $SessionFileName Then
			$CheckNewName = $NewName
			If StringRight($CheckNewName, 4) <> ".dsi" Then $CheckNewName &= ".dsi"
			
			If FileExists($SessionFileDir & "\" & $CheckNewName) Then
				_GuiMsgBox(16, 1, $AppName & " - Error", "File with such name already exists." & @LF & _
					"Please type different name...", 300, 100, -1, 5, $Gui)
				$DefaultName = $NewName
				ContinueLoop
			ElseIf StringRight($NewName, 4) <> ".dsi" Then
				$NewName &= ".dsi"
			EndIf
			
			$NewName = $SessionFileDir & "\" & $NewName
			
			$FileMoveCheck = FileMove($SelectedSession, $NewName)
			If $FileMoveCheck = 0 Then
				SetStatusBarData("Can not Rename Session File: " & _GetMidlePath($SelectedSession, 1))
			Else
				IniWrite($ConfigFile, "Sessions", "Session_" & $SelectedIndex+1, $NewName)
				
				Local $TraySessionText = TrayItemGetText($Tray_Sessions_Items_Arr[$SelectedIndex+1])
				$TraySessionText = StringReplace($TraySessionText, $SelectedSession, $NewName)
				TrayItemSetText($Tray_Sessions_Items_Arr[$SelectedIndex+1], $TraySessionText)
				
				_GUICtrlListViewSetItemText($ListView, $SelectedIndex, 0, $NewName)
			EndIf
			Return
		Else
			Return
		EndIf
	WEnd
EndFunc

Func CallCheckUpdatesProc()
	SetStatusBarData()
	
	If Not @Compiled Then
		_GuiMsgBox(48, 1, $AppName & " - Attention!", "The script must be compiled for this option to work!", 330, 90, -1, 10, $Gui)
		Return
	EndIf
	
	TraySetClick(0)
	ToggleHotKeys(0)
	
	GUISetState(@SW_DISABLE, $Gui)
	Local $ConnectGui = GUICreate("Connection...", 300, 100, -1, -1, $WS_POPUP+$WS_BORDER, $WS_EX_TOOLWINDOW, $Gui)
	
	GUICtrlCreateIcon('shell32.dll', 14, 130, 10, 36, 36)
	
	GUICtrlCreateLabel("Connecting, please wait...", 0, 60, 300, 30, $SS_CENTER)
	GUICtrlSetFont(-1, 10, 800)

	GUISetState(@SW_SHOW, $ConnectGui)
	
	Local $CheckUpdateFile = "http://creator-lab.ucoz.ru/Update_Files/DIR_Updates.dat"
	Local $Temp_DIR_File = @TempDir & "\DIR_Updates.dat"
	
	InetGet($CheckUpdateFile, $Temp_DIR_File, 1, 0)
	$Temp_DIR_File_Content = FileRead($Temp_DIR_File)
	If $Temp_DIR_File_Content = "" Then $Temp_DIR_File_Content = _INetGetSource($CheckUpdateFile)
	
	If StringInStr($Temp_DIR_File_Content, "Ucoz Web Services") Then
		GUIDelete($ConnectGui)
		GUISwitch($Gui)
		_GuiMsgBox(16, 1, $AppName & " - Error!", _
			"It seems that there is a problems on the server http://ucoz.ru, please try later.", 300, 120, -1, -1, $Gui)
	ElseIf $Temp_DIR_File_Content = "" Then
		$InetErrObj = ObjEvent("AutoIt.Error", "InetErrHandler")
		If IsNotConnect() Then
			GUIDelete($ConnectGui)
			GUISwitch($Gui)
			Local $ErrDescription = ""
			If IsObj($InetErrObj) Then $ErrDescription = $InetErrObj.description
			_GuiMsgBox(16, 1, $AppName & " - Attention!", _
				"There is no connection to the Internet.." & @LF & $ErrDescription & @LF & @LF & _
				"Please connect and try again.", 330, 150, -1, -1, $Gui)
		Else
			GUIDelete($ConnectGui)
			GUISwitch($Gui)
			_GuiMsgBox(16, 1, $AppName & " - Error!", _
				"There was an unknown error while trying to get Update Information, please try later :(.", 360, 120, -1, -1, $Gui)
		EndIf
	Else
		GUIDelete($ConnectGui)
		GUISwitch($Gui)
		$CheckAppVersion = StringReplace($AppVersion, ' - v', '')
		$DIR_Version = IniRead($Temp_DIR_File, "Main Info", "Version", $AppVersion)
		$DIR_URL = IniRead($Temp_DIR_File, "Main Info", "Download URL", "http://creator-lab.ucoz.ru/Desktop_Icons_Restorator.exe")
		$DIR_ChangeLog = StringReplace(IniRead($Temp_DIR_File, "Change Log", "Data", ""), "\n", @CRLF)
		If $DIR_Version > $CheckAppVersion Then
			UpdateDialog($DIR_Version, $DIR_URL, $DIR_ChangeLog, $Gui)
		Else
			_GuiMsgBox(64, 1, $AppName & " - Update Checking Finished!", _
				"You are using the latest version of this program [" & $CheckAppVersion & "]", 340, 100, -1, 10, $Gui)
		EndIf
	EndIf
	FileDelete($Temp_DIR_File)
	TraySetClick($TrayMenuClick)
	ToggleHotKeys(1)
EndFunc

Func CheckSelectedSession($CheckExisted=0)
	Local $SelectedSession = _GUICtrlListViewGetItemText($ListView, -1, 0)
	Local $SessCount = _GUICtrlListViewGetItemCount($ListView)
	
	If $SessCount <= 0 Then
		SetStatusBarData("The list is empty")
		Return SetError(1)
	EndIf
	
	If $CheckExisted = 2 Then Return
	
	If $SelectedSession = $LV_ERR Or $SelectedSession = "" Then
		SetStatusBarData("Please select Session File")
		Return SetError(2)
	EndIf
	
	If $CheckExisted = 1 Then
		If Not FileExists($SelectedSession) Then
			SetStatusBarData("Can not find DSI file: " & _GetMidlePath($SelectedSession, 1))
			Return SetError(3)
		EndIf
	EndIf
	
	Return $SelectedSession
EndFunc

Func _QuickSessionSave($hWnd, $uiMsg, $idEvent, $dwTime)
	_SaveSession($Last_AutoSessPath & "\Auto-Saved_Session [" & _GetDateTime() & "].dsi", $AddToListOnAutoSave, 1)
EndFunc

Func _SaveSession($DSI_Sess_Name=-1, $AddItems=1, $QuickMode=0)
	ToggleHotKeys(0)
	If $DSI_Sess_Name = -1 Then
		$LastSessName = StringRegExpReplace($LastSessName, "^.*\\", "")
		Local $LastSessPath = StringTrimRight($LastSessName, StringLen($LastSessName)+1)
		
		If $Show_Desk_On_Saving = 1 And _WinIsVisible($Gui) Then WinActivate($Gui)
		$Dsi_File = _FileSaveDialog("Select *.Dsi file to save session", $LastSessPath, _
			"DSI Files [Desktop Session Info file] (*.dsi)", 18, $LastSessName, "", $Gui)
		If @error Then Return
		
		$LastSessName = $Dsi_File
		IniWrite($ConfigFile, "Main Prefs", "Last Session File", $LastSessName)
	Else
		$Dsi_File = $DSI_Sess_Name
	EndIf
	
	If StringRight($Dsi_File, 3) <> "dsi" Then $Dsi_File &= ".dsi"
	If Not FileExists($Dsi_File) And $Add_DateToSess = 1 And Not $QuickMode Then _
		$Dsi_File = StringTrimRight($Dsi_File, 4) & " [" & _GetDateTime() & "].dsi"
	
	_Write_DSI_Session($Dsi_File)
	If @error Then Return SetError(1)
	
	If $AddItems = 1 Then
		_AddSession($Dsi_File)
		SetColumnsWidth()
		TrayItemSetState($Tray_Sessions_Menu, 64)
	EndIf
	
	If $PlaySaveSound = 1 Then
		If Not FileExists($SaveSoundPath) Or $SaveSoundPath = "!BeepSaveSound!" Then
			PlayBeepSound(1)
		Else
			SoundPlay($SaveSoundPath, $WaitSoundPlay)
		EndIf
	EndIf
EndFunc

Func _RestoreSession($DSI_F_NameArr=-1)
	ToggleHotKeys(0)
	$Dsi_File = ""
	$Dsi_File_Date = ""
	
	If IsArray($DSI_F_NameArr) Then
		$Dsi_File = $DSI_F_NameArr[1]
		$Dsi_File_Date = $DSI_F_NameArr[2]
	ElseIf $DSI_F_NameArr = -1 Then
		$Dsi_File = _GUICtrlListViewGetItemText($ListView, -1, 0)
		$Dsi_File_Date = _GUICtrlListViewGetItemText($ListView, -1, 1)
		If @error Then
			CheckSelectedSession(1)
			If @error Then Return
		EndIf
	EndIf
	
	If Not FileExists($Dsi_File) Then
		SetStatusBarData("Can not find DSI file: " & _GetMidlePath($Dsi_File, 1))
		Return
	EndIf
	
	If IniRead($ConfigFile, "Main Prefs", "Confirm Restore", 1) = 1 Then
		Local $AskForRestore = _GuiMsgBox(36, 2, $AppName & " - Attention!", _
			"Would you like to restore selected session?" & @LF & @LF & _GetMidlePath($Dsi_File, 1) & @LF & _
			"DATE/TIME:	[" & $Dsi_File_Date & "]", _
			400, 130, "Restore without asking", -1, $Gui, "Yes", "No")
		
		$CheckBitAnd = BitAND($AskForRestore, 8)
		If $CheckBitAnd = 8 Then
			$Confirm_Restore = 0
			IniWrite($ConfigFile, "Main Prefs", "Confirm Restore", 0)
		EndIf
		
		If $AskForRestore - $CheckBitAnd = 7 Then Return
	EndIf
	
	;Get a handle on the desktop, which is actually a listview control.
	$hWnd_LV = ControlGetHandle("[CLASS:Progman]", "", "SysListView321")
	
	$ItemsArr = IniReadSection($Dsi_File, "Icons")
	If @error Then
		_GuiMsgBox(16, 1, $AppName & " - Error", _
			"Incorrect Data in DSI File:" & @LF & @LF & _GetMidlePath($Dsi_File) & @LF & @LF & _
			"File are Demaged or it not include a correct Data Information", 420, 130, -1, 10, $Gui)
		Return
	EndIf
	
	For $iCount = 1 To 3
		;Walk the listview items, applying their positions from the INI file.
		For $nIdx = 0 To $ItemsArr[0][0]
			$sIconText = _ListView_GetItemText($hWnd_LV, $nIdx)
			$aPos = StringSplit(IniRead($Dsi_File, "Icons", $sIconText, ""), ";")
			If IsArray($aPos) And $aPos[0] = 2 Then _ListView_SetItemPosition($hWnd_LV, $nIdx, $aPos[1], $aPos[2])
		Next
	Next
	ControlSend("[CLASS:Progman]", "", "SysListView321", "{F5}")
	ControlFocus($Gui, "", $ListView)
	
	If $PlayRestoreSound = 1 Then
		If Not FileExists($RestoreSoundPath) Or $RestoreSoundPath = "!BeepSound!" Then
			PlayBeepSound(-1)
		Else
			SoundPlay($RestoreSoundPath, $WaitSoundPlay)
		EndIf
	EndIf
EndFunc

Func RemoveSelectedItem()
	ToggleHotKeys(0)
	Local $SelectedIndex = _GUICtrlListViewGetSelectedIndices($ListView, 0)
	Local $SessCount = _GUICtrlListViewGetItemCount($ListView)
	
	_GUICtrlListViewDeleteItemsSelected($ListView)
	IniDelete($ConfigFile, "Sessions")
	
	If $SelectedIndex+1 <= UBound($Tray_Sessions_Items_Arr)-1 Then
		TrayItemDelete($Tray_Sessions_Items_Arr[$SelectedIndex+1])
		_RemoveFromArray($Tray_Sessions_Items_Arr, $SelectedIndex+1)
		If @error = -1 Then TrayItemSetState($Tray_Sessions_Menu, 128)
	EndIf
	
	$LastSession = 0
	If $SessCount - 1 <= 0 Then Return
	
	For $i = 0 To $SessCount-1
		$CurrentSessFile = _GUICtrlListViewGetItemText($ListView, $i, 0)
		If Not @error And $CurrentSessFile <> "" Then
			$LastSession += 1
			IniWrite($ConfigFile, "Sessions", "Session_" & $LastSession, $CurrentSessFile)
		EndIf
	Next
	
	If $SelectedIndex > $SessCount-2 Then $SelectedIndex -= 1
	_GUICtrlListViewSetItemSelState($ListView, $SelectedIndex, 1, 1)
EndFunc

Func RemoveAllItems($Delete=0)
	ToggleHotKeys(0)
	SetStatusBarData("Please wait...")
	If $Delete = 1 Then
		Local $CountItems = _GUICtrlListViewGetItemCount($ListView)
		Local $CurrentSessionFile
		For $i = $CountItems - 1 To 0 Step -1
			$CurrentSessionFile = _GUICtrlListViewGetItemText($ListView, $i, 0)
			FileDelete($CurrentSessionFile)
			_GUICtrlListViewDeleteItem($ListView, $i)
			TrayItemDelete($Tray_Sessions_Items_Arr[$i+1])
		Next
	Else
		_GUICtrlListViewDeleteAllItems($ListView)
		For $iT = 1 To UBound($Tray_Sessions_Items_Arr)-1
			TrayItemDelete($Tray_Sessions_Items_Arr[$iT])
		Next
	EndIf
	
	Dim $Tray_Sessions_Items_Arr[1] = [0]
	TrayItemSetState($Tray_Sessions_Menu, 128)
	IniDelete($ConfigFile, "Sessions")
	SetStatusBarData("")
EndFunc

Func _AddSessionFiles()
	ToggleHotKeys(0)
	$LastSessName = StringRegExpReplace($LastSessName, "^.*\\", "")
	Local $LastSessPath = StringTrimRight($LastSessName, StringLen($LastSessName)+1)
	
	Local $Sess_Files
	
	While 1
		$Sess_Files = _FileOpenDialog("Select *.DSI file(s) (Desktop Session Info file) to add", $LastSessPath, _
			"DSI Files [Desktop Session Info file] (*.dsi)", 7, $LastSessName, "", $Gui)
		If @error Then Return
		
		If StringRight($Sess_Files, 3) <> "dsi" Then
			_GuiMsgBox(48, 1, $AppName & " - Error", "Please select only *.DSI file(s)...", 300, 100, -1, 5, $Gui)
			ContinueLoop
		EndIf
		ExitLoop
	WEnd
	
	Local $Sess_FilesArr = _PharseSelected($Sess_Files)
	If UBound($Sess_FilesArr)-1 < 1 Then Return
	
	Local $FoundedIndexesArr[1]
	
	For $i = 1 To UBound($Sess_FilesArr)-1
		_AddSession($Sess_FilesArr[$i])
	Next
	SetColumnsWidth()
	TrayItemSetState($Tray_Sessions_Menu, 64)
EndFunc

Func _AddSession($Dsi_File)
	ToggleHotKeys(0)
	$LastSession += 1
	
	Local $Session_Date = _GetFileDate($Dsi_File)
	Local $Find_Dsi_File = _FindLVItem($ListView, $Dsi_File, 0)
	
	If $Find_Dsi_File <> -1 Then
		If $Session_Date <> "" Then _GUICtrlListViewSetItemText($ListView, $Find_Dsi_File, 1, $Session_Date)
		$LastSession -= 1
		_GUICtrlListViewSetItemSelState($ListView, $Find_Dsi_File, 1, 1)
		ControlFocus($Gui, "", $ListView)
	Else
		Local $ItemIndex = _GUICtrlListViewInsertItem($ListView, -1, $Dsi_File & "|" & $Session_Date)
		_GUICtrlListViewSetItemImage($h_LV, $ItemIndex, 0, 0)
		
		If $Session_Date <> "" Then $Session_Date = "	[" & $Session_Date & "]"
		ReDim $Tray_Sessions_Items_Arr[UBound($Tray_Sessions_Items_Arr)+1]
		$Tray_Sessions_Items_Arr[UBound($Tray_Sessions_Items_Arr)-1] = TrayCreateItem($Dsi_File & _
			$Session_Date, $Tray_Sessions_Menu)
		TrayItemSetOnEvent(-1, "TraySessionsEvents")
		
		IniWrite($ConfigFile, "Sessions", "Session_" & $LastSession, $Dsi_File)
	EndIf
EndFunc

Func PlayBeepSound($Flag=1)
	Local $For = 500, $To = 1500, $Step = 500
	If $Flag = 1 Then
		$For = 1500
		$To = 500
		$Step = -500
	EndIf
	
	For $i = $For To $To Step $Step
		Beep($i, 100)
	Next
EndFunc

Func _Write_DSI_Session($sFile)
	;Check For Ability to Write
	Local $OpFile = FileOpen($sFile, 9)
	If $OpFile = -1 Then Return SetError(1)
	FileClose($OpFile)
	
	;Drop all previous icon positions
	IniDelete($sFile, "Icons")
	
	Local $sIconText, $aPos
	;Get a handle on the desktop, which is actually a listview control.
	Local $hWnd_LV = ControlGetHandle("[CLASS:Progman]", "", "SysListView321")
	
	;Walk the listview items, saving their positions to the DSI file.
	For $nIdx = 0 To _ListView_GetItemCount($hWnd_LV) - 1
		$sIconText = _ListView_GetItemText($hWnd_LV, $nIdx)
		$aPos = _ListView_GetItemPosition($hWnd_LV, $nIdx)
		IniWrite($sFile, "Icons", $sIconText, $aPos[0] & ";" & $aPos[1])
	Next
EndFunc

Func UpdateDialog($DIR_Version, $DIR_URL, $DIR_ChangeLog, $hWnd=0)
	Local $Old_Opt_GOEM = Opt("GuiOnEventMode", 0)
	WinSetState($hWnd, "", @SW_DISABLE)
	
	Local $UpdateGui = GUICreate($AppName & " - New Version availible [" & $DIR_Version & "]", _
		450, 450, -1, -1, -1, $WS_EX_TOOLWINDOW, $hWnd)
	
	GUICtrlCreateLabel("Would you like to download and update new version of <" & $AppName & "> [" & $DIR_Version & "]", _
		0, 20, 450, 60, $SS_CENTER)
	GUICtrlSetFont(-1, 8, 800)
	
	GUICtrlCreateLabel("What's New:", 20, 50, 200)
	GUICtrlSetFont(-1, 9, 800)
	GUICtrlSetColor(-1, 0xFF0000)
	GUICtrlCreateEdit($DIR_ChangeLog, 20, 70, 410, 310, BitOr($GUI_SS_DEFAULT_EDIT, $ES_READONLY))
	GUICtrlSetColor(-1, 0xD76B00)
	
	GUICtrlCreateLabel("Press OK to download and Update the new version of the program [" & $DIR_Version & "]", 20, 390, 430)
	GUICtrlSetFont(-1, 8, 800)
	
	Local $DownloadButton = GUICtrlCreateButton("OK", 85, 420, 60, 20)
	Local $CancelButton = GUICtrlCreateButton("Cancel", 305, 420, 60, 20)
	
	GUISetState(@SW_SHOW, $UpdateGui)
	
	While 1
		Switch GUIGetMsg()
			Case $DownloadButton
				WinSetState($hWnd, "", @SW_ENABLE)
				GUIDelete($UpdateGui)
				WinSetState($hWnd, "", @SW_DISABLE)
				
				HotKeySet("^+a", "AbortUpdate")
				_GUICtrlStatusBarSetText($StatusBar, "Downloading, please wait... (Press <Ctrl Shift A> to abort Downloading)", 255)
				Local $ProgressTopPos = GetProgressTopPos()
				Local $ProgressLeftPos = GetProgressLeftPos()
				
				$InfoArray = _InetGetWithProgress($DIR_URL, @TempDir, $AppName & " - Download Updates Progress", _
					"Download: %F", _
					"Ready: %R (bytes: %b from %FS)" & @LF & _
					"Downloading speed: %S" & @LF & _
					"Approximately Remained Time: %T", _
					"Collecting data, Please wait...", $ProgressLeftPos, $ProgressTopPos, 16, $hWnd)
				If Not @error And $DOWNLOADISABORTED = False Then
					Local $RestartGui = GUICreate("Restarting...", 300, 100, -1, -1, $WS_POPUP+$WS_BORDER, $WS_EX_TOOLWINDOW, $hWnd)
					GUICtrlCreateIcon('shell32.dll', 28, 130, 10, 36, 36)
					GUICtrlCreateLabel("Restarting, please wait...", 0, 60, 300, 30, $SS_CENTER)
					GUICtrlSetFont(-1, 10, 800)
					GUISetState(@SW_SHOW, $RestartGui)
					Sleep(2000)
					Run(@ComSpec & ' /c ping -n 2 localhost > nul & move /y "' & _
						@TempDir & '\' & $InfoArray[4] & '" "' & @ScriptFullPath & '" & start "" "' & _
						@ScriptFullPath & '"', @ScriptDir, @SW_HIDE)
					Exit
				ElseIf @error Then
					_GuiMsgBox(16, 1, $AppName & " - Error!", _
						"There was an error to Download Update File(s), please check connection, or try later :(.", _
						300, 120, -1, -1, $hWnd)
				EndIf
				ExitLoop
			Case $CancelButton, -3
				ExitLoop
		EndSwitch
	WEnd
	WinSetState($hWnd, "", @SW_ENABLE)
	GUIDelete($UpdateGui)
	GUISwitch($hWnd)
	HotKeySet("^+a")
	Opt("GuiOnEventMode", $Old_Opt_GOEM)
	FinishDownloading(1)
	SetStatusBarData()
	_ReduceMemory(@AutoItPID)
EndFunc

Func AbortUpdate()
	Local $AskAbort = _GuiMsgBox(52, 2, "Attention!", "Are you sure that you want to abort this download?", _
		300, 100, -1, -1, $PROGRESSHWND)
	If $AskAbort - BitAND($AskAbort, 8) = 7 Then Return
	FinishDownloading(0, $Gui)
EndFunc

Func PreferencesDialog($hWnd)
	ToggleHotKeys(0)
	Local $Old_Opt_GOEM = Opt('GuiOnEventMode', 0)
	Local $Old_Opt_GCOE = Opt('GUICloseOnESC', 0)
	
	WinSetState($hWnd, "", @SW_DISABLE)
	
	Local $GUI_WIDTH = 500, $GUI_HEIGHT = 400
	Local $ExStyle = $WS_EX_TOOLWINDOW
	If Not _WinIsVisible($Gui) Then $ExStyle += $WS_EX_APPWINDOW
	
	$Prefs_Gui = GUICreate($AppName & " - Preferences", $GUI_WIDTH, $GUI_HEIGHT, -1, -1, -1, $ExStyle, $hWnd)
	SetTransparency($Prefs_Gui)
	GUISetBkColor($AppBkColor, $Prefs_Gui)
	
	GUISetIcon($MainIconFile)
	GUIRegisterMsg($WM_HSCROLL, "WM_HVSCROLL")
	
	GUICtrlCreateIcon("shell32.dll", 177, 5, 5)
	GUICtrlSetState(-1, 128)
	
	Local $Prefs_Label = GUICtrlCreateLabel("Session Preferences", 70, 10, $GUI_WIDTH-60, 30)
	GUICtrlSetFont(-1, 11, 800)
	GUICtrlSetColor(-1, 0xFF0000)
	GUICtrlSetState(-1, 128)
	
	GUICtrlCreateGraphic(5, 40, $GUI_WIDTH-10, 3, $SS_ETCHEDFRAME)
	
	GUICtrlCreateGraphic(5, $GUI_HEIGHT-40, $GUI_WIDTH-10, 3, $SS_ETCHEDFRAME)
	
	Local $OK_Button = GUICtrlCreateButton("OK", 10, $GUI_HEIGHT-30, 60, 20)
	Local $Cancel_Button = GUICtrlCreateButton("Cancel", 100, $GUI_HEIGHT-30, 60, 20)
	
	Local $Main_Tab = GUICtrlCreateTab(10, 50, $GUI_WIDTH-20, $GUI_HEIGHT-95, _
		BitOr($GUI_SS_DEFAULT_TAB, $TCS_FIXEDWIDTH, $TCS_BUTTONS))
	GuictrlSendMsg($Main_Tab, $TCM_SETITEMSIZE, 0, BitOR(BitAnd(93, 0xFFFF), BitShift(BitAnd(22, 0xFFFF), -16)))
	
	GUICtrlCreateTabItem("Session Prefs")
	#Region Session Prefs Tab Item
	GUICtrlCreateGroup("Session Options [Confirm Dialogs]", 20, 80, $GUI_WIDTH-40, 140)
	$Confirm_Restore_CB = GUICtrlCreateCheckbox("Confirm When Restore Session", 40, 100)
	If $Confirm_Restore = 1 Then GUICtrlSetState(-1, 1)
	
	$Confirm_Remove_All_CB = GUICtrlCreateCheckbox("Confirm When Removing All Session From List", 40, 130)
	If $Confirm_Remove_All = 1 Then GUICtrlSetState(-1, 1)
	
	$Confirm_Delete_All_CB = GUICtrlCreateCheckbox("Confirm When Deleting All Session Files", 40, 160)
	If $Confirm_Delete_All = 1 Then GUICtrlSetState(-1, 1)
	
	$Confirm_Del_Sess_CB = GUICtrlCreateCheckbox("Confirm When Deleting Selected Session File", 40, 190)
	If $Confirm_Del_Sess = 1 Then GUICtrlSetState(-1, 1)
	
	GUICtrlCreateGroup("Session Options [Saving]", 20, 230, $GUI_WIDTH-40, 120)
	$Add_Date_To_Session_CB = GUICtrlCreateCheckbox("Add Date/Time When Saving Session", 40, 250)
	If $Add_DateToSess = 1 Then GUICtrlSetState(-1, 1)
	
	$ShowDesktopOnSaving_CB = GUICtrlCreateCheckbox("Show Desktop When Saving Session", 40, 270)
	If $Show_Desk_On_Saving = 1 Then GUICtrlSetState(-1, 1)
	
	$QuickSave_Session_CB = GUICtrlCreateCheckbox("Save Session In Quick Mode", 40, 290)
	GUICtrlSetTip(-1, "Session Will be saved to selected path with Default Name + Date Stamp")
	
	GUICtrlCreateLabel("Quick Saving Path:", 40, 317)
	$QuickSavePath_Input = GUICtrlCreateInput($QuickSavingPath, 140, 315, $GUI_WIDTH-205, 20)
	GUICtrlSetState(-1, 128)
	
	$QuickSavePath_Button = GUICtrlCreateButton("...", $GUI_WIDTH-60, 314, 30, 22)
	GUICtrlSetState(-1, 128)
	
	If $QuickSaveSession = 1 Then
		GUICtrlSetState($QuickSave_Session_CB, 1)
		GUICtrlSetState($QuickSavePath_Input, 64)
		GUICtrlSetState($QuickSavePath_Button, 64)
	EndIf
	#EndRegion Session Prefs Tab Item
	;
	
	GUICtrlCreateTabItem("Sound Prefs")
	#Region Sound Prefs Tab Item
	$SoundIsPlaying = False
	
	GUICtrlCreateGroup("Sound Options", 20, 80, $GUI_WIDTH-40, 160)
	$Play_Save_Sound_CB = GUICtrlCreateCheckbox("Play Sound When Saving Session", 40, 100)
	If $PlaySaveSound = 1 Then GUICtrlSetState($Play_Save_Sound_CB, 1)
	
	$Save_Sound_Play_Button = GUICtrlCreateButton("Sound Path:", 40, 125, 80, 21)
	GUICtrlSetTip(-1, "Press Button To Play the Sound")
	GUICtrlSetBkColor(-1, 0x808080)
	
	$Play_Save_Sound_Input = GUICtrlCreateInput($SaveSoundPath, 140, 125, $GUI_WIDTH-205, 20)
	$Play_Save_Sound_Button = GUICtrlCreateButton("...", $GUI_WIDTH-60, 124, 30, 22)
	
	If $PlaySaveSound <> 1 Then
		GUICtrlSetState($Save_Sound_Play_Button, 128)
		GUICtrlSetState($Play_Save_Sound_Input, 128)
		GUICtrlSetState($Play_Save_Sound_Button, 128)
	EndIf
	
	$Play_Restore_Sound_CB = GUICtrlCreateCheckbox("Play Sound When Restoring Session", 40, 175)
	If $PlayRestoreSound = 1 Then GUICtrlSetState($Play_Restore_Sound_CB, 1)
	
	$Restore_Sound_Play_Button = GUICtrlCreateButton("Sound Path:", 40, 200, 80, 21)
	GUICtrlSetTip(-1, "Press Button To Play the Sound")
	GUICtrlSetBkColor(-1, 0x808080)
	
	$Play_Restore_Sound_Input = GUICtrlCreateInput($RestoreSoundPath, 140, 200, $GUI_WIDTH-205, 20)
	
	$Play_Restore_Sound_Button = GUICtrlCreateButton("...", $GUI_WIDTH-60, 199, 30, 22)
	
	If $PlayRestoreSound <> 1 Then
		GUICtrlSetState($Restore_Sound_Play_Button, 128)
		GUICtrlSetState($Play_Restore_Sound_Input, 128)
		GUICtrlSetState($Play_Restore_Sound_Button, 128)
	EndIf
	#EndRegion Sound Prefs Tab Item
	;
	
	GUICtrlCreateTabItem("System Tray")
	#Region Tray Tab Item
	GUICtrlCreateGroup("Tray Click Options", 20, 80, $GUI_WIDTH-40, 195)
	Local $MouseNameButton = "LEFT"
	
	$ShowTrayIcon_CB = GUICtrlCreateCheckbox("Show Tray Icon", 30, 95)
	
	$SubGroup_1 = GUICtrlCreateGroup("", 30, 110, $GUI_WIDTH-60, 80)
	GUICtrlCreateLabel("Show Menu when...", 40, 120, 120)
	GUICtrlSetFont(-1, 9, 800)
	
	$RightClickMenu_Radio = GUICtrlCreateRadio("RIGHT M.Button Clicked on tray icon", 50, 140)
	GUICtrlSetState(-1, 1)
	$LeftClickMenu_Radio = GUICtrlCreateRadio("LEFT M.Button Clicked on tray icon", 50, 160)
	If $WhatClickShowMenu = 1 Then
		GUICtrlSetState(-1, 1)
		$MouseNameButton = "RIGHT"
	EndIf
	
	$SubGroup_2 = GUICtrlCreateGroup("", 30, 190, $GUI_WIDTH-60, 80)
	$GroupTitleLabel = GUICtrlCreateLabel("When " & $MouseNameButton & " M.Button pressed...", 40, 200, 220)
	GUICtrlSetFont(-1, 9, 800)
	
	$ShowActMainWindow_Radio = GUICtrlCreateRadio("Show/Activate Main Window", 50, 220)
	GUICtrlSetState(-1, 1)
	$RestoreLastSession_Radio = GUICtrlCreateRadio("Restore Last Session", 50, 240)
	If $ActionOnTrayClick = 2 Then GUICtrlSetState(-1, 1)
	
	If $ShowTrayIcon <> 1 Then
		For $i = $SubGroup_1 To $RestoreLastSession_Radio
			GUICtrlSetState($i, 128)
		Next
	Else
		GUICtrlSetState($ShowTrayIcon_CB, 1)
	EndIf
	#EndRegion Tray and Transparency Tab Item
	;
	
	GUICtrlCreateTabItem("Trans. && Colors")
	#Region Transparency and Colors Tab Item
	$Set_AppBkColor_Temp = $AppBkColor
	$Set_LV_BkColor_Temp = $LV_BkColor
	$Set_Main_Menu_Color_Temp = $Main_Menu_Color
	$Set_Context_Menu_Color_Temp = $Context_Menu_Color
	
	GUICtrlCreateGroup("Colors", 20, 80, $GUI_WIDTH-40, 180)
	
	$AppBkColor_CB = GUICtrlCreateCheckbox("Background color of the program", 30, 100)
	If $AppBkColor <> "0xF3F3F3" Then GUICtrlSetState(-1, 1)
	$AppBkColor_Label = GUICtrlCreateLabel(" ", 220, 101, 60, 20, $SS_SUNKEN)
	GUICtrlSetBkColor(-1, $AppBkColor)
	GUICtrlSetState(-1, 128)
	
	$ListBkColor_CB = GUICtrlCreateCheckbox("Background color of the List", 30, 130)
	If $LV_BkColor <> "0xF8F8FC" Then GUICtrlSetState(-1, 1)
	$ListBkColor_Label = GUICtrlCreateLabel(" ", 220, 131, 60, 20, $SS_SUNKEN)
	GUICtrlSetBkColor(-1, $LV_BkColor)
	GUICtrlSetState(-1, 128)
	
	$Main_Menu_Color_CB = GUICtrlCreateCheckbox("Main Menu Color", 30, 160)
	If $Main_Menu_Color <> "0xC0C0C0" Then GUICtrlSetState(-1, 1)
	$Main_Menu_Color_Label = GUICtrlCreateLabel(" ", 220, 161, 60, 20, $SS_SUNKEN)
	GUICtrlSetBkColor(-1, $Main_Menu_Color)
	GUICtrlSetState(-1, 128)
	
	$Context_Menu_Color_CB = GUICtrlCreateCheckbox("Context Menu Color", 30, 190)
	If $Context_Menu_Color <> "0xBADCDC" Then GUICtrlSetState(-1, 1)
	$Context_Menu_Color_Label = GUICtrlCreateLabel(" ", 220, 191, 60, 20, $SS_SUNKEN)
	GUICtrlSetBkColor(-1, $Context_Menu_Color)
	GUICtrlSetState(-1, 128)
	
	
	GUICtrlCreateGroup("Transparency", 20, 280, $GUI_WIDTH-40, 70)
	$SetTransOnlyForGUI_CB = GUICtrlCreateCheckbox("Set Transparency Only For Main Window", 30, 295)
	If $SetTransForMainGUI = 1 Then GUICtrlSetState(-1, 1)
	
	GUICtrlCreateLabel("Transparency Precent: ", 30, 325)
	$Trans_Precent_Label = GUICtrlCreateLabel(Round($Transparency / 2.5) & "%", 150, 325, 30, 20, $ES_READONLY, $WS_EX_TRANSPARENT)
	$Trans_Slider = GUICtrlCreateSlider(180, 320, $GUI_WIDTH-210, 25)
	GUICtrlSetLimit(-1, 200)
	GUICtrlSetCursor(-1, 13)
	If $Transparency <> 0 Then GUICtrlSetData(-1, $Transparency)
	#EndRegion Transparency and Colors Tab Item
	;
	
	GUICtrlCreateTabItem("Other Prefs")
	#Region Other Prefs
	$RunAppWithWindows_CB = GUICtrlCreateCheckbox("Run Program When Windows Start", 30, 80)
	Local $RunPath = FileGetShortName(@ScriptFullPath)
	If Not @Compiled Then $RunPath = FileGetShortName(@AutoItExe) & ' ' & $RunPath
	If RegRead("HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Run", $AppName) = $RunPath Then GUICtrlSetState(-1, 1)
	#EndRegion Other Prefs
	;
	
	GUISetState(@SW_SHOW, $Prefs_Gui)
	
	While 1
		Switch GUIGetMsg()
			Case -3, $Cancel_Button
				SetTransparency($Gui)
				If $Transparency <= 0 Then WinSetTrans($Gui, "", 255)
				ExitLoop
			Case $Main_Tab
				Switch GUICtrlRead($Main_Tab)
					Case 0
						GUICtrlSetData($Prefs_Label, "Session Preferences")
					Case 1
						GUICtrlSetData($Prefs_Label, "Sound Preferences")
					Case 2
						GUICtrlSetData($Prefs_Label, "System Tray Preferences")
					Case 3
						GUICtrlSetData($Prefs_Label, "Transparency and Colors Preferences")
					Case 4
						GUICtrlSetData($Prefs_Label, "Other Preferences")
				EndSwitch
			Case $QuickSave_Session_CB
				If GUICtrlRead($QuickSave_Session_CB) = 1 Then
					GUICtrlSetState($QuickSavePath_Input, 64)
					GUICtrlSetState($QuickSavePath_Button, 64)
				Else
					GUICtrlSetState($QuickSavePath_Input, 128)
					GUICtrlSetState($QuickSavePath_Button, 128)
				EndIf
			Case $QuickSavePath_Button
				$Select_QuickSave_Path = _FileSelectFolder('Please select Folder to save sessions Quickly', _
					0, $BIF_NEWDIALOGSTYLE+$BIF_RETURNONLYFSDIRS, $QuickSavingPath, $Prefs_Gui)
				If @error Then ContinueLoop
				
				GUICtrlSetData($QuickSavePath_Input, $Select_QuickSave_Path)
			Case $Play_Save_Sound_CB
				If GUICtrlRead($Play_Save_Sound_CB) = 1 Then
					GUICtrlSetState($Save_Sound_Play_Button, 64)
					GUICtrlSetState($Play_Save_Sound_Input, 64)
					GUICtrlSetState($Play_Save_Sound_Button, 64)
				Else
					GUICtrlSetState($Save_Sound_Play_Button, 128)
					GUICtrlSetState($Play_Save_Sound_Input, 128)
					GUICtrlSetState($Play_Save_Sound_Button, 128)
				EndIf
			Case $Save_Sound_Play_Button
				Local $SoundPathRead = GUICtrlRead($Play_Save_Sound_Input)
				If $SoundPathRead = "!BeepSaveSound!" Then
					PlayBeepSound(1)
				Else
					SoundPlay($SoundPathRead)
					$SoundIsPlaying = True
				EndIf
			Case $Play_Save_Sound_Button
				Local $ReadSoundPath = GUICtrlRead($Play_Save_Sound_Input)
				Local $SoundInitDir = StringLeft($ReadSoundPath, StringInStr($ReadSoundPath, "\", 0, -1))
				If Not FileExists($SoundInitDir) Then $SoundInitDir = @WindowsDir & "\Media"
				
				Local $Select_Play_Sound = _FileOpenDialog('Please select Sound File', $SoundInitDir, _
					"*.WAV, *.MID Files (*.wav;*.mid)", 0, "", ".wav", $Prefs_Gui)
				If @error Then ContinueLoop
				
				GUICtrlSetData($Play_Save_Sound_Input, $Select_Play_Sound)
			Case $Play_Restore_Sound_CB
				If GUICtrlRead($Play_Restore_Sound_CB) = 1 Then
					GUICtrlSetState($Restore_Sound_Play_Button, 64)
					GUICtrlSetState($Play_Restore_Sound_Input, 64)
					GUICtrlSetState($Play_Restore_Sound_Button, 64)
				Else
					GUICtrlSetState($Restore_Sound_Play_Button, 128)
					GUICtrlSetState($Play_Restore_Sound_Input, 128)
					GUICtrlSetState($Play_Restore_Sound_Button, 128)
				EndIf
			Case $Restore_Sound_Play_Button
				Local $SoundPathRead = GUICtrlRead($Play_Restore_Sound_Input)
				If $SoundPathRead = "!BeepRestoreSound!" Then
					PlayBeepSound(-1)
				Else
					SoundPlay($SoundPathRead)
					$SoundIsPlaying = True
				EndIf
			Case $Play_Restore_Sound_Button
				Local $ReadSoundPath = GUICtrlRead($Play_Restore_Sound_Input)
				Local $SoundInitDir = StringLeft($ReadSoundPath, StringInStr($ReadSoundPath, "\", 0, -1))
				If Not FileExists($SoundInitDir) Then $SoundInitDir = @WindowsDir & "\Media"
				
				Local $Select_Play_Sound = _FileOpenDialog('Please select Sound File', $SoundInitDir, _
					"*.WAV, *.MID Files (*.wav;*.mid)", 0, "", "", $Prefs_Gui)
				If @error Then ContinueLoop
				
				GUICtrlSetData($Play_Restore_Sound_Input, $Select_Play_Sound)
			Case $ShowTrayIcon_CB
				Local $ElemtsState = 128
				If GUICtrlRead($ShowTrayIcon_CB) = 1 Then $ElemtsState = 64
				For $i = $SubGroup_1 To $RestoreLastSession_Radio
					GUICtrlSetState($i, $ElemtsState)
				Next
			Case $LeftClickMenu_Radio
				$MouseNameButton = "RIGHT"
				GUICtrlSetData($GroupTitleLabel, "When " & $MouseNameButton & " M.Button pressed...")
			Case $RightClickMenu_Radio
				$MouseNameButton = "LEFT"
				GUICtrlSetData($GroupTitleLabel, "When " & $MouseNameButton & " M.Button pressed...")
			Case $SetTransOnlyForGUI_CB
				Local $TransRead = GUICtrlRead($Trans_Slider)
				If GUICtrlRead($SetTransOnlyForGUI_CB) = 1 Then
					If $TransRead > 0 Then WinSetTrans($Prefs_Gui, "", 255)
				Else
					If $TransRead > 0 Then WinSetTrans($Prefs_Gui, "", 255 - $TransRead)
				EndIf
			Case $AppBkColor_CB
				If GUICtrlRead($AppBkColor_CB) = 1 Then
					Local $SelColor = _ChooseColor(2, $AppBkColor, 2, $Prefs_Gui)
					If @error Then
						GUICtrlSetState($AppBkColor_CB, 4)
						ContinueLoop
					EndIf
					$Set_AppBkColor_Temp = $SelColor
					GUICtrlSetBkColor($AppBkColor_Label, $SelColor)
				Else
					GUICtrlSetBkColor($AppBkColor_Label, "0xF3F3F3")
				EndIf
			Case $ListBkColor_CB
				If GUICtrlRead($ListBkColor_CB) = 1 Then
					Local $SelColor = _ChooseColor(2, $LV_BkColor, 2, $Prefs_Gui)
					If @error Then
						GUICtrlSetState($ListBkColor_CB, 4)
						ContinueLoop
					EndIf
					$Set_LV_BkColor_Temp = $SelColor
					GUICtrlSetBkColor($ListBkColor_Label, $SelColor)
				Else
					GUICtrlSetBkColor($ListBkColor_Label, 0xF8F8FC)
				EndIf
			Case $Main_Menu_Color_CB
				If GUICtrlRead($Main_Menu_Color_CB) = 1 Then
					Local $SelColor = _ChooseColor(2, $Main_Menu_Color, 2, $Prefs_Gui)
					If @error Then
						GUICtrlSetState($Main_Menu_Color_CB, 4)
						ContinueLoop
					EndIf
					$Set_Main_Menu_Color_Temp = $SelColor
					GUICtrlSetBkColor($Main_Menu_Color_Label, $SelColor)
				Else
					GUICtrlSetBkColor($Main_Menu_Color_Label, 0xC0C0C0)
				EndIf
			Case $Context_Menu_Color_CB
				If GUICtrlRead($Context_Menu_Color_CB) = 1 Then
					Local $SelColor = _ChooseColor(2, $Context_Menu_Color, 2, $Prefs_Gui)
					If @error Then
						GUICtrlSetState($Context_Menu_Color_CB, 4)
						ContinueLoop
					EndIf
					
					$Set_Context_Menu_Color_Temp = $SelColor
					GUICtrlSetBkColor($Context_Menu_Color_Label, $SelColor)
				Else
					GUICtrlSetBkColor($Context_Menu_Color_Label, 0xBADCDC)
				EndIf
			Case $OK_Button
				#Region Session Prefs
				$Confirm_Restore = 0
				If GUICtrlRead($Confirm_Restore_CB) = 1 Then $Confirm_Restore = 1
				
				$Confirm_Remove_All = 0
				If GUICtrlRead($Confirm_Remove_All_CB) = 1 Then $Confirm_Remove_All = 1
				
				$Confirm_Delete_All = 0
				If GUICtrlRead($Confirm_Delete_All_CB) = 1 Then $Confirm_Delete_All = 1
				
				$Confirm_Del_Sess = 0
				If GUICtrlRead($Confirm_Del_Sess_CB) = 1 Then $Confirm_Del_Sess = 1
				
				$Show_Desk_On_Saving = 0
				If GUICtrlRead($ShowDesktopOnSaving_CB) = 1 Then $Show_Desk_On_Saving = 1
				
				$Add_DateToSess = 0
				If GUICtrlRead($Add_Date_To_Session_CB) = 1 Then $Add_DateToSess = 1
				
				$QuickSaveSession = 0
				If GUICtrlRead($QuickSave_Session_CB) = 1 Then $QuickSaveSession = 1
				
				IniWrite($ConfigFile, "Main Prefs", "Confirm Restore", $Confirm_Restore)
				IniWrite($ConfigFile, "Main Prefs", "Confirm Remove All From List", $Confirm_Remove_All)
				IniWrite($ConfigFile, "Main Prefs", "Confirm Delete All Sessions", $Confirm_Delete_All)
				IniWrite($ConfigFile, "Main Prefs", "Confirm Delete Selected Session", $Confirm_Del_Sess)
				
				IniWrite($ConfigFile, "Main Prefs", "Show Desktop When Saving Session", $Show_Desk_On_Saving)
				IniWrite($ConfigFile, "Main Prefs", "Add Date/Time When Saving Session", $Add_DateToSess)
				IniWrite($ConfigFile, "Main Prefs", "Quick Save Session", $QuickSaveSession)
				If $QuickSaveSession = 1 Then
					$QuickSavingPath = GUICtrlRead($QuickSavePath_Input)
					If Not StringInStr(FileGetAttrib($QuickSavingPath), "D") Then $QuickSavingPath = $Deff_AutoSessPath
					IniWrite($ConfigFile, "Main Prefs", "Quick Save Path", $QuickSavingPath)
				EndIf
				#EndRegion Session Prefs
				;
				
				#Region Sound Prefs
				$PlaySaveSound = 0
				If GUICtrlRead($Play_Save_Sound_CB) = 1 Then $PlaySaveSound = 1
				
				$PlayRestoreSound = 0
				If GUICtrlRead($Play_Restore_Sound_CB) = 1 Then $PlayRestoreSound = 1
				
				IniWrite($ConfigFile, "Main Prefs", "Play Save Sound", $PlaySaveSound)
				If $PlaySaveSound = 1 Then
					$SaveSoundPath = GUICtrlRead($Play_Save_Sound_Input)
					If Not FileExists($SaveSoundPath) Then $SaveSoundPath = "!BeepSaveSound!"
					IniWrite($ConfigFile, "Main Prefs", "Save Sound Path", $SaveSoundPath)
				EndIf
				
				IniWrite($ConfigFile, "Main Prefs", "Play Restore Sound", $PlayRestoreSound)
				If $PlayRestoreSound = 1 Then
					$RestoreSoundPath = GUICtrlRead($Play_Restore_Sound_Input)
					If Not FileExists($RestoreSoundPath) Then $RestoreSoundPath = "!BeepRestoreSound!"
					IniWrite($ConfigFile, "Main Prefs", "Restore Sound Path", $RestoreSoundPath)
				EndIf
				#EndRegion Sound Prefs
				;
				
				#Region Tray Prefs
				$ShowTrayIcon = 0
				If GUICtrlRead($ShowTrayIcon_CB) = 1 Then
					$ShowTrayIcon = 1
					$MinimizeToTray = IniRead($ConfigFile, "Main Window Prefs", "Minimize To Tray", 0)
					GUICtrlSetState($MinimizeToTray_Item, 64)
					TraySetState(1)
					TraySetIcon($MainIconFile)
					IniWrite($ConfigFile, "Tray Prefs", "Show Tray Icon", 1)
					
					$WhatClickShowMenu = 2
					If GUICtrlRead($LeftClickMenu_Radio) = 1 Then $WhatClickShowMenu = 1
					
					$ActionOnTrayClick = 1
					If GUICtrlRead($RestoreLastSession_Radio) = 1 Then $ActionOnTrayClick = 2
					
					If $WhatClickShowMenu = 1 Then
						$TrayMenuClick = 2
						TraySetClick(2)
						TraySetOnEvent(-7, "")
						TraySetOnEvent(-9, "TrayIconClickEvent")
					Else
						$TrayMenuClick = 16
						TraySetClick($TrayMenuClick)
						TraySetOnEvent(-7, "TrayIconClickEvent")
						TraySetOnEvent(-9, "")
					EndIf
					
					IniWrite($ConfigFile, "Tray Prefs", "On What Click Show Menu", $WhatClickShowMenu)
					IniWrite($ConfigFile, "Tray Prefs", "Action On Tray Click", $ActionOnTrayClick)
				Else
					IniWrite($ConfigFile, "Tray Prefs", "Show Tray Icon", 0)
					$MinimizeToTray = 0
					GUICtrlSetState($MinimizeToTray_Item, 128)
					TraySetState(2)
				EndIf
				#EndRegion Tray Prefs
				;
				
				#Region Transparency Prefs
				$Trans_Slider_Read = GUICtrlRead($Trans_Slider)
				If $Trans_Slider_Read > 1 Or $Transparency > 0 Then
					$Transparency = $Trans_Slider_Read
				ElseIf $Trans_Slider_Read <= 1 Then
					$Transparency = 0
					WinSetTrans($Gui, "", 255)
				EndIf
				If $Transparency < 0 Then $Transparency = 0
				IniWrite($ConfigFile, "Main Window Prefs", "Transparency", $Transparency)
				
				$SetTransForMainGUI = 0
				If GUICtrlRead($SetTransOnlyForGUI_CB) = 1 Then $SetTransForMainGUI = 1
				
				IniWrite($ConfigFile, "Main Window Prefs", "Set Transparency Only For Main Window", $SetTransForMainGUI)
				#EndRegion Transparency Prefs
				;
				
				#Region Color Prefs
				$AppBkColor = $Set_AppBkColor_Temp
				$LV_BkColor = $Set_LV_BkColor_Temp
				$Main_Menu_Color = $Set_Main_Menu_Color_Temp
				$Context_Menu_Color = $Set_Context_Menu_Color_Temp
				
				If GUICtrlRead($AppBkColor_CB) <> 1 Then $AppBkColor = "0xF3F3F3"
				GUISetBkColor($AppBkColor, $Gui)
				
				If GUICtrlRead($ListBkColor_CB) <> 1 Then $LV_BkColor = "0xF8F8FC"
				GUICtrlSetBkColor($ListView, $LV_BkColor)
				GUICtrlSetState($ListView, $GUI_HIDE)
				GUICtrlSetState($ListView, $GUI_SHOW)
				
				
				If GUICtrlRead($Main_Menu_Color_CB) <> 1 Then $Main_Menu_Color = "0xC0C0C0"
				SetMenuColor($Options_Menu, RGB2BGR($Main_Menu_Color))
				SetMenuColor($Edit_Menu, RGB2BGR($Main_Menu_Color))
				SetMenuColor($View_Menu, RGB2BGR($Main_Menu_Color))
				SetMenuColor($Help_Menu, RGB2BGR($Main_Menu_Color))
				
				If GUICtrlRead($Context_Menu_Color_CB) <> 1 Then $Context_Menu_Color = "0xBADCDC"
				SetMenuColor($LV_Context_Menu, RGB2BGR($Context_Menu_Color))
				
				IniWrite($ConfigFile, "Main Window Prefs", "Main Background Color", $AppBkColor)
				IniWrite($ConfigFile, "Main Window Prefs", "List Background Color", $LV_BkColor)
				IniWrite($ConfigFile, "Main Window Prefs", "Main Menu Color", $Main_Menu_Color)
				IniWrite($ConfigFile, "Main Window Prefs", "Context Menu Color", $Context_Menu_Color)
				#EndRegion Color Prefs
				;
				
				#Region Other Prefs
				If GUICtrlRead($RunAppWithWindows_CB) = 1 Then _
					RegWrite("HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Run", $AppName, "REG_SZ", StringToUTF($RunPath))
				#EndRegion Other Prefs
				;
				
				ExitLoop
		EndSwitch
	WEnd
	
	WinSetState($hWnd, "", @SW_ENABLE)
	GUIDelete($Prefs_Gui)
	GUISwitch($hWnd)
	Opt('GuiOnEventMode', $Old_Opt_GOEM)
	Opt('GUICloseOnESC', $Old_Opt_GCOE)
	GUIRegisterMsg($WM_HSCROLL, "")
	If $SoundIsPlaying Then SoundPlay("", 0) ;Stop the sound (if any was playing).
	_ReduceMemory(@AutoItPID)
EndFunc

Func AutoSaveSessDialog()
	ToggleHotKeys(0)
	Local $Old_Opt_GOEM = Opt("GuiOnEventMode", 0)
	TraySetClick(0)
	
	GUISetState(@SW_DISABLE, $Gui)
	$AutoSS_GUI = GUICreate($AppName & " - Settings for Auto-Saving Sessions", 340, 220, -1, -1, -1, $WS_EX_TOOLWINDOW, $Gui) 
	SetTransparency($AutoSS_GUI)
	GUISetBkColor($AppBkColor, $AutoSS_GUI)
	
	GUISetFont(9, 800)
	GUICtrlCreateLabel("Type number of seconds to Auto-Save Session Files." & @LF & _
		"0 = No Auto-Saving/Disable Auto-Saving:", 10, 10)
	GUICtrlSetColor(-1, 0x0000FF)
	
	GUICtrlCreateGroup("Settings", 20, 50, 300, 130)
	
	GUICtrlCreateLabel("Save every ", 30, 73)
	
	$Time_Input = GUICtrlCreateInput($Auto_SessSavingTime, 100, 70, 55, 21, _
		$ES_LEFT+$ES_AUTOHSCROLL+$ES_NUMBER+$ES_CENTER, $WS_EX_DLGMODALFRAME)
	GUICtrlSetLimit(-1, StringLen((24 * 60) * 60)) ;Limit Around 24 hours
	GUICtrlSetColor(-1, 0xFF0000)
	
	GUICtrlCreateLabel("Seconds", 163, 73)
	GUISetFont(9, 400)
	
	$AddToListOnAutoSave_CB = GUICtrlCreateCheckbox("Add To Main List when Auto-Saving", 30, 110)
	If $AddToListOnAutoSave = 1 Then GUICtrlSetState(-1, 1)
	
	$Sessions_Input = GUICtrlCreateInput($Last_AutoSessPath, 30, 150, 250, 20, _
		$ES_LEFT+$ES_AUTOHSCROLL+$ES_READONLY, $WS_EX_DLGMODALFRAME)
	GUICtrlSetBkColor(-1, 0xFFFFFF)
	$Select_Auto_SessionPathButton = GUICtrlCreateButton("...", 290, 150, 20, 20)
	GUICtrlSetTip(-1, "Select Folder to save sessions")
	
	Local $Set_Button = GUICtrlCreateButton("SET", 20, 190, 50, 20)
	Local $Cancel_Button = GUICtrlCreateButton("Cancel", 80, 190, 50, 20)
	
	GUISetState(@SW_SHOW, $AutoSS_GUI)
	
	_DllCallBack_Free($OriginalWindowProc)
	Local $WindowProcCallBack = _DllCallBack("_WindowProc", "hwnd;uint;long;ptr", 4)
	$OriginalWindowProc = _WinSubclass(GUICtrlGetHandle($Time_Input), $WindowProcCallBack)
	
	While 1
		If WinActive($AutoSS_GUI) Then
			HotKeySet("^v", "DummyFunc")
		Else
			HotKeySet("^v")
		EndIf
		
		Switch GUIGetMsg()
			Case -3, $Cancel_Button
				GUISetState(@SW_ENABLE, $Gui)
				ExitLoop
			Case $Select_Auto_SessionPathButton
				$Select_Session_Path = _FileSelectFolder('Please select Folder to save sessions', _
					0, $BIF_NEWDIALOGSTYLE+$BIF_RETURNONLYFSDIRS, $Last_AutoSessPath, $AutoSS_GUI)
				If @error Then ContinueLoop
				
				$Last_AutoSessPath = $Select_Session_Path
				GUICtrlSetData($Sessions_Input, $Last_AutoSessPath)
			Case $Set_Button
				GUISetState(@SW_ENABLE, $Gui)
				GUISetState(@SW_HIDE, $AutoSS_GUI)
				
				$AddToListOnAutoSave = GUICtrlRead($AddToListOnAutoSave_CB)
				If $AddToListOnAutoSave <> 1 Then $AddToListOnAutoSave = 0
				
				$Auto_SessSavingTime = StringRegExpReplace(GUICtrlRead($Time_Input), '[^0-9]', '')
				If $Auto_SessSavingTime = "" Then $Auto_SessSavingTime = 0
				
				If Not StringInStr(FileGetAttrib($Last_AutoSessPath), "D") Then
					If Not DirCreate($Last_AutoSessPath) Then
						$Last_AutoSessPath = $Deff_AutoSessPath
						DirCreate($Last_AutoSessPath)
					EndIf
				EndIf
				
				IniWrite($ConfigFile, "Main Prefs", "Add To list When Auto-Saving Sessions", $AddToListOnAutoSave)
				IniWrite($ConfigFile, "Main Prefs", "Auto-Saving Session Time", $Auto_SessSavingTime)
				IniWrite($ConfigFile, "Main Prefs", "Last Auto-Saving Session Path", $Last_AutoSessPath)
				
				If $Auto_SessSavingTime > 0 Then
					$pTimerProc = _DllCallBack("_QuickSessionSave", "hwnd;uint;uint;dword")
					$uiTimer = DllCall("user32.dll", "uint", "SetTimer", "hwnd", $Gui, "uint", 0, "int", _
						$Auto_SessSavingTime*1000, "ptr", $pTimerProc)
					$uiTimer = $uiTimer[0]
					GUICtrlSetState($StopAutoSaving_Icon, $GUI_SHOW)
					GUICtrlSetState($StopAutoSaving_Label, $GUI_SHOW)
					TrayItemSetState($StopAutoSaving_TrayItem, $TRAY_ENABLE)
				ElseIf $pTimerProc <> 0 Then
					_DllCallBack_Free($pTimerProc)
					DllCall("user32.dll", "int", "KillTimer", "hwnd", 0, "uint", $uiTimer)
					$pTimerProc = 0
				EndIf
				
				ExitLoop
		EndSwitch
	WEnd
	
	_DllCallBack_Free($OriginalWindowProc)
	HotKeySet("^v")
	GUIDelete($AutoSS_GUI)
	GUISwitch($Gui)
	Opt("GuiOnEventMode", $Old_Opt_GOEM)
	TraySetClick($TrayMenuClick)
EndFunc

Func RegisterDialog()
	ToggleHotKeys(0)
	Local $Old_Opt_GOEM = Opt("GuiOnEventMode", 0)
	TraySetClick(0)
	
	Local $ShellDefaultItem = RegRead("HKCR\DSI_Files\Shell", "")
	If $ShellDefaultItem = "" Then $ShellDefaultItem = "Open"
	
	Local $ShellOpenRead = RegRead("HKCR\DSI_Files\Shell\Open", "")
	Local $ShellSaveRead = RegRead("HKCR\DSI_Files\Shell\Save", "")
	Local $ShellRestoreRead = RegRead("HKCR\DSI_Files\Shell\Restore", "")
	Local $ShellCreateRead = RegRead("HKCR\.dsi\ShellNew", "Command")
	
	GUISetState(@SW_DISABLE, $Gui)
	$Registr_GUI = GUICreate($AppName & " - Registration Application File Types", 340, 260, -1, -1, -1, $WS_EX_TOOLWINDOW, $Gui) 
	SetTransparency($Registr_GUI)
	GUISetBkColor($AppBkColor, $Registr_GUI)
	
	GUICtrlCreateIcon($FilesIconFile, -2, 10, 10, 32, 32)
	GUICtrlSetState(-1, 128)
	GUICtrlCreateLabel("Configure shell options for Right-clicking on *.DSI files?", 50, 10)
	
	GUICtrlCreateGroup("Items to add for *.DSI files", 10, 50, 320, 160)
	
	$OpenItem_CB = GUICtrlCreateCheckbox('O&pen Session in "' & $AppName & '"', 20, 70)
	If $ShellOpenRead <> "" Then GUICtrlSetState(-1, $GUI_CHECKED)
	
	$Open_Default_RadioB = GUICtrlCreateRadio("Default", 270, 70)
	If $ShellDefaultItem = "Open" Then GUICtrlSetState(-1, $GUI_CHECKED)
	
	$SaveItem_CB = GUICtrlCreateCheckbox("Sa&ve Desktop Session Here", 20, 105)
	If $ShellSaveRead <> "" Then GUICtrlSetState(-1, $GUI_CHECKED)
	
	$Save_Default_RadioB = GUICtrlCreateRadio("Default", 270, 105)
	If $ShellDefaultItem = "Save" Then GUICtrlSetState(-1, $GUI_CHECKED)
	
	$RestoreItem_CB = GUICtrlCreateCheckbox("Res&tore Desktop Session", 20, 140)
	If $ShellRestoreRead <> "" Then GUICtrlSetState(-1, $GUI_CHECKED)
	
	$Restore_Default_RadioB = GUICtrlCreateRadio("Default", 270, 140)
	If $ShellDefaultItem = "Restore" Then GUICtrlSetState(-1, $GUI_CHECKED)
	
	$CreateFileItem_CB = GUICtrlCreateCheckbox("Add to <Create File> Context menu", 20, 175)
	If $ShellCreateRead <> "" Then GUICtrlSetState(-1, $GUI_CHECKED)
	
	GUICtrlCreateLabel("Hint: ", 15, 210)
	GUICtrlSetFont(-1, 8.5, 800)
	GUICtrlCreateLabel("Unset all checkboxes to UnRegiter File Types", 45, 211)
	GUICtrlSetFont(-1, 8)
	
	Local $Ok_Button = GUICtrlCreateButton("OK", 20, 230, 50, 20)
	Local $Cancel_Button = GUICtrlCreateButton("Cancel", 80, 230, 50, 20)
	
	GUISetState(@SW_SHOW, $Registr_GUI)
	
	While 1
		Switch GUIGetMsg()
			Case -3, $Cancel_Button
				GUISetState(@SW_ENABLE, $Gui)
				ExitLoop
			Case $Ok_Button
				GUISetState(@SW_ENABLE, $Gui)
				GUISetState(@SW_HIDE, $Registr_GUI)
				
				Local $ScriptPathCmd = '"' & @ScriptFullPath & '"'
				If Not @Compiled Then $ScriptPathCmd = '"' & @AutoItExe & '" ' & $ScriptPathCmd
				
				Local $Default_Item = "Open", $Count_Shell_Items = 0
				
				If GUICtrlRead($OpenItem_CB) = $GUI_CHECKED Then
					$Count_Shell_Items += 1
					If GUICtrlRead($Open_Default_RadioB) = $GUI_CHECKED Then $Default_Item = "Open"
					RegWrite("HKCR\DSI_Files\Shell\Open", "", "REG_SZ", 'O&pen Session in "' & $AppName & '"')
					RegWrite("HKCR\DSI_Files\Shell\Open\command", "", "REG_SZ", $ScriptPathCmd & ' :Open "%1"')
				Else
					RegDelete("HKCR\DSI_Files\Shell\Open")
				EndIf
				
				If GUICtrlRead($SaveItem_CB) = $GUI_CHECKED Then
					$Count_Shell_Items += 1
					If GUICtrlRead($Save_Default_RadioB) = $GUI_CHECKED Then $Default_Item = "Save"
					RegWrite("HKCR\DSI_Files\Shell\Save", "", "REG_SZ", "Sa&ve Desktop Session Here")
					RegWrite("HKCR\DSI_Files\Shell\Save\command", "", "REG_SZ", $ScriptPathCmd & ' :Save "%1"')
				Else
					RegDelete("HKCR\DSI_Files\Shell\Save")
				EndIf
				
				If GUICtrlRead($RestoreItem_CB) = $GUI_CHECKED Then
					$Count_Shell_Items += 1
					If GUICtrlRead($Restore_Default_RadioB) = $GUI_CHECKED Then $Default_Item = "Restore"
					RegWrite("HKCR\DSI_Files\Shell\Restore", "", "REG_SZ", "Res&tore Desktop Session")
					RegWrite("HKCR\DSI_Files\Shell\Restore\command", "", "REG_SZ", $ScriptPathCmd & ' :Restore "%1"')
				Else
					RegDelete("HKCR\DSI_Files\Shell\Restore")
				EndIf
				
				If GUICtrlRead($CreateFileItem_CB) = $GUI_CHECKED Then
					$Count_Shell_Items += 1
					RegWrite("HKCR\.dsi\ShellNew", "Command", "REG_SZ", $ScriptPathCmd & ' :Create "%1"')
				Else
					RegDelete("HKCR\.dsi\ShellNew")
				EndIf
				
				
				If $Count_Shell_Items > 0 Then
					RegWrite("HKCR\.dsi", "", "REG_SZ", "DSI_Files")
					RegWrite("HKCR\DSI_Files", "", "REG_SZ", "Desktop Session Info File")
					RegWrite("HKCR\DSI_Files\DefaultIcon", "", "REG_SZ", '"' & $FilesIconFile & '",' & $FilesIconID)
					
					RegWrite("HKCR\DSI_Files\Shell", "", "REG_SZ", $Default_Item) ;Default Item
				Else
					RegDelete("HKCR\.dsi")
					RegDelete("HKCR\DSI_Files")
				EndIf
				
				EnvUpdate()
				ExitLoop
		EndSwitch
	WEnd
	
	GUIDelete($Registr_GUI)
	GUISwitch($Gui)
	Opt("GuiOnEventMode", $Old_Opt_GOEM)
	TraySetClick($TrayMenuClick)
EndFunc

Func Editing_DSI_Dialog($Sess_File, $IconsArr, $ParentSelIndex, $hWnd=0)
	Local $Old_Opt_GOEM = Opt("GuiOnEventMode", 0)
	
	WinSetState($hWnd, "", @SW_DISABLE)
	$Editing_DSI_Gui = GuiCreate($AppName & " - Editing Of DSI Files", 600, 500, -1, -1, $WS_SYSMENU, -1, $hWnd)
	GUISetBkColor($AppBkColor, $Editing_DSI_Gui)
	
	GUICtrlCreateLabel("Double Click on the item to Change it Values", 20, 5, 290, 20)
	GUICtrlSetColor(-1, 0xFF0000)
	GUICtrlSetFont(-1, 10, 800)
	
	$Edit_LV = GUICtrlCreateListView("Desktop Icons|Coords", 20, 30, 560, 400)
	GUICtrlSetStyle(-1, BitOr($GUI_SS_DEFAULT_LISTVIEW, $LVS_NOCOLUMNHEADER))
	GUICtrlSendMsg(-1, $LVM_SETEXTENDEDLISTVIEWSTYLE, $LVS_EX_BORDERSELECT, $LVS_EX_BORDERSELECT)
	GUICtrlSendMsg(-1, $LVM_SETEXTENDEDLISTVIEWSTYLE, $LVS_EX_TRACKSELECT, $LVS_EX_TRACKSELECT)
	
	For $i = 1 To $IconsArr[0][0]
		GUICtrlCreateListViewItem($IconsArr[$i][0] & " [" & $IconsArr[$i][1] & "]|" & $IconsArr[$i][1], $Edit_LV)
		$IconArr = _GetItemImage($IconsArr[$i][0])
		If IsArray($IconArr) Then
			GUICtrlSetImage(-1, $IconArr[1], $IconArr[2])
		Else
			GUICtrlSetImage(-1, $IconArr, 0)
		EndIf
	Next
	
	$Confirm_Edit_Button = GUICtrlCreateButton("Confirm Edit", 20, 440, 80, 20)
	$Cancel_Edit_Button = GUICtrlCreateButton("Cancel Edit", 120, 440, 80, 20)
	
	$Open_Sess_In_Notepad_Button = GUICtrlCreateButton("Open DSI file in Notepad", 350, 440, 140, 20)
	GUICtrlSetTip(-1, "Will close this dialog")
	$Editing_DSI_Button = GUICtrlCreateButton("Edit Session..", 500, 440, 80, 20)
	
	GUISetState()
	
	While 1
		$Editing_DSI_Msg = GUIGetMsg()
		Select
			Case $Editing_DSI_Msg = -3 Or $Editing_DSI_Msg = $Cancel_Edit_Button
				ExitLoop
			Case $Editing_DSI_Msg = $Confirm_Edit_Button
				Local $Value, $Key
				Local $CountItems = _GUICtrlListViewGetItemCount($Edit_LV)
				
				IniDelete($Sess_File, "Icons")
				For $i = 0 To $CountItems-1
					$Value = _GUICtrlListViewGetItemText($Edit_LV, $i, 1)
					$Key = StringStripWS(StringReplace(_GUICtrlListViewGetItemText($Edit_LV, $i, 0), "[" & $Value & "]", ""), 3)
					IniWrite($Sess_File, "Icons", $Key, $Value)
				Next
				_GUICtrlListViewSetItemText($ListView, $ParentSelIndex, 1, _GetFileDate($Sess_File))
				ExitLoop
			Case $Editing_DSI_Msg = $Open_Sess_In_Notepad_Button
				Run('Notepad.exe "' & $Sess_File & '"', '', @SW_MAXIMIZE)
				ExitLoop
			Case $Editing_DSI_Msg = $Editing_DSI_Button Or $Edit_Dsi_DoubleClickEvent
				$Edit_Dsi_DoubleClickEvent = False
				Local $SelectedIndex = _GUICtrlListViewGetCurSel($Edit_LV)
				Local $SelText = _GUICtrlListViewGetItemText($Edit_LV, $SelectedIndex, 0)
				If $SelText = "" Then
					_GuiMsgBox(48, 1, $AppName & " - Attention", _
						"Please select Item to Edit.", 300, 100, -1, 5, $Gui)
					ContinueLoop
				EndIf
				
				Local $Default = _GUICtrlListViewGetItemText($Edit_LV, $SelectedIndex, 1)
				$SelText = StringStripWS(StringReplace($SelText, "[" & $Default & "]", ""), 3)
				
				Local $Input = _InputBox("New Coords...", "Type New Icon Coords for <" & $SelText & ">:", $Default, _
					400, 120, $Editing_DSI_Gui)
				If @error Then
					WinActivate($hWnd)
					ContinueLoop
				EndIf
				WinActivate($hWnd) ;Sometimes the main Gui is minimized after we Exit from Editing Dialog
				
				_GUICtrlListViewSetItemText($Edit_LV, $SelectedIndex, 0, $SelText & " [" & $Input & "]")
				_GUICtrlListViewSetItemText($Edit_LV, $SelectedIndex, 1, $Input)
		EndSelect
	WEnd
	
	WinSetState($hWnd, "", @SW_ENABLE)
	GUIDelete($Editing_DSI_Gui)
	GUISwitch($hWnd)
	Opt("GuiOnEventMode", $Old_Opt_GOEM)
EndFunc

Func _FileSaveDialog($sTitle, $sInitDir, $sFilter = 'All (*.*)', $iOpt = 0, $sDefaultFile = "", $sDefaultExt = "", $mainGUI = 0)
    Local $iFileLen = 65536 ; Max chars in returned string
    ; API flags prepare
    Local $iFlag = BitOR (BitShift (BitAND ($iOpt, 2),-10), BitShift (BitAND ($iOpt,16), 3 ))
    ; Filter string to array convertion
    Local $asFLines = StringSplit ( $sFilter, '|'), $asFilter [$asFLines [0] *2+1]
    Local $i, $iStart, $iFinal, $suFilter = ''
    $asFilter [0] = $asFLines [0] *2
    For $i=1 To $asFLines [0]
        $iStart = StringInStr ($asFLines [$i], '(', 0, 1)
        $iFinal = StringInStr ($asFLines [$i], ')', 0,-1)
        $asFilter [$i*2-1] = StringStripWS(StringLeft($asFLines [$i], $iStart-1), 3)
        $asFilter [$i*2] = StringStripWS(StringTrimRight(StringTrimLeft($asFLines [$i], $iStart), _
			StringLen($asFLines [$i]) -$iFinal+1), 3)
        $suFilter = $suFilter & 'char[' & StringLen($asFilter [$i*2-1])+1 & '];char[' & StringLen($asFilter [$i*2])+1 & '];'
    Next
    ; Create API structures
    Local $uOFN = DllStructCreate ('dword;int;int;ptr;ptr;dword;dword;ptr;dword' & _
        ';ptr;int;ptr;ptr;dword;short;short;ptr;ptr;ptr;ptr;ptr;dword;dword' )
    Local $usTitle  = DllStructCreate ('char[' & StringLen ($sTitle) +1 & ']')
    Local $usInitDir= DllStructCreate ('char[' & StringLen ($sInitDir) +1 & ']')
    Local $usFilter = DllStructCreate ($suFilter & 'char')
    Local $usFile   = DllStructCreate ('char[' & $iFileLen & ']')
    Local $usExtn   = DllStructCreate ('char[' & StringLen ($sDefaultExt) +1 & ']')
    For $i=1 To $asFilter [0]
        DllStructSetData ($usFilter, $i, $asFilter [$i])
    Next
    ; Set Data of API structures
    DllStructSetData ($usTitle, 1, $sTitle)
    DllStructSetData ($usInitDir, 1, $sInitDir)
    DllStructSetData ($usFile, 1, $sDefaultFile)
    DllStructSetData ($usExtn, 1, $sDefaultExt)
    DllStructSetData ($uOFN,  1, DllStructGetSize($uOFN))
    DllStructSetData ($uOFN,  2, $mainGUI)
    DllStructSetData ($uOFN,  4, DllStructGetPtr ($usFilter))
    DllStructSetData ($uOFN,  7, 1)
    DllStructSetData ($uOFN,  8, DllStructGetPtr ($usFile))
    DllStructSetData ($uOFN,  9, $iFileLen)
    DllStructSetData ($uOFN, 12, DllStructGetPtr ($usInitDir))
    DllStructSetData ($uOFN, 13, DllStructGetPtr ($usTitle))
    DllStructSetData ($uOFN, 14, $iFlag)
    DllStructSetData ($uOFN, 17, DllStructGetPtr ($usExtn))
    DllStructSetData ($uOFN, 23, BitShift (BitAND ($iOpt, 32), 5))
    ; Call API function
    $ret = DllCall ('comdlg32.dll', 'int', 'GetSaveFileName', _
            'ptr', DllStructGetPtr ($uOFN) )
    If $ret [0] Then
        Return DllStructGetData ($usFile, 1)
    Else
        SetError (1)
        Return ""
    EndIf
EndFunc

Func _FileOpenDialog($sTitle, $sInitDir, $sFilter = 'All (*.*)', $iOpt = 0, $sDefaultFile = "", $sDefaultExt = "", $mainGUI = 0)
    Local $iFileLen = 65536 ; Max chars in returned string
    ; API flags prepare
    Local $iFlag = BitOR ( _
        BitShift (BitAND ($iOpt, 1),-12), BitShift (BitAND ($iOpt, 2),-10), BitShift (BitAND ($iOpt, 4),-7 ), _
        BitShift (BitAND ($iOpt, 8),-10), BitShift (BitAND ($iOpt, 4),-17) )
    ; Filter string to array convertion
    Local $asFLines = StringSplit ( $sFilter, '|'), $asFilter [$asFLines [0] *2+1]
    Local $i, $iStart, $iFinal, $suFilter = ''
    $asFilter[0] = $asFLines[0] *2
    For $i=1 To $asFLines[0]
        $iStart = StringInStr ($asFLines[$i], '(', 0, 1)
        $iFinal = StringInStr ($asFLines[$i], ')', 0,-1)
        $asFilter[$i*2-1] = StringStripWS(StringLeft($asFLines[$i], $iStart-1), 3)
        $asFilter[$i*2] = StringStripWS(StringTrimRight(StringTrimLeft($asFLines[$i], $iStart), _
			StringLen($asFLines[$i]) -$iFinal+1), 3)
        $suFilter &= 'byte[' & StringLen($asFilter[$i*2-1])+1 & '];char[' & StringLen($asFilter[$i*2])+1 & '];'
    Next
    ; Create API structures
    Local $uOFN = DllStructCreate ('dword;int;int;ptr;ptr;dword;dword;ptr;dword' & _
        ';ptr;int;ptr;ptr;dword;short;short;ptr;ptr;ptr;ptr;ptr;dword;dword' )
    Local $usTitle  = DllStructCreate('char[' & StringLen($sTitle) +1 & ']')
    Local $usInitDir= DllStructCreate('char[' & StringLen($sInitDir) +1 & ']')
    Local $usFilter = DllStructCreate($suFilter & 'byte')
    Local $usFile   = DllStructCreate ('char[' & $iFileLen & ']')
    Local $usExtn   = DllStructCreate('char[' & StringLen($sDefaultExt) +1 & ']')
    For $i=1 To $asFilter[0]
        DllStructSetData($usFilter, $i, $asFilter[$i])
    Next
    ; Set Data of API structures
    DllStructSetData ($usTitle, 1, $sTitle)
    DllStructSetData ($usInitDir, 1, $sInitDir)
    DllStructSetData ($usFile, 1, $sDefaultFile)
    DllStructSetData ($usExtn, 1, $sDefaultExt)
    DllStructSetData ($uOFN,  1, DllStructGetSize($uOFN))
    DllStructSetData ($uOFN,  2, $mainGUI)
    DllStructSetData ($uOFN,  4, DllStructGetPtr ($usFilter))
    DllStructSetData ($uOFN,  7, 1)
    DllStructSetData ($uOFN,  8, DllStructGetPtr ($usFile))
    DllStructSetData ($uOFN,  9, $iFileLen)
    DllStructSetData ($uOFN, 12, DllStructGetPtr ($usInitDir))
    DllStructSetData ($uOFN, 13, DllStructGetPtr ($usTitle))
    DllStructSetData ($uOFN, 14, $iFlag)
    DllStructSetData ($uOFN, 17, DllStructGetPtr ($usExtn))
    DllStructSetData ($uOFN, 23, BitShift (BitAND ($iOpt, 32), 5))
    ; Call API function
    $ret = DllCall ('comdlg32.dll', 'int', 'GetOpenFileName', 'ptr', DllStructGetPtr ($uOFN) )
    If $ret[0] Then
        If BitAND ($iOpt, 4) Then
			$i = 1
			While 1
				If Binary(DllStructGetData ($usFile, 1, $i))=0 Then
					If Binary(DllStructGetData ($usFile, 1, $i+1))=0 Then
						ExitLoop
					Else
						DllStructSetData ($usFile, 1, '|', $i)
					EndIf
				EndIf
				$i += 1
			Wend
        EndIf
        Return DllStructGetData($usFile, 1)
    Else
        Return SetError(1, 0, "")
    EndIf
EndFunc

Func _AboutBox($Title, $Parent=0, $IconFile=@AutoItExe)
	ToggleHotKeys(0)
	Local $OldEventOpt = Opt("GUIOnEventMode", 0)
	Local $Width = 650, $Height = 400
	Local $About_GUI, $About_Msg, $CurInfo
	Local $CurIsOnCtrlArr[1]
	
	Local $HoverCheck = False
	Local $CopyRLabelText = "Copyright  2007 trids, G.Sandler. All rights reserved."
	Local $NameURL1 = "Program's Topic on AutoIt Forums", $URL1 = "http://www.autoitscript.com/forum/index.php?showtopic=53209"
	Local $NameURL2 = "mscreator@gmail.com", $URL2 = "mailto:mscreator@gmail.com"
	Local $NameURL3 = "trids Profile On AutoIt Forum", $URL3 = "http://www.autoitscript.com/forum/index.php?showuser=54"
	
	Local $LinkColor = 0x0000FF
	Local $LinkVisitedColor[4] = [3, $LinkColor, $LinkColor, $LinkColor]
	Local $LinkLabel[4]
	
	WinSetState($Parent, "", @SW_DISABLE)
	
	$About_GUI = GUICreate($Title, $Width, $Height, -1, -1, -1, $WS_EX_TOOLWINDOW+$WS_EX_CLIENTEDGE, $Parent)
	GUISetBkColor(0xFFFFFF)
	
	GUICtrlCreateIcon($IconFile, 0, 10, 20)
	GUICtrlSetState(-1, 128)
	
	GUICtrlCreateLabel($AppName & $AppVersion, 45, 10, $Width-45, 40, 1)
	GUICtrlSetFont(-1, 10, 800)
	GUICtrlCreateLabel("This program designed for Saving and Restoring Desktop Icons positions!", 45, 30, $Width-45, 40, 1)
	GUICtrlSetFont(-1, 8, 800)
	
	GUICtrlCreateGraphic(5, 75, $Width-10, 3, $SS_ETCHEDFRAME)
	
	GUICtrlCreateLabel("Author(s):", 10, 100, 60)
	GUICtrlSetFont(-1, 9, 800)
	
	GUICtrlCreateLabel("* trids (Idea and main functions).", 90, 100, $Width-90)
	GUICtrlSetFont(-1, 9, 400, 2)
	GUICtrlCreateLabel("* G.Sandler a.k.a CreatoR (GUI and additional functionality).", 90, 120, $Width-90)
	GUICtrlSetFont(-1, 9, 400, 2)
	
	GUICtrlCreateLabel("THANKS TO:", 10, 150, 70)
	GUICtrlSetFont(-1, 9, 800)
	
	GUICtrlCreateLabel("* Special Thanks to <AutoIt Team> that designed so powerfull tool such AutoIT :D" & @LF & _
		"* Thanks to all AutoIt Community for helping me understand of how thing are realy works ;)" & @LF & _
		"* Thank to those ho write/rewrited/modified functions that used in this program, " & @LF & _
		"and sorry for not mention all of you guys - it will be a looong list!", 90, 150, $Width-120, 60)
	GUICtrlSetFont(-1, 9, 400, 2)
	
	GUICtrlCreateLabel("Contacts:", 10, 230, 70)
	GUICtrlSetFont(-1, 9, 800)
	
	Local $LinkTop = 250
	For $i = 1 To 3
		$LinkLabel[$i] = GUICtrlCreateLabel(Eval("NameURL" & $i), 90, $LinkTop, 185, 15)
		GUICtrlSetCursor(-1, 0)
		GUICtrlSetColor(-1, $LinkColor)
		GUICtrlSetFont(-1, 9, 800, 0)
		GUICtrlSetTip(-1, Eval("URL" & $i))
		$LinkTop += 30
	Next
	
	GUICtrlCreateGraphic(5, $Height-40, $Width-10, 3, $SS_ETCHEDFRAME)
	
	$CopyRight_Label = GUICtrlCreateLabel($CopyRLabelText, 10, $Height-20, $Width-100)
	GUICtrlSetColor(-1, 0x969696)
	GUICtrlSetState(-1, 128)
	
	Local $Readme_Button = GUICtrlCreateButton("Readme", $Width-160, $Height-30, 60, 20)
	Local $Close_Button = GUICtrlCreateButton("Close", $Width-80, $Height-30, 60, 20)
	GUICtrlSetState(-1, $GUI_DEFBUTTON)
	
	FileInstall("Resources\BASSMOD.dll", @TempDir & "\", 1)
	FileInstall("Resources\AboutSound.mod", @TempDir & "\", 1)
	
	Local $HandleArr = BassModOpen(@TempDir & "\BASSMOD.dll", @TempDir & "\AboutSound.mod", 1024+4)
	
	GUISetState(@SW_SHOW, $About_GUI)
	
	While 1
		$About_Msg = GUIGetMsg()
		
		Switch $About_Msg
			Case -3, $Close_Button
				BassModClose($HandleArr)
				FileDelete(@TempDir & "\BASSMOD.dll")
				FileDelete(@TempDir & "\AboutSound.mod")
				ExitLoop
			Case $Readme_Button
				FileInstall("Resources\Readme.txt", @ScriptDir & "\")
				Run(@AutoItExe & ' /ErrorStdOut /AutoIt3ExecuteLine "ShellExecute(''' & $Readme_File & ''')"')
				$ReadmrRunErrTitle = "[Class:#32770; Title:" & $Readme_File & "]"
				WinWait($ReadmrRunErrTitle, "Windows", 3)
				If WinExists($ReadmrRunErrTitle, "Windows") Then WinSetOnTop($ReadmrRunErrTitle, "Windows", 1)
			Case $LinkLabel[1], $LinkLabel[2], $LinkLabel[3]
				GUISetCursor(0, 1, $About_GUI)
				$CurInfo = GUIGetCursorInfo($About_GUI)
				If $About_Msg = $LinkLabel[1] Then $i = 1
				If $About_Msg = $LinkLabel[2] Then $i = 2
				If $About_Msg = $LinkLabel[3] Then $i = 3
				
				While $CurInfo[2] = 1
					$CurInfo = GUIGetCursorInfo($About_GUI)
					Sleep(10)
				WEnd
				
				If $CurInfo[4] = $About_Msg Then
					GUISetCursor(-1, 0, $About_GUI)
					$LinkVisitedColor[$i] = 0xAC00A9
					GUICtrlSetColor($About_Msg, $LinkVisitedColor[$i])
					RunWait(@ComSpec & ' /c start "" "' & Eval("URL" & $i) & '"', '', @SW_HIDE)
					WinActivate($About_GUI)
					$HoverCheck = True
				EndIf
				GUISetCursor(-1, 0, $About_GUI)
		EndSwitch
		
		If WinActive($About_GUI) Or $HoverCheck Then
			If $HoverCheck Then $HoverCheck = False
			Sleep(20)
			ControlHover($About_GUI, $LinkLabel[1], 1, $CurIsOnCtrlArr, 0xFF0000, $LinkColor)
			ControlHover($About_GUI, $LinkLabel[2], 2, $CurIsOnCtrlArr, 0xFF0000, $LinkColor)
			ControlHover($About_GUI, $LinkLabel[3], 3, $CurIsOnCtrlArr, 0xFF0000, $LinkColor)
		EndIf
	WEnd
	WinSetState($Parent, "", @SW_ENABLE)
	GUIDelete($About_GUI)
	GUISwitch($Parent)
	Opt("GUIOnEventMode", $OldEventOpt)
	_ReduceMemory(@AutoItPID)
EndFunc

Func _MsgBox($MsgBoxType, $MsgBoxTitle, $MsgBoxText, $mainGUI)
	ToggleHotKeys(0)
	TraySetClick(0)
	Local $mRet = DllCall("user32.dll", "int", "MessageBox", "hwnd", $mainGUI, _
		"str", $MsgBoxText, "str", $MsgBoxTitle, "int", $MsgBoxType)
	TraySetClick($TrayMenuClick)
    Return $mRet[0]
EndFunc

Func _GuiMsgBox($IcoType,$Butt_Num,$Title,$Text,$Width,$Height,$CB_Text=-1,$Timer=-1,$hWnd=0,$B1Text=-1,$B2Text=-1,$ExStyle=-1)
	ToggleHotKeys(0)
	SetStatusBarData("")
	StringReplace($Text, @LF, "")
	Local $TextLines = @extended
	
	Local $Yes, $No, $OK, $CheckBox=-1, $Gui_MsgBox, $GuiHeight = $Height
	Local $TitleType = $WS_CAPTION+$WS_POPUP, $Gui_Msg, $ReturnVal = 0
	Local $DefButton = $OK, $DefButtonText = $B1Text, $Counter
	
	Local $Ico_File = 'user32.dll'
	
	If FileExists($IcoType) Then
		$Ico_File = $IcoType
	Else
		Switch $IcoType
			Case 16
				$IcoType = 103
			Case 32
				$IcoType = 102
			Case 48
				$IcoType = 101
			Case 64
				$IcoType = 104
			Case Else
				$IcoType = 102
		EndSwitch
	EndIf
	
	Local $Old_Opt_GOEM = Opt('GuiOnEventMode', 0)
	Local $Old_Opt_GCOE = Opt('GUICloseOnESC', 0)
	
	If $hWnd <> 0 Then WinSetState($hWnd, "", @SW_DISABLE)
	If $Butt_Num = 1 Then $TitleType += $WS_SYSMENU
	
	If $GuiHeight < $TextLines * 18 Then
		$GuiHeight = $TextLines * 18
		$Height = $GuiHeight
	EndIf
	If $CB_Text <> -1 Then $GuiHeight += 25
	
	If $B1Text = -1 Then $B1Text = 'OK'
	If $B2Text = -1 Then $B2Text = 'Cancel'
	
	$Gui_MsgBox = GuiCreate($Title, $Width, $GuiHeight, -1, -1, $TitleType, $ExStyle, $hWnd)
	SetTransparency($Gui_MsgBox)
	GUISetBkColor($AppBkColor, $Gui_MsgBox)
	GUISetIcon($MainIconFile)
	
	GUICtrlCreateIcon($Ico_File, $IcoType, 10, 10)
	GUICtrlSetState(-1, 128)
	GUICtrlCreateLabel($Text, 70, 15, $Width-80, $Height-50)
	
	Select
		Case $Butt_Num = 2
			$Yes = GUICtrlCreateButton($B1Text, ($Width/2)-90, $Height-35, 70, 20)
			$DefButton = $Yes
			
			$No = GUICtrlCreateButton($B2Text, ($Width/2)+20, $Height-35, 70, 20)
			
			GUICtrlSetState($No, $GUI_ONTOP)
			GUICtrlSetState($Yes, $GUI_ONTOP+$GUI_DEFBUTTON)
		Case Else
			$OK = GUICtrlCreateButton($B1Text, ($Width-70)/2, $Height-35, 70, 20)
			GUICtrlSetState($OK, $GUI_DEFBUTTON+$GUI_ONTOP)
			$DefButton = $OK
	EndSelect
	
	If $CB_Text <> -1 Then $CheckBox = GUICtrlCreateCheckbox($CB_Text, 15, $Height-10)
	GuiSetState(@SW_SHOW, $Gui_MsgBox)
	
	If $Timer > 0 Then
		$Counter = $Timer
		$Timer = TimerInit()
		$DefButtonText = GUICtrlRead($DefButton)
		GUICtrlSetData($DefButton, $DefButtonText & ' (' & $Counter & ')')
	EndIf
	
	While 1
		$Gui_Msg = GUIGetMsg()
		
		If $Timer > 0 And TimerDiff($Timer) >= 1000 Then
			$Timer = TimerInit()
			$Counter -= 1
			GUICtrlSetData($DefButton, $DefButtonText & ' (' & $Counter & ')')
			If $Counter < 0 Then $Gui_Msg = $DefButton
		EndIf
		
		Select
			Case $Butt_Num = 2 And $Gui_Msg = $Yes
				$ReturnVal = 6
				ExitLoop
			Case $Butt_Num = 2 And $Gui_Msg = $No
				$ReturnVal = 7
				ExitLoop
			Case $Gui_Msg = -3 Or ($Gui_Msg = $OK And $Butt_Num <> 2)
				$ReturnVal = 1
				ExitLoop
		EndSelect
	Wend
	
	If GUICtrlRead($CheckBox) = 1 Then $ReturnVal += 8
	
	If $hWnd <> 0 Then WinSetState($hWnd, "", @SW_ENABLE)
	GUIDelete($Gui_MsgBox)
	GUISwitch($hWnd)
	Opt('GuiOnEventMode', $Old_Opt_GOEM)
	Opt('GUICloseOnESC', $Old_Opt_GCOE)
	_ReduceMemory(@AutoItPID)
	Return $ReturnVal
EndFunc

Func _InputBox($Title,$Promt,$Default="",$Width=-1,$Height=-1,$hWnd=0,$Limit=-1,$IconFile=-1,$IsPassword=0,$IsDigits=0,$Timeout=0,$Left=-1,$Top=-1,$Style=0,$exStyle=0)
	ToggleHotKeys(0)
	SetStatusBarData("")
	Local $OldOpt_GOM = Opt("GuiOnEventMode", 0)
	If $Width < 200 Then $Width = 200
	If $Height < 150 Then $Height = 150
	
	Local $RetError = 0, $Ret_Value = ""
	Local $OKButton, $CancelButton, $InputBoxID, $Msg, $GuiCoords, $RetValue, $InputMsg, $TimerStart
	
	WinSetState($hWnd, "", @SW_DISABLE)
	$InputGui = GUICreate($Title, $Width, $Height, $Left, $Top, 0x00040000+$Style, $exStyle, $hWnd)
	SetTransparency($InputGui)
	GUISetBkColor($AppBkColor, $InputGui)
	
	GUIRegisterMsg(0x24, "WM_GETMINMAXINFO")
	GUIRegisterMsg($WM_LBUTTONDOWN, "DRAG_COMMAND")
	
	If $IconFile <> -1 Then
		GUISetIcon($IconFile)
		GUICtrlCreateIcon($IconFile, 0, 10, 10)
		GUICtrlSetState(-1, 128)
	EndIf
	
	GUICtrlCreateLabel($Promt, 60, 5, $Width, -1)
	GUICtrlSetResizing(-1, 256+512)
	
	$OKButton = GUICtrlCreateButton("OK", ($Width/2)-70, $Height-95, 60, 25)
	GUICtrlSetResizing(-1, 0x0240)
	GUICtrlSetState(-1, 2048)
	GUICtrlSetState(-1, 512)
	
	$CancelButton = GUICtrlCreateButton("Cancel", ($Width/2)+10, $Height-95, 60, 25)
	GUICtrlSetResizing(-1, 0x0240)
	GUICtrlSetState(-1, 2048)
	
	If $IsPassword <> 0 Then $IsPassword = 32
	If $IsDigits <> 0 Then $IsDigits = 8192
	
	$InputBoxID = GUICtrlCreateInput($Default, 20, $Height-60, $Width-40, 20, $IsPassword+$IsDigits+128, 0x00000001)
	GUICtrlSetResizing(-1, 0x0240)
	GUICtrlSetState(-1, 256)
	If $Limit <> -1 Then GUICtrlSetLimit(-1, $Limit)
	
	GUISetState(@SW_SHOW, $InputGui)
	If $Timeout > 0 Then $TimerStart = TimerInit()
	
	While 1
		$InputMsg = GUIGetMsg()
		Switch $InputMsg
			Case -12
				ControlFocus($InputGui, "", $OKButton)
				ControlFocus($InputGui, "", $CancelButton)
			Case -3, $CancelButton
				$RetError = 1
				ExitLoop
			Case $OKButton
				$Ret_Value = GUICtrlRead($InputBoxID)
				$RetError = 0
				ExitLoop
		EndSwitch
		
		If $Timeout > 0 And Round(TimerDiff($TimerStart)/1000) = $Timeout Then
			$Ret_Value = GUICtrlRead($InputBoxID)
			$RetError = 2
			ExitLoop
		EndIf
	WEnd
	
	WinSetState($hWnd, "", @SW_ENABLE)
	GUIDelete($InputGui)
	GUISwitch($hWnd)
	Opt("GuiOnEventMode", $OldOpt_GOM)
	_ReduceMemory(@AutoItPID)
	Return SetError($RetError, 0, $Ret_Value)
EndFunc

Func WM_DROPFILES_FUNC($hWnd, $msgID, $wParam, $lParam)
    If $hWnd <> $Gui Then Return $GUI_RUNDEFMSG
	Local $nSize, $pFileName
    Local $nAmt = DllCall("shell32.dll", "int", "DragQueryFile", "hwnd", $wParam, "int", 0xFFFFFFFF, "ptr", 0, "int", 255)
    For $i = 0 To $nAmt[0] - 1
        $nSize = DllCall("shell32.dll", "int", "DragQueryFile", "hwnd", $wParam, "int", $i, "ptr", 0, "int", 0)
        $nSize = $nSize[0] + 1
        $pFileName = DllStructCreate("char[" & $nSize & "]")
        DllCall("shell32.dll", "int", "DragQueryFile", "hwnd", $wParam, "int", $i, "ptr", _
			DllStructGetPtr($pFileName), "int", $nSize)
        ReDim $DropFilesArr[$i + 2]
        $DropFilesArr[$i+1] = DllStructGetData($pFileName, 1)
        $pFileName = 0
    Next
	$DropFilesArr[0] = UBound($DropFilesArr)-1
EndFunc

Func WM_SIZE($hWnd, $MsgID, $wParam, $lParam)
	If $hWnd <> $Gui Then Return $GUI_RUNDEFMSG
	_GuiCtrlStatusBarResize($StatusBar)
	If $AutoResizeColumns = 1 Then SetColumnsWidth()
	Return $GUI_RUNDEFMSG
EndFunc

Func WM_SESS_FUNC($hWnd, $MsgID, $wParam, $lParam)
	If $hWnd <> $Gui Then Return
	If $MsgID <> $WM_COPYDATA Then Return
	
	ToggleHotKeys(0)
	
	Local $vs_msg = _AU3COM_RecvData($LParam)
	Local $MSGRECVD = DllStructGetData($vs_msg, 1)
	Local $Cmd = $MSGRECVD
	Local $Action = ":Open"
	
	If StringInStr($Cmd, ":Save") Then $Action = ":Save"
	If StringInStr($Cmd, ":Restore") Then $Action = ":Restore"
	
	Local $Sess_F_Name = StringRegExpReplace($Cmd, '(?i)(.*)' & $Action & '\s', '')
	$Sess_F_Name = _StringStripChars($Sess_F_Name, '"', 3)
	
	Switch $Action
		Case ":Open"
			_AddSession($Sess_F_Name)
			SetColumnsWidth()
			WinActivate($Gui)
		Case ":Save"
			_SaveSession($Sess_F_Name)
		Case ":Restore" ;Not Needed Yet...
			
	EndSwitch
EndFunc

Func WM_NOTIFY_EVENTS($hWnd, $MsgID, $wParam, $lParam)
	If $hWnd <> $Gui And $hWnd <> $Editing_DSI_Gui Then Return $GUI_RUNDEFMSG
	Local $tagNMHDR = DllStructCreate("int;int;int", $lParam)
	If @error Then Return $GUI_RUNDEFMSG
	Local $Code = DllStructGetData($tagNMHDR, 3)
	If $wParam = $ListView And $Code = -3 Then $RestoreNotify = True
	If $wParam = $Edit_LV And $Code = -3 Then $Edit_Dsi_DoubleClickEvent = True
	Return $GUI_RUNDEFMSG
EndFunc

Func WM_GETMINMAXINFO($hWnd, $Msg, $wParam, $lParam)
	If $hWnd <> $Gui And $hWnd <> $InputGui Then Return $GUI_RUNDEFMSG
	
	Local $MINGuiX = 508, $MINGuiY = 387
	If $hWnd = $InputGui Then Local $MINGuiX = 306, $MINGuiY = 156
	
	Local $MINMAXINFO = DllStructCreate("int;int;int;int;int;int;int;int;int;int",$lParam)
	DllStructSetData($MINMAXINFO, 7, $MINGuiX)
	DllStructSetData($MINMAXINFO, 8, $MINGuiY)
	Return $GUI_RUNDEFMSG
EndFunc

Func WM_HVSCROLL($hWndGUI, $MsgID, $WParam, $LParam)
	If $hWndGUI <> $Prefs_Gui Then Return $GUI_RUNDEFMSG
	Switch $LParam
		Case GUICtrlGetHandle($Trans_Slider)
			Local $TransRead = GUICtrlRead($Trans_Slider)
			Local $PrecentSet = Round($TransRead / 2.5)
			GUICtrlSetData($Trans_Precent_Label, $PrecentSet & "%")
			If $TransRead > 0 Then
				If GUICtrlRead($SetTransOnlyForGUI_CB) <> 1 Then WinSetTrans($hWndGUI, "", 255 - $TransRead)
				WinSetTrans($Gui, "", 255 - $TransRead)
			Else
				If GUICtrlRead($SetTransOnlyForGUI_CB) <> 1 Then WinSetTrans($hWndGUI, "", 254)
				WinSetTrans($Gui, "", 254)
			EndIf
	EndSwitch
EndFunc

Func DRAG_COMMAND($HWnd, $command, $wParam, $lParam)
	If BitAND(WinGetState($HWnd), 32) Then Return $GUI_RUNDEFMSG
	DllCall("user32.dll", "long", "SendMessage", "hwnd", $HWnd, "int", $WM_SYSCOMMAND, "int", 0xF009, "int", 0)
EndFunc

Func WM_SYSCOMMAND($hWnd, $Msg, $wParam, $lParam)
	If $hWnd <> $Gui Then Return $GUI_RUNDEFMSG
	Local $BitANDCheck = BitAND($wParam, 0xFFF0)
	If $BitANDCheck = $SC_MINIMIZE Then
		HideToTrayProc()
		Return
	ElseIf $BitANDCheck = $SC_MAXIMIZE Then
		MaximizeProc()
		Return
	ElseIf $BitANDCheck = $SC_RESTORE Then
		WinSetState($Gui, "", @SW_RESTORE)
		$GUI_STATE = WinGetState($Gui)
		Return
	EndIf
EndFunc

Func _AU3COM_SendData($InfoToSend, $RecvWinHandle)
    Local $StructDef_COPYDATA = "dword var1;dword var2;ptr var3"
    Local $CDString = DllStructCreate("char var1[256];char var2[256]") ;the array to hold the string we are sending
    
    DllStructSetData($CDString, 1, $InfoToSend)
    Local $pCDString = DllStructGetPtr($CDString) ;the pointer to the string
    Local $vs_cds = DllStructCreate($StructDef_COPYDATA);create the message struct
    DllStructSetData($vs_cds, "var1", 0) ;0 here indicates to the receiving program that we are sending a string
    DllStructSetData($vs_cds, "var2", String(StringLen($InfoToSend) + 1));tell the receiver the length of the string
    DllStructSetData($vs_cds, "var3", $pCDString) ;the pointer to the string
    Local $pStruct = DllStructGetPtr($vs_cds)
    _SendMessage($RecvWinHandle, $WM_COPYDATA, 0, $pStruct)
    
    $vs_cds = 0 ;free the struct
    $CDString = 0 ;free the struct
    
    Return 1
EndFunc

Func _AU3COM_RecvData($COM_LParam)
    ; $COM_LParam = Poiter to a COPYDATA Struct
    Local $STRUCTDEF_AU3MESSAGE = "char var1[256];int"
    Local $StructDef_COPYDATA = "dword var1;dword var2;ptr var3"
    Local $vs_cds = DllStructCreate($StructDef_COPYDATA, $COM_LParam)
    ; Member No. 3 of COPYDATA Struct (PVOID lpData;) = Pointer to Costum Struct
    Local $vs_msg = DllStructCreate($STRUCTDEF_AU3MESSAGE, DllStructGetData($vs_cds, 3))
    Return $vs_msg
EndFunc

Func _WindowProc($hWnd, $uiMsg, $wParam, $lParam)
	; Disable the right mouse button
	If $uiMsg = $WM_CONTEXTMENU Then Return 0

	; Returning a Pointer to the original WindowProc means: We did not process this message.
	; Do not call CallWindowProc() api yourself, the stub will do that for you!
	Return $OriginalWindowProc
EndFunc

Func _WinSubclass($hWnd, $lpNewWindowProc)
	;#define GWL_WNDPROC (-4)
	Local $aTmp = DllCall("user32.dll", "ptr", "SetWindowLong", "hwnd", $hWnd, "int", -4, "ptr", $lpNewWindowProc)
	If @error Then Return SetError(1, 0, 0)
	If $aTmp[0] = 0 Then Return SetError(1, 0, 0)
	Return $aTmp[0]
EndFunc

Func _ReduceMemory($i_PID = -1)
	If $i_PID <> - 1 Then
		Local $ai_Handle = DllCall("kernel32.dll", 'int', 'OpenProcess', 'int', 0x1f0fff, 'int', False, 'int', $i_PID)
		Local $ai_Return = DllCall("psapi.dll", 'int', 'EmptyWorkingSet', 'long', $ai_Handle[0])
		DllCall('kernel32.dll', 'int', 'CloseHandle', 'int', $ai_Handle[0])
	Else
		Local $ai_Return = DllCall("psapi.dll", 'int', 'EmptyWorkingSet', 'long', -1)
	EndIf
	Return $ai_Return[0]
EndFunc

Func _LV_GetSelectedText($ListView, $SubItem=-1)
	Local $ItemIndexArr = _GUICtrlListViewGetSelectedIndices($ListView, 1)
	If Not IsArray($ItemIndexArr) Then Return SetError(1, 0, -1)
	Local $SelText = "", $Ubound = UBound($ItemIndexArr)-1, $CRLF = @CRLF
	
	For $i = 1 To $Ubound
		If $i = $Ubound Then $CRLF = ""
		$SelText &= _GUICtrlListViewGetItemText($ListView, $ItemIndexArr[$i], $SubItem) & $CRLF
	Next
	Return $SelText
EndFunc

Func _FindLVItem($ListView, $String, $SubItem=0, $IgnoredItem=-1)
	Local $TotalItems = _GUICtrlListViewGetItemCount($ListView)
	For $i = 0 To $TotalItems - 1
		If $i <> $IgnoredItem And _GUICtrlListViewGetItemText($ListView, $i, $SubItem) = $String Then Return $i
	Next
	Return -1
EndFunc

Func _RemoveFromArray(ByRef $avArray, $iElemet)
	Local $UboundAray = UBound($avArray)-1
	If $iElemet > $UboundAray Then Return SetError(-1)
	Local $TempArr[1]
	
	For $i = 1 To $UboundAray
		If $i <> $iElemet Then
			ReDim $TempArr[UBound($TempArr)+1]
			$TempArr[UBound($TempArr)-1] = $avArray[$i]
		EndIf
	Next
	
	$TempArr[0] = $UboundAray-1
	$avArray = $TempArr
	
	If $avArray[0] <= 0 Then Return SetError(-1)
	Return 1
EndFunc

Func _FileCopy($FromFile, $Tofile)
	Local $FOF_RESPOND_YES = 64
	Local $FOF_SIMPLEPROGRESS = 256
	$ErrorObjEvent = ObjEvent("AutoIt.Error", "Dummy_COM_Err_Func")
	$WinShell = ObjCreate("shell.application")
	$WinShell.NameSpace($Tofile).CopyHere($FromFile)
EndFunc

Func _Write_GUI_Pos(ByRef $PosArr)
	If Not IsArray($PosArr) Then Return
	IniWrite($ConfigFile, "Main Window Prefs", "Left", $PosArr[0])
	IniWrite($ConfigFile, "Main Window Prefs", "Top", $PosArr[1])
	IniWrite($ConfigFile, "Main Window Prefs", "Width", $PosArr[2])
	IniWrite($ConfigFile, "Main Window Prefs", "Height", $PosArr[3])
EndFunc

Func ControlHover($hWnd, $CtrlID, $CtrlNum, ByRef $CurIsOnCtrlArr, $HoverColor=0xFF0000, $LinkColor=0x0000FF)
	Local $CursorCtrl = GUIGetCursorInfo($hWnd)
	ReDim $CurIsOnCtrlArr[UBound($CurIsOnCtrlArr)+1]
	If $CursorCtrl[4] = $CtrlID And $CurIsOnCtrlArr[$CtrlNum] = 1 Then
		GUICtrlSetFont($CtrlID, 9, 800, 6)
		GUICtrlSetColor($CtrlID, $HoverColor)
		$CurIsOnCtrlArr[$CtrlNum] = 0
	ElseIf $CursorCtrl[4] <> $CtrlID And $CurIsOnCtrlArr[$CtrlNum] = 0 Then
		GUICtrlSetFont($CtrlID, 9, 800, 0)
		GUICtrlSetColor($CtrlID, $LinkColor)
		$CurIsOnCtrlArr[$CtrlNum] = 1
	EndIf
EndFunc

Func _WinIsVisible($hWnd)
	Return BitAND(WinGetState($hWnd), 2)
EndFunc

Func _IsFolder($name)
	Return StringInStr(FileGetAttrib($name), "D")
EndFunc

Func _GetItemImage($PartName)
	Local $Search = FileFindFirstFile(@DesktopDir & "\" & $PartName & "*")
	If $Search = -1 Then Return "No_Image"
	
	Local $NextFile = FileFindNextFile($Search)
	Local $Error = @error
	FileClose($Search)
	If $Error Then Return "No_Image"
	Return _GetFileIcon(@DesktopDir & "\" & $NextFile)
EndFunc

Func _GetFileIcon($szFile)
	Local $Old_Opt_EES = Opt("ExpandEnvStrings", 1)
	Local $szRegDefault = "", $szDefIcon = "", $szExt, $szIconFile, $nIcon=0
	Local $RetArr[3]
	
	If _IsFolder($szFile) Then
		$szRegDefault = RegRead("HKCR\Folder", "")
		If $szRegDefault <> "" Then $szDefIcon = RegRead("HKCR\Folder\DefaultIcon", "")
	Else
		$szExt = StringRegExpReplace($szFile, '^.*\.', '.')
		
		If $szExt = ".lnk" Then
			Local $LnkInfoArr = FileGetShortcut($szFile)
			If Not @error Then
				Local $RetArr[3] = [2, $LnkInfoArr[4], $LnkInfoArr[5]]
				Return $RetArr
			EndIf
		EndIf
		
		If $szExt = $szFile Then
			$szExt = FileFindFirstFile($szFile & ".*")
			$szExt = StringRegExpReplace(FileFindNextFile($szExt), '^.*\.', '.')
			$szFile &= $szExt
		EndIf
		$szRegDefault = RegRead("HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\" & $szExt, "ProgID")
		If $szRegDefault = "" Then $szRegDefault = RegRead("HKCR\" & $szExt, "")
		If $szRegDefault <> "" Then $szDefIcon = RegRead("HKCR\" & $szRegDefault & "\DefaultIcon", "")
	EndIf
	If $szDefIcon = "" Then
		$szIconFile = "shell32.dll"
	ElseIf $szDefIcon <> "%1" Then
		If StringRegExpReplace($szFile, "^.*\\", "") = "shell32.dll" Then
			$szIconFile = $szFile
			$nIcon = 0
		Else
			$arSplit = StringSplit($szDefIcon, ",")
			If IsArray($arSplit) Then
				$szIconFile = $arSplit[1]
				If $arSplit[0] > 1 Then $nIcon = $arSplit[2]
			Else
				Opt("ExpandEnvStrings", $Old_Opt_EES)
				Return SetError(1, 0, $RetArr)
			EndIf
		EndIf
	ElseIf $szDefIcon = "%1" Then
		$szIconFile = $szFile
		$nIcon = 0
	EndIf
	Opt("ExpandEnvStrings", $Old_Opt_EES)
	Local $RetArr[3] = [2, $szIconFile, $nIcon]
	Return $RetArr
EndFunc

Func _GetMidlePath($sPath, $Flag=0)
	StringReplace($sPath, "\", "")
	If @extended < 4 Then Return $sPath
	
	If $Flag = 1 Then
		Local $PartsArr = StringSplit($sPath, "\")
		Local $ShortPath = ""
		For $i = 2 To UBound($PartsArr)-2
			$ShortPath &= "\.."
		Next
		
		$ShortPath = $PartsArr[1] & $ShortPath & "\" & $PartsArr[$PartsArr[0]]
		Return $ShortPath
	EndIf
	
	Local $StartPath = StringLeft($sPath, StringInStr($sPath, "\", 0, 2))
	Local $EndPath = StringTrimLeft($sPath, StringInStr($sPath, "\", 0, -2)-1)
	Return $StartPath & "...." & $EndPath
EndFunc

Func _GetFileDate($sFile)
	Local $CreatedDateArr = FileGetTime($sFile, 0)
	If IsArray($CreatedDateArr) Then
		Return $CreatedDateArr[2] & "." & $CreatedDateArr[1] & "." & $CreatedDateArr[0] & _
			", " & $CreatedDateArr[3] & ":" & $CreatedDateArr[4] & ":" & $CreatedDateArr[5]
	EndIf
	Return ""
EndFunc

Func _GetDateTime()
	Return @MDAY & "." & @MON & "." & @YEAR & ", " & @HOUR & ";" & @MIN & ";" & @SEC
EndFunc

Func GetProgressTopPos()
	Local $WorkingAreaArray = _GetWorkingArea()
	Local $ProgressTopPos
	If IsArray($WorkingAreaArray) Then
		$ProgressTopPos = $WorkingAreaArray[3] - 125
	Else
		Local $TaskbarArr = WinGetPos("[Class:Shell_TrayWnd]")
		If IsArray($TaskbarArr) Then $ProgressTopPos = @DesktopHeight-125-$TaskbarArr[3]
	EndIf
	If $ProgressTopPos < 0 Then $ProgressTopPos = @DesktopHeight-125
	Return $ProgressTopPos
EndFunc

Func GetProgressLeftPos()
	Local $WorkingAreaArray = _GetWorkingArea()
	Local $ProgressLeftPos
	If IsArray($WorkingAreaArray) Then
		$ProgressLeftPos = $WorkingAreaArray[0]
	Else
		Local $TaskbarArr = WinGetPos("[Class:Shell_TrayWnd]")
		If IsArray($TaskbarArr) Then $ProgressLeftPos = $TaskbarArr[2]
		If $ProgressLeftPos = @DesktopWidth Then $ProgressLeftPos = 0
	EndIf
	If $ProgressLeftPos < 0 Or $ProgressLeftPos > @DesktopWidth Then $ProgressLeftPos = 0
	Return $ProgressLeftPos
EndFunc

;===============================================================================
;
; Function Name:    _GetWorkingArea()
; Description:      Returns the coordinates of desktop working area rectangle
; Parameter(s):     None
; Return Value(s):  On Success - Array containing coordinates:
;                        $a[0] = left
;                        $a[1] = top
;                        $a[2] = right
;                        $a[3] = bottom
;                   On Failure - 0
;
;===============================================================================
Func _GetWorkingArea()
    Local $dRECT = DllStructCreate("long; long; long; long")
    Local $spiRet = DllCall("User32.dll", "int", "SystemParametersInfo", _
		"uint", 48, "uint", 0, "ptr", DllStructGetPtr($dRECT), "uint", 0)
    If @error Then Return 0
    If $spiRet[0] = 0 Then Return 0
    Local $aRet[4] = [DllStructGetData($dRECT, 1), DllStructGetData($dRECT, 2), _
		DllStructGetData($dRECT, 3), DllStructGetData($dRECT, 4)]
    Return $aRet
EndFunc

Func _GetSysColor($nIndex)
	Local $BGRColor = DllCall("user32.dll", "long", "GetSysColor", "long", $nIndex)
	Local $BGR = Hex($BGRColor[0], 6)
	Local $RGB = "0x" & StringRight($BGR, 2) & StringMid($BGR, 3, 2) & StringLeft($BGR, 2)
	Return $RGB
EndFunc

Func _PharseSelected($String)
	Local $RetArr[1]
	If StringInStr($String, "|") Then
		Local $SplitArr = StringSplit($String, "|"), $InitPath = StringRegExpReplace($SplitArr[1], '([^\\])\\*$', '\1')
		For $i = 2 To UBound($SplitArr)-1
			ReDim $RetArr[UBound($RetArr) + 1]
			$RetArr[UBound($RetArr) - 1] = $InitPath & "\" & $SplitArr[$i]
		Next
		$RetArr[0] = UBound($RetArr) - 1
	Else
		Local $RetArr[2] = [1, $String]
	EndIf
	Return $RetArr
EndFunc

Func _StringStripChars($String, $Char, $Flag=0)
	If StringLen($String) = 0 Or Not StringInStr($String, $Char) Then Return SetError(1, 0, $String)
	Local $ChrLenght = StringLen($Char)
	Switch $Flag
		Case 1
			If StringLeft($String, $ChrLenght) = $Char Then Return StringTrimLeft($String, $ChrLenght)
		Case 2
			If StringRight($String, $ChrLenght) = $Char Then Return StringTrimRight($String, $ChrLenght)
		Case 3
			If StringLeft($String, $ChrLenght) = $Char Then $String = StringTrimLeft($String, $ChrLenght)
			If StringRight($String, $ChrLenght) = $Char Then $String = StringTrimRight($String, $ChrLenght)
			Return $String
		Case Else
			$String = StringReplace($String, $Char, "")
			Return SetError(0, @extended, $String)
	EndSwitch
	Return SetError(2, 0, $String)
EndFunc

Func StringToUTF($String)
	Dim $sResult = ""
	$VarUTFArr = StringSplit($String, "")
	
	For $i = 1 To $VarUTFArr[0]
		$code = Asc($VarUTFArr[$i])
		
		Select
			Case $code >= 192 And $code <= 239
				$VarUTFArr[$i] = Chr(208) & Chr($code - 48)
			Case $code >= 240 And $code <= 255
				$VarUTFArr[$i] = Chr(209) & Chr($code - 112)
			Case $code = 168
				$VarUTFArr[$i] = Chr(208) & Chr(129)
			Case $code = 184
				$VarUTFArr[$i] = Chr(209) & Chr(145)
			Case Else
				$VarUTFArr[$i] = Chr($code)
		EndSelect
		
		$sResult = $sResult & $VarUTFArr[$i]
	Next
	
	Return $sResult
EndFunc

Func BassModOpen($DllPath, $sPath, $Flag=0)
	If Not FileExists($DllPath) Then Return SetError(1)
	
	Local $BassModDll = DllOpen($dllPath)
	If $BassModDll = -1 Then Return -1
	
	Local $init = DllCall($BassModDll, "int", "BASSMOD_Init", "int", -1, _  ;device
							"int", 44100, _  ;freq Hz
							"int", 0)       ;flag
	Local $FName = DllStructCreate("char[255]")
	DllStructSetData($FName, 1, $sPath)
	Local $load = DllCall($BassModDll, "int", "BASSMOD_MusicLoad", "int", False, _  ;loading from memory
							"ptr", DllStructGetPtr($FName), _ ;file
							"int", 0, _   ;offset
							"int", 0, _   ;length
							"int", $Flag) ;flag
	Local $Music_Handle = $load[0]
	DllCall($BassModDll, "int:cdecl", "BASSMOD_MusicPlay", "int", $Music_Handle)
	Local $RetArr[2] = [$BassModDll, $Music_Handle]
	Return $RetArr
EndFunc

Func BassModClose(ByRef $HandleArr)
	If Not IsArray($HandleArr) Then Return SetError(1)
	DllCall($HandleArr[0], "int:cdecl", "BASSMOD_Free", "int", $HandleArr[1]) ;clear resource
	DllClose($HandleArr[0])
EndFunc

Func IsNotConnect()
	Local $oHTTP = ObjCreate("winhttp.winhttprequest.5.1")
	If IsObj($oHTTP) Then
		$oHTTP.Open("GET", "http://ucoz.ru")
		$oHTTP.Send()
	EndIf
	Return @error
EndFunc

Func InetErrHandler()
	If Not IsObj($InetErrObj) Then Return ""
	Select
		Case $InetErrObj.source = "WinHttp.WinHttpRequest"
			SetError(1)
		Case Else
			Return $InetErrObj.description
	EndSelect
Endfunc

Func Dummy_COM_Err_Func()
EndFunc

Func DummyFunc()
EndFunc

Func Quit()
	$GUI_WRITE_STATE = WinGetState($Gui)
	If _WinIsVisible($Gui) Then
		If BitAND($GUI_WRITE_STATE, 16) Or BitAND($GUI_WRITE_STATE, 32) Then WinSetState($Gui, "", @SW_RESTORE)
		
		$GuiPosArr = WinGetPos($Gui)
		WinSetState($Gui, "", @SW_HIDE)
		
		IniWrite($ConfigFile, "Main Window Prefs", "Window State", $GUI_WRITE_STATE)
		_Write_GUI_Pos($GuiPosArr)
	EndIf
	TraySetState(2)
	
	$OnTopState = 0
	If GUICtrlRead($OnTop_Item) = 65 Then $OnTopState = 1
	
	$MinToTrayState = 0
	If GUICtrlRead($MinimizeToTray_Item) = 65 Then $MinToTrayState = 1
	
	$AutoResizeColumns = 0
	If GUICtrlRead($AutoResizeColumns_Item) = 65 Then $AutoResizeColumns = 1
	
	IniWrite($ConfigFile, "Main Window Prefs", "On Top", $OnTopState)
	IniWrite($ConfigFile, "Main Window Prefs", "Minimize To Tray", $MinToTrayState)
	IniWrite($ConfigFile, "Main Window Prefs", "Auto-Resize Columns", $AutoResizeColumns)
	Exit
EndFunc

