#include-once
#include <GuiConstants.au3>
#include <GuiListView.au3>

Global $Editing_DSI_Gui
Global $Edit_Dsi_DoubleClickEvent = False
Global $Edit_LV

Func Editing_DSI_Dialog($Sess_File, $IconsArr, $hWnd=0)
	Local $Old_Opt_GOEM = Opt("GuiOnEventMode", 0)
	
	WinSetState($hWnd, "", @SW_DISABLE)
	$Editing_DSI_Gui = GuiCreate($AppName & " - Editing Of DSI Files", 600, 500, -1, -1, $WS_SYSMENU, -1, $hWnd)
	
	GUICtrlCreateLabel("Double Click on the item to Change it Values", 20, 5, 500)
	GUICtrlSetState(-1, 128)
	GUICtrlSetFont(-1, 10, 800)
	
	$Edit_LV = GUICtrlCreateListView("Desktop Icons|Coords", 20, 25, 560, 400)
	GUICtrlSetStyle(-1, BitOr($GUI_SS_DEFAULT_LISTVIEW, $LVS_NOCOLUMNHEADER))
	GUICtrlSendMsg(-1, $LVM_SETEXTENDEDLISTVIEWSTYLE, $LVS_EX_BORDERSELECT, $LVS_EX_BORDERSELECT)
	
	For $i = 1 To $IconsArr[0][0]
		GUICtrlCreateListViewItem($IconsArr[$i][0] & " [" & $IconsArr[$i][1] & "]|" & $IconsArr[$i][1], $Edit_LV)
		$IconArr = _GetItemImage($IconsArr[$i][0])
		If IsArray($IconArr) Then
			GUICtrlSetImage(-1, $IconArr[1], $IconArr[2])
		Else
			GUICtrlSetImage(-1, $IconArr, 0)
		EndIf
	Next
	
	$Confirm_Edit_Button = GUICtrlCreateButton("Confirm Edit", 20, 440, 80, 20)
	$Cancel_Edit_Button = GUICtrlCreateButton("Cancel Edit", 120, 440, 80, 20)
	
	$Editing_DSI_Button = GUICtrlCreateButton("Edit Session..", 500, 440, 80, 20)
	
	GUISetState()
	
	While 1
		$Editing_DSI_Msg = GUIGetMsg()
		Select
			Case $Editing_DSI_Msg = -3 Or $Editing_DSI_Msg = $Cancel_Edit_Button
				ExitLoop
			Case $Editing_DSI_Msg = $Confirm_Edit_Button
				Local $Value, $Key
				Local $CountItems = _GUICtrlListViewGetItemCount($Edit_LV)
				
				IniDelete($Sess_File, "Icons")
				For $i = 0 To $CountItems-1
					$Value = _GUICtrlListViewGetItemText($Edit_LV, $i, 1)
					$Key = StringStripWS(StringReplace(_GUICtrlListViewGetItemText($Edit_LV, $i, 0), "[" & $Value & "]", ""), 3)
					IniWrite($Sess_File, "Icons", $Key, $Value)
				Next
				ExitLoop
			Case $Editing_DSI_Msg = $Editing_DSI_Button Or $Edit_Dsi_DoubleClickEvent
				$Edit_Dsi_DoubleClickEvent = False
				Local $SelectedIndex = _GUICtrlListViewGetCurSel($Edit_LV)
				Local $SelText = _GUICtrlListViewGetItemText($Edit_LV, $SelectedIndex, 0)
				If $SelText = "" Then
					_GuiMsgBox(48, 1, $AppName & " - Attention", _
						"Please select Item to Edit.", 300, 100, -1, 5, $Editing_DSI_Gui)
					ContinueLoop
				EndIf
				
				Local $Default = _GUICtrlListViewGetItemText($Edit_LV, $SelectedIndex, 1)
				$SelText = StringStripWS(StringReplace($SelText, "[" & $Default & "]", ""), 3)
				
				Local $Input = _InputBox("New Coords...", "Type New Icon Coords for <" & $SelText & ">:", $Default, _
					400, 120, $Editing_DSI_Gui)
				If @error Then
					WinActivate($hWnd)
					ContinueLoop
				EndIf
				WinActivate($hWnd) ;Sometimes the main Gui is minimized after we Exit from Editing Dialog
				
				_GUICtrlListViewSetItemText($Edit_LV, $SelectedIndex, 0, $SelText & " [" & $Input & "]")
				_GUICtrlListViewSetItemText($Edit_LV, $SelectedIndex, 1, $Input)
		EndSelect
	WEnd
	
	WinSetState($hWnd, "", @SW_ENABLE)
	GUIDelete($Editing_DSI_Gui)
	GUISwitch($hWnd)
	Opt("GuiOnEventMode", $Old_Opt_GOEM)
EndFunc

Func _GetItemImage($PartName)
	Local $Search = FileFindFirstFile(@DesktopDir & "\" & $PartName & "*")
	If $Search = -1 Then Return "No_Image"
	
	Local $NextFile = FileFindNextFile($Search)
	Local $Error = @error
	FileClose($Search)
	If $Error Then Return "No_Image"
	Return _FileGetIcon(@DesktopDir & "\" & $NextFile)
EndFunc

Func _FileGetType($FilePathOrExt)
	Local $Old_Opt_EES = Opt("ExpandEnvStrings", 1)
	Local $RegDefault, $RegType="", $Ext
	If _IsFolder($FilePathOrExt) Then
		$RegDefault = RegRead("HKCR\Folder", "")
		If $RegDefault <> "" Then $RegType = $RegDefault
	Else
		$Ext = StringRegExpReplace($FilePathOrExt, '^.*\.', '.')
		If $Ext = $FilePathOrExt Then
			$ExtSaerch = FileFindFirstFile($FilePathOrExt & ".*")
			$Ext = StringRegExpReplace(FileFindNextFile($ExtSaerch), '^.*\.', '.')
			$FilePathOrExt &= $Ext
		EndIf
		$RegDefault = RegRead("HKCR\" & $Ext, "")
		If $RegDefault <> "" Then $RegType = RegRead("HKCR\" & $RegDefault, "")
		If $RegType = "" Then $RegType = $Ext & "-File"
	EndIf
	Opt("ExpandEnvStrings", $Old_Opt_EES)
	Return $RegType
EndFunc

Func _FileGetIcon($szFile)
	Local $Old_Opt_EES = Opt("ExpandEnvStrings", 1)
	Local $szRegDefault = "", $szDefIcon = "", $szExt, $szIconFile, $nIcon=0
	Local $RetArr[3]
	
	If _IsFolder($szFile) Then
		$szRegDefault = RegRead("HKCR\Folder", "")
		If $szRegDefault <> "" Then $szDefIcon = RegRead("HKCR\Folder\DefaultIcon", "")
	Else
		$szExt = StringRegExpReplace($szFile, '^.*\.', '.')
		
		If $szExt = ".lnk" Then
			Local $LnkInfoArr = FileGetShortcut($szFile)
			If Not @error Then
				Local $RetArr[3] = [2, $LnkInfoArr[4], $LnkInfoArr[5]]
				Return $RetArr
			EndIf
		EndIf
		
		If $szExt = $szFile Then
			$szExt = FileFindFirstFile($szFile & ".*")
			$szExt = StringRegExpReplace(FileFindNextFile($szExt), '^.*\.', '.')
			$szFile &= $szExt
		EndIf
		$szRegDefault = RegRead("HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\" & $szExt, "ProgID")
		If $szRegDefault = "" Then $szRegDefault = RegRead("HKCR\" & $szExt, "")
		If $szRegDefault <> "" Then $szDefIcon = RegRead("HKCR\" & $szRegDefault & "\DefaultIcon", "")
	EndIf
	If $szDefIcon = "" Then
		$szIconFile = "shell32.dll"
	ElseIf $szDefIcon <> "%1" Then
		If StringRegExpReplace($szFile, "^.*\\", "") = "shell32.dll" Then
			$szIconFile = $szFile
			$nIcon = 0
		Else
			$arSplit = StringSplit($szDefIcon, ",")
			If IsArray($arSplit) Then
				$szIconFile = $arSplit[1]
				If $arSplit[0] > 1 Then $nIcon = $arSplit[2]
			Else
				Opt("ExpandEnvStrings", $Old_Opt_EES)
				Return SetError(1, 0, $RetArr)
			EndIf
		EndIf
	ElseIf $szDefIcon = "%1" Then
		$szIconFile = $szFile
		$nIcon = 0
	EndIf
	Opt("ExpandEnvStrings", $Old_Opt_EES)
	Local $RetArr[3] = [2, $szIconFile, $nIcon]
	Return $RetArr
EndFunc

Func _IsFolder($name)
	Return StringInStr(FileGetAttrib($name), "D")
EndFunc

