#include-once
#include <GUIConstants.au3>
#include <GuiListView.au3>
#include <Misc.au3>
#include <Memory.au3>

#Region Globals *************************************************************************
Global Enum $HD_MASK = 1, $HD_CXY, $HD_PSZTEXT, $HD_HBM, $HD_CCHTEXTMAX, $HD_FMT, _
	$HD_LPARAM, $HD_IIMAGE, $HD_IORDER, $HD_TYPE, $HD_PVFILTER
#Endregion Globals **********************************************************************
;

Func SetImagesProc($h_LV, $ImgPath, $IconId=-1, $Image_Width=16, $Image_Height=16)
	Local $h_Images = _GUICtrlListViewCreateImageList($Image_Width, $Image_Height, 0x0021, 0, 4, 2)
	_GUICtrlListViewImageListAdd($h_Images, $ImgPath, $IconId)
	_GuiCtrlListViewSetImageList($h_LV, $h_Images, $LVSIL_SMALL)
EndFunc

Func _GUICtrlListViewSetItemImage($h_listview, $i_index = 0, $i_subindex = 0, $i_IconIdex = 0)
    If Not IsHWnd($h_listview) Then Return SetError(-1, -1, 0)
    
    Local $pItem, $iSize, $rMemMap, $pMemory, $iResult, $struct_LVITEM
    $struct_LVITEM = DllStructCreate("int;int;int;int;int;ptr;int;int;int;int;int;ptr")
    If @error Then
        _GetLastErrorMessage("Struct")
        Return SetError(-1, -1, 0)
    EndIf
    DllStructSetData($struct_LVITEM, $LVI_MASK, $LVIF_IMAGE)
    DllStructSetData($struct_LVITEM, $LVI_IITEM, $i_index)
    DllStructSetData($struct_LVITEM, $LVI_ISUBITEM, $i_subindex)
    DllStructSetData($struct_LVITEM, $LVI_IIMAGE, $i_IconIdex)
    $pItem = DllStructGetPtr($struct_LVITEM)
    $iSize = DllStructGetSize($struct_LVITEM)
    $pMemory = _MemInit ($h_listview, $iSize, $rMemMap)
    _MemWrite ($rMemMap, $pItem)
    $iResult = _SendMessage ($h_listview, $LVM_SETITEM, 0, $pMemory)
    If @error Then
        _GetLastErrorMessage("$LVM_SETITEM")
        Return SetError(-1, -1, 0)
    EndIf
;~     ConsoleWrite($iResult & @LF)
    _MemRead ($rMemMap, $pMemory, $pItem, $iSize)
    _MemFree ($rMemMap)
    ;****************************************************************************************
EndFunc   ;==>_GUICtrlListViewSetItemImage

;===============================================
;    _GetLastErrorMessage($DisplayMsgBox="")
;    Format the last windows error as a string and return it
;    if $DisplayMsgBox <> "" Then it will display a message box w/ the error
;    Return        Window's error as a string
;===============================================
Func _GetLastErrorMessage($DisplayMsgBox="")
    Local $ret,$s
    Local $p    = DllStructCreate("char[4096]")
    Local Const $FORMAT_MESSAGE_FROM_SYSTEM        = 0x00001000

    If @error Then Return ""

    $ret    = DllCall("Kernel32.dll","int","GetLastError")

    $ret    = DllCall("kernel32.dll","int","FormatMessage", _
                        "int",$FORMAT_MESSAGE_FROM_SYSTEM, _
                        "ptr",0, _
                        "int",$ret[0], _
                        "int",0, _
                        "ptr",DllStructGetPtr($p), _
                        "int",4096, _
                        "ptr",0)
    $s    = DllStructGetData($p,1)
    If $DisplayMsgBox <> "" Then MsgBox(0,"_GetLastErrorMessage",$DisplayMsgBox & @CRLF & $s)
    return $s
EndFunc


Func _GUICtrlListViewCreateImageList($iCX = 16, $iCY = 16, $iFlags = 0x0021, $iInitial = 4, $iGrow = 4, $iType = 0)
    Local $h_images, $aResult
    If @error Then Return SetError(-1, -1, 0)
    $h_images = DllCall("ComCtl32.dll", "hwnd", "ImageList_Create", "int", $iCX, "int", $iCY, _
            "int", $iFlags, "int", $iInitial, "int", $iGrow)
    If @error Then Return SetError(-1, -1, 0)
    $h_images = $h_images[0]
    Return $h_images
EndFunc   ;==>_GUICtrlListViewCreateImageList

Func _GUICtrlListViewDestroyImageList($h_images)
    Local $result = DllCall("ComCtl32.dll", "int", "ImageList_Destroy", "hwnd", $h_images)
    If @error Then Return SetError(-1, -1, 0)
    Return $result[0]
EndFunc   ;==>_GUICtrlListViewDestroyImageList

Func _GuiCtrlListViewSetImageList($h_LV, $h_images, $iType = 0)
    Local $iResult = _SendMessage ($h_LV, $LVM_SETIMAGELIST, $iType, $h_images)
    If @error Then 
        _GetLastErrorMessage("_GuiCtrlListViewSetImageList")
        Return SetError(-1, -1, 0)
    EndIf
;~     ConsoleWrite($iResult & @LF)
    Return $iResult
EndFunc   ;==>_GuiCtrlListViewSetImageList

Func _GUICtrlListViewImageListAdd($hImageList, $szFile, $nIconID = -1, $i_Width = -1, $i_Height = -1, $Mask = 0)
    Local $result
    Local $ext = StringLower(StringRight($szFile, 3))
    If $ext = "ico" Or $ext = "cur" Or $ext = "exe" Then
        If $nIconID = -1 Then $nIconID = 0
        Local $hIcon = DllStructCreate("int")
         $result = DllCall("shell32.dll", "int", "ExtractIconEx", "str",  $szFile, _
			"int", $nIconID, "hwnd", 0, "ptr", DllStructGetPtr($hIcon),  "int", 1)
        If @error Then Return SetError(-1, -1, 0)
        $result = $result[0]
        If $result > 0 Then
            Local $icon_handle = DllStructGetData($hIcon, 1)
            $result = DllCall("ComCtl32.dll", "int", "ImageList_ReplaceIcon", "hwnd", $hImageList, "int", -1, _
                    "hwnd", $icon_handle)
            If @error Then Return SetError(-1, -1, 0)
            DllCall("user32.dll", "int", "DestroyIcon", "hwnd", $icon_handle)
            If @error Then Return SetError(-1, -1, 0)
            Return $result[0]
        EndIf
    ElseIf $ext = "bmp" Then
        Local $fuLoad = $LR_LOADFROMFILE
        If $i_Width = -1 Then $i_Width = 20
        If $i_Height = -1 Then $i_Height = 20
        Local $h_Bitmap = DllCall('user32.dll', 'hwnd', 'LoadImage', 'hwnd', 0, 'str', $szFile, _
                'int', 0, 'int', $i_Width, 'int', $i_Height, 'int', $fuLoad)
        If @error Then Return SetError(-1, -1, 0)
        $result = DllCall("ComCtl32.dll", "int", "ImageList_Add", "hwnd", $hImageList, "hwnd", $h_Bitmap[0], "hwnd", $Mask)
        If @error Then Return SetError(-1, -1, 0)
        DllCall('gdi32.dll', 'int', 'DeleteObject', 'hwnd', $h_Bitmap[0])
        Return $result[0]
    EndIf
EndFunc   ;==>_GUICtrlListViewImageListAdd

Func _GUICtrlListViewImageListRemove($hImageList, $iIndex = -1) ; -1 removes all images
    Local $result = DllCall("ComCtl32.dll", "int", "ImageList_Remove", "hwnd", $hImageList, "int", $iIndex)
    If @error Then Return SetError(-1, -1, 0)
    Return $result[0]
EndFunc   ;==>_GUICtrlListViewImageListRemove

Func _GUICtrlListViewReleaseBitMap(ByRef $hLVBitmap)
    DllCall('gdi32.dll', 'int', 'DeleteObject', 'hwnd', $hLVBitmap)
    If @error Then Return SetError(-1, -1, 0)
EndFunc   ;==>_GUICtrlListViewReleaseBitMap

Func _GUICtrlListViewSetHeaderItemImage($h_listview, $i_Column = -1, $i_IconIdex = -1, $i_side = -1)
    If Not IsHWnd($h_listview) Then Return SetError(-1, -1, 0)
    If $i_IconIdex = -1 Then Return SetError(-1, -1, 0)
    
    Local $pItem, $iSize, $rMemMap, $pMemory, $iResult
    Local $Mask, $Fmt, $h_LVHeader, $struct_HDITEM
    $struct_HDITEM = DllStructCreate('uint;int;ptr;uint;int;int;uint;int;int')
    If @error Then Return SetError(-1, -1, 0)
    
    If $i_Column = -1 Then $i_Column = 0
    If $i_side = -1 Then $i_side = 0
    $Mask = BitOR($HDI_FORMAT, $HDI_IMAGE)
    $Fmt = BitOR($HDF_IMAGE, $HDF_STRING)
    If $i_side = 1 Then $Fmt = BitOR($Fmt, $HDF_BITMAP_ON_RIGHT)
    DllStructSetData($struct_HDITEM, $HD_IIMAGE, $i_IconIdex)
    $h_LVHeader = _SendMessage ($h_listview, $LVM_GETHEADER, 0, 0)
    If @error Then Return SetError(-1, -1, 0)
    ;****************************************************************************************
    ; this works with autoit created listview
    ;****************************************************************************************
    $pItem = DllStructGetPtr($struct_HDITEM)
    $iSize = DllStructGetSize($struct_HDITEM)
    DllStructSetData($struct_HDITEM, $HD_MASK, $Mask)
    DllStructSetData($struct_HDITEM, $HD_FMT, $Fmt)
    $pMemory = _MemInit ($h_LVHeader, $iSize, $rMemMap)
    _MemWrite ($rMemMap, $pItem)
    $iResult = _SendMessage ($h_LVHeader, $HDM_SETITEM, $i_Column, $pMemory)
    If @error Then Return SetError(-1, -1, 0)
    _MemFree ($rMemMap)
    ;****************************************************************************************
EndFunc   ;==>_GUICtrlListViewSetHeaderItemImage

Func  _GUICtrlListViewSetHeaderItemBitMap($h_listview, $i_Column = -1,  $v_File = "", $v_Type = 0, $i_side = -1, $i_Width = -1, $i_Height = -1)
    If Not IsHWnd($h_listview) Then Return SetError(-1, -1, 0)
    If $v_File = "" Then Return SetError(-1, -1, 0)
    Local $fuLoad, $pItem, $iSize, $rMemMap, $pMemory, $iResult
    Local $Mask, $Fmt, $h_LVHeader, $h_Bitmap, $struct_HDITEM
    $struct_HDITEM = DllStructCreate('uint;int;ptr;uint;int;int;uint;int;int')
    If @error Then Return SetError(-1, -1, 0)
    
    If $i_Column = -1 Then $i_Column = 0
    If $i_side = -1 Then $i_side = 0
    $h_LVHeader = _SendMessage ($h_listview, $LVM_GETHEADER, 0, 0)
    If @error Then Return SetError(-1, -1, 0)
    $Mask = BitOR($HDI_FORMAT, $HDI_BITMAP)
    $Fmt = BitOR($HDF_BITMAP, $HDF_STRING)
    If $i_side = 1 Then $Fmt = BitOR($Fmt, $HDF_BITMAP_ON_RIGHT)
    $fuLoad = $LR_LOADFROMFILE
    If $i_Width = -1 And $i_Height = -1 Then
        $fuLoad = BitOR($fuLoad, $LR_DEFAULTSIZE)
    Else
        If $i_Width = -1 Then $i_Width = 10
        If $i_Height = -1 Then $i_Height = 10
    EndIf
    If StringLen($v_File) Then
        $h_Bitmap = DllCall('user32.dll', 'hwnd', 'LoadImage', 'hwnd', 0, 'str', $v_File, _
                'int', $v_Type, 'int', $i_Width, 'int', $i_Height, 'int', $fuLoad)
        If @error Then Return SetError(-1, -1, 0)
    EndIf
    ;****************************************************************************************
    ; this works with autoit created listview
    ;****************************************************************************************
    $pItem = DllStructGetPtr($struct_HDITEM)
    $iSize = DllStructGetSize($struct_HDITEM)
    DllStructSetData($struct_HDITEM, $HD_MASK, $Mask)
    DllStructSetData($struct_HDITEM, $HD_HBM, $h_Bitmap[0])
    DllStructSetData($struct_HDITEM, $HD_FMT, $Fmt)
    $pMemory = _MemInit ($h_LVHeader, $iSize, $rMemMap)
    _MemWrite ($rMemMap, $pItem)
    $iResult = _SendMessage ($h_LVHeader, $HDM_SETITEM, $i_Column, $pMemory)
    If @error Then Return SetError(-1, -1, 0)
    _MemFree ($rMemMap)
    If StringLen($v_File) Then Return $h_Bitmap[0]
    ;****************************************************************************************
EndFunc   ;==>_GUICtrlListViewSetHeaderItemBitMap

Func _GUICtrlListViewSetHeaderItemText($h_listview, $s_Text = "", $i_Column = -1)
    If Not IsHWnd($h_listview) Then Return SetError(-1, -1, 0)
    
    Local $pBuffer, $pItem, $iSize, $rMemMap, $pMemory, $pTextPtr, $iResult
    Local $Mask, $Fmt, $h_LVHeader, $struct_text, $struct_HDITEM
    $struct_text = DllStructCreate("char[4096]")
    If @error Then Return SetError(-1, -1, 0)
    $struct_HDITEM = DllStructCreate('uint;int;ptr;uint;int;int;uint;int;int')
    If @error Then Return SetError(-1, -1, 0)
    
    If $i_Column = -1 Then $i_Column = 0
    $h_LVHeader = _SendMessage ($h_listview, $LVM_GETHEADER, 0, 0)
    If @error Then Return SetError(-1, -1, 0)
    ;****************************************************************************************
    ; this works with autoit created listview
    ;****************************************************************************************
    $pBuffer = DllStructGetPtr($struct_text)
    $pItem = DllStructGetPtr($struct_HDITEM)
    $iSize = DllStructGetSize($struct_HDITEM)
    $pMemory = _MemInit ($h_LVHeader, $iSize + 4096, $rMemMap)
    $pTextPtr = $pMemory + 4096
    DllStructSetData($struct_text, 1, $s_Text)
    DllStructSetData($struct_HDITEM, $HD_MASK, $HDI_TEXT)
    DllStructSetData($struct_HDITEM, $HD_PSZTEXT, $pTextPtr)
    DllStructSetData($struct_HDITEM, $HD_FMT, $HDF_STRING)
    DllStructSetData($struct_HDITEM, $HD_CCHTEXTMAX, StringLen($s_Text) + 1)

    _MemWrite ($rMemMap, $pItem)
    _MemWrite ($rMemMap, $pBuffer, $pTextPtr, 4096)
    $iResult = _SendMessage ($h_LVHeader, $HDM_SETITEM, $i_Column, $pMemory)
    If @error Then Return SetError(-1, -1, 0)
    _MemFree ($rMemMap)
    ;****************************************************************************************
EndFunc   ;==>_GUICtrlListViewSetHeaderItemText

Func _GuiCtrlListViewHeaderSetImageList($h_LV, $h_images, $iType = 0)
    If Not IsHWnd($h_LV) Then Return SetError(-1, -1, 0)
    Local $h_LVHeader = _SendMessage ($h_LV, $LVM_GETHEADER, 0, 0)
    If @error Then Return SetError(-1, -1, 0)
    Local $iResult = _SendMessage ($h_LVHeader, $HDM_SETIMAGELIST, $iType, $h_images)
    If @error Then Return SetError(-1, -1, 0)
    Return $iResult
EndFunc   ;==>_GuiCtrlListViewHeaderSetImageList
