#include-once
#include <A3LHeader.au3>
#include <A3LMemory.au3>
#include <ListViewConstants.au3>

Opt("MustDeclareVars", 1)

; #INDEX# =======================================================================================================================
; Title .........: ListView
; Description ...: A ListView control is a window that displays a collection of items; each item consists of an icon and a label.
;                  ListView controls provide several ways to arrange and display items. For example, additional information about
;                  each item can be displayed in columns to the right of the icon and label.
; Author ........: Paul Campbell (PaulIA)
; ===============================================================================================================================

; #CONSTANTS# ===================================================================================================================
; Global Const $LV_VIEW_ICON            = 0x00000000
; Global Const $LV_VIEW_DETAILS         = 0x00000001
; Global Const $LV_VIEW_SMALLICON       = 0x00000002
; Global Const $LV_VIEW_LIST            = 0x00000003
; Global Const $LV_VIEW_TILE            = 0x00000004

; Global Const $LVA_DEFAULT             = 0x000000000
; Global Const $LVA_ALIGNLEFT           = 0x000000001
; Global Const $LVA_ALIGNTOP            = 0x000000002
; Global Const $LVA_SNAPTOGRID          = 0x000000005

  Global Const $LVBKIF_SOURCE_NONE      = 0x00000000
  Global Const $LVBKIF_SOURCE_HBITMAP   = 0x00000001
  Global Const $LVBKIF_SOURCE_URL       = 0x00000002
  Global Const $LVBKIF_SOURCE_MASK      = 0x00000003
  Global Const $LVBKIF_STYLE_NORMAL     = 0x00000000
  Global Const $LVBKIF_STYLE_TILE       = 0x00000010
  Global Const $LVBKIF_STYLE_MASK       = 0x00000010
  Global Const $LVBKIF_FLAG_TILEOFFSET  = 0x00000100
  Global Const $LVBKIF_TYPE_WATERMARK   = 0x10000000

; Global Const $LVCF_FMT                = 0x00000001
; Global Const $LVCF_WIDTH              = 0x00000002
; Global Const $LVCF_TEXT               = 0x00000004
  Global Const $LVCF_SUBITEM            = 0x00000008
  Global Const $LVCF_IMAGE              = 0x00000010
  Global Const $LVCF_ORDER              = 0x00000020
  Global Const $LVCF_ALLDATA            = 0X0000003F

; Global Const $LVCFMT_LEFT             = 0x00000000
; Global Const $LVCFMT_RIGHT            = 0x00000001
; Global Const $LVCFMT_CENTER           = 0x00000002
  Global Const $LVCFMT_JUSTIFYMASK      = 0x00000003
  Global Const $LVCFMT_IMAGE            = 0x00000800
  Global Const $LVCFMT_BITMAP_ON_RIGHT  = 0x00001000
  Global Const $LVCFMT_COL_HAS_IMAGES   = 0x00008000

; Global Const $LVFI_PARAM              = 0x00000001
; Global Const $LVFI_STRING             = 0x00000002
; Global Const $LVFI_PARTIAL            = 0x00000008
; Global Const $LVFI_WRAP               = 0x00000020
  Global Const $LVFI_NEARESTXY          = 0x00000040

  Global Const $LVGA_HEADER_LEFT        = 0x00000001
  Global Const $LVGA_HEADER_CENTER      = 0x00000002
  Global Const $LVGA_HEADER_RIGHT       = 0x00000004

  Global Const $LVGF_NONE               = 0x00000000
  Global Const $LVGF_HEADER             = 0x00000001
  Global Const $LVGF_FOOTER             = 0x00000002
  Global Const $LVGF_STATE              = 0x00000004
  Global Const $LVGF_ALIGN              = 0x00000008
  Global Const $LVGF_GROUPID            = 0x00000010

  Global Const $LVGMF_NONE              = 0x00000000
  Global Const $LVGMF_BORDERSIZE        = 0x00000001
  Global Const $LVGMF_BORDERCOLOR       = 0x00000002
  Global Const $LVGMF_TEXTCOLOR         = 0x00000004

  Global Const $LVHT_NOWHERE            = 0x00000001
  Global Const $LVHT_ONITEMICON         = 0x00000002
  Global Const $LVHT_ONITEMLABEL        = 0x00000004
  Global Const $LVHT_ONITEMSTATEICON    = 0x00000008
  Global Const $LVHT_ONITEM             = 0x0000000E
  Global Const $LVHT_ABOVE              = 0x00000008
  Global Const $LVHT_BELOW              = 0x00000010
  Global Const $LVHT_TORIGHT            = 0x00000020
  Global Const $LVHT_TOLEFT             = 0x00000040

; Global Const $LVIF_TEXT               = 0x00000001
  Global Const $LVIF_IMAGE              = 0x00000002
  Global Const $LVIF_PARAM              = 0x00000004
; Global Const $LVIF_STATE              = 0x00000008
  Global Const $LVIF_INDENT             = 0x00000010
  Global Const $LVIF_GROUPID            = 0x00000100
  Global Const $LVIF_COLUMNS            = 0x00000200
  Global Const $LVIF_NORECOMPUTE        = 0x00000800

  Global Const $LVIM_AFTER              = 0x00000001

; Global Const $LVIR_BOUNDS             = 0x00000000
  Global Const $LVIR_ICON               = 0x00000001
  Global Const $LVIR_LABEL              = 0x00000002
  Global Const $LVIR_SELECTBOUNDS       = 0x00000003

; Global Const $LVIS_FOCUSED            = 0x00000001
; Global Const $LVIS_SELECTED           = 0x00000002
; Global Const $LVIS_CUT                = 0x00000004
; Global Const $LVIS_DROPHILITED        = 0x00000008
; Global Const $LVIS_OVERLAYMASK        = 0x00000F00
; Global Const $LVIS_STATEIMAGEMASK     = 0x0000F000

; Global Const $LVNI_ALL                = 0x00000000
; Global Const $LVNI_FOCUSED            = 0x00000001
; Global Const $LVNI_SELECTED           = 0x00000002
; Global Const $LVNI_CUT                = 0x00000004
; Global Const $LVNI_DROPHILITED        = 0x00000008
; Global Const $LVNI_ABOVE              = 0x00000100
; Global Const $LVNI_BELOW              = 0x00000200
; Global Const $LVNI_TOLEFT             = 0x00000400
; Global Const $LVNI_TORIGHT            = 0x00000800

; Global Const $LVSIL_NORMAL            = 0
; Global Const $LVSIL_SMALL             = 1
; Global Const $LVSIL_STATE             = 2

; Global Const $VK_PRIOR                = 0x21
; Global Const $VK_NEXT                 = 0x22
; Global Const $VK_END                  = 0x23
  Global Const $VK_HOME                 = 0x24
; Global Const $VK_LEFT                 = 0x25
; Global Const $VK_UP                   = 0x26
; Global Const $VK_RIGHT                = 0x27
; Global Const $VK_DOWN                 = 0x28
; ===============================================================================================================================

; #MESSAGES# ====================================================================================================================
; Global Const $LVM_SETBKCOLOR                  = 0x1001
; Global Const $LVM_GETBKCOLOR                  = 0x1000
; Global Const $LVM_GETIMAGELIST                = 0x1002
  Global Const $LVM_SETIMAGELIST                = 0x1003
; Global Const $LVM_GETITEMCOUNT                = 0x1004
  Global Const $LVM_GETITEM                     = 0x1005
  Global Const $LVM_SETITEM                     = 0x1006
  Global Const $LVM_INSERTITEM                  = 0x1007
; Global Const $LVM_DELETEITEM                  = 0x1008
; Global Const $LVM_DELETEALLITEMS              = 0x1009
; Global Const $LVM_GETCALLBACKMASK             = 0x100A
; Global Const $LVM_SETCALLBACKMASK             = 0x100B
; Global Const $LVM_GETNEXTITEM                 = 0x100C
; Global Const $LVM_FINDITEM                    = 0x100D
  Global Const $LVM_GETITEMRECT                 = 0x100E
; Global Const $LVM_SETITEMPOSITION             = 0x100F
  Global Const $LVM_GETITEMPOSITION             = 0x1010
  Global Const $LVM_GETSTRINGWIDTH              = 0x1011
  Global Const $LVM_HITTEST                     = 0x1012
; Global Const $LVM_ENSUREVISIBLE               = 0x1013
; Global Const $LVM_SCROLL                      = 0x1014
; Global Const $LVM_REDRAWITEMS                 = 0x1015
; Global Const $LVM_ARRANGE                     = 0x1016
; Global Const $LVM_EDITLABEL                   = 0x1017
; Global Const $LVM_GETEDITCONTROL              = 0x1018
  Global Const $LVM_GETCOLUMN                   = 0x1019
  Global Const $LVM_SETCOLUMN                   = 0x101A
  Global Const $LVM_INSERTCOLUMN                = 0x101B
; Global Const $LVM_DELETECOLUMN                = 0x101C
; Global Const $LVM_GETCOLUMNWIDTH              = 0x101D
; Global Const $LVM_SETCOLUMNWIDTH              = 0x101E
; Global Const $LVM_GETHEADER                   = 0x101F
  Global Const $LVM_CREATEDRAGIMAGE             = 0x1021
; Global Const $LVM_GETVIEWRECT                 = 0x1022
  Global Const $LVM_GETTEXTCOLOR                = 0x1023
; Global Const $LVM_SETTEXTCOLOR                = 0x1024
  Global Const $LVM_GETTEXTBKCOLOR              = 0x1025
; Global Const $LVM_SETTEXTBKCOLOR              = 0x1026
; Global Const $LVM_GETTOPINDEX                 = 0x1027
; Global Const $LVM_GETCOUNTPERPAGE             = 0x1028
  Global Const $LVM_GETORIGIN                   = 0x1029
; Global Const $LVM_UPDATE                      = 0x102A
; Global Const $LVM_SETITEMSTATE                = 0x102B
; Global Const $LVM_GETITEMSTATE                = 0x102C
  Global Const $LVM_GETITEMTEXT                 = 0x102D
  Global Const $LVM_SETITEMTEXT                 = 0x102E
; Global Const $LVM_SETITEMCOUNT                = 0x102F
  Global Const $LVM_SORTITEMS                   = 0x1030
  Global Const $LVM_SETITEMPOSITION32           = 0x1031
; Global Const $LVM_GETSELECTEDCOUNT            = 0x1032
  Global Const $LVM_GETITEMSPACING              = 0x1033
  Global Const $LVM_GETISEARCHSTRING            = 0x1034
; Global Const $LVM_SETICONSPACING              = 0x1035
; Global Const $LVM_SETEXTENDEDLISTVIEWSTYLE    = 0x1036
; Global Const $LVM_GETEXTENDEDLISTVIEWSTYLE    = 0x1037
; Global Const $LVM_GETSUBITEMRECT              = 0x1038
  Global Const $LVM_SUBITEMHITTEST              = 0x1039
; Global Const $LVM_SETCOLUMNORDERARRAY         = 0x103A
; Global Const $LVM_GETCOLUMNORDERARRAY         = 0x103B
; Global Const $LVM_SETHOTITEM                  = 0x103C
; Global Const $LVM_GETHOTITEM                  = 0x103D
  Global Const $LVM_SETHOTCURSOR                = 0x103E
; Global Const $LVM_GETHOTCURSOR                = 0x103F
  Global Const $LVM_APPROXIMATEVIEWRECT         = 0x1040
  Global Const $LVM_SETWORKAREAS                = 0x1041
  Global Const $LVM_GETSELECTIONMARK            = 0x1042
  Global Const $LVM_SETSELECTIONMARK            = 0x1043
  Global Const $LVM_SETBKIMAGE                  = 0x1044
  Global Const $LVM_GETBKIMAGE                  = 0x1045
  Global Const $LVM_GETWORKAREAS                = 0x1046
; Global Const $LVM_SETHOVERTIME                = 0x1047
; Global Const $LVM_GETHOVERTIME                = 0x1048
  Global Const $LVM_GETNUMBEROFWORKAREAS        = 0x1049
  Global Const $LVM_SETTOOLTIPS                 = 0x104A
  Global Const $LVM_GETITEMW                    = 0x104B
  Global Const $LVM_SETITEMW                    = 0x104C
  Global Const $LVM_INSERTITEMW                 = 0x104D
  Global Const $LVM_GETTOOLTIPS                 = 0x104E
  Global Const $LVM_SORTITEMSEX                 = 0x1051
  Global Const $LVM_FINDITEMW                   = 0x1053
  Global Const $LVM_GETSTRINGWIDTHW             = 0x1057
  Global Const $LVM_GETCOLUMNW                  = 0x105F
  Global Const $LVM_SETCOLUMNW                  = 0x1060
  Global Const $LVM_INSERTCOLUMNW               = 0x1061
  Global Const $LVM_GETITEMTEXTW                = 0x1073
  Global Const $LVM_SETITEMTEXTW                = 0x1074
  Global Const $LVM_GETISEARCHSTRINGW           = 0x1075
  Global Const $LVM_EDITLABELW                  = 0x1076
  Global Const $LVM_SETBKIMAGEW                 = 0x108A
  Global Const $LVM_GETBKIMAGEW                 = 0x108B
; Global Const $LVM_SETSELECTEDCOLUMN           = 0x108C
  Global Const $LVM_SETTILEWIDTH                = 0x108D
; Global Const $LVM_SETVIEW                     = 0x108E
; Global Const $LVM_GETVIEW                     = 0x108F
  Global Const $LVM_INSERTGROUP                 = 0x1091
  Global Const $LVM_SETGROUPINFO                = 0x1093
  Global Const $LVM_GETGROUPINFO                = 0x1095
  Global Const $LVM_REMOVEGROUP                 = 0x1096
  Global Const $LVM_MOVEGROUP                   = 0x1097
  Global Const $LVM_MOVEITEMTOGROUP             = 0x109A
  Global Const $LVM_SETGROUPMETRICS             = 0x109B
  Global Const $LVM_GETGROUPMETRICS             = 0x109C
; Global Const $LVM_ENABLEGROUPVIEW             = 0x109D
  Global Const $LVM_SORTGROUPS                  = 0x109E
  Global Const $LVM_INSERTGROUPSORTED           = 0x109F
  Global Const $LVM_REMOVEALLGROUPS             = 0x10A0
  Global Const $LVM_HASGROUP                    = 0x10A1
  Global Const $LVM_SETTILEVIEWINFO             = 0x10A2
  Global Const $LVM_GETTILEVIEWINFO             = 0x10A3
  Global Const $LVM_SETTILEINFO                 = 0x10A4
  Global Const $LVM_GETTILEINFO                 = 0x10A5
  Global Const $LVM_SETINSERTMARK               = 0x10A6
  Global Const $LVM_GETINSERTMARK               = 0x10A7
  Global Const $LVM_INSERTMARKHITTEST           = 0x10A8
  Global Const $LVM_GETINSERTMARKRECT           = 0x10A9
  Global Const $LVM_SETINSERTMARKCOLOR          = 0x10AA
  Global Const $LVM_GETINSERTMARKCOLOR          = 0x10AB
  Global Const $LVM_SETINFOTIP                  = 0x10AD
; Global Const $LVM_GETSELECTEDCOLUMN           = 0x10AE
  Global Const $LVM_ISGROUPVIEWENABLED          = 0x10AF
  Global Const $LVM_GETOUTLINECOLOR             = 0x10B0
  Global Const $LVM_SETOUTLINECOLOR             = 0x10B1
; Global Const $LVM_CANCELEDITLABEL             = 0x10B3
  Global Const $LVM_MAPINDEXTOID                = 0x10B4
  Global Const $LVM_MAPIDTOINDEX                = 0x10B5
; Global Const $LVM_GETUNICODEFORMAT            = $CCM_GETUNICODEFORMAT
; Global Const $LVM_SETUNICODEFORMAT            = $CCM_SETUNICODEFORMAT
; ===============================================================================================================================

; #NOTIFICATIONS# ===============================================================================================================
  Global Const $LVN_ITEMCHANGING        = 0xFFFFFF9C    ; An item is changing
  Global Const $LVN_ITEMCHANGED         = 0xFFFFFF9B    ; An item has changed
  Global Const $LVN_INSERTITEM          = 0xFFFFFF9A    ; A new item was inserted
  Global Const $LVN_DELETEITEM          = 0xFFFFFF99    ; An item is about to be deleted
  Global Const $LVN_DELETEALLITEMS      = 0xFFFFFF98    ; All items are about to be deleted
  Global Const $LVN_BEGINLABELEDIT      = 0xFFFFFF97    ; The label editting is starting
  Global Const $LVN_ENDLABELEDIT        = 0xFFFFFF96    ; The label editting is ending
  Global Const $LVN_COLUMNCLICK         = 0xFFFFFF94    ; A column was clicked
  Global Const $LVN_BEGINDRAG           = 0xFFFFFF93    ; A drag and drop involving the left mouse button is being initiated
  Global Const $LVN_BEGINRDRAG          = 0xFFFFFF91    ; A drag and drop involving the right mouse button is being initiated
  Global Const $LVN_ODCACHEHINT         = 0xFFFFFF8F    ; The contents of its display area for a virtual control have changed
  Global Const $LVN_ITEMACTIVATE        = 0xFFFFFF8E    ; The user activated an item
  Global Const $LVN_ODSTATECHANGED      = 0xFFFFFF8D    ; The state of an item or range of items in a virtual control has changed
  Global Const $LVN_HOTTRACK            = 0xFFFFFF87    ; The user moved the mouse over an item
  Global Const $LVN_GETDISPINFO         = 0xFFFFFF6A    ; Request for the parent to provide information
  Global Const $LVN_SETDISPINFO         = 0xFFFFFF69    ; Sent to the parent when it needs to update item information
  Global Const $LVN_ODFINDITEM          = 0xFFFFFF68    ; Sent to the parent when it needs to find a callback item
  Global Const $LVN_BEGINLABELEDITW     = 0xFFFFFF51    ; [Unicode] The label editting is starting
  Global Const $LVN_ENDLABELEDITW       = 0xFFFFFF50    ; [Unicode] The label editting is ending
  Global Const $LVN_GETDISPINFOW        = 0xFFFFFF4F    ; [Unicode] Request for the parent to provide information
  Global Const $LVN_SETDISPINFOW        = 0xFFFFFF4E    ; [Unicode] Sent to the parent when it needs to update item information
  Global Const $LVN_ODFINDITEMW         = 0xFFFFFF4D    ; [Unicode] Sent to the parent when it needs to find a callback item
; ===============================================================================================================================

; #STYLES# ======================================================================================================================
  Global Const $LVS_ALIGNTOP            = 0x00000000    ; Items are aligned at the top in icon and small icon view
; Global Const $LVS_ICON                = 0x00000000    ; This style specifies icon view
; Global Const $LVS_REPORT              = 0x00000001    ; This style specifies report view
; Global Const $LVS_SMALLICON           = 0x00000002    ; This style specifies small icon view
; Global Const $LVS_LIST                = 0x00000003    ; This style specifies list view
  Global Const $LVS_TYPEMASK            = 0x00000003    ; Determines the control's current window style
; Global Const $LVS_SINGLESEL           = 0x00000004    ; Only one item at a time can be selected
; Global Const $LVS_SHOWSELALWAYS       = 0x00000008    ; The selection is always shown
; Global Const $LVS_SORTASCENDING       = 0x00000010    ; Item indexes are sorted based on item text in ascending order
; Global Const $LVS_SORTDESCENDING      = 0x00000020    ; Item indexes are sorted based on item text in descending order
  Global Const $LVS_SHAREIMAGELISTS     = 0x00000040    ; The image list will not be deleted when the control is destroyed
; Global Const $LVS_NOLABELWRAP         = 0x00000080    ; Item text is displayed on a single line in icon view
  Global Const $LVS_AUTOARRANGE         = 0x00000100    ; Icons are automatically kept arranged in icon and small icon view
; Global Const $LVS_EDITLABELS          = 0x00000200    ; Item text can be edited in place
  Global Const $LVS_OWNERDRAWFIXED      = 0x00000400    ; The owner window can paint items in report view
  Global Const $LVS_ALIGNLEFT           = 0x00000800    ; Items are left aligned in icon and small icon view
  Global Const $LVS_ALIGNMASK           = 0x00000C00    ; Determines the control's current alignment
  Global Const $LVS_NOSCROLL            = 0x00002000    ; Scrolling is disabled
; Global Const $LVS_NOCOLUMNHEADER      = 0x00004000    ; Column headers are not displayed in report view
; Global Const $LVS_NOSORTHEADER        = 0x00008000    ; Column headers do not work like buttons
  Global Const $LVS_TYPESTYLEMASK       = 0x0000FC00    ; Determines the window styles
  Global Const $LVS_DEFAULT             = 0x0000000D    ; Default control style
; ===============================================================================================================================

; #EXSTYLES# ====================================================================================================================
; Global Const $LVS_EX_GRIDLINES        = 0x00000001    ; Displays gridlines around items and subitems
; Global Const $LVS_EX_SUBITEMIMAGES    = 0x00000002    ; Allows images to be displayed for subitems
; Global Const $LVS_EX_CHECKBOXES       = 0x00000004    ; Enables check boxes for items
; Global Const $LVS_EX_TRACKSELECT      = 0x00000008    ; Enables hot-track selection
; Global Const $LVS_EX_HEADERDRAGDROP   = 0x00000010    ; Enables drag-and-drop reordering of columns
; Global Const $LVS_EX_FULLROWSELECT    = 0x00000020    ; When an item is selected, the item and all its subitems are highlighted
; Global Const $LVS_EX_ONECLICKACTIVATE = 0x00000040    ; Sends an $LVN_ITEMACTIVATE message when the user clicks an item
; Global Const $LVS_EX_TWOCLICKACTIVATE = 0x00000080    ; Sends an $LVN_ITEMACTIVATE message when the user double clicks an item
; Global Const $LVS_EX_FLATSB           = 0x00000100    ; Enables flat scroll bars
; Global Const $LVS_EX_REGIONAL         = 0x00000200    ; Sets the region to include only the icons and text using SetWindowRgn
; Global Const $LVS_EX_INFOTIP          = 0x00000400    ; A message is sent to the parent before displaying an item's ToolTip
; Global Const $LVS_EX_UNDERLINEHOT     = 0x00000800    ; Causes hot items to be displayed with underlined text
; Global Const $LVS_EX_UNDERLINECOLD    = 0x00001000    ; Causes non-hot items to be displayed with underlined text
  Global Const $LVS_EX_MULTIWORKAREAS   = 0x00002000    ; The control will not autoarrange its icons until a work area is defined
; Global Const $LVS_EX_LABELTIP         = 0x00004000    ; If a partially hidden label lacks ToolTip text, the label will unfold
; Global Const $LVS_EX_BORDERSELECT     = 0x00008000    ; The border color of the item changes when selected
  Global Const $LVS_EX_DOUBLEBUFFER     = 0x00010000    ; Paints via double-buffering, which reduces flicker
  Global Const $LVS_EX_SNAPTOGRID       = 0x00080000    ; Icons automatically snap to grid
  Global Const $LVS_EX_SIMPLESELECT     = 0x00100000    ; Moves the state image to the top right of the large icon rendering
; ===============================================================================================================================

; #STRUCTURE# ===================================================================================================================
; Description ...: tagLVBKIMAGE structure
; Fields ........: Flags      - This member may be one or more of the following flags.  You can use the LVBKIF_SOURCE_MASK value
;                  +to mask off all but the source flags.  You can use the LVBKIF_STYLE_MASK value to mask off all but the  style
;                  +flags.
;                  |$LVBKIF_SOURCE_NONE     - The control has no background image
;                  |$LVBKIF_SOURCE_URL      - The Image member contains the URL of the background image
;                  |$LVBKIF_STYLE_NORMAL    - The background image is displayed normally
;                  |$LVBKIF_STYLE_TILE      - The background image will be tiled to fill the entire background of the control
;                  |$LVBKIF_FLAG_TILEOFFSET - You use this flag to specify the coordinates of the first tile.  This flag is valid
;                  +only if the $LVBKIF_STYLE_TILE flag is also specified. If this flag is not specified the first tile begins at
;                  +the upper-left corner of the client area.
;                  hBmp        - Not used
;                  Image       - Address of a string that contains the URL of the background image. This member is only valid if
;                  +the $LVBKIF_SOURCE_URL flag is set in Flags.  This member must be initialized to point  to  the  buffer  that
;                  +contains or receives the text before sending the message.
;                  ImageMax    - Size of the buffer at the address in Image.  If information is being sent to the  control,  this
;                  +member is ignored.
;                  XOffPercent - Percentage of the client area that the image should be offset horizontally.  For example, at  0
;                  +percent, the image will be displayed against the left edge of the control's client area.  At 50 percent,  the
;                  +image will be displayed horizontally centered in the control's client area. At 100 percent, the image will be
;                  +displayed against the right edge  of  the  control's  client  area.  This  member  is  only  valid  when  the
;                  +$LVBKIF_STYLE_NORMAL is specified in  Flags.  If  both  $LVBKIF_FLAG_TILEOFFSET  and  $LVBKIF_STYLE_TILE  are
;                  +specified in Flags, then the value specifies the pixel, not percentage offset, of the first tile.  Otherwise,
;                  +the value is ignored.
;                  YOffPercent - Percentage of the control's client area that the image should be offset vertically. For example
;                  +at 0 percent, the image will be displayed against the top edge of the control's client area.  At 50  percent,
;                  +the image will be displayed vertically centered in the control's client area.  At 100 percent, the image will
;                  +be displayed against the bottom edge of the control's client  area.  This  member  is  only  valid  when  the
;                  +$LVBKIF_STYLE_NORMAL is specified in  Flags.  If  both  $LVBKIF_FLAG_TILEOFFSET  and  $LVBKIF_STYLE_TILE  are
;                  +specified in Flags, then the value specifies the pixel, not percentage offset, of the first tile.  Otherwise,
;                  +the value is ignored.
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; ===============================================================================================================================
Global Const $tagLVBKIMAGE = "int Flags;int hBmp;int Image;int ImageMax;int XOffPercent;int YOffPercent"

; #STRUCTURE# ===================================================================================================================
; Description ...: tagLVCOLUMN structure
; Fields ........: Mask    - Variable specifying which members contain valid information.  This member can be zero,  or  one  or
;                  +more of the following values:
;                  |LVCF_FMT     - The Fmt member is valid
;                  |LVCF_WIDTH   - The CX member is valid
;                  |LVCF_TEXT    - The Text member is valid
;                  |LVCF_SUBITEM - The SubItem member is valid
;                  |LVCF_IMAGE   - The Image member is valid
;                  |LVCF_ORDER   - The Order member is valid.
;                  Fmt     - Alignment of the column header and the subitem text in the column.  This member can be one  of  the
;                  +following values. The alignment of the leftmost column is always left-justified; it cannot be changed:
;                  |LVCFMT_LEFT            - Text is left-aligned
;                  |LVCFMT_RIGHT           - Text is right-aligned
;                  |LVCFMT_CENTER          - Text is centered
;                  |LVCFMT_JUSTIFYMASK     - A bitmask used to select those bits of Fmt that control field justification
;                  |LVCFMT_IMAGE           - The item displays an image from an image list
;                  |LVCFMT_BITMAP_ON_RIGHT - The bitmap appears to the right of text
;                  |LVCFMT_COL_HAS_IMAGES  - The header item contains an image in the image list.
;                  CX      - Width of the column, in pixels
;                  Text    - If column information is being set, this member is the address of a string that contains the column
;                  +header text.  If the structure is receiving information about a column, this member specifies the address  of
;                  +the buffer that receives the column header text.
;                  TextMax - Size of the buffer pointed to by the Text member.  If the structure is  not  receiving  information
;                  +about a column, this member is ignored.
;                  SubItem - Index of subitem associated with the column
;                  Image   - Zero based index of an image within the image list
;                  Order   - Zero-based column offset. Column offset is in left-to-right order.
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; ===============================================================================================================================
Global Const $tagLVCOLUMN = "int Mask;int Fmt;int CX;ptr Text;int TextMax;int SubItem;int Image;int Order"

; #STRUCTURE# ===================================================================================================================
; Description ...: tagLVFINDINFO structure
; Fields ........: Flags     - Type of search to perform. This member can be set to one or more of the following values:
;                  |$LVFI_PARAM    - Searches for a match between this structure's Param member and the Param member of an item.
;                  +If $LVFI_PARAM is specified, all other flags are ignored.
;                  |$LVFI_PARTIAL  - Checks to see if the item text begins with the string pointed to by the Text  member.  This
;                  +value implies use of $LVFI_STRING.
;                  |$LVFI_STRING   - Searches based on the item text.  Unless additional values are specified, the item text  of
;                  +the matching item must exactly match the string pointed to by the Text member.
;                  |$LVFI_WRAP     - Continues the search at the beginning if no match is found
;                  |LVFI_NEARESTXY - Finds the item nearest to the position specified in the X and Y members, in  the  direction
;                  +specified by the Direction member. This flag is supported only by large icon and small icon modes.
;                  Text      - Address of a string to compare with the item text.  It is valid if $LVFI_STRING or  $LVFI_PARTIAL
;                  +is set in the Flags member.
;                  Param     - Value to compare with the Param member of an item's  $LVITEM  structure.  It  is  valid  only  if
;                  +$LVFI_PARAM is set in the flags member.
;                  X         - Initial X search position. It is valid only if $LVFI_NEARESTXY is set in the Flags member.
;                  Y         - Initial Y search position. It is valid only if $LVFI_NEARESTXY is set in the Flags member.
;                  Direction - Virtual key code that specifies the direction to search. The following codes are supported:
;                  |VK_LEFT
;                  |VK_RIGHT
;                  |VK_UP
;                  |VK_DOWN
;                  |VK_HOME
;                  |VK_END
;                  |VK_PRIOR
;                  |VK_NEXT
;                  |This member is valid only if $LVFI_NEARESTXY is set in the flags member.
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; ===============================================================================================================================
Global Const $tagLVFINDINFO = "int Flags;ptr Text;int Param;int X;int Y;int Direction"

; #STRUCTURE# ===================================================================================================================
; Description ...: tagLVGROUP structure
; Fields ........: Size      - Size of this structure, in bytes
;                  Mask      - Mask that specifies which members of the structure are valid input.  Can be one or  more  of  the
;                  +following values:
;                  |$LVGF_NONE    - No other items are valid
;                  |$LVGF_HEADER  - Header and HeaderMax members are valid
;                  |$LVGF_FOOTER  - Reserved
;                  |$LVGF_STATE   - Reserved
;                  |$LVGF_ALIGN   - Align member is valid
;                  |$LVGF_GROUPID - GroupId member is valid
;                  Header    - Pointer to a string that contains the header text when item information is being  set.  If  group
;                  +information is being retrieved this member specifies the address of the buffer that receives the header text.
;                  HeaderMax - Size of the buffer pointed to by the Header member. If the structure is not receiving information
;                  +about a group, this member is ignored.
;                  Footer    - Reserved
;                  FooterMax - Reserved
;                  GroupID   - ID of the group
;                  StateMask - Reserved
;                  State     - Reserved
;                  Align     - Indicates the alignment of the header text.  It can have one or more of the following values. Use
;                  +one of the header flags.
;                  |LVGA_HEADER_CENTER - Header text is centered horizontally in the window
;                  |LVGA_HEADER_LEFT   - Header text is aligned at the left of the window
;                  |LVGA_HEADER_RIGHT  - Header text is aligned at the right of the window.
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; ===============================================================================================================================
Global Const $tagLVGROUP = "int Size;int Mask;ptr Header;int HeaderMax;ptr Footer;int FooterMax;int GroupID;int StateMask;int State;int Align"

; #STRUCTURE# ===================================================================================================================
; Description ...: tagLVGROUPMETRICS structure
; Fields ........: Size     - Size of this structure, in bytes
;                  Mask     - Flag that can have one or more of the following values:
;                  |$LVGMF_BORDERCOLOR
;                  |$LVGMF_BORDERSIZE
;                  |$LVGMF_NONE
;                  |$LVGMF_TEXTCOLOR
;                  Left     - Specifies the left border
;                  Top      - Specifies the top border
;                  Right    - Specifies the right border
;                  Bottom   - Specifies the bottom border
;                  CRLeft   - Specifies the color of the left border
;                  CRTop    - Specifies the color of the top border
;                  CRRight  - Specifies the color of the right border
;                  CRBottom - Specifies the color of the bottom border
;                  CRHeader - Specifies the color of the header text
;                  CRFooter - Specifies the color of the footer text
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; ===============================================================================================================================
Global Const $tagLVGROUPMETRICS = "int Size;int Mask;int Left;int Top;int Right;int Bottom;int CRLeft;int CRTop;int CRRight;" & _
             "int CRBottom;int CRHeader;int CRFooter"

; #STRUCTURE# ===================================================================================================================
; Description ...: tagLVHITTESTINFO
; Fields ........: X       - X position to hit test
;                  Y       - Y position to hit test
;                  Flags   - Results of a hit test. Can be one or more of the following values:
;                  |$LVHT_ABOVE           - The position is above the control's client area
;                  |$LVHT_BELOW           - The position is below the control's client area
;                  |$LVHT_NOWHERE         - The position is inside the client window, but it is not over a list item
;                  |$LVHT_ONITEMICON      - The position is over an item's icon
;                  |$LVHT_ONITEMLABEL     - The position is over an item's text
;                  |$LVHT_ONITEMSTATEICON - The position is over the state image of an item
;                  |$LVHT_TOLEFT          - The position is to the left of the client area
;                  |$LVHT_TORIGHT         - The position is to the right of the client area
;                  Item    - Receives the index of the matching item. Or if hit-testing a subitem,  this  value  represents  the
;                  +subitem's parent item.
;                  SubItem - Receives the index of the matching subitem. When hit-testing an item, this member will be zero.
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; ===============================================================================================================================
Global Const $tagLVHITTESTINFO = "int X;int Y;int Flags;int Item;int SubItem"

; #STRUCTURE# ===================================================================================================================
; Description ...: tagLVINSERTMARK structure
; Fields ........: Size     - Size of this structure, in bytes
;                  Flags    - Flag that specifies where the insertion point should appear:
;                  |$LVIM_AFTER - The insertion point appears after the item specified if the $LVIM_AFTER flag is set; otherwise
;                  +it appears before the specified item.
;                  Item     - Item next to which the insertion point appears. If -1, there is no insertion point.
;                  Reserved - Reserved. Must be set to 0.
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; ===============================================================================================================================
Global Const $tagLVINSERTMARK = "int Size;int Flags;int Item;int Reserved"

; #STRUCTURE# ===================================================================================================================
; Description ...: tagLVITEM structure
; Fields ........: Mask      - Set of flags that specify which members of this structure contain data to be set or which members
;                  +are being requested. This member can have one or more of the following flags set:
;                  |$LVIF_COLUMNS     - The Columns member is valid
;                  |$LVIF_DI_SETITEM  - The operating system should store the requested list item information
;                  |$LVIF_GROUPID     - The GroupID member is valid
;                  |$LVIF_IMAGE       - The Image member is valid
;                  |$LVIF_INDENT      - The Indent member is valid
;                  |$LVIF_NORECOMPUTE - The control will not generate LVN_GETDISPINFO to retrieve text information
;                  |$LVIF_PARAM       - The Param member is valid
;                  |$LVIF_STATE       - The State member is valid
;                  |$LVIF_TEXT        - The Text member is valid
;                  Item      - Zero based index of the item to which this structure refers
;                  SubItem   - One based index of the subitem to which this structure refers
;                  State     - Indicates the item's state, state image, and overlay image
;                  StateMask - Value specifying which bits of the state member will be retrieved or modified
;                  Text      - Pointer to a string containing the item text
;                  TextMax   - Number of bytes in the buffer pointed to by Text, including the string terminator
;                  Image     - Index of the item's icon in the control's image list
;                  Param     - Value specific to the item
;                  Indent    - Number of image widths to indent the item
;                  GroupID   - Identifier of the tile view group that receives the item
;                  Columns   - Number of tile view columns to display for this item
;                  pColumns  - Pointer to the array of column indices
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; ===============================================================================================================================
Global Const $tagLVITEM = "int Mask;int Item;int SubItem;int State;int StateMask;ptr Text;int TextMax;int Image;int Param;" & _
             "int Indent;int GroupID;int Columns;int pColumns"

; #STRUCTURE# ===================================================================================================================
; Description ...: tagLVSETINFOTIP structure
; Fields ........: Size    - Size of this structure, in bytes
;                  Flags   - Flag that specifies how the text should be set. Set to zero.
;                  Text    - Pointer to a Unicode string that contains the tooltip text
;                  Item    - Contains the zero based index of the item to which this structure refers
;                  SubItem - Contains the one based index of the subitem to which this structure refers
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; ===============================================================================================================================
Global Const $tagLVSETINFOTIP = "int Size;int Flags;ptr Text;int Item;int SubItem"

; #STRUCTURE# ===================================================================================================================
; Description ...: tagNMITEMACTIVATE structure
; Fields ........: WndFrom   - Window handle to the control sending a message
;                  IDFrom    - Identifier of the control sending a message
;                  Code      - Notification code
;                  Item      - Index of the item. If the item index is not used for the notification, this will contain -1.
;                  SubItem   - One based index of the subitem.  If the subitem index is not used  for  the  notification  or  the
;                  +notification does not apply to a subitem, this will be zero.
;                  NewState  - New item state. This member is zero for notification messages that do not use it.
;                  OldState  - Old item state. This member is zero for notification messages that do not use it.
;                  Changed   - Set of flags that indicate the item attributes that have changed.  This is zero for  notifications
;                  +that do not use it. Otherwise, it can have the following values:
;                  |$LVIF_COLUMNS     - The Columns member is valid
;                  |$LVIF_DI_SETITEM  - The operating system should store the requested list item information
;                  |$LVIF_GROUPID     - The GroupID member is valid
;                  |$LVIF_IMAGE       - The Image member is valid
;                  |$LVIF_INDENT      - The Indent member is valid
;                  |$LVIF_NORECOMPUTE - The control will not generate LVN_GETDISPINFO to retrieve text information
;                  |$LVIF_PARAM       - The Param member is valid
;                  |$LVIF_STATE       - The State member is valid
;                  |$LVIF_TEXT        - The Text member is valid
;                  PointX    - X coordinate at which the event occurred
;                  PointY    - Y coordinate at which the event occurred
;                  Param     - Application-defined value of the item
;                  KeyFlags  - Modifier keys that were pressed at the time of the activation.  This can be a combination  of  the
;                  +following flags:
;                  |$LVKF_ALT     - The key is pressed
;                  |$LVKF_CONTROL - The key is pressed
;                  |$LVKF_SHIFT   - The key is pressed
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; ===============================================================================================================================
Global Const $tagNMITEMACTIVATE = "int WndFrom;int IDFrom;int Code;int Item;int SubItem;int NewState;int OldState;int Changed;" & _
             "int PointX;int PointY;int Param;int KeyFlags"

; #STRUCTURE# ===================================================================================================================
; Description ...: tagNMLISTVIEW structure
; Fields ........: WndFrom  - Window handle to the control sending a message
;                  IDFrom   - Identifier of the control sending a message
;                  Code     - Notification code
;                  Item     - Identifies the item, or -1 if not used
;                  SubItem  - Identifies the subitem, or zero if none
;                  NewState - New item state
;                  OldState - Old item state
;                  Changed  - Set of flags that indicate the item attributes that have changed
;                  ActionX  - X position at which the event occurred
;                  ActionY  - Y position at which the event occurred
;                  Param    - Application-defined value of the item
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; ===============================================================================================================================
Global Const $tagNMLISTVIEW = "int WndFrom;int IDFrom;int Code;int Item;int SubItem;int NewState;int OldState;int Changed;" & _
             "int ActionX;int ActionY;int Param"

; #STRUCTURE# ===================================================================================================================
; Description ...: tagNMLVCUSTOMDRAW structure
; Fields ........: WndFrom    - A window handle to the control sending the message
;                  IDFrom     - An identifier of the control sending the message
;                  Code       - A notification code
;                  DrawStage  - The current drawing stage. This is one of the following values:
;                  |Global values:
;                  | $CDDS_POSTERASE - After the erasing cycle is complete
;                  | $CDDS_POSTPAINT - After the painting cycle is complete
;                  | $CDDS_PREERASE  - Before the erasing cycle begins
;                  | $CDDS_PREPAINT  - Before the painting cycle begins
;                  |Item specific values:
;                  | $CDDS_ITEM          - Indicates that the ItemSpec, ItemState, and ItemlParam members are valid
;                  | $CDDS_ITEMPOSTERASE - After an item has been erased
;                  | $CDDS_ITEMPOSTPAINT - After an item has been drawn
;                  | $CDDS_ITEMPREERASE  - Before an item is erased
;                  | $CDDS_ITEMPREPAINT  - Before an item is drawn
;                  | $CDDS_SUBITEM       - Combined with $CDDS_ITEMPREPAINT or $CDDS_ITEMPOSTPAINT if a subitem is being drawn
;                  DC         - Handle to the control's device context
;                  RectL      - Left postion of area being drawn
;                  RectT      - Top position of area being drawn
;                  RectR      - Right position of area being drawn
;                  RectB      - Bottom position of area being drawn
;                  ItemSpec   - The item number
;                  ItemState  - The current item state. This value is a combination of the following flags:
;                  |$CDIS_CHECKED          - The item is checked
;                  |$CDIS_DEFAULT          - The item is in its default state
;                  |$CDIS_DISABLED         - The item is disabled
;                  |$CDIS_FOCUS            - The item is in focus
;                  |$CDIS_GRAYED           - The item is grayed
;                  |$CDIS_HOT              - The item is currently under the pointer
;                  |$CDIS_INDETERMINATE    - The item is in an indeterminate state
;                  |$CDIS_MARKED           - The item is marked
;                  |$CDIS_SELECTED         - The item is selected
;                  |$CDIS_SHOWKEYBOARDCUES - The item is a keyboard cue
;                  |$CDIS_NEARHOT          - The item is part of a control that is currently under the mouse pointer
;                  |$CDIS_OTHERSIDEHOT     - The item is part of a splitbutton that is currently under the mouse pointer
;                  |$CDIS_DROPHILITED      - The item is currently the drop target of a drag-and-drop operation
;                  ItemlParam - Application-defined item data
;                  ClrText    - Color that will be used to display text foreground
;                  ClrTextBk  - Color that will be used to display text background
;                  SubItem    - Index of the subitem that is being drawn
;                  ItemType   - The type of the item to draw:
;                  |$LVCDI_ITEM  - An item is to be drawn
;                  |$LVCDI_GROUP - A group is to be drawn
;                  ClrFace    - Color that will be used to display the face of an item
;                  IconEffect - Specifies the effect that is applied to an icon
;                  IconPhase  - Specifies the phase of an icon
;                  PartID     - Specifies the ID of the part of an item to draw
;                  StateID    - Specifies the ID of the state of an item to draw
;                  rcTextL    - Left position of area where text is to be drawn
;                  rcTextT    - Top position of area where text is to be drawn
;                  rcTextR    - Right position of area where text is to be drawn
;                  rcTextB    - Bottom position of area where text is to be drawn
;                  Align      - Specifies how a group should be aligned. This member can be one of the following values:
;                  |$LVGA_HEADER_CENTER - Center the group
;                  |$LVGA_HEADER_LEFT   - Align the group on the left
;                  |$LVGA_HEADER_RIGHT  - Align the group on the right
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; ===============================================================================================================================
Global Const $tagNMLVCUSTOMDRAW = "hwnd WndFrom;int IDFrom;int Code;int DrawStage;hwnd DC;int RectL;int RectT;int RectR;int RectB;" & _
       "int ItemSpec;int ItemState;int ItemlParam;int ClrText;int ClrTextBk;int SubItem;int ItemType;int ClrFace;int IconEffect;"   & _
       "int IconPhase;int PartID;int StateID;int rcTextL;int rcTextT;int rcTextR;int rcTextB;int Align"

; #STRUCTURE# ===================================================================================================================
; Description ...: tagNMLVDISPINFO structure
; Fields ........: WndFrom   - Window handle to the control sending a message
;                  IDFrom    - Identifier of the control sending a message
;                  Code      - Notification code
;                  Mask      - Set of flags that specify which members of this structure contain data to be set or which members
;                  +are being requested. This member can have one or more of the following flags set:
;                  |$LVIF_COLUMNS     - The Columns member is valid
;                  |$LVIF_DI_SETITEM  - The operating system should store the requested list item information
;                  |$LVIF_GROUPID     - The GroupID member is valid
;                  |$LVIF_IMAGE       - The Image member is valid
;                  |$LVIF_INDENT      - The Indent member is valid
;                  |$LVIF_NORECOMPUTE - The control will not generate LVN_GETDISPINFO to retrieve text information
;                  |$LVIF_PARAM       - The Param member is valid
;                  |$LVIF_STATE       - The State member is valid
;                  |$LVIF_TEXT        - The Text member is valid
;                  Item      - Zero based index of the item to which this structure refers
;                  SubItem   - One based index of the subitem to which this structure refers
;                  State     - Indicates the item's state, state image, and overlay image
;                  StateMask - Value specifying which bits of the state member will be retrieved or modified
;                  Text      - Pointer to a string containing the item text
;                  TextMax   - Number of bytes in the buffer pointed to by Text, including the string terminator
;                  Image     - Index of the item's icon in the control's image list
;                  Param     - Value specific to the item
;                  Indent    - Number of image widths to indent the item
;                  GroupID   - Identifier of the tile view group that receives the item
;                  Columns   - Number of tile view columns to display for this item
;                  pColumns  - Pointer to the array of column indices
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; ===============================================================================================================================
Global Const $tagNMLVDISPINFO = "int WndFrom;int IDFrom;int Code;int Mask;int Item;int SubItem;int State;int StateMask;" & _
                                "ptr Text;int TextMax;int Image;int Param;int Indent;int GroupID;int Columns;int pColumns"

; #VARIABLES# ===================================================================================================================
Global $ghLVLastWnd
; ===============================================================================================================================

; #FUNCTION# ====================================================================================================================
; Description ...: Adds items from an array to the control
; Parameters ....: $hWnd        - Handle to the control
;                  $aItems      - Array with the following format:
;                  |[0][0] - Item 1 Text
;                  |[0][1] - Item 1 Subitem 1 text
;                  |[0][2] - Item 1 Subitem 2 text
;                  |[0][n] - Item 1 Subitem n text
;                  |[1][0] - Item 2 Text
;                  |[1][1] - Item 2 Subitem 1 text
;                  |[1][2] - Item 2 Subitem 2 text
;                  |[1][n] - Item 2 Subitem n text
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......:
; ===============================================================================================================================
Func _ListView_AddArray($hWnd, ByRef $aItems)
  Local $pBuffer, $tBuffer, $iItem, $pItem, $tItem, $tMemMap, $pMemory, $pText, $iI, $iJ

  $tItem   = DllStructCreate($tagLVITEM)
  $pItem   = DllStructGetPtr($tItem)
  $tBuffer = DllStructCreate("char Text[4096]")
  $pBuffer = DllStructGetPtr($tBuffer)
  DllStructSetData($tItem, "Mask"   , $LVIF_TEXT)
  DllStructSetData($tItem, "Text"   , $pBuffer  )
  DllStructSetData($tItem, "TextMax", 4096      )
  _ListView_BeginUpdate($hWnd)
  if _Lib_InProcess($hWnd, $ghLVLastWnd) then
    for $iI = 0 to UBound($aItems) - 1
      DllStructSetData($tItem  , "Item"   , $iI)
      DllStructSetData($tItem  , "SubItem", 0  )
      DllStructSetData($tBuffer, "Text"   , $aItems[$iI][0])
      _API_SendMessage($hWnd, $LVM_INSERTITEM, 0, $pItem)
      for $iJ = 1 to UBound($aItems, 2) - 1
        DllStructSetData($tItem  , "SubItem", $iJ)
        DllStructSetData($tBuffer, "Text"   , $aItems[$iI][$iJ])
        _API_SendMessage($hWnd, $LVM_SETITEM , 0, $pItem)
      next
    next
  else
    $iItem   = DllStructGetSize($tItem)
    $pMemory = _Mem_CtrlInit($hWnd, $iItem + 4096, $tMemMap)
    $pText   = $pMemory + $iItem
    DllStructSetData($tItem, "Text", $pText)
    for $iI = 0 to UBound($aItems) - 1
      DllStructSetData($tItem  , "Item"   , $iI)
      DllStructSetData($tItem  , "SubItem", 0  )
      DllStructSetData($tBuffer, "Text"   , $aItems[$iI][0])
      _Mem_CtrlWrite($tMemMap, $pItem  , $pMemory, $iItem)
      _Mem_CtrlWrite($tMemMap, $pBuffer, $pText  , 4096  )
      _API_SendMessage($hWnd, $LVM_INSERTITEM, 0, $pMemory)
      for $iJ = 1 to UBound($aItems, 2) - 1
        DllStructSetData($tItem  , "SubItem", $iJ)
        DllStructSetData($tBuffer, "Text"   , $aItems[$iI][$iJ])
        _Mem_CtrlWrite($tMemMap, $pItem  , $pMemory, $iItem)
        _Mem_CtrlWrite($tMemMap, $pBuffer, $pText  , 4096  )
        _API_SendMessage($hWnd, $LVM_SETITEM , 0, $pMemory)
      next
    next
    _Mem_CtrlFree($tMemMap)
  endif
  _ListView_EndUpdate($hWnd)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Adds a new column in the control
; Parameters ....: $hWnd        - Handle to the control
;                  $sText       - Column header text
;                  $iWidth      - Width of the column, in pixels
;                  $sAlign      - Alignment of the column header and the subitem text in the column:
;                  |  Left - Text is left aligned
;                  | Right - Text is right aligned
;                  |Center - Text is centered
;                  $iImage      - Zero based index of an image within the image list
;                  $fOnRight    - If True, the column image appears to the right of text
; Return values .: Success      - The index of the new column
;                  Failure      - -1
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: The alignment of the leftmost column is always left justified
; Related .......:
; ===============================================================================================================================
Func _ListView_AddColumn($hWnd, $sText, $iWidth=50, $sAlign="left", $iImage=-1, $fOnRight=False)
  Return _ListView_InsertColumn($hWnd, _ListView_GetColumnCount($hWnd), $sText, $iWidth, $sAlign, $iImage, $fOnRight)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Adds a new item to the end of the list
; Parameters ....: $hWnd        - Handle to the control
;                  $sText       - Item text. If set to -1, the item set is set via the $LVN_GETDISPINFO notification message.
;                  $iImage      - Zero based index of the item's icon in the control's image list
; Return values .: Success      - The index of the new item
;                  Failure      - -1
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: You can not use this function to insert subitems. Use _ListView_AddSubItem to insert subitems.
; Related .......: _ListView_AddSubItem
; ===============================================================================================================================
Func _ListView_AddItem($hWnd, $sText, $iImage=-1)
  Return _ListView_InsertItem($hWnd, 999999999, $sText, $iImage)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Adds a new subitem to the control
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
;                  $sText       - Item or subitem text
;                  $iSubItem    - One based index of the subitem
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_AddItem
; ===============================================================================================================================
Func _ListView_AddSubItem($hWnd, $iIndex, $sText, $iSubItem, $iImage=-1)
  Local $iMask, $iBuffer, $pBuffer, $tBuffer, $iItem, $pItem, $tItem, $pMemory, $tMemMap, $pText, $iResult

  $iBuffer = StringLen($sText) + 1
  $tBuffer = DllStructCreate("char Text[" & $iBuffer & "]")
  $pBuffer = DllStructGetPtr($tBuffer)
  $tItem   = DllStructCreate($tagLVITEM)
  $pItem   = DllStructGetPtr($tItem  )
  $iMask   = $LVIF_TEXT
  if $iImage <> -1 then $iMask = BitOR($iMask, $LVIF_IMAGE)
  DllStructSetData($tBuffer, "Text"   , $sText   )
  DllStructSetData($tItem  , "Mask"   , $iMask   )
  DllStructSetData($tItem  , "Item"   , $iIndex  )
  DllStructSetData($tItem  , "SubItem", $iSubItem)
  DllStructSetData($tItem  , "Image"  , $iImage  )
  if _Lib_InProcess($hWnd, $ghLVLastWnd) then
    DllStructSetData($tItem, "Text", $pBuffer)
    $iResult = _API_SendMessage($hWnd, $LVM_SETITEM, 0, $pItem  )
  else
    $iItem   = DllStructGetSize($tItem)
    $pMemory = _Mem_CtrlInit($hWnd, $iItem + $iBuffer, $tMemMap)
    $pText   = $pMemory + $iItem
    DllStructSetData($tItem, "Text", $pText)
    _Mem_CtrlWrite($tMemMap, $pItem  , $pMemory, $iItem  )
    _Mem_CtrlWrite($tMemMap, $pBuffer, $pText  , $iBuffer)
    $iResult = _API_SendMessage($hWnd, $LVM_SETITEM, 0, $pMemory)
    _Mem_CtrlFree($tMemMap)
  endif
  Return $iResult <> 0
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Calculates the approximate height required to display a given number of items
; Parameters ....: $hWnd        - Handle to the control
;                  $iCount      - Number of items to be displayed in the control. If this parameter is set to -1 the message uses
;                  +the total number of items in the control.
;                  $iCX         - Proposed X dimension of the control, in pixels.  This parameter can be set to -1 to  allow  the
;                  +message to use the current width value.
;                  $iCY         - Proposed Y dimension of the control, in pixels.  This parameter can be set to -1 to  allow  the
;                  +message to use the current height value.
; Return values .: Success      - Approximate height, in pixels, needed to display the items
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: Setting the size of the control based on the dimensions provided by  this  message  can  optimize  redraw  and
;                  reduce flicker.
; Related .......: _ListView_ApproximateViewWidth
; ===============================================================================================================================
Func _ListView_ApproximateViewHeight($hWnd, $iCount=-1, $iCX=-1, $iCY=-1)
  Return _Lib_HiWord(_API_SendMessage($hWnd, $LVM_APPROXIMATEVIEWRECT, $iCount, _Lib_MakeLong($iCX, $iCY)))
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Calculates the approximate size required to display a given number of items
; Parameters ....: $hWnd        - Handle to the control
;                  $iCount      - Number of items to be displayed in the control. If this parameter is set to -1 the message uses
;                  +the total number of items in the control.
;                  $iCX         - Proposed X dimension of the control, in pixels.  This parameter can be set to -1 to  allow  the
;                  +message to use the current width value.
;                  $iCY         - Proposed Y dimension of the control, in pixels.  This parameter can be set to -1 to  allow  the
;                  +message to use the current height value.
; Return values .: Success      - Array with the following format:
;                  |[0] - Approximate width, in pixels, needed to display the items
;                  |[1] - Approximate height, in pixels, needed to display the items
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: Setting the size of the control based on the dimensions provided by  this  message  can  optimize  redraw  and
;                  reduce flicker.
; Related .......: _ListView_ApproximateViewHeight, _ListView_ApproximateViewWidth
; ===============================================================================================================================
Func _ListView_ApproximateViewRect($hWnd, $iCount=-1, $iCX=-1, $iCY=-1)
  Local $iView, $aView[2]

  $iView    = _API_SendMessage($hWnd, $LVM_APPROXIMATEVIEWRECT, $iCount, _Lib_MakeLong($iCX, $iCY))
  $aView[0] = _Lib_LoWord($iView)
  $aView[1] = _Lib_HiWord($iView)
  Return $aView
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Calculates the approximate width required to display a given number of items
; Parameters ....: $hWnd        - Handle to the control
;                  $iCount      - Number of items to be displayed in the control. If this parameter is set to -1 the message uses
;                  +the total number of items in the control
;                  $iCX         - Proposed X dimension of the control, in pixels.  This parameter can be set to -1  to  allow the
;                  +message to use the current width value.
;                  $iCY         - Proposed Y dimension of the control, in pixels.  This parameter can be set to -1  to  allow the
;                  +message to use the current height value.
; Return values .: Success      - Approximate width, in pixels, needed to display the items
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: Setting the size of the control based on the dimensions provided by  this  message  can  optimize  redraw  and
;                  reduce flicker.
; Related .......: _ListView_ApproximateViewHeight
; ===============================================================================================================================
Func _ListView_ApproximateViewWidth($hWnd, $iCount=-1, $iCX=-1, $iCY=-1)
  Return _Lib_LoWord(_API_SendMessage($hWnd, $LVM_APPROXIMATEVIEWRECT, $iCount, _Lib_MakeLong($iCX, $iCY)))
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Arranges items in icon view
; Parameters ....: $hWnd        - Handle to the control
;                  $iArrange    - Alignment. This can be one of the following values:
;                  |0 - Aligns items according to the controls default value
;                  |1 - Aligns items along the left edge of the window
;                  |2 - Aligns items along the top edge of the window
;                  |3 - Snaps all icons to the nearest grid position.
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_SetItemPosition
; ===============================================================================================================================
Func _ListView_Arrange($hWnd, $iArrange=0)
  Local $aArrange[4]=[$LVA_DEFAULT, $LVA_ALIGNLEFT, $LVA_ALIGNTOP, $LVA_SNAPTOGRID]

  Return _API_SendMessage($hWnd, $LVM_ARRANGE, $aArrange[$iArrange], 0) <> 0
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Prevents updating of the control until the EndUpdate function is called
; Parameters ....: $hWnd        - Handle to the control
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_EndUpdate
; ===============================================================================================================================
Func _ListView_BeginUpdate($hWnd)
  Return _API_SendMessage($hWnd, $WM_SETREDRAW, 0, 0) = 0
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Cancels an item text editing operation
; Parameters ....: $hWnd        - Handle to the control
; Return values .:
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: Windows XP only
; Related .......: _ListView_EditLabel
; ===============================================================================================================================
Func _ListView_CancelEditLabel($hWnd)
  _API_SendMessage($hWnd, $LVM_CANCELEDITLABEL, 0, 0)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Clicks an item
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
;                  $sButton     - Button to click
;                  $fMove       - If True, the mouse will be moved. If False, the mouse does not move.
;                  $iClicks     - Number of clicks
;                  $iSpeed      - Delay between clicks
;                  $fPopupScan  - If True, a popup scan will be done after the click
; Return values .:
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......:
; ===============================================================================================================================
Func _ListView_ClickItem($hWnd, $iIndex, $sButton="left", $fMove=False, $iClicks=1, $iSpeed=1, $fPopupScan=False)
  Local $tPoint, $tRect, $iX, $iY

  _ListView_EnsureVisible($hWnd, $iIndex, False)
  $tRect  = _ListView_GetItemRectEx($hWnd, $iIndex)
  $tPoint = _Lib_PointFromRect($tRect, True)
  $tPoint = _API_ClientToScreen($hWnd, $tPoint)
  _Lib_GetXYFromPoint($tPoint, $iX, $iY)
  _Lib_MouseClick($sButton, $iX, $iY, $fMove, $iClicks, $iSpeed, $fPopupScan)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Create a ListView control
; Parameters ....: $hWnd        - Handle to parent or owner window
;                  $iX          - Horizontal position of the control
;                  $iY          - Vertical position of the control
;                  $iWidth      - Control width
;                  $iHeight     - Control height
;                  $iStyle      - Control styles:
;                  |$LVS_ALIGNLEFT       - Items are left aligned in icon and small icon view
;                  |$LVS_ALIGNTOP        - Items are aligned with the top of the control in icon and small icon view
;                  |$LVS_AUTOARRANGE     - Icons are automatically kept arranged in icon and small icon view
;                  |$LVS_EDITLABELS      - Item text can be edited in place
;                  |$LVS_ICON            - This style specifies icon view
;                  |$LVS_LIST            - This style specifies list view
;                  |$LVS_NOCOLUMNHEADER  - Column headers are not displayed in report view
;                  |$LVS_NOLABELWRAP     - Item text is displayed on a single line in icon view
;                  |$LVS_NOSCROLL        - Scrolling is disabled
;                  |$LVS_NOSORTHEADER    - Column headers do not work like buttons
;                  |$LVS_OWNERDATA       - This style specifies a virtual control
;                  |$LVS_OWNERDRAWFIXED  - The owner window can paint items in report view
;                  |$LVS_REPORT          - This style specifies report view
;                  |$LVS_SHAREIMAGELISTS - The image list will not be deleted
;                  |$LVS_SHOWSELALWAYS   - The selection, if any, is always shown
;                  |$LVS_SINGLESEL       - Only one item at a time can be selected
;                  |$LVS_SMALLICON       - This style specifies small icon view
;                  |$LVS_SORTASCENDING   - Item indexes are sorted in ascending order
;                  |$LVS_SORTDESCENDING  - Item indexes are sorted in descending order
;                  $iExStyle    - Extended control styles
;                  -
;                  |Default: $LVS_REPORT, $LVS_SINGLESEL, $LVS_SHOWSELALWAYS
;                  |Forced : $WS_CHILD, $WS_VISIBLE
; Return values .: Success      - Handle to the ListView control
;                  Failure      - 0
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......:
; ===============================================================================================================================
Func _ListView_Create($hWnd, $iX, $iY, $iWidth=150, $iHeight=150, $iStyle=0x0000000D, $iExStyle=0x00000000)
  Local $hList

  $iStyle = BitOR($iStyle, $WS_CHILD, $WS_VISIBLE)
  $hList = _API_CreateWindowEx($iExStyle, "SysListView32", "", $iStyle, $iX, $iY, $iWidth, $iHeight, $hWnd)
  _ListView_SetUnicodeFormat($hList, False)
  _Lib_SetFont($hList, _API_GetStockObject($DEFAULT_GUI_FONT))
  Return $hList
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Creates a drag image list for the specified item
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
; Return values .: Success      - Array with the following format:
;                  |[0] - Handle to the drag image list if successful, otherwise 0
;                  |[1] - X coordinate of the upper left corner of the image
;                  |[2] - Y coordinate of the upper left corner of the image
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: You are responsible for destroying the image list when it is no longer needed
; Related .......:
; ===============================================================================================================================
Func _ListView_CreateDragImage($hWnd, $iIndex)
  Local $tMemMap, $pMemory, $iPoint, $pPoint, $tPoint, $aDrag[3]

  $tPoint = DllStructCreate($tagPOINT)
  $pPoint = DllStructGetPtr($tPoint)
  if _Lib_InProcess($hWnd, $ghLVLastWnd) then
    $aDrag[0] = _API_SendMessage($hWnd, $LVM_CREATEDRAGIMAGE, $iIndex, $pPoint )
  else
    $iPoint   = DllStructGetSize($tPoint)
    $pMemory  = _Mem_CtrlInit($hWnd, $iPoint, $tMemMap)
    $aDrag[0] = _API_SendMessage($hWnd, $LVM_CREATEDRAGIMAGE, $iIndex, $pMemory)
    _Mem_CtrlRead($tMemMap, $pMemory, $pPoint, $iPoint)
    _Mem_CtrlFree($tMemMap)
  endif
  $aDrag[1] = DllStructGetData($tPoint, "X")
  $aDrag[2] = DllStructGetData($tPoint, "Y")
  Return $aDrag
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Removes all items from the control
; Parameters ....: $hWnd        - Handle to the control
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_DeleteItem
; ===============================================================================================================================
Func _ListView_DeleteAllItems($hWnd)
  Return _API_SendMessage($hWnd, $LVM_DELETEALLITEMS, 0, 0) <> 0
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Removes a column from the control
; Parameters ....: $hWnd        - Handle to the control
;                  $iColumn     - Zero based index of the column to delete
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: Column zero cannot be deleted.  If you must delete column zero, insert a zero length  dummy  column  zero  and
;                  delete column one and above.
; Related .......:
; ===============================================================================================================================
Func _ListView_DeleteColumn($hWnd, $iColumn)
  Return _API_SendMessage($hWnd, $LVM_DELETECOLUMN, $iColumn, 0) <> 0
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Removes an item from the control
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_DeleteAllItems
; ===============================================================================================================================
Func _ListView_DeleteItem($hWnd, $iIndex)
  Return _API_SendMessage($hWnd, $LVM_DELETEITEM, $iIndex, 0) <> 0
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Begins in place editing of the specified item text
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item to edit
; Return values .: Success      - Returns the handle to the edit control that is used to edit the item
;                  Failure      - 0
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: When the user completes or cancels editing, the edit control is destroyed and the handle is no  longer  valid.
;                  You can subclass the edit control, but you should not destroy it.
; Related .......: _ListView_CancelEditLabel
; ===============================================================================================================================
Func _ListView_EditLabel($hWnd, $iIndex)
  _API_SetFocus($hWnd)
  Return _API_SendMessage($hWnd, $LVM_EDITLABEL, $iIndex, 0)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Enables or disables whether the items in the control display as a group
; Parameters ....: $hWnd        - Handle to the control
;                  $fEnable     - Indicates whether to enable group displayed items
;                  | True - Enable group view
;                  |False - Disable group view
; Return values .: 0 - The ability to display listview items as a group is already enabled or disabled
;                  1 - The state of the control was successfully changed
;                  -1 - The operation failed
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: This function is not supported under the $LVS_OWNERDATA style.  To use  this  function,  you  must  provide  a
;                  manifest specifying Comclt32.dll version 6.0.
; Related .......:
; ===============================================================================================================================
Func _ListView_EnableGroupView($hWnd, $fEnable=True)
  Return _API_SendMessage($hWnd, $LVM_ENABLEGROUPVIEW, $fEnable, 0)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Enables screen repainting that was turned off with the BeginUpdate function
; Parameters ....: $hWnd        - Handle to the control
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_BeginUpdate
; ===============================================================================================================================
Func _ListView_EndUpdate($hWnd)
  Return _API_SendMessage($hWnd, $WM_SETREDRAW, 1, 0) = 0
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Ensures that an item is either entirely or partially visible
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
;                  $fPartialOK  - Specifies whether the item must be entirely visible.  If True, no scrolling occurs if the  item
;                  +is at least partially visible.
; Return values .: Success       - True
;                  Failure       - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......:
; ===============================================================================================================================
Func _ListView_EnsureVisible($hWnd, $iIndex, $fPartialOK=False)
  Return _API_SendMessage($hWnd, $LVM_ENSUREVISIBLE, $iIndex, $fPartialOK) <> 0
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Searches for an item that contains the specified text anywhere in its text
; Parameters ....: $hWnd        - Handle to the control
;                  $sText       - Text to match
;                  $iStart      - Zero based index of the item to begin the search with or -1 to start from  the  beginning.  The
;                  +specified item is itself excluded from the search.
;                  $fWrapOK     - If True, the search will continue with the first item if no match is found
; Return values .: Success      - The zero based index of the item
;                  Failure      - -1
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: The search is case insensitive. Unlike _ListView_FindText, this function will search all subitems for the text
;                  as well.
; Related .......: _ListView_FindText
; ===============================================================================================================================
Func _ListView_FindInText($hWnd, $sText, $iStart=-1, $fWrapOK=True)
  Local $iI, $iJ, $iCount, $iColumns, $sList

  $iCount   = _ListView_GetItemCount  ($hWnd)
  $iColumns = _ListView_GetColumnCount($hWnd)
  if $iColumns = 0 then $iColumns = 1

  for $iI = $iStart + 1 to $iCount - 1
    for $iJ = 0 to $iColumns - 1
      $sList = _ListView_GetItemText($hWnd, $iI, $iJ)
      if StringInStr($sList, $sText) then Return $iI
    next
  next

  if ($iStart = -1) or not $fWrapOK then Return -1
  for $iI = 0 to $iStart - 1
    for $iJ = 0 to $iColumns - 1
      $sList = _ListView_GetItemText($hWnd, $iI, $iJ)
      if StringInStr($sList, $sText) then Return $iI
    next
  next

  Return -1
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Searches for an item with the specified characteristics
; Parameters ....: $hWnd        - Handle to the control
;                  $iStart      - Zero based index of the item to begin the search with or -1 to start from  the  beginning.  The
;                  +specified item is itself excluded from the search.
;                  $tFindInfo   - tagLVFINDINFO structure that contains the search information
; Return values .: Success      - The zero based index of the item
;                  Failure      - -1
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: tagLVFINDINFO
; ===============================================================================================================================
Func _ListView_FindItem($hWnd, $iStart, ByRef $tFindInfo, $sText="")
  Local $iBuffer, $tBuffer, $pBuffer, $iFindInfo, $pFindInfo, $pMemory, $tMemMap, $pText, $iResult

  $iBuffer   = StringLen($sText) + 1
  $tBuffer   = DllStructCreate("char Text[" & $iBuffer & "]")
  $pBuffer   = DllStructGetPtr($tBuffer  )
  $pFindInfo = DllStructGetPtr($tFindInfo)
  DllStructSetData($tBuffer, "Text", $sText)
  if _Lib_InProcess($hWnd, $ghLVLastWnd) then
    DllStructSetData($tFindInfo, "Text", $pBuffer)
    $iResult = _API_SendMessage($hWnd, $LVM_FINDITEM, $iStart, $pFindInfo)
  else
    $iFindInfo = DllStructGetSize($tFindInfo)
    $pMemory   = _Mem_CtrlInit($hWnd, $iFindInfo + $iBuffer, $tMemMap)
    $pText     = $pMemory + $iFindInfo
    DllStructSetData($tFindInfo, "Text", $pText)
    _Mem_CtrlWrite($tMemMap, $pFindInfo, $pMemory, $iFindInfo)
    _Mem_CtrlWrite($tMemMap, $pBuffer  , $pText  , $iBuffer  )
    $iResult = _API_SendMessage($hWnd, $LVM_FINDITEM, $iStart, $pMemory)
    _Mem_CtrlFree($tMemMap)
  endif
  Return $iResult
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Finds the item nearest to the position specified
; Parameters ....: $hWnd        - Handle to the control
;                  $iX          - X position
;                  $iY          - Y position
;                  $iDir        - Specifies which direction to search:
;                  |0 - Left
;                  |1 - Right
;                  |2 - Up
;                  |3 - Down
;                  |4 - From start
;                  |5 - From end
;                  |6 - From prior item
;                  |7 - From next item
;                  $iStart      - Zero based index of the item to begin the search with or -1 to start from  the  beginning.  The
;                  +specified item is itself excluded from the search.
;                  $fWrapOK     - If True, the search will continue with the first item if no match is found
; Return values .: Success      - The zero based index of the item
;                  Failure      - -1
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: This function is supported only by large icon and small icon modes
; Related .......: _ListView_FindItem
; ===============================================================================================================================
Func _ListView_FindNearest($hWnd, $iX, $iY, $iDir=0, $iStart=-1, $fWrapOK=True)
  Local $tFindInfo, $iFlags, $aDir[8]=[$VK_LEFT, $VK_RIGHT, $VK_UP, $VK_DOWN, $VK_HOME, $VK_END, $VK_PRIOR, $VK_NEXT]

  $tFindInfo = DllStructCreate($tagLVFINDINFO)
  $iFlags    = $LVFI_NEARESTXY
  if $fWrapOK then $iFlags = BitOR($iFlags, $LVFI_WRAP)
  DllStructSetData($tFindInfo, "Flags"    , $iFlags     )
  DllStructSetData($tFindInfo, "X"        , $iX         )
  DllStructSetData($tFindInfo, "Y"        , $iY         )
  DllStructSetData($tFindInfo, "Direction", $aDir[$iDir])
  Return _ListView_FindItem($hWnd, $iStart, $tFindInfo)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Searches for an item with the specified lParam
; Parameters ....: $hWnd        - Handle to the control
;                  $iParam      - Param value to search for
;                  $iStart      - Zero based index of the item to begin the search with or -1 to start from  the  beginning.  The
;                  +specified item is itself excluded from the search.
; Return values .: Success      - The zero based index of the item
;                  Failure      - -1
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_FindItem
; ===============================================================================================================================
Func _ListView_FindParam($hWnd, $iParam, $iStart=-1)
  Local $tFindInfo

  $tFindInfo = DllStructCreate($tagLVFINDINFO)
  DllStructSetData($tFindInfo, "Flags", $LVFI_PARAM)
  DllStructSetData($tFindInfo, "Param", $iParam    )
  Return _ListView_FindItem($hWnd, $iStart, $tFindInfo)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Searches for an item with the specified text
; Parameters ....: $hWnd        - Handle to the control
;                  $sText       - Text to match
;                  $iStart      - Zero based index of the item to begin the search with or -1 to start from  the  beginning.  The
;                  +specified item is itself excluded from the search.
;                  $fPartialOK  - If True, a match will occur if the item text begins with the text
;                  $fWrapOK     - If True, the search will continue with the first item if no match is  found
; Return values .: Success      - The zero based index of the item
;                  Failure      - -1
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: The search is case insensitive. The search is performed on the item only. Use _ListView_FindInText if you want
;                  to search for the text in subitems.
; Related .......: _ListView_FindInText
; ===============================================================================================================================
Func _ListView_FindText($hWnd, $sText, $iStart=-1, $fPartialOK=True, $fWrapOK=True)
  Local $tFindInfo, $iFlags

  $tFindInfo = DllStructCreate($tagLVFINDINFO)
  $iFlags    = $LVFI_STRING
  if $fPartialOK then $iFlags = BitOR($iFlags, $LVFI_PARTIAL)
  if $fWrapOK    then $iFlags = BitOR($iFlags, $LVFI_WRAP   )
  DllStructSetData($tFindInfo, "Flags", $iFlags)
  Return _ListView_FindItem($hWnd, $iStart, $tFindInfo, $sText)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the background color of the control
; Parameters ....: $hWnd        - Handle to the control
; Return values .: Success      - Background color
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_SetBkColor
; ===============================================================================================================================
Func _ListView_GetBkColor($hWnd)
  Return _API_SendMessage($hWnd, $LVM_GETBKCOLOR, 0, 0)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the background image in the control
; Parameters ....: $hWnd        - Handle to the control
; Return values .: Success      - Array with the following format:
;                  |[0] - One or more of the following flags:
;                  | 0 - The control has no background
;                  | 1 - The background is from a bitmap
;                  | 2 - The background is from a URL
;                  |[1] - URL of the background image
;                  |[2] - Percentage of the client area that the image should be X offset
;                  |[3] - Percentage of the client area that the image should be Y offset
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_SetBkImage
; ===============================================================================================================================
Func _ListView_GetBkImage($hWnd)
  Local $pBuffer, $tBuffer, $pMemory, $tMemMap, $pText, $iImage, $pImage, $tImage, $aImage[4], $iResult

  $tBuffer = DllStructCreate("char Text[4096]")
  $pBuffer = DllStructGetPtr($tBuffer)
  $tImage  = DllStructCreate($tagLVBKIMAGE)
  $pImage  = DllStructGetPtr($tImage )
  DllStructSetData($tImage, "ImageMax", 4096)
  if _Lib_InProcess($hWnd, $ghLVLastWnd) then
    DllStructSetData($tImage, "Image", $pBuffer)
    $iResult = _API_SendMessage($hWnd, $LVM_GETBKIMAGE, 0, $pImage )
  else
    $iImage  = DllStructGetSize($tImage)
    $pMemory = _Mem_CtrlInit($hWnd, $iImage + 4096, $tMemMap)
    $pText   = $pMemory + $iImage
    DllStructSetData($tImage, "Image", $pText)
    _Mem_CtrlWrite($tMemMap, $pImage, $pMemory, $iImage)
    $iResult = _API_SendMessage($hWnd, $LVM_GETBKIMAGE, 0, $pMemory)
    _Mem_CtrlRead($tMemMap, $pMemory, $pImage , $iImage)
    _Mem_CtrlRead($tMemMap, $pText  , $pBuffer, 4096   )
    _Mem_CtrlFree($tMemMap)
  endif
  Switch BitAND(DllStructGetData($tImage, "Flags"), $LVBKIF_SOURCE_MASK)
    case $LVBKIF_SOURCE_HBITMAP
      $aImage[0] = 1
    case $LVBKIF_SOURCE_URL
      $aImage[0] = 2
  EndSwitch
  $aImage[1] = DllStructGetData($tBuffer, "Text"       )
  $aImage[2] = DllStructGetData($tImage , "XOffPercent")
  $aImage[3] = DllStructGetData($tImage , "YOffPercent")
  Return SetError($iResult<>0, 0, $aImage)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the callback mask for the control
; Parameters ....: $hWnd        - Handle to the control
; Return values .: Success      - Value of the callback mask. The bits of the mask indicate the item states or images  for  which
;                  +the application stores the current state data.  This value can be any combination of the following:
;                  | 1 - The item is marked for a cut-and-paste operation
;                  | 2 - The item is highlighted as a drag-and-drop target
;                  | 4 - The item has the focus
;                  | 8 - The item is selected
;                  |16 - The application stores the image list index of the current overlay image
;                  |32 - The application stores the image list index of the current state image
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: The callback mask is a set of bit flags that specify the item states for which the  application,  rather  than
;                  the control, stores the current data.  The callback mask applies to all of the  control's  items,  unlike  the
;                  callback item designation, which applies to a specific item.  The callback mask is zero  by  default,  meaning
;                  that the control stores all item state information.
; Related .......: _ListView_SetCallBackMask
; ===============================================================================================================================
Func _ListView_GetCallbackMask($hWnd)
  Local $iFlags=0, $iMask

  $iMask = _API_SendMessage($hWnd, $LVM_GETCALLBACKMASK, 0, 0)
  if BitAND($iMask, $LVIS_CUT           ) <> 0 then $iFlags = BitOR($iFlags,  1)
  if BitAND($iMask, $LVIS_DROPHILITED   ) <> 0 then $iFlags = BitOR($iFlags,  2)
  if BitAND($iMask, $LVIS_FOCUSED       ) <> 0 then $iFlags = BitOR($iFlags,  4)
  if BitAND($iMask, $LVIS_SELECTED      ) <> 0 then $iFlags = BitOR($iFlags,  8)
  if BitAND($iMask, $LVIS_OVERLAYMASK   ) <> 0 then $iFlags = BitOR($iFlags, 16)
  if BitAND($iMask, $LVIS_STATEIMAGEMASK) <> 0 then $iFlags = BitOR($iFlags, 32)
  Return $iFlags
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the attributes of a column
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of column
; Return values .: Success      - Array with the following format:
;                  |[0] - Alignment of the column header and the subitem text in the column:
;                  | 0 - Text is left-aligned
;                  | 1 - Text is right-aligned
;                  | 2 - Text is centered
;                  |[1] - True if item displays an image from an image list
;                  |[2] - True if bitmap appears to the right of text
;                  |[3] - True header contains an image
;                  |[4] - Width of the column, in pixels
;                  |[5] - Column header text
;                  |[6] - Index of subitem associated with the column
;                  |[7] - Zero-based index of an image within the image list
;                  |[8] - Zero-based column order
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_SetColumn
; ===============================================================================================================================
Func _ListView_GetColumn($hWnd, $iIndex)
  Local $pBuffer, $tBuffer, $iColumn, $pColumn, $tColumn, $pMemory, $tMemMap, $pText, $aColumn[9], $iResult

  $tBuffer = DllStructCreate("char Text[4096]")
  $pBuffer = DllStructGetPtr($tBuffer)
  $tColumn = DllStructCreate($tagLVCOLUMN)
  $pColumn = DllStructGetPtr($tColumn)
  DllStructSetData($tColumn, "Mask"   , $LVCF_ALLDATA)
  DllStructSetData($tColumn, "TextMax", 4096         )
  if _Lib_InProcess($hWnd, $ghLVLastWnd) then
    DllStructSetData($tColumn, "Text", $pBuffer)
    $iResult = _API_SendMessage($hWnd, $LVM_GETCOLUMN, $iIndex, $pColumn)
  else
    $iColumn = DllStructGetSize($tColumn)
    $pMemory = _Mem_CtrlInit($hWnd, $iColumn + 4096, $tMemMap)
    $pText   = $pMemory + $iColumn
    DllStructSetData($tColumn, "Text", $pText)
    _Mem_CtrlWrite($tMemMap, $pColumn, $pMemory, $iColumn)
    $iResult = _API_SendMessage($hWnd, $LVM_GETCOLUMN, $iIndex, $pMemory)
    _Mem_CtrlRead($tMemMap, $pMemory, $pColumn, $iColumn)
    _Mem_CtrlRead($tMemMap, $pText  , $pBuffer, 4096    )
    _Mem_CtrlFree($tMemMap)
  endif
  Switch BitAND(DllStructGetData($tColumn, "Fmt"), $LVCFMT_JUSTIFYMASK)
    case $LVCFMT_RIGHT
      $aColumn[0] = 1
    case $LVCFMT_CENTER
      $aColumn[0] = 2
    case else
      $aColumn[0] = 0
  EndSwitch
  $aColumn[1] = BitAND(DllStructGetData($tColumn, "Fmt"), $LVCFMT_IMAGE          ) <> 0
  $aColumn[2] = BitAND(DllStructGetData($tColumn, "Fmt"), $LVCFMT_BITMAP_ON_RIGHT) <> 0
  $aColumn[3] = BitAND(DllStructGetData($tColumn, "Fmt"), $LVCFMT_COL_HAS_IMAGES ) <> 0
  $aColumn[4] = DllStructGetData($tColumn, "CX"     )
  $aColumn[5] = DllStructGetData($tBuffer, "Text"   )
  $aColumn[6] = DllStructGetData($tColumn, "SubItem")
  $aColumn[7] = DllStructGetData($tColumn, "Image"  )
  $aColumn[8] = DllStructGetData($tColumn, "Order"  )
  Return SetError($iResult=0, 0, $aColumn)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the number of columns in the control
; Parameters ....: $hWnd        - Handle to the control
; Return values .: Success      - Column count
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_SetItemCount
; ===============================================================================================================================
Func _ListView_GetColumnCount($hWnd)
  Return _Header_GetItemCount(_ListView_GetHeader($hWnd))
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the current left-to-right order of columns in the control
; Parameters ....: $hWnd        - Handle to the control
; Return values .: Success      - Array with the following format:
;                  |[0] - Number of items in array (n)
;                  |[1] - First column index
;                  |[2] - First column index
;                  |[n] - Last column index
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_SetColumnOrderArray
; ===============================================================================================================================
Func _ListView_GetColumnOrderArray($hWnd)
  Local $iI, $iBuffer, $pBuffer, $tBuffer, $iColumns, $pMemory, $tMemMap

  $iColumns = _ListView_GetColumnCount($hWnd)
  $tBuffer  = DllStructCreate("int[" & $iColumns & "]")
  $pBuffer  = DllStructGetPtr($tBuffer)
  if _Lib_InProcess($hWnd, $ghLVLastWnd) then
    _API_SendMessage($hWnd, $LVM_GETCOLUMNORDERARRAY, $iColumns, $pBuffer)
  else
    $iBuffer = DllStructGetSize($tBuffer)
    $pMemory = _Mem_CtrlInit($hWnd, $iBuffer, $tMemMap)
    _API_SendMessage($hWnd, $LVM_GETCOLUMNORDERARRAY, $iColumns, $pMemory)
    _Mem_CtrlRead($tMemMap, $pMemory, $pBuffer, $iBuffer)
    _Mem_CtrlFree($tMemMap)
  endif

  Dim $aBuffer[$iColumns + 1]
  $aBuffer[0] = $iColumns
  for $iI = 1 to $iColumns
    $aBuffer[$iI] = DllStructGetData($tBuffer, 1, $iI)
  next
  Return $aBuffer
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the width of a column in report or list view mode
; Parameters ....: $hWnd        - Handle to the control
;                  $iColumn     - Zero based index of column. This parameter is ignored in list view.
; Return values .: Success      - Column width
;                  Failure      - 0
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_SetColumnWidth
; ===============================================================================================================================
Func _ListView_GetColumnWidth($hWnd, $iColumn)
  Return _API_SendMessage($hWnd, $LVM_GETCOLUMNWIDTH, $iColumn, 0)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Calculates the number of items that can fit vertically in the control
; Parameters ....: $hWnd        - Handle to the control
; Return values .: Success      - The number of fully visible items
;                  Failure      - 0
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......:
; ===============================================================================================================================
Func _ListView_GetCountPerPage($hWnd)
  Return _API_SendMessage($hWnd, $LVM_GETCOUNTPERPAGE, 0, 0)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the handle to the edit control being used to edit an item's text
; Parameters ....: $hWnd        - Handle to the control
; Return values .: Success      - The handle to the edit control
;                  Failure      - 0
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: When label editing begins, an edit control is created, positioned,  and  initialized.  Before  displayed,  the
;                  control sends its parent window an $LVN_BEGINLABELEDIT notification message.  If you want to  customize  label
;                  editing implement a handler for $LVN_BEGINLABELEDIT and have it send an  $LVM_GETEDITCONTROL  message  to  the
;                  control. If a label is being edited, the return value will be a handle to the edit control. Use this handle to
;                  customize the edit control by sending the usual EM_XXX messages. When the user completes or  cancels  editing,
;                  the edit control is destroyed and the handle is no longer valid.  You can subclass the edit control,  but  you
;                  should not destroy it.  To cancel editing, send the control a $WM_CANCELMODE message.  The control item  being
;                  edited is the currently focused item. To find an item based on its state, use the $LVM_GETNEXTITEM message.
; Related .......: _ListView_CancelEditLabel
; ===============================================================================================================================
Func _ListView_GetEditControl($hWnd)
  Return _API_SendMessage($hWnd, $LVM_GETEDITCONTROL, 0, 0)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the extended styles that are currently in use for the control
; Parameters ....: $hWnd        - Handle to the control
; Return values .: Success      - Styles currently in use:
;                  |$LVS_EX_BORDERSELECT     - When an item is selected the border color of the item changes
;                  |$LVS_EX_CHECKBOXES       - Enables check boxes for items in a list-view control
;                  |$LVS_EX_DOUBLEBUFFER     - Paints via double-buffering, which reduces flicker
;                  |$LVS_EX_FLATSB           - Enables flat scroll bars in the list view
;                  |$LVS_EX_FULLROWSELECT    - When an item is selected, the item and all its subitems are highlighted
;                  |$LVS_EX_GRIDLINES        - Displays gridlines around items and subitems
;                  |$LVS_EX_HEADERDRAGDROP   - Enables drag-and-drop reordering of columns
;                  |$LVS_EX_INFOTIP          - The $LVN_GETINFOTIP notification message is sent before displaying a ToolTip
;                  |$LVS_EX_LABELTIP         - If not set, the unfolds partly hidden labels only for the large icon mode
;                  |$LVS_EX_MULTIWORKAREAS   - The control will not autoarrange its icons until one or more work areas are defined
;                  |$LVS_EX_ONECLICKACTIVATE - The control sends an $LVN_ITEMACTIVATE messages when the user clicks an item
;                  |$LVS_EX_REGIONAL         - Sets the control region to include only the item icons and text
;                  |$LVS_EX_SIMPLESELECT     - In icon view moves the state image of the control to the top right
;                  |$LVS_EX_SUBITEMIMAGES    - Allows images to be displayed for subitems
;                  |$LVS_EX_TRACKSELECT      - Enables hot-track selection in the control
;                  |$LVS_EX_TWOCLICKACTIVATE - The control sends an $LVN_ITEMACTIVATE message when the user double-clicks an item
;                  |$LVS_EX_UNDERLINECOLD    - Causes non-hot items that may be activated to be displayed with underlined text
;                  |$LVS_EX_UNDERLINEHOT     - Causes hot items that may be activated to be displayed with underlined text
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_SetExtendedListViewStyle
; ===============================================================================================================================
Func _ListView_GetExtendedListViewStyle($hWnd)
  Return _API_SendMessage($hWnd, $LVM_GETEXTENDEDLISTVIEWSTYLE, 0, 0)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves group information
; Parameters ....: $hWnd        - Handle to the control
;                  $iGroupID    - ID that specifies the group whose information is retrieved
; Return values .: Success      - Array with the following format:
;                  |[0] - Header text
;                  |[1] - Header alignment:
;                  | 0 - Left
;                  | 1 - Center
;                  | 2 - Right
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: Windows XP only
; Related .......: _ListView_SetGroupInfo
; ===============================================================================================================================
Func _ListView_GetGroupInfo($hWnd, $iGroupID)
  Local $iGroup, $pGroup, $tGroup, $aGroup[2], $tMemMap, $pMemory, $iResult

  $tGroup = DllStructCreate ($tagLVGROUP)
  $pGroup = DllStructGetPtr ($tGroup)
  $iGroup = DllStructGetSize($tGroup)
  DllStructSetData($tGroup, "Size", $iGroup)
  DllStructSetData($tGroup, "Mask", BitOR($LVGF_HEADER, $LVGF_ALIGN))
  if _Lib_InProcess($hWnd, $ghLVLastWnd) then
    $iResult = _API_SendMessage($hWnd, $LVM_GETGROUPINFO, $iGroupID, $pGroup )
  else
    $pMemory = _Mem_CtrlInit($hWnd, $iGroup, $tMemMap)
    _Mem_CtrlWrite($tMemMap, $pGroup, $pMemory, $iGroup)
    $iResult = _API_SendMessage($hWnd, $LVM_GETGROUPINFO, $iGroupID, $pMemory)
    _Mem_CtrlRead($tMemMap, $pMemory, $pGroup, $iGroup)
    _Mem_CtrlFree($tMemMap)
  endif
  $aGroup[0] = _API_WideCharToMultiByte(DllStructGetData($tGroup, "Header"))
  Select
    case BitAND(DllStructGetData($tGroup, "Align"), $LVGA_HEADER_CENTER) <> 0
      $aGroup[1] = 1
    case BitAND(DllStructGetData($tGroup, "Align"), $LVGA_HEADER_RIGHT ) <> 0
      $aGroup[1] = 2
    case else
      $aGroup[1] = 0
  EndSelect
  Return SetError($iResult<>$iGroupID, 0, $aGroup)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Checks whether the control has group view enabled
; Parameters ....: $hWnd        - Handle to the control
; Return values .: Success      - Group view setting:
;                  | True - Group view is enabled
;                  |False - Group view is not enabled
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_EnableGroupView
; ===============================================================================================================================
Func _ListView_GetGroupViewEnabled($hWnd)
  Return _API_SendMessage($hWnd, $LVM_ISGROUPVIEWENABLED, 0, 0) <> 0
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the handle to the header control used by the control
; Parameters ....: $hWnd        - Handle to the control
; Return values .: Success      - Handle to the header control
;                  Failure      - 0
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......:
; ===============================================================================================================================
Func _ListView_GetHeader($hWnd)
  Return _API_SendMessage($hWnd, $LVM_GETHEADER, 0, 0)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves a handle to the cursor used when the pointer is over an item
; Parameters ....: $hWnd        - Handle to the control
; Return values .: Success      - Cursor handle
;                  Failure      - 0
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_SetHotCursor
; ===============================================================================================================================
Func _ListView_GetHotCursor($hWnd)
  Return _API_SendMessage($hWnd, $LVM_GETHOTCURSOR, 0, 0)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the index of the hot item
; Parameters ....: $hWnd        - Handle to the control
; Return values .: Success      - Zero based index of the item that is hot
;                  Failure      - -1
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_SetHotItem
; ===============================================================================================================================
Func _ListView_GetHotItem($hWnd)
  Return _API_SendMessage($hWnd, $LVM_GETHOTITEM, 0, 0)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the time that the cursor must hover over an item before it is selected
; Parameters ....: $hWnd        - Handle to the control
; Return values .: Success      - Time in milliseconds. If the return value is -1, then the hover time is the default hover time.
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: The hover time only affects ListView controls that have the $LVS_EX_TRACKSELECT, $LVS_EX_ONECLICKACTIVATE,  or
;                  $LVS_EX_TWOCLICKACTIVATE extended style.
; Related .......: _ListView_SetHoverTime
; ===============================================================================================================================
Func _ListView_GetHoverTime($hWnd)
  Return _API_SendMessage($hWnd, $LVM_GETHOVERTIME, 0, 0)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the handle to an image list used for drawing listview items
; Parameters ....: $hWnd        - Handle to the control
;                  $iImageList  - Image list to retrieve:
;                  |0 - Image list with large icons
;                  |1 - Image list with small icons
;                  |2 - Image list with state images
; Return values .: Success      - The handle to the specified image list
;                  Failure      - 0
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_SetImageList
; ===============================================================================================================================
Func _ListView_GetImageList($hWnd, $iImageList)
  Local $aImageList[3]=[$LVSIL_NORMAL, $LVSIL_SMALL, $LVSIL_STATE]

  Return _API_SendMessage($hWnd, $LVM_GETIMAGELIST, $aImageList[$iImageList], 0)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the position of the insertion point
; Parameters ....: $hWnd        - Handle to the control
; Return values .: Success      - Array with the following format:
;                  |[0] - True if the insertion point appears after the item, otherwise False
;                  |[1] - Item next to which the insertion point appears.  If this is -1, there is no insertion point.
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: Windows XP only.  An insertion point can appear only if the control is in icon view, small icon view, or  tile
;                  view, and is not in group view  mode.
; Related .......: _ListView_SetInsertMark
; ===============================================================================================================================
Func _ListView_GetInsertMark($hWnd)
  Local $iMark, $pMark, $tMark, $pMemory, $tMemMap, $aMark[2], $iResult

  $tMark = DllStructCreate ($tagLVINSERTMARK)
  $pMark = DllStructGetPtr ($tMark)
  $iMark = DllStructGetSize($tMark)
  DllStructSetData($tMark, "Size", $iMark)
  if _Lib_InProcess($hWnd, $ghLVLastWnd) then
    $iResult = _API_SendMessage($hWnd, $LVM_GETINSERTMARK, 0, $pMark  )
  else
    $pMemory = _Mem_CtrlInit($hWnd, $iMark, $tMemMap)
    _Mem_CtrlWrite($tMemMap, $pMark)
    $iResult = _API_SendMessage($hWnd, $LVM_GETINSERTMARK, 0, $pMemory)
    _Mem_CtrlRead($tMemMap, $pMemory, $pMark, $iMark)
    _Mem_CtrlFree($tMemMap)
  endif
  $aMark[0] = DllStructGetData($tMark, "Flags") = $LVIM_AFTER
  $aMark[1] = DllStructGetData($tMark, "Item")
  Return SetError($iResult=0, 0, $aMark)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the color of the insertion point
; Parameters ....: $hWnd        - Handle to the control
; Return values .: Success      - Color of the insertion point
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: Windows XP only
; Related .......: _ListView_SetInsertMarkColor
; ===============================================================================================================================
Func _ListView_GetInsertMarkColor($hWnd)
  Return _API_SendMessage($hWnd, $LVM_GETINSERTMARKCOLOR, $LVSIL_STATE, 0)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the rectangle that bounds the insertion point
; Parameters ....: $hWnd        - Handle to the control
; Return values .: Success      - Array with the following format:
;                  |[0] = True if insertion point found, otherwise False
;                  |[1] = X coordinate of the upper left corner of the rectangle
;                  |[2] = Y coordinate of the upper left corner of the rectangle
;                  |[3] = X coordinate of the lower right corner of the rectangle
;                  |[4] = Y coordinate of the lower right corner of the rectangle
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: Windows XP only
; Related .......:
; ===============================================================================================================================
Func _ListView_GetInsertMarkRect($hWnd)
  Local $iRect, $pRect, $tRect, $pMemory, $tMemMap, $aRect[5]

  $tRect = DllStructCreate($tagRECT)
  $pRect = DllStructGetPtr($tRect)
  if _Lib_InProcess($hWnd, $ghLVLastWnd) then
    $aRect[0] = _API_SendMessage($hWnd, $LVM_GETINSERTMARKRECT, 0, $pRect  ) <> 0
  else
    $iRect    = DllStructGetSize($tRect)
    $pMemory  = _Mem_CtrlInit($hWnd, $iRect, $tMemMap)
    $aRect[0] = _API_SendMessage($hWnd, $LVM_GETINSERTMARKRECT, 0, $pMemory) <> 0
    _Mem_CtrlRead($tMemMap, $pMemory, $pRect, $iRect)
    _Mem_CtrlFree($tMemMap)
  endif
  $aRect[1] = DllStructGetData($tRect, "Left"  )
  $aRect[2] = DllStructGetData($tRect, "Top"   )
  $aRect[3] = DllStructGetData($tRect, "Right" )
  $aRect[4] = DllStructGetData($tRect, "Bottom")
  Return $aRect
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the incremental search string of the control
; Parameters ....: $hWnd        - Handle to the control
; Return values .: Success      - Incremental search string or a blank string if no search string exists
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......:
; ===============================================================================================================================
Func _ListView_GetISearchString($hWnd)
  Local $iBuffer, $pBuffer, $tBuffer, $pMemory, $tMemMap

  $iBuffer = _API_SendMessage($hWnd, $LVM_GETISEARCHSTRING, 0, 0) + 1
  if $iBuffer = 1 then Return ""
  $tBuffer = DllStructCreate("char Text[" & $iBuffer & "]")
  $pBuffer = DllStructGetPtr($tBuffer)
  if _Lib_InProcess($hWnd, $ghLVLastWnd) then
    _API_SendMessage($hWnd, $LVM_GETISEARCHSTRING, 0, $pBuffer)
  else
    $pMemory = _Mem_CtrlInit($hWnd, $iBuffer, $tMemMap)
    _API_SendMessage($hWnd, $LVM_GETISEARCHSTRING, 0, $pMemory)
    _Mem_CtrlRead($tMemMap, $pMemory, $pBuffer, $iBuffer)
    _Mem_CtrlFree($tMemMap)
  endif
  Return DllStructGetData($tBuffer, "Text")
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves an item's attributes
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based item index
;                  $iSubItem    - One based subitem index
; Return values .: Success      - Array with the following format:
;                  |[0] - Item state, which can be a combination of the following:
;                  | 1 - The item is marked for a cut-and-paste operation
;                  | 2 - The item is highlighted as a drag-and-drop target
;                  | 4 - The item has the focus
;                  | 8 - The item is selected
;                  |[1] - One based item image overlay index
;                  |[2] - One based item state image index
;                  |[3] - Item text
;                  |[4] - Zero based item image index
;                  |[5] - Item application defined value
;                  |[6] - Number of image widths to indent the item
;                  |[7] - Identifier of the tile view group that receives the item
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_SetItem
; ===============================================================================================================================
Func _ListView_GetItem($hWnd, $iIndex, $iSubItem=0)
  Local $iState, $tItem, $aItem[8]

  $tItem = DllStructCreate($tagLVITEM)
  DllStructSetData($tItem, "Mask"     , BitOR($LVIF_GROUPID, $LVIF_IMAGE, $LVIF_INDENT, $LVIF_PARAM, $LVIF_STATE))
  DllStructSetData($tItem, "Item"     , $iIndex  )
  DllStructSetData($tItem, "SubItem"  , $iSubItem)
  DllStructSetData($tItem, "StateMask", -1       )
  _ListView_GetItemEx($hWnd, $tItem)
  $iState   = DllStructGetData($tItem, "State")
  if BitAND($iState, $LVIS_CUT        ) <> 0 then $aItem[0] = BitOR($aItem[0], 1)
  if BitAND($iState, $LVIS_DROPHILITED) <> 0 then $aItem[0] = BitOR($aItem[0], 2)
  if BitAND($iState, $LVIS_FOCUSED    ) <> 0 then $aItem[0] = BitOR($aItem[0], 4)
  if BitAND($iState, $LVIS_SELECTED   ) <> 0 then $aItem[0] = BitOR($aItem[0], 8)
  $aItem[1] = _ListView_OverlayImageMaskToIndex($iState)
  $aItem[2] = _ListView_StateImageMaskToIndex  ($iState)
  $aItem[3] = _ListView_GetItemText($hWnd, $iIndex, $iSubItem)
  $aItem[4] = DllStructGetData($tItem, "Image"  )
  $aItem[5] = DllStructGetData($tItem, "Param"  )
  $aItem[6] = DllStructGetData($tItem, "Indent" )
  $aItem[7] = DllStructGetData($tItem, "GroupID")
  Return $aItem
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves some or all of an item's attributes
; Parameters ....: $hWnd        - Handle to the control
;                  $tItem       - tagLVITEM structure that specifies the information to retrieve
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetItem, tagLVITEM
; ===============================================================================================================================
Func _ListView_GetItemEx($hWnd, ByRef $tItem)
  Local $iItem, $pItem, $pMemory, $tMemMap, $iResult

  $pItem = DllStructGetPtr($tItem)
  if _Lib_InProcess($hWnd, $ghLVLastWnd) then
    $iResult = _API_SendMessage($hWnd, $LVM_GETITEM, 0, $pItem)
  else
    $iItem   = DllStructGetSize($tItem)
    $pMemory = _Mem_CtrlInit($hWnd, $iItem, $tMemMap)
    _Mem_CtrlWrite($tMemMap, $pItem)
    _API_SendMessage($hWnd, $LVM_GETITEM, 0, $pMemory)
    _Mem_CtrlRead($tMemMap, $pMemory, $pItem, $iItem)
    _Mem_CtrlFree($tMemMap)
  endif
  Return $iResult
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Gets the checked state of an item
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
; Return values .: True         - Item is checked
;                  False        - Item is not checked
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: Use only on controls that have the $LVS_EX_CHECKBOXES extended style
; Related .......: _ListView_SetItemChecked
; ===============================================================================================================================
Func _ListView_GetItemChecked($hWnd, $iIndex)
  Local $iExStyle

  $iExStyle = _API_GetWindowLong($hWnd, $GWL_EXSTYLE)
  if BitAND($iExStyle, $LVS_EX_CHECKBOXES) = 0 then Return SetError(-1, -1, False)
  Return _ListView_GetItemStateImage($hWnd, $iIndex) = 2
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the number of items in the control
; Parameters ....: $hWnd        - Handle to the control
; Return values .: Success      - Item count
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......:
; ===============================================================================================================================
Func _ListView_GetItemCount($hWnd)
  Return _API_SendMessage($hWnd, $LVM_GETITEMCOUNT, 0, 0)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Determines whether the item is marked for a cut and paste operation
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
; Return values .: True         - Item is marked for a cut and paste operation
;                  False        - Item is not marked for a cut and paste operation
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_SetItemCut
; ===============================================================================================================================
Func _ListView_GetItemCut($hWnd, $iIndex)
  Return _ListView_GetItemState($hWnd, $iIndex, $LVIS_CUT) <> 0
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Determines whether the item is highlighted as a drag-and-drop target
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_SetItemDropHilited
; ===============================================================================================================================
Func _ListView_GetItemDropHilited($hWnd, $iIndex)
  Return _ListView_GetItemState($hWnd, $iIndex, $LVIS_DROPHILITED) <> 0
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Determines whether the item is highlighted as a drag-and-drop target
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_SetItemFocused
; ===============================================================================================================================
Func _ListView_GetItemFocused($hWnd, $iIndex)
  Return _ListView_GetItemState($hWnd, $iIndex, $LVIS_FOCUSED) <> 0
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Gets the item group ID
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
; Return values .: Success      - Item group ID
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: Windows XP Only
; Related .......: _ListView_SetItemGroupID
; ===============================================================================================================================
func _ListView_GetItemGroupID($hWnd, $iIndex)
  Local $tItem

  $tItem = DllStructCreate($tagLVITEM)
  DllStructSetData($tItem, "Mask", $LVIF_GROUPID)
  DllStructSetData($tItem, "Item", $iIndex      )
  _ListView_GetItemEx($hWnd, $tItem)
  Return DllStructGetData($tItem, "GroupID")
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the index of the item's icon
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based item index
;                  $iSubItem    - One based item sub item index
; Return values .: Success      - Zero based item image index
;                  Failue       - -1
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_SetItemImage
; ===============================================================================================================================
Func _ListView_GetItemImage($hWnd, $iIndex, $iSubItem=0)
  Local $tItem

  $tItem = DllStructCreate($tagLVITEM)
  DllStructSetData($tItem, "Mask", $LVIF_IMAGE)
  DllStructSetData($tItem, "Item", $iIndex    )
  DllStructSetData($tItem, "SubItem", $iSubItem)
  _ListView_GetItemEx($hWnd, $tItem)
  Return DllStructGetData($tItem, "Image")
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the number of image widths the item is indented
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based item index
; Return values .: Success      - Item indention
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_SetItemIndent
; ===============================================================================================================================
Func _ListView_GetItemIndent($hWnd, $iIndex)
  Local $tItem

  $tItem = DllStructCreate($tagLVITEM)
  DllStructSetData($tItem, "Mask", $LVIF_INDENT)
  DllStructSetData($tItem, "Item", $iIndex     )
  _ListView_GetItemEx($hWnd, $tItem)
  Return DllStructGetData($tItem, "Indent")
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Gets the overlay image that is superimposed over the item's icon image
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
; Return values .: Success      - Zero based image index
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: This function is used internally by Auto3Lib and should not normally be called
; Related .......: _ListView_SetItemOverlayImage
; ===============================================================================================================================
Func _ListView_GetItemOverlayImage($hWnd, $iIndex)
  Return BitShift(_ListView_GetItemState($hWnd, $iIndex, $LVIS_OVERLAYMASK), 8)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the application specific value of the item
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based item index
; Return values .: Success      - Application specific value
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_SetItemParam
; ===============================================================================================================================
Func _ListView_GetItemParam($hWnd, $iIndex)
  Local $tItem

  $tItem = DllStructCreate($tagLVITEM)
  DllStructSetData($tItem, "Mask", $LVIF_PARAM)
  DllStructSetData($tItem, "Item", $iIndex    )
  _ListView_GetItemEx($hWnd, $tItem)
  Return DllStructGetData($tItem, "Param")
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the position of an item
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
; Return values .: Success      - Array with the following format:
;                  |[0] - X position of item
;                  |[1] - Y position of item
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_SetItemPosition
; ===============================================================================================================================
Func _ListView_GetItemPosition($hWnd, $iIndex)
  Local $iPoint, $pPoint, $tPoint, $pMemory, $tMemMap, $aPoint[2], $iResult

  $tPoint = DllStructCreate($tagPOINT)
  $pPoint = DllStructGetPtr($tPoint)
  if _Lib_InProcess($hWnd, $ghLVLastWnd) then
    $iResult = _API_SendMessage($hWnd, $LVM_GETITEMPOSITION, $iIndex, $pPoint)
  else
    $iPoint  = DllStructGetSize($tPoint)
    $pMemory = _Mem_CtrlInit($hWnd, $iPoint, $tMemMap)
    $iResult = _API_SendMessage($hWnd, $LVM_GETITEMPOSITION, $iIndex, $pMemory)
    _Mem_CtrlRead($tMemMap, $pMemory, $pPoint, $iPoint)
    _Mem_CtrlFree($tMemMap)
  endif
  $aPoint[0] = DllStructGetData($tPoint, "X")
  $aPoint[1] = DllStructGetData($tPoint, "Y")
  Return SetError($iResult=0, 0, $aPoint)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the X position of an item
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
; Return values .: Success      - X position of item
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetItemPosition
; ===============================================================================================================================
Func _ListView_GetItemPositionX($hWnd, $iIndex)
  Local $aPoint

  $aPoint = _ListView_GetItemPosition($hWnd, $iIndex)
  Return $aPoint[0]
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the Y position of an item
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
; Return values .: Success      - Y position of item
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetItemPosition
; ===============================================================================================================================
Func _ListView_GetItemPositionY($hWnd, $iIndex)
  Local $aPoint

  $aPoint = _ListView_GetItemPosition($hWnd, $iIndex)
  Return $aPoint[1]
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the bounding rectangle for all or part of an item
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
;                  $iPart       - The portion of the item to retrieve:
;                  |0 - The bounding rectangle of the entire item
;                  |1 - The bounding rectangle of the icon or small icon
;                  |2 - The bounding rectangle of the item text
;                  |3 - The union of 1 and 2, but excludes columns in report view
; Return values .: Success      - Array with the following format:
;                  |[0] - X coordinate of the upper left corner of the rectangle
;                  |[1] - Y coordinate of the upper left corner of the rectangle
;                  |[2] - X coordinate of the lower right corner of the rectangle
;                  |[3] - Y coordinate of the lower right corner of the rectangle
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetItemRectEx
; ===============================================================================================================================
Func _ListView_GetItemRect($hWnd, $iIndex, $iPart=3)
  Local $tRect, $aRect[4]

  $tRect = _ListView_GetItemRectEx($hWnd, $iIndex, $iPart)
  $aRect[0] = DllStructGetData($tRect, "Left"  )
  $aRect[1] = DllStructGetData($tRect, "Top"   )
  $aRect[2] = DllStructGetData($tRect, "Right" )
  $aRect[3] = DllStructGetData($tRect, "Bottom")
  Return $aRect
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the bounding rectangle for all or part of an item
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
;                  $iPart       - The portion of the item to retrieve:
;                  |$LVIR_BOUNDS       - Returns the bounding rectangle of the entire item, including the icon and label
;                  |$LVIR_ICON         - Returns the bounding rectangle of the icon or small icon
;                  |$LVIR_LABEL        - Returns the bounding rectangle of the item text
;                  |$LVIR_SELECTBOUNDS - Returns the union of the $LVIR_ICON and $LVIR_LABEL rectangles, but excludes columns  in
;                  +report view.
; Return values .: Success      - tagRECT structure
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetItemRect, tagRECT
; ===============================================================================================================================
Func _ListView_GetItemRectEx($hWnd, $iIndex, $iPart=3)
  Local $iRect, $pRect, $tRect, $pMemory, $tMemMap

  $tRect = DllStructCreate($tagRECT)
  $pRect = DllStructGetPtr($tRect)
  DllStructSetData($tRect, "Left", $iPart)
  if _Lib_InProcess($hWnd, $ghLVLastWnd) then
    _API_SendMessage($hWnd, $LVM_GETITEMRECT, $iIndex, $pRect  )
  else
    $iRect   = DllStructGetSize($tRect)
    $pMemory = _Mem_CtrlInit($hWnd, $iRect, $tMemMap)
    _Mem_CtrlWrite($tMemMap, $pRect, $pMemory, $iRect)
    _API_SendMessage($hWnd, $LVM_GETITEMRECT, $iIndex, $pMemory)
    _Mem_CtrlRead($tMemMap, $pMemory, $pRect, $iRect)
    _Mem_CtrlFree($tMemMap)
  endif
  Return $tRect
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Determines whether the item is selected
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_SetItemSelected
; ===============================================================================================================================
Func _ListView_GetItemSelected($hWnd, $iIndex)
  Return _ListView_GetItemState($hWnd, $iIndex, $LVIS_SELECTED) <> 0
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Determines the spacing between items in the control
; Parameters ....: $hWnd        - Handle to the control
;                  $fSmall      - View for which to retrieve the item spacing:
;                  | True - Small icon view
;                  |False - Icon view
; Return values .: Success      - Array with the following format:
;                  |[0] - Horizontal spacing
;                  |[1] - Vertical spacing
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......:
; ===============================================================================================================================
Func _ListView_GetItemSpacing($hWnd, $fSmall=False)
  Local $iSpace, $aSpace[2]

  $iSpace = _API_SendMessage($hWnd, $LVM_GETITEMSPACING, $fSmall, 0)
  $aSpace[0] = _Lib_LoWord($iSpace)
  $aSpace[1] = _Lib_HiWord($iSpace)
  Return $aSpace
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Determines the horizontal spacing between items in the control
; Parameters ....: $hWnd        - Handle to the control
;                  $fSmall      - View for which to retrieve the item spacing:
;                  | True - Small icon view
;                  |False - Icon view
; Return values .: Success      - Horizontal spacing
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetItemSpacing
; ===============================================================================================================================
Func _ListView_GetItemSpacingX($hWnd, $fSmall=False)
  Return _Lib_LoWord(_API_SendMessage($hWnd, $LVM_GETITEMSPACING, $fSmall, 0))
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Determines the vertical spacing between items in the control
; Parameters ....: $hWnd        - Handle to the control
;                  $fSmall      - View for which to retrieve the item spacing:
;                  | True - Small icon view
;                  |False - Icon view
; Return values .: Success      - Vertical spacing
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetItemSpacing
; ===============================================================================================================================
Func _ListView_GetItemSpacingY($hWnd, $fSmall=False)
  Return _Lib_HiWord(_API_SendMessage($hWnd, $LVM_GETITEMSPACING, $fSmall, 0))
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the state of a listview item
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
;                  $iMask       - State information to retrieve. This can be a combination of:
;                  |$LVIS_CUT            - The item is marked for a cut-and-paste operation
;                  |$LVIS_DROPHILITED    - The item is highlighted as a drag-and-drop target
;                  |$LVIS_FOCUSED        - The item has the focus, so it is surrounded by a standard focus rectangle
;                  |$LVIS_SELECTED       - The item is selected
;                  |$LVIS_OVERLAYMASK    - Use this mask to retrieve the item's overlay image index
;                  |$LVIS_STATEIMAGEMASK - Use this mask to retrieve the item's state image index
; Return values .: Success      - The current state for the specified item
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: An items state information includes a set of bit flags as well as image list indexes that indicate the  item's
;                  state image and overlay image
; Related .......: _ListView_SetItemState
; ===============================================================================================================================
Func _ListView_GetItemState($hWnd, $iIndex, $iMask)
  Return _API_SendMessage($hWnd, $LVM_GETITEMSTATE, $iIndex, $iMask)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Gets the state image that is displayed
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
; Return values .: Success      - One based overlay image index
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_SetItemStateImage
; ===============================================================================================================================
Func _ListView_GetItemStateImage($hWnd, $iIndex)
  Return BitShift(_ListView_GetItemState($hWnd, $iIndex, $LVIS_STATEIMAGEMASK), 12)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the text of an item or subitem
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
;                  $iSubItem    - One based sub item index
; Return values .: Success      - Item or subitem text
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: To retrieve the item text, set iSubItem to zero. To retrieve the text of a subitem, set iSubItem  to  the  one
;                  based subitem's index.
; Related .......: _ListView_SetItemText
; ===============================================================================================================================
Func _ListView_GetItemText($hWnd, $iIndex, $iSubItem=0)
  Local $pBuffer, $tBuffer, $iItem, $pItem, $tItem, $pMemory, $tMemMap, $pText

  $tBuffer = DllStructCreate("char Text[4096]")
  $pBuffer = DllStructGetPtr($tBuffer)
  $tItem   = DllStructCreate($tagLVITEM)
  $pItem   = DllStructGetPtr($tItem  )
  DllStructSetData($tItem, "SubItem", $iSubItem)
  DllStructSetData($tItem, "TextMax", 4096     )
  if _Lib_InProcess($hWnd, $ghLVLastWnd) then
    DllStructSetData($tItem, "Text", $pBuffer)
    _API_SendMessage($hWnd, $LVM_GETITEMTEXT, $iIndex, $pItem)
  else
    $iItem   = DllStructGetSize($tItem)
    $pMemory = _Mem_CtrlInit($hWnd, $iItem + 4096, $tMemMap)
    $pText   = $pMemory + $iItem
    DllStructSetData($tItem, "Text", $pText)
    _Mem_CtrlWrite($tMemMap, $pItem, $pMemory, $iItem)
    _API_SendMessage($hWnd, $LVM_GETITEMTEXT, $iIndex, $pMemory)
    _Mem_CtrlRead($tMemMap, $pText, $pBuffer, 4096)
    _Mem_CtrlFree($tMemMap)
  endif
  Return DllStructGetData($tBuffer, "Text")
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Searches for an item that has the specified properties
; Parameters ....: $hWnd        - Handle to the control
;                  $iStart      - Index of the item to begin the search with, or -1 to find  the  first  item  that  matches  the
;                  +specified flags.  The specified item itself is excluded from the search.
;                  $iSearch     - Relationship to the index of the item where the search is to begin:
;                  |0 - Searches for a subsequent item by index
;                  |1 - Searches for an item that is above the specified item
;                  |2 - Searches for an item that is below the specified item
;                  |3 - Searches for an item to the left of the specified item
;                  |4 - Searches for an item to the right of the specified item
;                  $iState      - State of the item to find. Can be a combination of:
;                  |1 - The item is cut
;                  |2 - The item is highlighted
;                  |4 - The item is focused
;                  |8 - The item is selected
; Return values .: Success      - The zero based index of the next item
;                  Failure      - -1
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......:
; ===============================================================================================================================
Func _ListView_GetNextItem($hWnd, $iStart=-1, $iSearch=0, $iState=8)
  Local $iFlags, $aSearch[5]=[$LVNI_ALL, $LVNI_ABOVE, $LVNI_BELOW, $LVNI_TOLEFT, $LVNI_TORIGHT]

  $iFlags = $aSearch[$iSearch]
  if BitAND($iState, 1) <> 0 then $iFlags = BitOR($iFlags, $LVNI_CUT        )
  if BitAND($iState, 2) <> 0 then $iFlags = BitOR($iFlags, $LVNI_DROPHILITED)
  if BitAND($iState, 4) <> 0 then $iFlags = BitOR($iFlags, $LVNI_FOCUSED    )
  if BitAND($iState, 8) <> 0 then $iFlags = BitOR($iFlags, $LVNI_SELECTED   )
  Return _API_SendMessage($hWnd, $LVM_GETNEXTITEM, $iStart, $iFlags)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the number of working areas in the control
; Parameters ....: $hWnd        - Handle to the control
; Return values .: Success      - Number of working areas
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_SetWorkAreas
; ===============================================================================================================================
Func _ListView_GetNumberOfWorkAreas($hWnd)
  Local $iBuffer, $pBuffer, $tBuffer, $tMemMap, $pMemMap, $pMemory

  $tBuffer = DllStructCreate("int Data")
  $pBuffer = DllStructGetPtr($tBuffer)
  if _Lib_InProcess($hWnd, $ghLVLastWnd) then
    _API_SendMessage($hWnd, $LVM_GETNUMBEROFWORKAREAS, 0, $pBuffer)
  else
    $iBuffer = DllStructGetSize($tBuffer)
    $pMemory = _Mem_CtrlInit($hWnd, $iBuffer, $tMemMap)
    _API_SendMessage($hWnd, $LVM_GETNUMBEROFWORKAREAS, 0, $pMemory)
    _Mem_CtrlRead($tMemMap, $pMemory, $pBuffer, $iBuffer)
    _Mem_CtrlFree($tMemMap)
  endif

  Return DllStructGetData($tBuffer, "Data")
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the current view origin for the control
; Parameters ....: $hWnd        - Handle to the control
; Return values .: Success      - Array with the following format:
;                  |[0] - View X position
;                  |[1] - View Y position
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetOriginX, _ListView_GetOriginY
; ===============================================================================================================================
Func _ListView_GetOrigin($hWnd)
  Local $iPoint, $pPoint, $tPoint, $pMemory, $tMemMap, $aOrigin[2]

  $tPoint = DllStructCreate($tagPOINT)
  $pPoint = DllStructGetPtr($tPoint)
  if _Lib_InProcess($hWnd, $ghLVLastWnd) then
    _API_SendMessage($hWnd, $LVM_GETORIGIN, 0, $pPoint )
  else
    $iPoint  = DllStructGetSize($tPoint)
    $pMemory = _Mem_CtrlInit($hWnd, $iPoint, $tMemMap)
    _API_SendMessage($hWnd, $LVM_GETORIGIN, 0, $pMemory)
    _Mem_CtrlRead($tMemMap, $pMemory, $pPoint, $iPoint)
    _Mem_CtrlFree($tMemMap)
  endif
  $aOrigin[0] = DllStructGetData($tPoint, "X")
  $aOrigin[1] = DllStructGetData($tPoint, "Y")
  Return $aOrigin
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the current horizontal view origin for the control
; Parameters ....: $hWnd        - Handle to the control
; Return values .: Success      - View X position
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetOrigin
; ===============================================================================================================================
Func _ListView_GetOriginX($hWnd)
  Local $aOrigin

  $aOrigin = _ListView_GetOrigin($hWnd)
  Return $aOrigin[0]
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the current horizontal view origin for the control
; Parameters ....: $hWnd        - Handle to the control
; Return values .: Success      - View Y position
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetOrigin
; ===============================================================================================================================
Func _ListView_GetOriginY($hWnd)
  Local $aOrigin

  $aOrigin = _ListView_GetOrigin($hWnd)
  Return $aOrigin[1]
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the color of the border of the control
; Parameters ....: $hWnd        - Handle to the control
; Return values .: Success      - Border color of the control
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: Windows XP only. Control must have the $LVS_EX_BORDERSELECT extended window style set
; Related .......: _ListView_SetOutlineColor
; ===============================================================================================================================
Func _ListView_GetOutlineColor($hWnd)
  Return _API_SendMessage($hWnd, $LVM_GETOUTLINECOLOR, 0, 0)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the index of the selected column
; Parameters ....: $hWnd        - Handle to the control
; Return values .: Success      - The zero based index of the selected column
;                  Failure      - -1
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: Windows XP only
; Related .......: _ListView_SetSelectedColumn
; ===============================================================================================================================
Func _ListView_GetSelectedColumn($hWnd)
  Return _API_SendMessage($hWnd, $LVM_GETSELECTEDCOLUMN, 0, 0)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Determines the number of selected items in the control
; Parameters ....: $hWnd        - Handle to the control
; Return values .: Success      - The number of selected items
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......:
; ===============================================================================================================================
Func _ListView_GetSelectedCount($hWnd)
  Return _API_SendMessage($hWnd, $LVM_GETSELECTEDCOUNT, 0, 0)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the selection mark from the control
; Parameters ....: $hWnd        - Handle to the control
; Return values .: Success      - The zero based selection mark
;                  Failure      - -1
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: The selection mark is the item index from which a multiple selection starts
; Related .......: _ListView_SetSelectionMark
; ===============================================================================================================================
Func _ListView_GetSelectionMark($hWnd)
  Return _API_SendMessage($hWnd, $LVM_GETSELECTIONMARK, 0, 0)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Determines the width of a specified string
; Parameters ....: $hWnd        - Handle to the control
;                  $sString     - String for which the width will be calculated
; Return values .: Success      - The string width
;                  Failure      - 0
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: This function returns the exact width, in pixels, of the specified string.  If you  use  the  returned  string
;                  width as the column width in the SetColumnWidth function the string will be truncated.  To retrieve the column
;                  width that can contain the string without truncating it, you must add padding to the returned string width.
; Related .......:
; ===============================================================================================================================
Func _ListView_GetStringWidth($hWnd, $sString)
  Local $iBuffer, $pBuffer, $tBuffer, $pMemory, $tMemMap, $iResult

  $iBuffer = StringLen($sString) + 1
  $tBuffer = DllStructCreate("char Text[" & $iBuffer & "]")
  $pBuffer = DllStructGetPtr($tBuffer)
  DllStructSetData($tBuffer, "Text", $sString)
  if _Lib_InProcess($hWnd, $ghLVLastWnd) then
    $iResult = _API_SendMessage($hWnd, $LVM_GETSTRINGWIDTH, 0, $pBuffer)
  else
    $pMemory = _Mem_CtrlInit($hWnd, $iBuffer, $tMemMap)
    _Mem_CtrlWrite($tMemMap, $pBuffer, $pMemory, $iBuffer)
    $iResult = _API_SendMessage($hWnd, $LVM_GETSTRINGWIDTH, 0, $pMemory)
    _Mem_CtrlRead($tMemMap, $pMemory, $pBuffer, $iBuffer)
    _Mem_CtrlFree($tMemMap)
  endif
  Return $iResult
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves information about an item bounding rectangle
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the subitem's parent item
;                  $iSubItem    - One based index of the subitem
;                  $iPart       - The portion of the subitem item to retrieve:
;                  |0 - The rectangle of the entire subitem, including the icon and label
;                  |1 - The rectangle of the icon or small icon
; Return values .: Success      - Array with the following format:
;                  |[0] - X coordinate of the upper left corner of the rectangle
;                  |[1] - Y coordinate of the upper left corner of the rectangle
;                  |[2] - X coordinate of the lower right corner of the rectangle
;                  |[3] - Y coordinate of the lower right corner of the rectangle
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: This function is used only with controls that use the $LVS_REPORT style
; Related .......:
; ===============================================================================================================================
Func _ListView_GetSubItemRect($hWnd, $iIndex, $iSubItem, $iPart=0)
  Local $iRect, $pRect, $tRect, $pMemory, $tMemMap, $aRect[4], $aPart[2]=[$LVIR_BOUNDS, $LVIR_ICON]

  $tRect = DllStructCreate($tagRECT)
  $pRect = DllStructGetPtr($tRect)
  DllStructSetData($tRect, "Top" , $iSubItem)
  DllStructSetData($tRect, "Left", $aPart[$iPart])
  if _Lib_InProcess($hWnd, $ghLVLastWnd) then
    _API_SendMessage($hWnd, $LVM_GETSUBITEMRECT, $iIndex, $pRect  )
  else
    $iRect   = DllStructGetSize($tRect)
    $pMemory = _Mem_CtrlInit($hWnd, $iRect, $tMemMap)
    _Mem_CtrlWrite($tMemMap, $pRect, $pMemory, $iRect)
    _API_SendMessage($hWnd, $LVM_GETSUBITEMRECT, $iIndex, $pMemory)
    _Mem_CtrlRead($tMemMap, $pMemory, $pRect, $iRect)
    _Mem_CtrlFree($tMemMap)
  endif
  $aRect[0] = DllStructGetData($tRect, "Left"  )
  $aRect[1] = DllStructGetData($tRect, "Top"   )
  $aRect[2] = DllStructGetData($tRect, "Right" )
  $aRect[3] = DllStructGetData($tRect, "Bottom")
  Return $aRect
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the text background color of the control
; Parameters ....: $hWnd        - Handle to the control
; Return values .: Success      - Text background color
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_SetTextBkColor
; ===============================================================================================================================
Func _ListView_GetTextBkColor($hWnd)
  Return _API_SendMessage($hWnd, $LVM_GETTEXTBKCOLOR, 0, 0)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the text color of the control
; Parameters ....: $hWnd        - Handle to the control
; Return values .: Success      - Text color
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_SetTextColor
; ===============================================================================================================================
Func _ListView_GetTextColor($hWnd)
  Return _API_SendMessage($hWnd, $LVM_GETTEXTCOLOR, 0, 0)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the ToolTip control handle
; Parameters ....: $hWnd        - Handle to the control
; Return values .: Success      - The handle of the ToolTip control
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_SetToolTips
; ===============================================================================================================================
Func _ListView_GetToolTips($hWnd)
  Return _API_SendMessage($hWnd, $LVM_GETTOOLTIPS, 0, 0)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the index of the topmost visible item when in list or report view mode
; Parameters ....: $hWnd        - Handle to the control
; Return values .: Success      - The zero based index of the item
;                  Failure      - 0
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......:
; ===============================================================================================================================
Func _ListView_GetTopIndex($hWnd)
  Return _API_SendMessage($hWnd, $LVM_GETTOPINDEX, 0, 0)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the Unicode character format flag for the control
; Parameters ....: $hWnd        - Handle to the control
; Return values .: True         - Control is using Unicode characters
;                  False        - Control is using ANSI characters
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_SetUnicodeFormat
; ===============================================================================================================================
Func _ListView_GetUnicodeFormat($hWnd)
  Return _API_SendMessage($hWnd, $LVM_GETUNICODEFORMAT, 0, 0) <> 0
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the current view of the control
; Parameters ....: $hWnd        - Handle to the control
; Return values .: Success      - The current view:
;                  |0 - Details
;                  |1 - Large Icon
;                  |2 - List
;                  |3 - Small Icon
;                  |4 - Tile
;                  Failure      - -1
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: Windows XP only
; Related .......: _ListView_SetView
; ===============================================================================================================================
Func _ListView_GetView($hWnd)
  Switch _API_SendMessage($hWnd, $LVM_GETVIEW, 0, 0)
    case $LV_VIEW_DETAILS
      Return 0
    case $LV_VIEW_ICON
      Return 1
    case $LV_VIEW_LIST
      Return 2
    case $LV_VIEW_SMALLICON
      Return 3
    case $LV_VIEW_TILE
      Return 4
    case else
      Return -1
  EndSwitch
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Determines whether the view mode is in detail mode
; Parameters ....: $hWnd        - Handle to the control
; Return values .: True         - View is in detail mode
;                  False        - View is not in detail mode
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetView
; ===============================================================================================================================
Func _ListView_GetViewDetails($hWnd)
  Return _ListView_GetView($hWnd) = 0
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Determines whether the view mode is in large icon mode
; Parameters ....: $hWnd        - Handle to the control
; Return values .: True         - View is in large icon mode
;                  False        - View is not in large icon mode
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetView
; ===============================================================================================================================
Func _ListView_GetViewLarge($hWnd)
  Return _ListView_GetView($hWnd) = 1
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Determines whether the view mode is in list mode
; Parameters ....: $hWnd        - Handle to the control
; Return values .: True         - View is in list mode
;                  False        - View is not in list mode
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetView
; ===============================================================================================================================
Func _ListView_GetViewList($hWnd)
  Return _ListView_GetView($hWnd) = 2
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Determines whether the view mode is in small icon mode
; Parameters ....: $hWnd        - Handle to the control
; Return values .: True         - View is in small icon mode
;                  False        - View is not in small icon mode
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetView
; ===============================================================================================================================
Func _ListView_GetViewSmall($hWnd)
  Return _ListView_GetView($hWnd) = 3
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Determines whether the view mode is in tile mode
; Parameters ....: $hWnd        - Handle to the control
; Return values .: True         - View is in tile mode
;                  False        - View is not in tile mode
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetView
; ===============================================================================================================================
Func _ListView_GetViewTile($hWnd)
  Return _ListView_GetView($hWnd) = 4
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the bounding rectangle of all items in the control
; Parameters ....: $hWnd        - Handle to the control
; Return values .: Success      - Array with the following format:
;                  |[0] - X coordinate of the upper left corner of the rectangle
;                  |[1] - Y coordinate of the upper left corner of the rectangle
;                  |[2] - X coordinate of the lower right corner of the rectangle
;                  |[3] - Y coordinate of the lower right corner of the rectangle
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: The control must be in icon or small icon view
; Related .......:
; ===============================================================================================================================
Func _ListView_GetViewRect($hWnd)
  Local $iView, $iRect, $pRect, $tRect, $pMemory, $tMemMap, $aRect[4]=[0, 0, 0, 0]

  $iView = _ListView_GetView($hWnd)
  if ($iView <> 1) and ($iView <> 3) then Return $aRect

  $tRect = DllStructCreate($tagRECT)
  $pRect = DllStructGetPtr($tRect)
  if _Lib_InProcess($hWnd, $ghLVLastWnd) then
    _API_SendMessage($hWnd, $LVM_GETVIEWRECT, 0, $pRect  )
  else
    $iRect   = DllStructGetSize($tRect)
    $pMemory = _Mem_CtrlInit($hWnd, $iRect, $tMemMap)
    _API_SendMessage($hWnd, $LVM_GETVIEWRECT, 0, $pMemory)
    _Mem_CtrlRead($tMemMap, $pMemory, $pRect, $iRect)
    _Mem_CtrlFree($tMemMap)
  endif
  $aRect[0] = DllStructGetData($tRect, "Left"  )
  $aRect[1] = DllStructGetData($tRect, "Top"   )
  $aRect[2] = DllStructGetData($tRect, "Right" )
  $aRect[3] = DllStructGetData($tRect, "Bottom")
  Return $aRect
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Determines which item is at a specified position
; Parameters ....: $hWnd        - Handle to the control
;                  $iX          - X position, in client coordinates, to be tested or -1 to use the current mouse position
;                  $iY          - Y position, in client coordinates, to be tested or -1 to use the current mouse position
; Return values .: Success      - Array with the following format:
;                  |[0] - Zero based index of the item at the specified position, or -1
;                  |[1] - If True, position is in control's client window but not on an item
;                  |[2] - If True, position is over item icon
;                  |[3] - If True, position is over item text
;                  |[4] - If True, position is over item state image
;                  |[5] - If True, position is somewhere on the item
;                  |[6] - If True, position is above the control's client area
;                  |[7] - If True, position is below the control's client area
;                  |[8] - If True, position is to the left of the client area
;                  |[9] - If True, position is to the right of the client area
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_SubItemHitTest
; ===============================================================================================================================
Func _ListView_HitTest($hWnd, $iX=-1, $iY=-1)
  Local $iFlags, $iTest, $tTest, $pTest, $pMemory, $tMemMap, $aTest[10]

  if $iX = -1 then $iX = _Lib_GetMousePosX(True, $hWnd)
  if $iY = -1 then $iY = _Lib_GetMousePosY(True, $hWnd)
  $tTest = DllStructCreate($tagLVHITTESTINFO)
  $pTest = DllStructGetPtr($tTest)
  DllStructSetData($tTest, "X", $iX)
  DllStructSetData($tTest, "Y", $iY)
  if _Lib_InProcess($hWnd, $ghLVLastWnd) then
    $aTest[0] = _API_SendMessage($hWnd, $LVM_HITTEST, 0, $pTest  )
  else
    $iTest   = DllStructGetSize($tTest)
    $pMemory = _Mem_CtrlInit($hWnd, $iTest, $tMemMap)
    _Mem_CtrlWrite($tMemMap, $pTest, $pMemory, $iTest)
    $aTest[0] = _API_SendMessage($hWnd, $LVM_HITTEST, 0, $pMemory)
    _Mem_CtrlRead($tMemMap, $pMemory, $pTest, $iTest)
    _Mem_CtrlFree($tMemMap)
  endif
  $iFlags = DllStructGetData($tTest, "Flags")
  $aTest[1] = BitAND($iFlags, $LVHT_NOWHERE        ) <> 0
  $aTest[2] = BitAND($iFlags, $LVHT_ONITEMICON     ) <> 0
  $aTest[3] = BitAND($iFlags, $LVHT_ONITEMLABEL    ) <> 0
  $aTest[4] = BitAND($iFlags, $LVHT_ONITEMSTATEICON) <> 0
  $aTest[5] = BitAND($iFlags, $LVHT_ONITEM         ) <> 0
  $aTest[6] = BitAND($iFlags, $LVHT_ABOVE          ) <> 0
  $aTest[7] = BitAND($iFlags, $LVHT_BELOW          ) <> 0
  $aTest[8] = BitAND($iFlags, $LVHT_TOLEFT         ) <> 0
  $aTest[9] = BitAND($iFlags, $LVHT_TORIGHT        ) <> 0
  Return $aTest
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Converts an image index to a overlay image mask
; Parameters ....: $iIndex      - One based overlay index
; Return values .: Success      - Image index mask
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: This function is used internally by Auto3Lib and should not normally be called
; Related .......: _ListView_OverlayImageMaskToIndex
; ===============================================================================================================================
Func _ListView_IndexToOverlayImageMask($iIndex)
  Return BitShift($iIndex, -8)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Converts an image index to a state image mask
; Parameters ....: $iIndex      - One based image index
; Return values .: Success      - Image index mask
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: This function is used internally by Auto3Lib and should not normally be called
; Related .......: _ListView_StateImageMaskToIndex
; ===============================================================================================================================
Func _ListView_IndexToStateImageMask($iIndex)
  Return BitShift($iIndex, -12)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Inserts a new column in the control
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of new column
;                  $sText       - Column header text
;                  $iWidth      - Width of the column, in pixels
;                  $sAlign      - Alignment of the column header and the subitem text in the column:
;                  |  Left - Text is left aligned
;                  | Right - Text is right aligned
;                  |Center - Text is centered
;                  $iImage      - Zero based index of an image within the image list
;                  $fOnRight    - If True, the column image appears to the right of text
; Return values .: Success      - The index of the new column
;                  Failure      - -1
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: The alignment of the leftmost column is always left-justified; it cannot be changed
; Related .......:
; ===============================================================================================================================
Func _ListView_InsertColumn($hWnd, $iIndex, $sText, $iWidth=50, $sAlign="left", $iImage=-1, $fOnRight=False)
  Local $iBuffer, $pBuffer, $tBuffer, $iColumn, $pColumn, $tColumn, $pMemory, $tMemMap, $pText, $iMask, $iFmt, $iResult

  $iBuffer = StringLen($sText) + 1
  $tBuffer = DllStructCreate("char Text[" & $iBuffer & "]")
  $pBuffer = DllStructGetPtr($tBuffer)
  $tColumn = DllStructCreate($tagLVCOLUMN)
  $pColumn = DllStructGetPtr($tColumn)
  $iMask   = BitOR($LVCF_FMT, $LVCF_WIDTH, $LVCF_TEXT)
  Switch $sAlign
    case "right"
      $iFmt = $LVCFMT_RIGHT
    case "center"
      $iFmt = $LVCFMT_CENTER
  EndSwitch
  if $iImage <> -1 then
    $iMask = BitOR($iMask, $LVCF_IMAGE           )
    $iFmt  = BitOr($iFmt , $LVCFMT_COL_HAS_IMAGES)
  endif
  if $fOnRight then     $iFmt = BitOR($iFmt, $LVCFMT_BITMAP_ON_RIGHT)
  DllStructSetData($tBuffer, "Text"   , $sText  )
  DllStructSetData($tColumn, "Mask"   , $iMask  )
  DllStructSetData($tColumn, "Fmt"    , $iFmt   )
  DllStructSetData($tColumn, "CX"     , $iWidth )
  DllStructSetData($tColumn, "TextMax", $iBuffer)
  DllStructSetData($tColumn, "Image"  , $iImage )
  if _Lib_InProcess($hWnd, $ghLVLastWnd) then
    DllStructSetData($tColumn, "Text", $pBuffer)
    $iResult = _API_SendMessage($hWnd, $LVM_INSERTCOLUMN, $iIndex, $pColumn)
  else
    $iColumn = DllStructGetSize($tColumn)
    $pMemory = _Mem_CtrlInit($hWnd, $iColumn + $iBuffer, $tMemMap)
    $pText   = $pMemory + $iColumn
    DllStructSetData($tColumn, "Text", $pText)
    _Mem_CtrlWrite($tMemMap, $pColumn, $pMemory, $iColumn)
    _Mem_CtrlWrite($tMemMap, $pBuffer, $pText  , $iBuffer)
    $iResult = _API_SendMessage($hWnd, $LVM_INSERTCOLUMN, $iIndex, $pMemory)
    _Mem_CtrlFree($tMemMap)
  endif
  Return $iResult
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Inserts a group
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Index where the group is to be added. If this is -1, the group is added at the end of the list.
;                  $sHeader     - Header text
;                  $iGroupID    - ID of the group
;                  $iAlign      - Alignment of the header text for the group:
;                  |0 - Left
;                  |1 - Center
;                  |2 - Right
; Return values .: Success      - Returns the index of the item that the group was added to
;                  Failure      - -1
; Author ........: Yoan Roblet (Arcker), Paul Campbell (PaulIA)
; Remarks .......: Windows XP Only. A group cannot be inserted into an empty control.
; Related .......:
; ===============================================================================================================================
Func _ListView_InsertGroup($hWnd, $iIndex, $iGroupID, $sHeader, $iAlign=0)
  Local $iHeader, $pHeader, $tHeader, $iGroup, $pGroup, $tGroup, $pMemory, $tMemMap, $pText, $iMask, $iResult
  Local $aAlign[3] = [$LVGA_HEADER_LEFT, $LVGA_HEADER_CENTER, $LVGA_HEADER_RIGHT]

  $tHeader = _API_MultiByteToWideChar($sHeader)
  $pHeader = DllStructGetPtr ($tHeader)
  $iHeader = DllStructGetSize($tHeader)
  $tGroup  = DllStructCreate ($tagLVGROUP)
  $pGroup  = DllStructGetPtr ($tGroup)
  $iGroup  = DllStructGetSize($tGroup)
  $iMask   = BitOR($LVGF_HEADER, $LVGF_ALIGN, $LVGF_GROUPID)
  DllStructSetData($tGroup, "Size"     , $iGroup         )
  DllStructSetData($tGroup, "Mask"     , $iMask          )
  DllStructSetData($tGroup, "HeaderMax", $iHeader        )
  DllStructSetData($tGroup, "GroupID"  , $iGroupID       )
  DllStructSetData($tGroup, "Align"    , $aAlign[$iAlign])
  if _Lib_InProcess($hWnd, $ghLVLastWnd) then
    DllStructSetData($tGroup, "Header", $pHeader)
    $iResult = _API_SendMessage ($hWnd, $LVM_INSERTGROUP, $iIndex, $pGroup)
  else
    $pMemory = _Mem_CtrlInit($hWnd, $iGroup + $iHeader, $tMemMap)
    $pText   = $pMemory + $iGroup
    DllStructSetData($tGroup, "Header", $pText)
    _Mem_CtrlWrite($tMemMap, $pGroup , $pMemory, $iGroup)
    _Mem_CtrlWrite($tMemMap, $pHeader, $pText  , $iHeader)
    $iResult = _API_SendMessage ($hWnd, $LVM_INSERTGROUP, $iIndex, $pGroup)
    _Mem_CtrlFree($tMemMap)
  endif
  Return $iResult
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Inserts a new item in the control
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index at which the new item should be inserted.  If this value is greater  than  the
;                  +number of items currently contained by the control, the new item will be appended to the end of the list  and
;                  +assigned the correct index.
;                  $sText       - Item text. If set to -1, the item set is set via the $LVN_GETDISPINFO notification message.
;                  $iImage      - Zero based index of the item's icon in the control's image list
; Return values .: Success      - The index of the new item
;                  Failure      - -1
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: You can not use this function to insert subitems. Use _ListView_SetItemText to insert subitems.
; Related .......: _ListView_SetItemText
; ===============================================================================================================================
Func _ListView_InsertItem($hWnd, $iIndex, $sText, $iImage=-1)
  Local $iBuffer, $pBuffer, $tBuffer, $iItem, $pItem, $tItem, $pMemory, $tMemMap, $pText, $iMask, $iResult

  $tItem = DllStructCreate($tagLVITEM)
  $pItem = DllStructGetPtr($tItem)
  if $sText <> -1 then
    $iBuffer = StringLen($sText) + 1
    $tBuffer = DllStructCreate("char Text[" & $iBuffer & "]")
    $pBuffer = DllStructGetPtr($tBuffer)
    DllStructSetData($tBuffer, "Text"   , $sText  )
    DllStructSetData($tItem  , "Text"   , $pBuffer)
    DllStructSetData($tItem  , "TextMax", $iBuffer)
  else
    DllStructSetData($tItem, "Text", -1)
  endif
  $iMask = $LVIF_TEXT
  if $iImage >= 0 then $iMask = BitOR($iMask, $LVIF_IMAGE)
  DllStructSetData($tItem, "Mask" , $iMask )
  DllStructSetData($tItem, "Item" , $iIndex)
  DllStructSetData($tItem, "Image", $iImage)
  if _Lib_InProcess($hWnd, $ghLVLastWnd) or ($sText = -1) then
    $iResult = _API_SendMessage($hWnd, $LVM_INSERTITEM, 0, $pItem  )
  else
    $iItem   = DllStructGetSize($tItem)
    $pMemory = _Mem_CtrlInit($hWnd, $iItem + $iBuffer, $tMemMap)
    $pText   = $pMemory + $iItem
    DllStructSetData($tItem, "Text", $pText)
    _Mem_CtrlWrite($tMemMap, $pItem  , $pMemory, $iItem  )
    _Mem_CtrlWrite($tMemMap, $pBuffer, $pText  , $iBuffer)
    $iResult = _API_SendMessage($hWnd, $LVM_INSERTITEM, 0, $pMemory)
    _Mem_CtrlFree($tMemMap)
  endif
  Return $iResult
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Retrieves the insertion point closest to a specified point
; Parameters ....: $hWnd        - Handle to the control
;                  $iX          - X position test point or -1 to use the current mouse position
;                  $iY          - Y position test point or -1 to use the current mouse position
; Return values .: Success      - Array with the following format:
;                  |[0] - True if the insertion point appears after the item, otherwise False
;                  |[1] - Item next to which the insertion point appears. If this is -1, there is no insertion point.
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetInsertMark
; ===============================================================================================================================
Func _ListView_InsertMarkHitTest($hWnd, $iX=-1, $iY=-1)
  Local $iPoint, $pPoint, $tPoint, $iMark, $tMark, $pMark, $pMemM, $pMemP, $tMemMap, $aTest[2]

  if $iX = -1 then $iX = _Lib_GetMousePosX(True, $hWnd)
  if $iY = -1 then $iY = _Lib_GetMousePosY(True, $hWnd)
  $tPoint = DllStructCreate ($tagPOINT)
  $pPoint = DllStructGetPtr ($tPoint)
  $tMark  = DllStructCreate ($tagLVINSERTMARK)
  $pMark  = DllStructGetPtr ($tMark)
  $iMark  = DllStructGetSize($tMark)
  DllStructSetData($tPoint, "X"   , $iX   )
  DllStructSetData($tPoint, "Y"   , $iY   )
  DllStructSetData($tMark , "Size", $iMark)
  if _Lib_InProcess($hWnd, $ghLVLastWnd) then
    _API_SendMessage($hWnd, $LVM_INSERTMARKHITTEST, $pPoint, $pMark)
  else
    $iPoint = DllStructGetSize($tPoint)
    $pMemM  = _Mem_CtrlInit($hWnd, $iPoint + $iMark, $tMemMap)
    $pMemP  = $pMemP + $iPoint
    _Mem_CtrlWrite($tMemMap, $pMark , $pMemM, $iMark )
    _Mem_CtrlWrite($tMemMap, $pPoint, $pMemP, $iPoint)
    _API_SendMessage($hWnd, $LVM_INSERTMARKHITTEST, $pMemP , $pMemM)
    _Mem_CtrlRead($tMemMap, $pMemM, $pMark, $iMark)
    _Mem_CtrlFree($tMemMap)
  endif
  $aTest[0] = DllStructGetData($tMark, "Flags") = $LVIM_AFTER
  $aTest[1] = DllStructGetData($tMark, "Item")
  Return $aTest
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Maps the ID of an item to an index
; Parameters ....: $hWnd        - Handle to the control
;                  $iID         - ID of an item
; Return values .: Success      - The most current index
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: ListView controls internally track items by index. This can present problems because indexes can change during
;                  the control's lifetime. The ListView control can tag an item with an ID when the item is created.  You can use
;                  this ID to guarantee uniqueness during the lifetime of the control. Windows XP only.
; Related .......: _ListView_MapIndexToID
; ===============================================================================================================================
Func _ListView_MapIDToIndex($hWnd, $iID)
  Return _API_SendMessage($hWnd, $LVM_MAPIDTOINDEX, $iID, 0)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Maps an index to an item ID
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of an item
; Return values .: Success      - The ID of the item
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: ListView controls internally track items by index. This can present problems because indexes can change during
;                  the control's lifetime. The ListView control can tag an item with an ID when the item is created.  You can use
;                  this ID to guarantee uniqueness during the lifetime of the control. Windows XP only.
; Related .......: _ListView_MapIDToIndex
; ===============================================================================================================================
Func _ListView_MapIndexToID($hWnd, $iIndex)
  Return _API_SendMessage($hWnd, $LVM_MAPINDEXTOID, $iIndex, 0)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Moves the group to the specified zero based index
; Parameters ....: $hWnd        - Handle to the control
;                  $iGroupID    - ID of the group to move
;                  $iIndex      - Zero based index of an item where the group will move
; Return values .:
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: Windows XP only
; Related .......:
; ===============================================================================================================================
Func _ListView_MoveGroup($hWnd, $iGroupID, $iIndex)
  Return _API_SendMessage($hWnd, $LVM_MOVEGROUP, $iGroupID, $iIndex)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Converts an overlay image mask to an image index
; Parameters ....: $iMask       - Image index mask
; Return values .: Success      - Image index
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: This function is used internally by Auto3Lib and should not normally be called
; Related .......: _ListView_IndexToOverlayImageMask
; ===============================================================================================================================
Func _ListView_OverlayImageMaskToIndex($iMask)
  Return BitShift(BitAND($LVIS_OVERLAYMASK, $iMask), 8)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Forces the control to redraw a range of items
; Parameters ....: $hWnd        - Handle to the control
;                  $iFirst      - Zero based index of the first item to redraw
;                  $iLast       - Zero based index of the last item to redraw
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: The specified items are not actually redrawn until the control receives a $WM_PAINT message to repaint.
; Related .......:
; ===============================================================================================================================
Func _ListView_RedrawItems($hWnd, $iFirst, $iLast)
  Return _API_SendMessage($hWnd, $LVM_REDRAWITEMS, $iFirst, $iLast) <> 0
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Removes all groups from the control
; Parameters ....: $hWnd        - Handle to the control
; Return values .:
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: Windows XP only.
; Related .......: _ListView_RemoveGroup
; ===============================================================================================================================
Func _ListView_RemoveAllGroups($hWnd)
  Return _API_SendMessage($hWnd, $LVM_REMOVEALLGROUPS, 0, 0)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Removes a group from the control
; Parameters ....: $hWnd        - Handle to the control
;                  $iGroupID    - ID that specifies the group to remove
; Return values .: Success      - The index of the group
;                  Failure      - -1
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: Windows XP only.
; Related .......: _ListView_RemoveGroup
; ===============================================================================================================================
Func _ListView_RemoveGroup($hWnd, $iGroupID)
  Return _API_SendMessage($hWnd, $LVM_REMOVEGROUP, $iGroupID, 0)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Scrolls the content of the control
; Parameters ....: $hWnd        - Handle to the control
;                  $iDX         - Specifies the amount of horizontal scrolling in pixels.  If the control is in list  view,  this
;                  +value specifies the number of columns to scroll.
;                  $iDY         - Specifies the amount of vertical scrolling in pixels
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: When the control is in report view, the control can only be scrolled vertically in whole line increments.  The
;                  $iDY parameter will be rounded to the nearest number of pixels that form a whole line increment.  For example,
;                  if the height of a line is 16 pixels and 8 is passed for $iDY, the list will be scrolled by  16  pixels.  If 7
;                  is passed for $iDY, the list will be scrolled 0 pixels.
; Related .......:
; ===============================================================================================================================
Func _ListView_Scroll($hWnd, $iDX, $iDY)
  Return _API_SendMessage($hWnd, $LVM_SCROLL, $iDX, $iDY) <> 0
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Sets the background color of the control
; Parameters ....: $hWnd        - Handle to the control
;                  $iColor      - Background color to set or CLR_NONE value for no background color
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetBkColor
; ===============================================================================================================================
Func _ListView_SetBkColor($hWnd, $iColor)
  Local $iResult

  $iResult = _API_SendMessage($hWnd, $LVM_SETBKCOLOR, 0, $iColor)
  _API_InvalidateRect($hWnd)
  Return $iResult <> 0
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Sets the background image in the control
; Parameters ....: $hWnd        - Handle to the control
;                  $sURL        - URL of the background image. If blank, the control has no background
;                  $iStyle      - Determines the background image style:
;                  |0 - Normal
;                  |1 - Tiled
;                  $iXOffset    - Percentage of the control's client area that the image  should  be  offset  horizontally.  Only
;                  +valid when 0 is used in $iStyle.
;                  $iYOffset    - Percentage of the control's client area that the image should be offset vertically.  Only valid
;                  +when 0 is used in $iStyle.
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetBkImage
; ===============================================================================================================================
Func _ListView_SetBkImage($hWnd, $sURL="", $iStyle=0, $iXOffset=0, $iYOffset=0)
  Local $iBuffer, $pBuffer, $tBuffer, $iImage, $pImage, $tImage, $pMemory, $tMemMap, $pText, $iResult
  Local $aStyle[2]=[$LVBKIF_STYLE_NORMAL, $LVBKIF_STYLE_TILE]

  $iBuffer = StringLen($sURL) + 1
  $tBuffer = DllStructCreate("char Text[" & $iBuffer & "]")
  $pBuffer = DllStructGetPtr($tBuffer)
  $tImage  = DllStructCreate($tagLVBKIMAGE)
  $pImage  = DllStructGetPtr($tImage)
  if $sURL <> "" then $iResult = $LVBKIF_SOURCE_URL
  $iResult = BitOR($iResult, $aStyle[$iStyle])
  DllStructSetData($tBuffer, "Text"       , $sURL    )
  DllStructSetData($tImage , "Flags"      , $iResult )
  DllStructSetData($tImage , "XOffPercent", $iXOffset)
  DllStructSetData($tImage , "YOffPercent", $iYOffset)
  if _Lib_InProcess($hWnd, $ghLVLastWnd) then
    DllStructSetData($tImage, "Image", $pBuffer)
    $iResult = _API_SendMessage($hWnd, $LVM_SETBKIMAGE, 0, $pImage )
  else
    $iImage  = DllStructGetSize($tImage)
    $pMemory = _Mem_CtrlInit($hWnd, $iImage + $iBuffer, $tMemMap)
    $pText   = $pMemory + $iImage
    DllStructSetData($tImage, "Image", $pText)
    _Mem_CtrlWrite($tMemMap, $pImage , $pMemory, $iImage )
    _Mem_CtrlWrite($tMemMap, $pBuffer, $pText  , $iBuffer)
    $iResult = _API_SendMessage($hWnd, $LVM_SETBKIMAGE, 0, $pMemory)
    _Mem_CtrlFree($tMemMap)
  endif
  Return $iResult <> 0
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Changes the callback mask for the control
; Parameters ....: $hWnd        - Handle to the control
;                  $iMask       - Value of the callback mask. The bits of the mask indicate the item states or images  for  which
;                  +the application stores the current state data.  This value can be any combination of the following:
;                  | 1 - The item is marked for a cut-and-paste operation
;                  | 2 - The item is highlighted as a drag-and-drop target
;                  | 4 - The item has the focus
;                  | 8 - The item is selected
;                  |16 - The application stores the image list index of the current overlay image
;                  |32 - The application stores the image list index of the current state image
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: The callback mask is a set of bit flags that specify the item states for which the  application,  rather  than
;                  the control, stores the current data.  The callback mask applies to all of the  control's  items,  unlike  the
;                  callback item designation, which applies to a specific item.  The callback mask is zero  by  default,  meaning
;                  that the control stores all item state information.
; Related .......: _ListView_GetCallbackMask
; ===============================================================================================================================
Func _ListView_SetCallBackMask($hWnd, $iMask)
  Local $iFlags

  if BitAND($iMask,  1) <> 0 then $iFlags = BitOR($iFlags, $LVIS_CUT           )
  if BitAND($iMask,  2) <> 0 then $iFlags = BitOR($iFlags, $LVIS_DROPHILITED   )
  if BitAND($iMask,  4) <> 0 then $iFlags = BitOR($iFlags, $LVIS_FOCUSED       )
  if BitAND($iMask,  8) <> 0 then $iFlags = BitOR($iFlags, $LVIS_SELECTED      )
  if BitAND($iMask, 16) <> 0 then $iFlags = BitOR($iFlags, $LVIS_OVERLAYMASK   )
  if BitAND($iMask, 32) <> 0 then $iFlags = BitOR($iFlags, $LVIS_STATEIMAGEMASK)
  Return _API_SendMessage($hWnd, $LVM_SETCALLBACKMASK, $iFlags, 0) <> 0
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Sets the attributes of a column
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of new column
;                  $sText       - Column header text
;                  $iWidth      - Width of the column, in pixels
;                  $iAlign      - Alignment of the column header and the subitem text in the column:
;                  |0 - Text is left aligned
;                  |1 - Text is right aligned
;                  |2 - Text is centered
;                  $iImage      - Zero based index of an image within the image list
;                  $fOnRight    - If True, the column image appears to the right of text
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetColumn
; ===============================================================================================================================
Func _ListView_SetColumn($hWnd, $iIndex, $sText, $iWidth=-1, $iAlign=-1, $iImage=-1, $fOnRight=False)
  Local $iBuffer, $pBuffer, $tBuffer, $iColumn, $pColumn, $tColumn, $pMemory, $tMemMap, $pText, $iMask, $iFmt, $iResult
  Local $aAlign[3]=[$LVCFMT_LEFT, $LVCFMT_RIGHT, $LVCFMT_CENTER]

  $iBuffer = StringLen($sText) + 1
  $tBuffer = DllStructCreate ("char Text[" & $iBuffer & "]")
  $pBuffer = DllStructGetPtr($tBuffer)
  $tColumn = DllStructCreate($tagLVCOLUMN)
  $pColumn = DllStructGetPtr($tColumn)
  $iMask   = $LVCF_TEXT
  if $iAlign <> -1 then
    $iMask = BitOR($iMask, $LVCF_FMT       )
    $iFmt  = BitOR($iFmt , $aAlign[$iAlign])
  endif
  if $iWidth <> -1 then $iMask = BitOR($iMask, $LVCF_WIDTH)
  if $iImage <> -1 then
    $iMask = BitOR($iMask, $LVCF_IMAGE           )
    $iFmt  = BitOr($iFmt , $LVCFMT_COL_HAS_IMAGES)
  endif
  if $fOnRight then $iFmt = BitOR($iFmt, $LVCFMT_BITMAP_ON_RIGHT)
  DllStructSetData($tBuffer, "Text"  , $sText   )
  DllStructSetData($tColumn, "Mask"   , $iMask  )
  DllStructSetData($tColumn, "Fmt"    , $iFmt   )
  DllStructSetData($tColumn, "CX"     , $iWidth )
  DllStructSetData($tColumn, "TextMax", $iBuffer)
  DllStructSetData($tColumn, "Image"  , $iImage )
  if _Lib_InProcess($hWnd, $ghLVLastWnd) then
    DllStructSetData($tColumn, "Text", $pBuffer)
    $iResult = _API_SendMessage($hWnd, $LVM_SETCOLUMN, $iIndex, $pColumn)
  else
    $iColumn = DllStructGetSize($tColumn)
    $pMemory = _Mem_CtrlInit($hWnd, $iColumn + $iBuffer, $tMemMap)
    $pText   = $pMemory + $iColumn
    DllStructSetData($tColumn, "Text", $pText)
    _Mem_CtrlWrite($tMemMap, $pColumn, $pMemory, $iColumn)
    _Mem_CtrlWrite($tMemMap, $pBuffer, $pText  , $iBuffer)
    $iResult = _API_SendMessage($hWnd, $LVM_SETCOLUMN, $iIndex, $pMemory)
    _Mem_CtrlFree($tMemMap)
  endif
  Return $iResult <> 0
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Sets the left-to-right order of columns in the control
; Parameters ....: $hWnd        - Handle to the control
;                  $aOrder      - Array of integers that holds the index values of the columsn in the control.  The array must be
;                  +formatted as follows:
;                  |[0] - Number of items in array
;                  |[1] - First column index
;                  |[2] - Second column index
;                  |[n] - Last column index
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetColumnOrderArray
; ===============================================================================================================================
Func _ListView_SetColumnOrderArray($hWnd, $aOrder)
  Local $iI, $iBuffer, $pBuffer, $tBuffer, $pMemory, $tMemMap, $iResult

  $tBuffer = DllStructCreate("int[" & $aOrder[0] & "]")
  $pBuffer = DllStructGetPtr($tBuffer)
  for $iI = 1 to $aOrder[0]
    DllStructSetData($tBuffer, 1, $aOrder[$iI], $iI)
  next

  if _Lib_InProcess($hWnd, $ghLVLastWnd) then
    $iResult = _API_SendMessage($hWnd, $LVM_SETCOLUMNORDERARRAY, $aOrder[0], $pBuffer)
  else
    $iBuffer = DllStructGetSize($tBuffer)
    $pMemory = _Mem_CtrlInit($hWnd, $iBuffer, $tMemMap)
    _Mem_CtrlWrite($tMemMap, $pBuffer, $pMemory, $iBuffer)
    $iResult = _API_SendMessage($hWnd, $LVM_SETCOLUMNORDERARRAY, $aOrder[0], $pMemory)
    _Mem_CtrlFree($tMemMap)
  endif
  Return $iResult <> 0
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Changes the width of a column in report view mode or the width of all columns in list mode
; Parameters ....: $hWnd        - Handle to the control
;                  $iColumn     - Zero based index of column
;                  $iCX         - Width of the column in pixels. Report view mode, has the following special values:
;                  |-1 - Automatically sizes the column
;                  |-2 - Automatically sizes the column to fit the header text
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetColumnWidth
; ===============================================================================================================================
Func _ListView_SetColumnWidth($hWnd, $iColumn, $iCX=50)
  Return _API_SendMessage($hWnd, $LVM_SETCOLUMNWIDTH, $iColumn, $iCX) <> 0
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Sets extended styles
; Parameters ....: $hWnd        - Handle to the control
;                  $iExStyle    - Extended control styles:
;                  |$LVS_EX_BORDERSELECT     - When an item is selected the border color of the item changes
;                  |$LVS_EX_CHECKBOXES       - Enables check boxes for items in a list-view control
;                  |$LVS_EX_DOUBLEBUFFER     - Paints via double-buffering, which reduces flicker
;                  |$LVS_EX_FLATSB           - Enables flat scroll bars in the list view
;                  |$LVS_EX_FULLROWSELECT    - When an item is selected, the item and all its subitems are highlighted
;                  |$LVS_EX_GRIDLINES        - Displays gridlines around items and subitems
;                  |$LVS_EX_HEADERDRAGDROP   - Enables drag-and-drop reordering of columns
;                  |$LVS_EX_INFOTIP          - The $LVN_GETINFOTIP notification message is sent before displaying a ToolTip
;                  |$LVS_EX_LABELTIP         - If not set, the unfolds partly hidden labels only for the large icon mode
;                  |$LVS_EX_MULTIWORKAREAS   - The control will not autoarrange its icons until one or more work areas are defined
;                  |$LVS_EX_ONECLICKACTIVATE - The control sends an $LVN_ITEMACTIVATE messages when the user clicks an item
;                  |$LVS_EX_REGIONAL         - Sets the control region to include only the item icons and text
;                  |$LVS_EX_SIMPLESELECT     - In icon view moves the state image of the control to the top right
;                  |$LVS_EX_SUBITEMIMAGES    - Allows images to be displayed for subitems
;                  |$LVS_EX_TRACKSELECT      - Enables hot-track selection in the control
;                  |$LVS_EX_TWOCLICKACTIVATE - The control sends an $LVN_ITEMACTIVATE message when the user double-clicks an item
;                  |$LVS_EX_UNDERLINECOLD    - Causes non-hot items that may be activated to be displayed with underlined text
;                  |$LVS_EX_UNDERLINEHOT     - Causes hot items that may be activated to be displayed with underlined text
;                  $iExMask     - Specifies which styles in $iExStyle are to be affected.  This parameter can be a combination of
;                  +extended styles. Only the extended styles in $iExMask will be changed. All other styles will be maintained as
;                  +they are. If this parameter is zero, all of the styles in $iExStyle will be affected.
; Return values .: Success      - The previous extended styles
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetExtendedListViewStyle
; ===============================================================================================================================
Func _ListView_SetExtendedListViewStyle($hWnd, $iExStyle, $iExMask=0)
  Local $iResult

  $iResult = _API_SendMessage($hWnd, $LVM_SETEXTENDEDLISTVIEWSTYLE, $iExMask, $iExStyle)
  _API_SetWindowLong ($hWnd, $GWL_EXSTYLE, $iExStyle)
  _API_InvalidateRect($hWnd)
  Return $iResult
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Sets group information
; Parameters ....: $hWnd        - Handle to the control
;                  $iGroupID    - ID of the group
;                  $sHeader     - Header text
;                  $iAlign      - Alignment of the header text for the group:
;                  |0 - Left
;                  |1 - Center
;                  |2 - Right
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: Windows XP Only
; Related .......: _ListView_GetGroupInfo
; ===============================================================================================================================
Func _ListView_SetGroupInfo($hWnd, $iGroupID, $sHeader, $iAlign=0)
  Local $iHeader, $pHeader, $tHeader, $iGroup, $pGroup, $tGroup, $pMemory, $tMemMap, $pText, $iMask, $iResult
  Local $aAlign[3]=[$LVGA_HEADER_LEFT, $LVGA_HEADER_CENTER, $LVGA_HEADER_RIGHT]

  $tHeader = _API_MultiByteToWideChar($sHeader)
  $pHeader = DllStructGetPtr ($tHeader)
  $iHeader = DllStructGetSize($tHeader)
  $tGroup  = DllStructCreate ($tagLVGROUP)
  $pGroup  = DllStructGetPtr ($tGroup)
  $iGroup  = DllStructGetSize($tGroup)
  $iMask   = BitOR($LVGF_HEADER, $LVGF_ALIGN, $LVGF_GROUPID)
  DllStructSetData($tGroup, "Size"     , $iGroup         )
  DllStructSetData($tGroup, "Mask"     , $iMask          )
  DllStructSetData($tGroup, "HeaderMax", $iHeader        )
  DllStructSetData($tGroup, "GroupID"  , 0xFFFFFFFF      )
  DllStructSetData($tGroup, "Align"    , $aAlign[$iAlign])
  if _Lib_InProcess($hWnd, $ghLVLastWnd) then
    DllStructSetData($tGroup, "Header", $pHeader)
    $iResult = _API_SendMessage($hWnd, $LVM_SETGROUPINFO, $iGroupID, $pGroup)
    DllStructSetData($tGroup, "Mask", $LVGF_GROUPID)
    DllStructSetData($tGroup, "GroupID", $iGroupID)
    _API_SendMessage($hWnd, $LVM_SETGROUPINFO, $iGroupID, $pGroup)
  else
    $pMemory = _Mem_CtrlInit($hWnd, $iGroup + $iHeader, $tMemMap)
    $pText   = $pMemory + $iGroup
    DllStructSetData($tGroup, "Header", $pText)
    _Mem_CtrlWrite($tMemMap, $pGroup , $pMemory, $iGroup )
    _Mem_CtrlWrite($tMemMap, $pHeader, $pText  , $iHeader)
    $iResult = _API_SendMessage($hWnd, $LVM_SETGROUPINFO, $iGroupID, $pMemory)
    DllStructSetData($tGroup, "Mask", $LVGF_GROUPID)
    DllStructSetData($tGroup, "GroupID", $iGroupID)
    _API_SendMessage($hWnd, $LVM_SETGROUPINFO, $iGroupID, $pMemory)
    _Mem_CtrlFree($tMemMap)
  endif
  _API_InvalidateRect($hWnd)
  Return $iResult <> 0
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Sets the cursor handle that the control uses
; Parameters ....: $hWnd        - Handle to the control
;                  $hCursor     - Handle to the cursor to be set
; Return values .: Success      - Handle to the previous hot cursor
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetHotCursor
; ===============================================================================================================================
Func _ListView_SetHotCursor($hWnd, $hCursor)
  Return _API_SendMessage($hWnd, $LVM_SETHOTCURSOR, 0, $hCursor)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Sets the hot item for the control
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item to be set as the hot item
; Return values .: Success      - The zero based index of the item that was previously hot
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetHotItem
; ===============================================================================================================================
Func _ListView_SetHotItem($hWnd, $iIndex)
  Return _API_SendMessage($hWnd, $LVM_SETHOTITEM, $iIndex, 0)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Sets the time the cursor must hover over an item before it is selected
; Parameters ....: $hWnd        - Handle to the control
;                  $iHoverTime  - The new amount of time, in milliseconds, that the mouse cursor must hover over an  item  before
;                  +it is selected. If this value is  -1, then the hover time is set to the default hover time.
; Return values .: Success      - The previous hover time
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetHoverTime
; ===============================================================================================================================
Func _ListView_SetHoverTime($hWnd, $iHoverTime)
  Return _API_SendMessage($hWnd, $LVM_SETHOVERTIME, 0, $iHoverTime)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Sets the spacing between icons where the style is large icon
; Parameters ....: $hWnd        - Handle to the control
;                  $iCX         - Distance, in pixels, to set between icons on the x-axis
;                  $iCY         - Distance, in pixels, to set between icons on the y-axis
; Return values .: Success      - Array with the following format:
;                  |[0] - Previous CX value
;                  |[1] - Previous CY value
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: Values for $iCX and $iCY are relative to the upper-left corner of an icon bitmap. To set spacing between icons
;                  that do not overlap, the $iCX or $iCY values must include the size of the icon, plus the amount of empty space
;                  desired between icons. Values that do not include the width of the icon will result in overlaps.
; Related .......:
; ===============================================================================================================================
Func _ListView_SetIconSpacing($hWnd, $iCX, $iCY)
  Local $iResult, $aPadding[2]

  $iResult = _API_SendMessage($hWnd, $LVM_SETICONSPACING, 0, _Lib_MakeLong($iCX, $iCY))
  $aPadding[0] = _Lib_LoWord($iResult)
  $aPadding[1] = _Lib_HiWord($iResult)
  _API_InvalidateRect($hWnd)
  Return $aPadding
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Assigns an image list to the control
; Parameters ....: $hWnd        - Handle to the control
;                  $hHandle     - Handle to the image list to assign
;                  $iType       - Type of image list:
;                  |0 - Image list with large icons
;                  |1 - Image list with small icons
;                  |2 - Image list with state images
; Return values .: Success      - The handle to the previous image list
;                  Failue       - 0
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: The current image list will be destroyed when the control is destroyed unless you set the $LVS_SHAREIMAGELISTS
;                  style. If you use this message to replace one image list with another your application must explicitly destroy
;                  all image lists other than the current one.
; Related .......: _ListView_GetImageList
; ===============================================================================================================================
Func _ListView_SetImageList($hWnd, $hHandle, $iType=0)
  Local $aType[3]=[$LVSIL_NORMAL, $LVSIL_SMALL, $LVSIL_STATE]

  Return _API_SendMessage($hWnd, $LVM_SETIMAGELIST, $aType[$iType], $hHandle)
EndFunc

; ===============================================================================================================================
; Description ...: Sets ToolTip text
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
;                  $sText       - String that contains the tooltip text
;                  $iSubItem    - One based index of the subitem
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: Windows XP Only
; Related .......:
; ===============================================================================================================================
Func _ListView_SetInfoTip($hWnd, $iIndex, $sText, $iSubItem=0)
  Local $iBuffer, $pBuffer, $tBuffer, $iInfo, $pInfo, $tInfo, $pMemory, $tMemMap, $pText, $iResult

  $tBuffer = _API_MultiByteToWideChar($sText)
  $pBuffer = DllStructGetPtr ($tBuffer)
  $iBuffer = DllStructGetSize($tBuffer)
  $tInfo   = DllStructCreate ($tagLVSETINFOTIP)
  $pInfo   = DllStructGetPtr ($tInfo)
  $iInfo   = DllStructGetSize($tInfo)
  DllStructSetData($tInfo, "Size"   , $iInfo   )
  DllStructSetData($tInfo, "Item"   , $iIndex  )
  DllStructSetData($tInfo, "SubItem", $iSubItem)
  if _Lib_InProcess($hWnd, $ghLVLastWnd) then
    DllStructSetData($tInfo, "Text", $pBuffer)
    $iResult = _API_SendMessage($hWnd, $LVM_SETINFOTIP, 0, $pInfo  )
  else
    $pMemory = _Mem_CtrlInit($hWnd, $iInfo + $iBuffer, $tMemMap)
    $pText   = $pMemory + $iInfo
    DllStructSetData($tInfo, "Text", $pText)
    _Mem_CtrlWrite($tMemMap, $pInfo  , $pMemory, $iInfo  )
    _Mem_CtrlWrite($tMemMap, $pBuffer, $pText  , $iBuffer)
    $iResult = _API_SendMessage($hWnd, $LVM_SETINFOTIP, 0, $pMemory)
    _Mem_CtrlFree($tMemMap)
  endif
  Return $iResult <> 0
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Sets the insertion point to the defined position
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
;                  $fAfter      - Insertion point:
;                  | True - The insertion point will appear after the item
;                  |False - The insertion point will appear before the item
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: Windows XP Only. An insertion point can only appear if the control is in icon view, small icon view,  or  tile
;                  view, and not in group view mode.
; Related .......: _ListView_GetInsertMark
; ===============================================================================================================================
Func _ListView_SetInsertMark($hWnd, $iIndex, $fAfter=False)
  Local $iMark, $pMark, $tMark, $pMemory, $tMemMap, $iResult

  $tMark = DllStructCreate ($tagLVINSERTMARK)
  $pMark = DllStructGetPtr ($tMark)
  $iMark = DllStructGetSize($tMark)
  DllStructSetData($tMark, "Size" , $iMark )
  DllStructSetData($tMark, "Flags", $fAfter)
  DllStructSetData($tMark, "Item" , $iIndex)
  if _Lib_InProcess($hWnd, $ghLVLastWnd) then
    $iResult = _API_SendMessage($hWnd, $LVM_SETINSERTMARK, 0, $pMark  )
  else
    $pMemory = _Mem_CtrlInit($hWnd, $iMark, $tMemMap)
    _Mem_CtrlWrite($tMemMap, $pMark)
    $iResult = _API_SendMessage($hWnd, $LVM_SETINSERTMARK, 0, $pMemory)
    _Mem_CtrlFree($tMemMap)
  endif
  Return $iResult <> 0
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Sets the color of the insertion point
; Parameters ....: $hWnd        - Handle to the control
;                  $iColor      - Color to set the insertion point
; Return values .: Success      - The previous insertion point color
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: Windows XP Only
; Related .......: _ListView_GetInsertMarkColor
; ===============================================================================================================================
Func _ListView_SetInsertMarkColor($hWnd, $iColor)
  Return _API_SendMessage($hWnd, $LVM_SETINSERTMARKCOLOR, 0, $iColor)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Sets some or all of a item's attributes
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index at which the new item should be inserted.  If this value is greater  than  the
;                  +number of items currently contained by the control, the new item will be appended to the end of the list  and
;                  +assigned the correct index.
;                  $sText       - Item text
;                  $iSubItem    - One based index of the subitem or zero if this refers to an item
;                  $iImage      - Zero base index of the item's icon in the control's image list
;                  $iParam      - Value specific to the item
;                  $iIndent     - Number of image widths to indent the item. A single indentation equals the width of an image.
; Return values .: Success      - The zero based index of the new item
;                  Failure      - -1
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetItem
; ===============================================================================================================================
Func _ListView_SetItem($hWnd, $iIndex, $sText, $iSubItem=0, $iImage=-1, $iParam=-1, $iIndent=-1)
  Local $iBuffer, $pBuffer, $tBuffer, $tItem, $iMask

  $iBuffer = StringLen($sText) + 1
  $tBuffer = DllStructCreate("char Text[" & $iBuffer & "]")
  $pBuffer = DllStructGetPtr($tBuffer)
  $tItem   = DllStructCreate($tagLVITEM)
  $iMask   = $LVIF_TEXT
  if $iImage  <> -1 then $iMask = BitOR($iMask, $LVIF_IMAGE )
  if $iParam  <> -1 then $iMask = BitOR($iMask, $LVIF_PARAM )
  if $iIndent <> -1 then $iMask = BitOR($iMask, $LVIF_INDENT)
  DllStructSetData($tBuffer, "Text"   , $sText   )
  DllStructSetData($tItem  , "Mask"   , $iMask   )
  DllStructSetData($tItem  , "Item"   , $iIndex  )
  DllStructSetData($tItem  , "SubItem", $iSubItem)
  DllStructSetData($tItem  , "Text"   , $pBuffer )
  DllStructSetData($tItem  , "TextMax", $iBuffer )
  DllStructSetData($tItem  , "Image"  , $iImage  )
  DllStructSetData($tItem  , "Param"  , $iMask   )
  DllStructSetData($tItem  , "Indent" , $iIndent )
  Return _ListView_SetItemEx($hWnd, $tItem)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Gets the checked state of an item
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
;                  $fCheck      - Item check state:
;                  | True - Check item
;                  |False - Uncheck item
;                  $fMove       - If True, the mouse will be moved. If False, the mouse does not move.
; Return values .:
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: Use only on controls that have the $LVS_EX_CHECKBOXES extended style
; Related .......: _ListView_GetItemChecked
; ===============================================================================================================================
Func _ListView_SetItemChecked($hWnd, $iIndex, $fCheck=True, $fMove=False)
  Local $iExStyle, $tRect1, $tRect2, $tPoint, $iX, $iY

  $iExStyle = _API_GetWindowLong($hWnd, $GWL_EXSTYLE)
  if BitAND($iExStyle, $LVS_EX_CHECKBOXES) = 0 then Return SetError(-1, -1, -1)
  if _ListView_GetItemChecked($hWnd, $iIndex) <> $fCheck then
    $tRect1 = _ListView_GetItemRectEx($hWnd, $iIndex, $LVIR_BOUNDS)
    $tRect2 = _ListView_GetItemRectEx($hWnd, $iIndex, $LVIR_ICON  )
    DllStructSetData($tRect1, "Right", DllStructGetData($tRect2, "Left"))
    $tPoint = _Lib_PointFromRect($tRect1)
    $tPoint = _API_ClientToScreen($hWnd, $tPoint)
    _Lib_GetXYFromPoint($tPoint, $iX, $iY)
    _Lib_MouseClick("left", $iX, $iY, $fMove)
  endif
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Causes the control to allocate memory for the specified number of items
; Parameters ....: $hWnd        - Handle to the control
;                  $iItems      - Number of items that the control will ultimately contain
;                  $iFlags      - Values that specify the behavior of the control after resetting the item count.  This value can
;                  +be a combination of the following:
;                  |1 - The control will not repaint unless affected items are currently in view
;                  |2 - The control will not change the scroll position when the item count changes
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: If the control was created without the $LVS_OWNERDATA style,  sending  this  message  causes  the  control  to
;                  allocate its internal data structure for the specified number of items.  This prevents the control from having
;                  to allocate the data structure every time an item is added. If the control was created with the $LVS_OWNERDATA
;                  style sending this message sets the virtual number of items that the control contains.  The $iFlags  parameter
;                  is intended only for controls that use the $LVS_OWNERDATA and $LVS_REPORT or $LVS_LIST styles.
; Related .......: _ListView_GetItemCount
; ===============================================================================================================================
Func _ListView_SetItemCount($hWnd, $iItems, $iFlags=0)
  Return _API_SendMessage($hWnd, $LVM_SETITEMCOUNT, $iItems, $iFlags) <> 0
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Sets whether the item is marked for a cut-and-paste operation
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
;                  $fEnabled    - If True the item state is set, otherwise it is not set.
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......:_ListView_GetItemCut
; ===============================================================================================================================
Func _ListView_SetItemCut($hWnd, $iIndex, $fEnabled=True)
  Local $iStateMask = 0

  if $fEnabled then $iStateMask = $LVIS_CUT
  Return _ListView_SetItemState($hWnd, $iIndex, $LVIS_CUT, $iStateMask)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Sets whether the item is highlighted as a drag-and-drop target
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
;                  $fEnabled    - If True the item state is set, otherwise it is not set.
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetItemDropHilited
; ===============================================================================================================================
Func _ListView_SetItemDropHilited($hWnd, $iIndex, $fEnabled=True)
  Local $iStateMask = 0

  if $fEnabled then $iStateMask = $LVIS_DROPHILITED
  Return _ListView_SetItemState($hWnd, $iIndex, $LVIS_DROPHILITED, $iStateMask)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Sets some or all of a item's attributes
; Parameters ....: $hWnd        - Handle to the control
;                  $tItem       - tagLVITEM structure
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: To set the attributes of an item set the Item member of the tagLVITEM structure to the index of the item,  and
;                  set the SubItem member to zero.  For an item, you can set the State, Text, Image, and  Param  members  of  the
;                  tagLVITEM structure.  To set the text of a subitem, set the Item and SubItem members to indicate the  specific
;                  subitem, and use the Text member to specify the text.  You cannot set the State or Param members for  subitems
;                  because subitems do not have these attributes.
; Related .......:
; ===============================================================================================================================
Func _ListView_SetItemEx($hWnd, ByRef $tItem)
  Local $iItem, $pItem, $iBuffer, $pBuffer, $pMemory, $tMemMap, $pText, $iResult

  $pItem = DllStructGetPtr($tItem)
  if _Lib_InProcess($hWnd, $ghLVLastWnd) then
    $iResult = _API_SendMessage($hWnd, $LVM_SETITEM, 0, $pItem)
  else
    $iItem   = DllStructGetSize($tItem)
    $iBuffer = StringLen(DllStructGetData($tItem, "Text")) + 1
    $pBuffer = DllStructGetData($tItem, "Text")
    $pMemory = _Mem_CtrlInit($hWnd, $iItem + $iBuffer, $tMemMap)
    $pText   = $pMemory + $iItem
    DllStructSetData($tItem, "Text", $pText)
    _Mem_CtrlWrite($tMemMap, $pItem, $pMemory, $iItem)
    if $pBuffer <> 0 then _Mem_CtrlWrite($tMemMap, $pBuffer, $pText, $iBuffer)
    $iResult = _API_SendMessage($hWnd, $LVM_SETITEM, 0, $pMemory)
    _Mem_CtrlFree($tMemMap)
  endif
  Return $iResult <> 0
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Sets whether the item has the focus
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
;                  $fEnabled    - If True the item state is set, otherwise it is not set.
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetItemFocused
; ===============================================================================================================================
Func _ListView_SetItemFocused($hWnd, $iIndex, $fEnabled=True)
  Local $iStateMask = 0

  if $fEnabled then $iStateMask = $LVIS_FOCUSED
  Return _ListView_SetItemState($hWnd, $iIndex, $LVIS_FOCUSED, $iStateMask)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Sets the item group ID
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
;                  $iGroupID    - Group ID
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Yoan Roblet (Arcker), Paul Campbell (PaulIA)
; Remarks .......: Windows XP Only
; Related .......: _ListView_GetItemGroupID
; ===============================================================================================================================
func _ListView_SetItemGroupID($hWnd, $iIndex, $iGroupID)
  Local $tItem

  $tItem = DllStructCreate($tagLVITEM)
  DllStructSetData($tItem, "Mask"   , $LVIF_GROUPID)
  DllStructSetData($tItem, "Item"   , $iIndex      )
  DllStructSetData($tItem, "GroupID", $iGroupID    )
  _ListView_SetItemEx($hWnd, $tItem)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Sets the index of the item's icon in the control's image list
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
;                  $iImage      - Zero based index into the control's image list
;                  $iSubItem    - One based index of the subitem
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetItemImage
; ===============================================================================================================================
Func _ListView_SetItemImage($hWnd, $iIndex, $iImage, $iSubItem=0)
  Local $tItem

  $tItem = DllStructCreate($tagLVITEM)
  DllStructSetData($tItem, "Mask"   , $LVIF_IMAGE)
  DllStructSetData($tItem, "Item"   , $iIndex    )
  DllStructSetData($tItem, "SubItem", $iSubItem  )
  DllStructSetData($tItem, "Image"  , $iImage    )
  Return _ListView_SetItemEx($hWnd, $tItem)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Sets the number of image widths to indent the item
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
;                  $iIndent     - Indention value
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetItemIndent
; ===============================================================================================================================
Func _ListView_SetItemIndent($hWnd, $iIndex, $iIndent)
  Local $tItem

  $tItem = DllStructCreate($tagLVITEM)
  DllStructSetData($tItem, "Mask", $LVIF_INDENT)
  DllStructSetData($tItem, "Item", $iIndex)
  DllStructSetData($tItem, "Indent", $iIndent)
  Return _ListView_SetItemEx($hWnd, $tItem)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Sets the overlay image is superimposed over the item's icon image
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
;                  $iImage      - One based overlay image index
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: This function is used internally by Auto3Lib and should not normally be called
; Related .......: _ListView_GetItemOverlayImage
; ===============================================================================================================================
Func _ListView_SetItemOverlayImage($hWnd, $iIndex, $iImage)
  Return _ListView_SetItemState($hWnd, $iIndex, _ListView_IndexToOverlayImageMask($iImage), $LVIS_OVERLAYMASK)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Sets the value specific to the item
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
;                  $iParam      - Item specific value
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetItemParam
; ===============================================================================================================================
Func _ListView_SetItemParam($hWnd, $iIndex, $iParam)
  Local $tItem

  $tItem = DllStructCreate($tagLVITEM)
  DllStructSetData($tItem, "Mask" , $LVIF_PARAM)
  DllStructSetData($tItem, "Item" , $iIndex    )
  DllStructSetData($tItem, "Param", $iParam    )
  Return _ListView_SetItemEx($hWnd, $tItem)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Moves an item to a specified position in the control
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
;                  $iCX         - New x-position of the item's upper-left corner, in view coordinates
;                  $iCY         - New y-position of the item's upper-left corner, in view coordinates
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: If the control has the $LVS_AUTOARRANGE style, the items in the control are arranged after the position of the
;                  item is set. The control must be in icon or small icon view mode.
; Related .......: _ListView_GetItemPosition
; ===============================================================================================================================
Func _ListView_SetItemPosition($hWnd, $iIndex, $iCX, $iCY)
  Return _API_SendMessage($hWnd, $LVM_SETITEMPOSITION, $iIndex, _Lib_MakeLong($iCX, $iCY)) <> 0
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Moves an item to a specified position in the control
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
;                  $iCX         - New x-position of the item's upper-left corner, in view coordinates
;                  $iCY         - New y-position of the item's upper-left corner, in view coordinates
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: If the control has the $LVS_AUTOARRANGE style, the items in the control are arranged after the position of the
;                  item is set.
; Related .......:
; ===============================================================================================================================
Func _ListView_SetItemPosition32($hWnd, $iIndex, $iCX, $iCY)
  Local $iPoint, $pPoint, $tPoint, $pMemory, $tMemMap, $iResult

  $tPoint = DllStructCreate($tagPOINT)
  $pPoint = DllStructGetPtr($tPoint)
  DllStructSetData($tPoint, "X", $iCX)
  DllStructSetData($tPoint, "Y", $iCY)
  if _Lib_InProcess($hWnd, $ghLVLastWnd) then
    $iResult = _API_SendMessage($hWnd, $LVM_SETITEMPOSITION32, $iIndex, $pPoint)
  else
    $iPoint  = DllStructGetSize($tPoint)
    $pMemory = _Mem_CtrlInit($hWnd, $iPoint, $tMemMap)
    _Mem_CtrlWrite($tMemMap, $pPoint)
    $iResult = _API_SendMessage($hWnd, $LVM_SETITEMPOSITION32, $iIndex, $pMemory)
    _Mem_CtrlFree($tMemMap)
  endif
  Return $iResult <> 0
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Sets whether the item is selected
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
;                  $fEnabled    - If True the item state is set, otherwise it is not set.
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetItemSelected
; ===============================================================================================================================
Func _ListView_SetItemSelected($hWnd, $iIndex, $fEnabled=True)
  Local $iStateMask = 0

  if $fEnabled then $iStateMask = $LVIS_SELECTED
  Return _ListView_SetItemState($hWnd, $iIndex, $LVIS_SELECTED, $iStateMask)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Changes the state of an item in the control
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
;                  $iState      - Item state to be changed
;                  $iStateMask  - Bits that determine whether state is active or inactive
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetItemState
; ===============================================================================================================================
Func _ListView_SetItemState($hWnd, $iIndex, $iState, $iStateMask)
  Local $tItem

  $tItem = DllStructCreate($tagLVITEM)
  DllStructSetData($tItem, "Mask"     , $LVIF_STATE)
  DllStructSetData($tItem, "Item"     , $iIndex    )
  DllStructSetData($tItem, "State"    , $iState    )
  DllStructSetData($tItem, "StateMask", $iStateMask)
  Return _ListView_SetItemEx($hWnd, $tItem)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Sets the state image that is displayed
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
;                  $iImage      - One based overlay image index
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetItemStateImage
; ===============================================================================================================================
Func _ListView_SetItemStateImage($hWnd, $iIndex, $iImage)
  Return _ListView_SetItemState($hWnd, $iIndex, _ListView_IndexToStateImageMask($iImage), $LVIS_STATEIMAGEMASK)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Changes the text of an item or subitem
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
;                  $sText       - Item or subitem text
;                  $iSubItem    - One based index of the subitem or 0 to set the item
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetItemText
; ===============================================================================================================================
Func _ListView_SetItemText($hWnd, $iIndex, $sText, $iSubItem=0)
  Local $iBuffer, $pBuffer, $tBuffer, $iItem, $pItem, $tItem, $pMemory, $tMemMap, $pText, $iResult

  $iBuffer = StringLen($sText) + 1
  $tBuffer = DllStructCreate("char Text[" & $iBuffer & "]")
  $pBuffer = DllStructGetPtr($tBuffer)
  $tItem   = DllStructCreate($tagLVITEM)
  $pItem   = DllStructGetPtr($tItem)
  DllStructSetData($tBuffer, "Text", $sText)
  DllStructSetData($tItem, "Mask"   , $LVIF_TEXT)
  DllStructSetData($tItem, "item"   , $iIndex   )
  DllStructSetData($tItem, "SubItem", $iSubItem )
  if _Lib_InProcess($hWnd, $ghLVLastWnd) then
    DllStructSetData($tItem, "Text", $pBuffer)
    $iResult = _API_SendMessage($hWnd, $LVM_SETITEM, 0, $pItem  )
  else
    $iItem   = DllStructGetSize($tItem)
    $pMemory = _Mem_CtrlInit($hWnd, $iItem + $iBuffer, $tMemMap)
    $pText   = $pMemory + $iItem
    DllStructSetData($tItem, "Text", $pText)
    _Mem_CtrlWrite($tMemMap, $pItem  , $pMemory, $iItem  )
    _Mem_CtrlWrite($tMemMap, $pBuffer, $pText  , $iBuffer)
    $iResult = _API_SendMessage($hWnd, $LVM_SETITEM, 0, $pMemory)
    _Mem_CtrlFree($tMemMap)
  endif
  Return $iResult <> 0
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Sets the color of the border
; Parameters ....: $hWnd        - Handle to the control
;                  $iColor      - Color to set the border
; Return values .: Success      - Previous outline color
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: Windows XP only.  Control must have the $LVS_EX_BORDERSELECT extended window style set
; Related .......: _ListView_GetOutlineColor
; ===============================================================================================================================
Func _ListView_SetOutlineColor($hWnd, $iColor)
  Return _API_SendMessage($hWnd, $LVM_SETOUTLINECOLOR, 0, $iColor)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Sets the index of the selected column
; Parameters ....: $hWnd        - Handle to the control
;                  $iColumn     - Zero based column index
; Return values .:
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: Windows XP only
; Related .......: _ListView_GetSelectedColumn
; ===============================================================================================================================
Func _ListView_SetSelectedColumn($hWnd, $iColumn)
  _API_SendMessage($hWnd, $LVM_SETSELECTEDCOLUMN, $iColumn, 0)
  _API_InvalidateRect($hWnd)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Sets the selection mark in the control
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the new selection mark. If -1,the selection mark is removed.
; Return values .: Success      - The previous selection mark
;                  Failure      - -1 if there is no previous selection mark
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: The selection mark is the item index from which a multiple selection starts.  This message does not affect the
;                  selection state of the item.
; Related .......: _ListView_GetSelectionMark
; ===============================================================================================================================
Func _ListView_SetSelectionMark($hWnd, $iIndex)
  Return _API_SendMessage($hWnd, $LVM_SETSELECTIONMARK, 0, $iIndex)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Sets the background color of text in the control
; Parameters ....: $hWnd        - Handle to the control
;                  $iColor      - Text color
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetTextBkColor
; ===============================================================================================================================
Func _ListView_SetTextBkColor($hWnd, $iColor)
  Return _API_SendMessage($hWnd, $LVM_SETTEXTBKCOLOR, 0, $iColor) <> 0
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Sets the color of text in the control
; Parameters ....: $hWnd        - Handle to the control
;                  $iColor      - Text color
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetTextColor
; ===============================================================================================================================
Func _ListView_SetTextColor($hWnd, $iColor)
  Local $iResult

  $iResult = _API_SendMessage($hWnd, $LVM_SETTEXTCOLOR, 0, $iColor)
  _API_InvalidateRect($hWnd)
  Return $iResult <> 0
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Sets the ToolTip control that the control will use to display ToolTips
; Parameters ....: $hWnd        - Handle to the control
;                  $hToolTip    - Handle to the ToolTip control to be set
; Return values .: Success      - The handle to the previous ToolTip control
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetToolTips
; ===============================================================================================================================
Func _ListView_SetToolTips($hWnd, $hToolTip)
  Return _API_SendMessage($hWnd, $LVM_SETTOOLTIPS, 0, $hToolTip)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Sets the UNICODE character format flag for the control
; Parameters ....: $hWnd        - Handle to the control
;                  $fUnicode    - Determines the character set that is used by the control. If True, the control will use Unicode
;                  +characters.  If this value is zero, the control will use ANSI characters.
; Return values .: Success      - The previous Unicode format flag for the control
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetUnicodeFormat
; ===============================================================================================================================
Func _ListView_SetUnicodeFormat($hWnd, $fUnicode)
  Return _API_SendMessage($hWnd, $LVM_SETUNICODEFORMAT, $fUnicode, 0)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Sets the view of the control
; Parameters ....: $hWnd        - Handle to the control
;                  $iView       - View state for the control:
;                  |0 - Details
;                  |1 - Large Icon
;                  |2 - List
;                  |3 - Small Icon
;                  |4 - Tile
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: Windows XP Only
; Related .......: _ListView_GetView
; ===============================================================================================================================
Func _ListView_SetView($hWnd, $iView)
  Local $aView[5]=[$LV_VIEW_DETAILS, $LV_VIEW_ICON, $LV_VIEW_LIST, $LV_VIEW_SMALLICON, $LV_VIEW_TILE]

  Return _API_SendMessage($hWnd, $LVM_SETVIEW, $aView[$iView], 0)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Creates a work area within the control
; Parameters ....: $hWnd        - Handle to the control
;                  $iLeft       - X coordinate of the upper left corner of the rectangle
;                  $iTop        - Y coordinate of the upper left corner of the rectangle
;                  $iRight      - X coordinate of the lower right corner of the rectangle
;                  $iBottom     - Y coordinate of the lower right corner of the rectangle
; Return values .:
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_GetNumberOfWorkAreas
; ===============================================================================================================================
Func _ListView_SetWorkAreas($hWnd, $iLeft, $iTop, $iRight, $iBottom)
  Local $iRect, $pRect, $tRect, $tMemMap, $pMemory

  $tRect = DllStructCreate($tagRECT)
  $pRect = DllStructGetPtr($tRect)
  DllStructSetData($tRect, "Left"  , $iLeft  )
  DllStructSetData($tRect, "Top"   , $iTop   )
  DllStructSetData($tRect, "Right" , $iRight )
  DllStructSetData($tRect, "Bottom", $iBottom)
  if _Lib_InProcess($hWnd, $ghLVLastWnd) then
    _API_SendMessage($hWnd, $LVM_SETWORKAREAS, 1, $pRect  )
  else
    $iRect   = DllStructGetSize($tRect)
    $pMemory = _Mem_CtrlInit($hWnd, $iRect, $tMemMap)
    _Mem_CtrlWrite($tMemMap, $pRect, $pMemory, $iRect)
    _API_SendMessage($hWnd, $LVM_SETWORKAREAS, 1, $pMemory)
    _Mem_CtrlFree($tMemMap)
  endif
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Converts a state image mask to an image index
; Parameters ....: $iMask       - State image mask
; Return values .: Success      - One base state image index
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: This function is used internally by Auto3Lib and should not normally be called
; Related .......: _ListView_IndexToStateImageMask
; ===============================================================================================================================
Func _ListView_StateImageMaskToIndex($iMask)
  Return BitShift(BitAND($iMask, $LVIS_STATEIMAGEMASK), 12)
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Determines which listview item or subitem is at a given position
; Parameters ....: $hWnd        - Handle to the control
;                  $iX          - X position to test or -1 to use the current mouse position
;                  $iY          - Y position to test or -1 to use the current mouse position
; Return values .: Success      - Array with the following format:
;                  |[ 0] - Zero based index of the item at the specified position, or -1
;                  |[ 1] - Zero based index of the subitem at the specified position, or -1
;                  |[ 2] - If True, position is in control's client window but not on an item
;                  |[ 3] - If True, position is over item icon
;                  |[ 4] - If True, position is over item text
;                  |[ 5] - If True, position is over item state image
;                  |[ 6] - If True, position is somewhere on the item
;                  |[ 7] - If True, the position is above the control's client area
;                  |[ 8] - If True, the position is below the control's client area
;                  |[ 9] - If True, the position is to the left of the client area
;                  |[10] - If True, the position is to the right of the client area
; Author ........: Paul Campbell (PaulIA)
; Remarks .......:
; Related .......: _ListView_HitTest
; ===============================================================================================================================
Func _ListView_SubItemHitTest($hWnd, $iX=-1, $iY=-1)
  Local $iTest, $pTest, $tTest, $pMemory, $tMemMap, $iFlags, $aTest[11]

  if $iX = -1 then $iX = _Lib_GetMousePosX(True, $hWnd)
  if $iY = -1 then $iY = _Lib_GetMousePosY(True, $hWnd)
  $tTest = DllStructCreate($tagLVHITTESTINFO)
  $pTest = DllStructGetPtr($tTest)
  DllStructSetData($tTest, "X", $iX)
  DllStructSetData($tTest, "Y", $iY)
  if _Lib_InProcess($hWnd, $ghLVLastWnd) then
    _API_SendMessage($hWnd, $LVM_SUBITEMHITTEST, 0, $pTest)
  else
    $iTest   = DllStructGetSize($tTest)
    $pMemory = _Mem_CtrlInit($hWnd, $iTest, $tMemMap)
    _Mem_CtrlWrite($tMemMap, $pTest)
    _API_SendMessage($hWnd, $LVM_SUBITEMHITTEST, 0, $pMemory)
    _Mem_CtrlRead ($tMemMap, $pMemory, $pTest, $iTest)
    _Mem_CtrlFree($tMemMap)
  endif
  $iFlags    = DllStructGetData($tTest, "Flags"  )
  $aTest[ 0] = DllStructGetData($tTest, "Item"   )
  $aTest[ 1] = DllStructGetData($tTest, "SubItem")
  $aTest[ 2] = BitAND($iFlags, $LVHT_NOWHERE        ) <> 0
  $aTest[ 3] = BitAND($iFlags, $LVHT_ONITEMICON     ) <> 0
  $aTest[ 4] = BitAND($iFlags, $LVHT_ONITEMLABEL    ) <> 0
  $aTest[ 5] = BitAND($iFlags, $LVHT_ONITEMSTATEICON) <> 0
  $aTest[ 6] = BitAND($iFlags, $LVHT_ONITEM         ) <> 0
  $aTest[ 7] = BitAND($iFlags, $LVHT_ABOVE          ) <> 0
  $aTest[ 8] = BitAND($iFlags, $LVHT_BELOW          ) <> 0
  $aTest[ 9] = BitAND($iFlags, $LVHT_TOLEFT         ) <> 0
  $aTest[10] = BitAND($iFlags, $LVHT_TORIGHT        ) <> 0
  Return $aTest
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Updates an item
; Parameters ....: $hWnd        - Handle to the control
;                  $iIndex      - Zero based index of the item
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: If the control has the $LVS_AUTOARRANGE style, this function causes the control to be arranged
; Related .......:
; ===============================================================================================================================
Func _ListView_Update($hWnd, $iIndex)
  Return _API_SendMessage($hWnd, $LVM_UPDATE, $iIndex, 0) <> 0
EndFunc

; #FUNCTION# ====================================================================================================================
; Description ...: Debug display WM_NOTIFY messages
; Parameters ....: $hWnd        - Window handle
;                  $iMsg        - Message
;                  $iwParam     - wParam
;                  $ilParam     - lParam
; Return values .: None
; Author ........: Paul Campbell (PaulIA)
; Remarks .......: This function should be used as part of a GUIRegisterMsg message in response to the WM_NOTIFY message
; Related .......:
; ===============================================================================================================================
Func _ListView_WM_NOTIFY($hWnd, $iMsg, $iwParam, $ilParam)
  Local $tNMHDR, $hFrom, $iID, $iCode

  $tNMHDR = DllStructCreate($tagNMHDR, $ilParam)
  $hFrom  = DllStructGetData($tNMHDR, "hWndFrom")
  $iID    = DllStructGetData($tNMHDR, "IDFrom"  )
  $iCode  = DllStructGetData($tNMHDR, "Code"    )
  Select
    case _Lib_WM_NOTIFY_EX("TVN_SELCHANGING"    , $hFrom, $iID, $iCode)
    case _Lib_WM_NOTIFY_EX("LVN_ITEMCHANGING"   , $hFrom, $iID, $iCode)
    case _Lib_WM_NOTIFY_EX("LVN_ITEMCHANGED"    , $hFrom, $iID, $iCode)
    case _Lib_WM_NOTIFY_EX("LVN_INSERTITEM"     , $hFrom, $iID, $iCode)
    case _Lib_WM_NOTIFY_EX("LVN_DELETEITEM"     , $hFrom, $iID, $iCode)
    case _Lib_WM_NOTIFY_EX("LVN_DELETEALLITEMS" , $hFrom, $iID, $iCode)
    case _Lib_WM_NOTIFY_EX("LVN_BEGINLABELEDIT" , $hFrom, $iID, $iCode)
    case _Lib_WM_NOTIFY_EX("LVN_ENDLABELEDIT"   , $hFrom, $iID, $iCode)
    case _Lib_WM_NOTIFY_EX("LVN_COLUMNCLICK"    , $hFrom, $iID, $iCode)
    case _Lib_WM_NOTIFY_EX("LVN_BEGINDRAG"      , $hFrom, $iID, $iCode)
    case _Lib_WM_NOTIFY_EX("LVN_BEGINRDRAG"     , $hFrom, $iID, $iCode)
    case _Lib_WM_NOTIFY_EX("LVN_ODCACHEHINT"    , $hFrom, $iID, $iCode)
    case _Lib_WM_NOTIFY_EX("LVN_ITEMACTIVATE"   , $hFrom, $iID, $iCode)
    case _Lib_WM_NOTIFY_EX("LVN_ODSTATECHANGED" , $hFrom, $iID, $iCode)
;    case _Lib_WM_NOTIFY_EX("LVN_HOTTRACK"       , $hFrom, $iID, $iCode)
    case _Lib_WM_NOTIFY_EX("LVN_GETDISPINFO"    , $hFrom, $iID, $iCode)
    case _Lib_WM_NOTIFY_EX("LVN_SETDISPINFO"    , $hFrom, $iID, $iCode)
    case _Lib_WM_NOTIFY_EX("LVN_ODFINDITEM"     , $hFrom, $iID, $iCode)
    case _Lib_WM_NOTIFY_EX("LVN_BEGINLABELEDITW", $hFrom, $iID, $iCode)
    case _Lib_WM_NOTIFY_EX("LVN_ENDLABELEDITW"  , $hFrom, $iID, $iCode)
    case _Lib_WM_NOTIFY_EX("LVN_GETDISPINFOW"   , $hFrom, $iID, $iCode)
    case _Lib_WM_NOTIFY_EX("LVN_SETDISPINFOW"   , $hFrom, $iID, $iCode)
    case _Lib_WM_NOTIFY_EX("LVN_ODFINDITEMW"    , $hFrom, $iID, $iCode)
    case else
      _Lib_WM_NOTIFY($hWnd, $iMsg, $iwParam, $ilParam)
  EndSelect
  Return $GUI_RUNDEFMSG
EndFunc

Opt("MustDeclareVars", 0)