#include <InetGet_Incl.au3>

$URL = "http://creator-lab.ucoz.ru/Desktop_Icons_Restorator.zip"

$ProgressTopPos = GetProgressTopPos()
$ProgressLeftPos = GetProgressLeftPos()

$InfoArray = _InetGetWithProgress($URL, @ScriptDir, $AppName & " - Download Updates Progress", _
	"Download: %F", _
	"Ready: %R (bytes: %b from %FS)" & @LF & _
	"Downloading speed: %S" & @LF & _
	"Approximately Remained Time: %T", _
	"Collecting data, Please wait...", $ProgressLeftPos, $ProgressTopPos, 16)

$TotlaDownloadTime = $InfoArray[1]
$AverageDownloadSpeed = $InfoArray[2]
$TotalDownloadFileSize_Kb = $InfoArray[3]
$FileName = $InfoArray[4]

_ProgressMsg(64, "Finish!", _
	"Download of <" & $FileName & "> has finished." & @LF & _
	"Total downloading time: " & $TotlaDownloadTime & @LF & _
	"The file was downloaded with average speed of: " & $AverageDownloadSpeed & " KB/S" & @LF & _
	"The file size is: " & $TotalDownloadFileSize_Kb & " KB", $PROGRESSHWND)

FinishDownloading()

Func Abort()
	Local $AskAbort = _ProgressMsg(256+52, "Attention", "Are you sure that you want to abort this download?", $ProgressHwnd)
	If $AskAbort <> 6 Then Return
	FinishDownloading()
EndFunc

Func GetProgressTopPos()
	Local $WorkingAreaArray = _GetWorkingArea()
	Local $ProgressTopPos
	If IsArray($WorkingAreaArray) Then
		$ProgressTopPos = $WorkingAreaArray[3] - 125
	Else
		Local $TaskbarArr = WinGetPos("[Class:Shell_TrayWnd]")
		If IsArray($TaskbarArr) Then $ProgressTopPos = @DesktopHeight-125-$TaskbarArr[3]
	EndIf
	If $ProgressTopPos < 0 Then $ProgressTopPos = @DesktopHeight-125
	Return $ProgressTopPos
EndFunc

Func GetProgressLeftPos()
	Local $WorkingAreaArray = _GetWorkingArea()
	Local $ProgressLeftPos
	If IsArray($WorkingAreaArray) Then
		$ProgressLeftPos = $WorkingAreaArray[0]
	Else
		Local $TaskbarArr = WinGetPos("[Class:Shell_TrayWnd]")
		If IsArray($TaskbarArr) Then $ProgressLeftPos = $TaskbarArr[2]
		If $ProgressLeftPos = @DesktopWidth Then $ProgressLeftPos = 0
	EndIf
	If $ProgressLeftPos < 0 Or $ProgressLeftPos > @DesktopWidth Then $ProgressLeftPos = 0
	Return $ProgressLeftPos
EndFunc

;===============================================================================
;
; Function Name:    _GetWorkingArea()
; Description:      Returns the coordinates of desktop working area rectangle
; Parameter(s):     None
; Return Value(s):  On Success - Array containing coordinates:
;                        $a[0] = left
;                        $a[1] = top
;                        $a[2] = right
;                        $a[3] = bottom
;                   On Failure - 0
;
;===============================================================================
Func _GetWorkingArea()
    Local $dRECT = DllStructCreate("long; long; long; long")
    Local $spiRet = DllCall("User32.dll", "int", "SystemParametersInfo", _
		"uint", 48, "uint", 0, "ptr", DllStructGetPtr($dRECT), "uint", 0)
    If @error Then Return 0
    If $spiRet[0] = 0 Then Return 0
    Local $aRet[4] = [DllStructGetData($dRECT, 1), DllStructGetData($dRECT, 2), _
		DllStructGetData($dRECT, 3), DllStructGetData($dRECT, 4)]
    Return $aRet
EndFunc