#include-once

Global $PROGRESSHWND, $INETSPEED = 0, $INETGETBYTESREAD = 0, $INETTIMESTAMP = 0, $TIMERSTART = 0, $DOWNLOADISABORTED = False

Func _InetGetWithProgress($URL, $FilePath="", $Title="", $MainText="", $SubText="", $WaitText="", $Left=-1, $Top=-1,$Opt=0,$hWnd=0)
	Local $FileName = StringRegExpReplace($URL, "^.*/", "")
	
	Local $InetGetSize = InetGetSize($URL)
	If $InetGetSize <= 0 Or @error Then Return SetError(1, "", FinishDownloading(1, $hWnd))
	
	ProgressOn($Title, StringReplace($MainText, "%F", StringTrimRight($FileName, 4)), $WaitText, $Left, $Top, $Opt)
	
	If $FilePath = "" Then $FilePath = @ScriptDir
	InetGet($URL, $FilePath & "\" & $FileName, 1, 1)
	
	$TIMERSTART = TimerInit()
	
	Local $InetGetBytesRead, $SpeedByBytes, $AverageDownloadSpeed, $RemainedTime, $GetDownPrecent, $ProgressInfo, $SetInfo
	
	Local $ProgressInfo = StringReplace($SubText, "%R", "0%")
	$ProgressInfo = StringReplace($ProgressInfo, "%T", "00:00:00")
	$ProgressInfo = StringReplace($ProgressInfo, "%S", "0 kb/s")
	$ProgressInfo = StringReplace($ProgressInfo, "%b", "0")
	$ProgressInfo = StringReplace($ProgressInfo, "%FS", $InetGetSize)
	
	ProgressSet(0, $ProgressInfo)

	$PROGRESSHWND = WinGetHandle($Title)

	While @InetGetActive
		Sleep(200)
		
		$InetGetBytesRead = @InetGetBytesRead
		$SpeedByBytes = _InetGetSpeed($InetGetBytesRead)
		$RemainedTime = _SecsToTime(Round(_InetGetRemained($InetGetBytesRead, $InetGetSize, $SpeedByBytes)))
		$GetDownPrecent = Round(_InetGetPrecent($InetGetBytesRead, $InetGetSize))
		
		$AverageDownloadSpeed = _GetAverageSpeed($InetGetBytesRead)
		
		$SetInfo = StringReplace($SubText, "%R", $GetDownPrecent & "%")
		$SetInfo = StringReplace($SetInfo, "%T", $RemainedTime)
		$SetInfo = StringReplace($SetInfo, "%S", Round($SpeedByBytes/1024, 1) & " kb/s")
		$SetInfo = StringReplace($SetInfo, "%b", $InetGetBytesRead)
		$SetInfo = StringReplace($SetInfo, "%FS", $InetGetSize)
		
		ProgressSet($GetDownPrecent, $SetInfo)
	WEnd
	
	$AverageDownloadSpeed = Round($AverageDownloadSpeed/1024, 1)
	Local $TotlaDownloadTime = _SecsToTime(Round(TimerDiff($TIMERSTART)/1000))
	Local $TotalDownloadFileSize_Kb = Round($InetGetSize/1024, 1)
	
	$SetInfo = StringReplace($SubText, "%R", "100%")
	$SetInfo = StringReplace($SetInfo, "%T", "00:00:00")
	$SetInfo = StringReplace($SetInfo, "%S", $AverageDownloadSpeed & " kb/s")
	$SetInfo = StringReplace($SetInfo, "%b", @InetGetBytesRead)
	$SetInfo = StringReplace($SetInfo, "%FS", $InetGetSize)
	
	ProgressSet(100, $SetInfo)

	Local $RetArray[5] = [4, $TotlaDownloadTime, $AverageDownloadSpeed, $TotalDownloadFileSize_Kb, $FileName]
	Return $RetArray
EndFunc

Func _InetGetSpeed($Bytes)
	If @InetGetActive Then
        If $InetTimeStamp Then
            Local $Ticks = TimerDiff($InetTimeStamp)
            If $Ticks > 0 Then $InetSpeed = ($Bytes-$InetGetBytesRead)*1000 / $Ticks
        EndIf
        $InetGetBytesRead = $Bytes
        $InetTimeStamp = TimerInit()
    Else
        $InetTimeStamp = 0
        $InetGetBytesRead = 0
        $InetSpeed = 0
    EndIf
	Return $InetSpeed
EndFunc

Func _GetAverageSpeed($Bytes)
	Return $Bytes*1000 / TimerDiff($TIMERSTART)
EndFunc

Func _InetGetRemained($Bytes, $TotalBytesSize, $SpeedByBytes)
	Local $RemainedSecs = ($TotalBytesSize - $Bytes) / $SpeedByBytes
	If $RemainedSecs < 0 Or StringLeft($RemainedSecs, 1) = "-" Then $RemainedSecs = 0
	Return $RemainedSecs
EndFunc

Func _InetGetPrecent($Bytes, $TotalBytesSize)
	Return 100 / ($TotalBytesSize / $Bytes)
EndFunc

Func _SecsToTime($iTicks, $Delim=":")
	If Number($iTicks) >= 0 Then
		Local $iHours = Int($iTicks / 3600)
		$iTicks = Mod($iTicks, 3600)
		Local $iMins = Int($iTicks / 60)
		Local $iSecs = Round(Mod($iTicks, 60))
		If StringLen($iHours) = 1 Then $iHours = "0" & $iHours
		If StringLen($iMins) = 1 Then $iMins = "0" & $iMins
		If StringLen($iSecs) = 1 Then $iSecs = "0" & $iSecs
		Return $iHours & $Delim & $iMins & $Delim & $iSecs
	Else
		Return SetError(1, 0, "00" & $Delim & "00" & $Delim & "00")
	EndIf
EndFunc

Func FinishDownloading($Param=0, $hWnd=0)
	If $Param = 0 Then
		InetGet("abort")
		$DOWNLOADISABORTED = True
	Else
		$DOWNLOADISABORTED = False
	EndIf
	If $hWnd <> 0 Then WinSetState($hWnd, "", @SW_ENABLE)
	ProgressOff()
EndFunc
