;compiler directives - Thanks to Zedna
#compiler_plugin_funcs = DefineGlWindow, EmbedToWindow, SetClearColor, SetCamera, SetCameraPos, SetCameraRotate, SetCameraUp, SetCameraView, SceneDraw, SetToObject, UnsetFromObject, ObjectCreate, ObjectDelete, ObjectTranslate, ObjectRotate, ObjectScale, ObjectHide, ObjectShow, SetPrint, UnsetPrint, ClearPrintBuffer, AddLine, AddTriangle, AddQuad, AddSphere, AddCylinder, AddStrokeText, AddBitmapText, AddPartialDisk, AddCube, ShapeTranslate, ShapeRotate, ShapeScale, CreateLight, SetLightAmbient, SetLightDiffuse, SetLightSpecular, SetLightPosition, TextureSetMode, TextureSetBuffer, TextureAdd, TextureBind

FileInstall( "Au3GlPlugin.dll", "Au3GlPlugin.dll" )

;yes, here begins all madness
Global $GlPluginHandle = PluginOpen( "Au3GlPlugin.dll" )

;--------------------------------------------------------------------------------------------
Func _AddTriangleEx( $ObjId, $V1, $V2, $V3, $Normal, $Red, $Green, $Blue, $Alpha )
	If UBound( $V1 ) and UBound( $V2 ) and UBound( $V3 ) and UBound( $Normal ) Then
		AddTriangle( $ObjId, $V1[0], $V1[1], $V1[2], $V2[0], $V2[1], $V2[2], $V3[0], $V3[1], $V3[2], $Normal[0], $Normal[1], $Normal[2], $Red, $Green, $Blue, $Alpha )
	EndIf
EndFunc

;--------------------------------------------------------------------------------------------
Func _AddQuadEx( $ObjId, $V1, $V2, $V3, $V4, $Normal, $Red, $Green, $Blue, $Alpha )
	If UBound( $V1 ) and UBound( $V2 ) and UBound( $V3 ) and UBound( $V4 ) and UBound( $Normal ) Then
		Return AddQuad( $ObjId, $V1[0], $V1[1], $V1[2], $V2[0], $V2[1], $V2[2], $V3[0], $V3[1], $V3[2], $V4[0], $V4[1], $V4[2], $Normal[0], $Normal[1], $Normal[2], $Red, $Green, $Blue, $Alpha )
	EndIf
EndFunc

;--------------------------------------------------------------------------------------------
Func _AddLineEx( $ObjId, $V1, $V2, $Red, $Green, $Blue )
	If UBound( $V1 ) and UBound( $V2 ) Then
		AddLine( $ObjId, $V1[0], $V1[1], $V1[2], $V2[0], $V2[1], $V2[2], $Red, $Green, $Blue, 1.0 )
	EndIf
EndFunc

;--------------------------------------------------------------------------------------------
Func _CreateCube( $ObjId, $OrX, $OrY, $OrZ, $DeX, $DeY, $DeZ ,$Red, $Green, $Blue, $Alpha, $Tex = "" )
	
	Local $V1[3] = [ $OrX, $OrY, $OrZ ]
	Local $V2[3] = [ $DeX, $OrY, $OrZ ]
	Local $V3[3] = [ $OrX, $DeY, $OrZ ]
	Local $V4[3] = [ $DeX, $DeY, $OrZ ]
	Local $V5[3] = [ $OrX, $OrY, $DeZ ]
	Local $V6[3] = [ $DeX, $OrY, $DeZ ]
	Local $V7[3] = [ $OrX, $DeY, $DeZ ]
	Local $V8[3] = [ $DeX, $DeY, $DeZ ]
	
	Local $Normal[3] = [ 0, 0,-1 ]
	Local $QuadIndex
	$QuadIndex = _AddQuadEx( $ObjId, $V1, $V2, $V4, $V3, $Normal, $Red, $Green, $Blue, $Alpha )
	If $Tex <> "" Then TextureBind( $ObjId, $QuadIndex, $Tex )

	Local $Normal[3] = [ 1, 0, 0 ]
	$QuadIndex = _AddQuadEx( $ObjId, $V8, $V4, $V2, $V6, $Normal, $Red, $Green, $Blue, $Alpha )
	If $Tex <> "" Then TextureBind( $ObjId, $QuadIndex, $Tex )

	Local $Normal[3] = [ 0, 0, 1 ]
	$QuadIndex = _AddQuadEx( $ObjId, $V5, $V7, $V8, $V6, $Normal, $Red, $Green, $Blue, $Alpha )
	If $Tex <> "" Then TextureBind( $ObjId, $QuadIndex, $Tex )

	Local $Normal[3] = [-1, 0, 0 ]
	$QuadIndex = _AddQuadEx( $ObjId, $V7, $V5, $V1, $V3, $Normal, $Red, $Green, $Blue, $Alpha )
	If $Tex <> "" Then TextureBind( $ObjId, $QuadIndex, $Tex )

	Local $Normal[3] = [ 0, 1, 0 ]
	$QuadIndex = _AddQuadEx( $ObjId, $V1, $V5, $V6, $V2, $Normal, $Red, $Green, $Blue, $Alpha )
	If $Tex <> "" Then TextureBind( $ObjId, $QuadIndex, $Tex )

	Local $Normal[3] = [ 0,-1, 0 ]
	$QuadIndex = _AddQuadEx( $ObjId, $V7, $V3, $V4, $V8, $Normal, $Red, $Green, $Blue, $Alpha )
	If $Tex <> "" Then TextureBind( $ObjId, $QuadIndex, $Tex )

EndFunc

;--------------------------------------------------------------------------------------------
Func _CreateWireCube( $ObjId, $OrX, $OrY, $OrZ, $DeX, $DeY, $DeZ ,$Red, $Green, $Blue )
	
	Local $V1[3] = [ $OrX, $OrY, $OrZ ]
	Local $V2[3] = [ $DeX, $OrY, $OrZ ]
	Local $V3[3] = [ $OrX, $DeY, $OrZ ]
	Local $V4[3] = [ $DeX, $DeY, $OrZ ]
	Local $V5[3] = [ $OrX, $OrY, $DeZ ]
	Local $V6[3] = [ $DeX, $OrY, $DeZ ]
	Local $V7[3] = [ $OrX, $DeY, $DeZ ]
	Local $V8[3] = [ $DeX, $DeY, $DeZ ]
	
	_AddLineEx( $ObjId, $V1, $V2, $Red, $Green, $Blue )
	_AddLineEx( $ObjId, $V2, $V6, $Red, $Green, $Blue )
	_AddLineEx( $ObjId, $V6, $V5, $Red, $Green, $Blue )
	_AddLineEx( $ObjId, $V5, $V1, $Red, $Green, $Blue )
	
	_AddLineEx( $ObjId, $V3, $V4, $Red, $Green, $Blue )
	_AddLineEx( $ObjId, $V4, $V8, $Red, $Green, $Blue )
	_AddLineEx( $ObjId, $V8, $V7, $Red, $Green, $Blue )
	_AddLineEx( $ObjId, $V7, $V3, $Red, $Green, $Blue )
	
	_AddLineEx( $ObjId, $V2, $V4, $Red, $Green, $Blue )
	_AddLineEx( $ObjId, $V6, $V8, $Red, $Green, $Blue )
	_AddLineEx( $ObjId, $V5, $V7, $Red, $Green, $Blue )
	_AddLineEx( $ObjId, $V1, $V3, $Red, $Green, $Blue )
	
EndFunc

;--------------------------------------------------------------------------------------------
;_CreateRect by CyberZeroCool
Func _CreateRect( $ObjId, $Red, $Green, $Blue, $Alpha, $width, $height, $depth, $x, $y, $z )
   
    Local $V1[3] = [ -($width/2)+$x,  $height/2+$y, -($depth/2)+$z]
    Local $V2[3] = [  $width/2+$x,  $height/2+$y, -($depth/2)+$z]
    Local $V3[3] = [ -($width/2)+$x, -($height/2)+$y, -($depth/2)+$z]
    Local $V4[3] = [  $width/2+$x, -($height/2)+$y, -($depth/2)+$z]
    Local $V5[3] = [ -($width/2)+$x,  $height/2+$y,  $depth/2+$z]
    Local $V6[3] = [  $width/2+$x,  $height/2+$y,  $depth/2+$z]
    Local $V7[3] = [ -($width/2)+$x, -($height/2)+$y,  $depth/2+$z]
    Local $V8[3] = [  $width/2+$x, -($height/2)+$y,  $depth/2+$z]
   
    Local $Normal[3] = [ 0, 0,-1 ]
    _AddTriangleEx( $ObjId, $V1, $V2, $V3, $Normal, $Red, $Green, $Blue, $Alpha )
    _AddTriangleEx( $ObjId, $V3, $V2, $V4, $Normal, $Red, $Green, $Blue, $Alpha )

    Local $Normal[3] = [ 1, 0, 0 ]
    _AddTriangleEx( $ObjId, $V6, $V8, $V2, $Normal, $Red, $Green, $Blue, $Alpha )
    _AddTriangleEx( $ObjId, $V8, $V4, $V2, $Normal, $Red, $Green, $Blue, $Alpha )

    Local $Normal[3] = [ 0, 0, 1 ]
    _AddTriangleEx( $ObjId, $V6, $V5, $V8, $Normal, $Red, $Green, $Blue, $Alpha )
    _AddTriangleEx( $ObjId, $V7, $V8, $V5, $Normal, $Red, $Green, $Blue, $Alpha )

    Local $Normal[3] = [-1, 0, 0 ]
    _AddTriangleEx( $ObjId, $V5, $V1, $V3, $Normal, $Red, $Green, $Blue, $Alpha )
    _AddTriangleEx( $ObjId, $V5, $V3, $V7, $Normal, $Red, $Green, $Blue, $Alpha )

    Local $Normal[3] = [ 0, 1, 0 ]
    _AddTriangleEx( $ObjId, $V1, $V5, $V6, $Normal, $Red, $Green, $Blue, $Alpha )
    _AddTriangleEx( $ObjId, $V1, $V6, $V2, $Normal, $Red, $Green, $Blue, $Alpha )

    Local $Normal[3] = [ 0,-1, 0 ]
    _AddTriangleEx( $ObjId, $V3, $V8, $V7, $Normal, $Red, $Green, $Blue, $Alpha )
    _AddTriangleEx( $ObjId, $V3, $V4, $V8, $Normal, $Red, $Green, $Blue, $Alpha )
EndFunc

;--------------------------------------------------------------------------------------------
;_CreateCubeEx by Alek
Func _CreateCubeEx( $ObjId, $OrX, $OrY, $OrZ, $DeX, $DeY, $DeZ ,$Red, $Green, $Blue, $Alpha )   
    Local $V1[3] = [ $OrX, $OrY, $OrZ ]
    Local $V2[3] = [ $DeX, $OrY, $OrZ ]
    Local $V3[3] = [ $OrX, $DeY, $OrZ ]
    Local $V4[3] = [ $DeX, $DeY, $OrZ ]
    Local $V5[3] = [ $OrX, $OrY, $DeZ ]
    Local $V6[3] = [ $DeX, $OrY, $DeZ ]
    Local $V7[3] = [ $OrX, $DeY, $DeZ ]
    Local $V8[3] = [ $DeX, $DeY, $DeZ ]
    Local $QuadIndex[6]
   
    Local $Normal[3] = [ 0, 0,-1 ]
    Local $QuadIndex
    $QuadIndex[0] = _AddQuadEx( $ObjId, $V1, $V2, $V4, $V3, $Normal, $Red, $Green, $Blue, $Alpha )

    Local $Normal[3] = [ 1, 0, 0 ]
    $QuadIndex[1] = _AddQuadEx( $ObjId, $V8, $V4, $V2, $V6, $Normal, $Red, $Green, $Blue, $Alpha )

    Local $Normal[3] = [ 0, 0, 1 ]
    $QuadIndex[2] = _AddQuadEx( $ObjId, $V7, $V8, $V6, $V5, $Normal, $Red, $Green, $Blue, $Alpha )

    Local $Normal[3] = [-1, 0, 0 ]
    $QuadIndex[3] = _AddQuadEx( $ObjId, $V3, $V7, $V5, $V1, $Normal, $Red, $Green, $Blue, $Alpha )
   
    Local $Normal[3] = [ 0, 1, 0 ]
    $QuadIndex[4] = _AddQuadEx( $ObjId, $V1, $V5, $V6, $V2, $Normal, $Red, $Green, $Blue, $Alpha )

    Local $Normal[3] = [ 0,-1, 0 ]
    $QuadIndex[5] = _AddQuadEx( $ObjId, $V7, $V3, $V4, $V8, $Normal, $Red, $Green, $Blue, $Alpha )
   
    Return $QuadIndex
EndFunc