#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_UseAnsi=y
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
#cs ----------------------------------------------------------------------------

 AutoIt Version: 3.2.4.9
 Author:         myName

 Script Function:
	Template AutoIt script.

#ce ----------------------------------------------------------------------------

; Script Start - Add your code below here

#include "GlPluginUtils.au3"
#Include <Misc.au3>

Global $pi = 3.14159265358979

FileInstall( "Cabin_Tex.bmp", "Cabin_Tex.bmp" )

AutoItSetOption( "TrayIconHide", 1 )
Opt( "WinTitleMatchMode", 3 )

HotKeySet( "{ESC}", "EndGame" )

TextureSetBuffer( 1 )
TextureAdd( "Cabin", @ScriptDir & "\Cabin_Tex.bmp" )
TextureSetMode( 1 )

;defining window
$WinTitle = "ItCopter"
DefineGlWindow( $WinTitle )
SetCameraView( 1.0, 5000 )

;setting back color
SetClearColor( 0.8, 0.8, 0.8 )

;creating light 0
CreateLight( 0, 300, 300, 300 )
SetLightAmbient( 0, 0.2, 0.2, 0.2 )
SetLightDiffuse( 0, 0.7, 0.7, 0.7 )
SetLightSpecular( 0, 0.1, 0.1, 0.1 )

;======================================
;lets select a color
;======================================
SetCamera( 0, 8, 30, 0, 8, 0 )

$Plane = ObjectCreate( )
for $x=0 to 100
    for $y=0 to 100
		;AddCube( ObjId, Width, Height, Deph, Red, Green, Blue, Alpha )
		$Cube = AddCube( $Plane, 5, 5, 0.5, 0.2, 0.2, random (0.6,0.9 ), random (1.0,1.5 ) )
		ShapeTranslate( $Plane, $Cube, $x*5 - 250, $y*5 - 250, -10 )
    next
next
SetPrint( $Plane )

$MakeColorPallete = ObjectCreate( )
$YColorPos = 11
$Cube = AddCube( $MakeColorPallete, 2.5, 2.5, 1, 1, 1, 0.5, 1.0 )
ShapeTranslate( $MakeColorPallete, $Cube, -12.5, $YColorPos, 0 )
$Cube = AddCube( $MakeColorPallete, 2.5, 2.5, 1, 1, 1, 1, 1.0 )
ShapeTranslate( $MakeColorPallete, $Cube, -7.5, $YColorPos, 0 )
$Cube = AddCube( $MakeColorPallete, 2.5, 2.5, 1, 0.5, 1, 0.5, 1.0 )
ShapeTranslate( $MakeColorPallete, $Cube, -2.5, $YColorPos, 0 )
$Cube = AddCube( $MakeColorPallete, 2.5, 2.5, 1, 0.5, 0.5, 1, 1.0 )
ShapeTranslate( $MakeColorPallete, $Cube, 2.5, $YColorPos, 0 )
$Cube = AddCube( $MakeColorPallete, 2.5, 2.5, 1, 1, 0.5, 0.5, 1.0 )
ShapeTranslate( $MakeColorPallete, $Cube, 7.5, $YColorPos, 0 )
$Cube = AddCube( $MakeColorPallete, 2.5, 2.5, 1, 1, 0.7, 0.9, 1.0 )
ShapeTranslate( $MakeColorPallete, $Cube, 12.5, $YColorPos, 0 )
SetPrint( $MakeColorPallete )

$ColorPalleteSelector = ObjectCreate( )
$Disk = AddPartialDisk( $ColorPalleteSelector, 0, 0, 0, 2.1, 2.6, 20, 2, 0, 360, 0, 1, 0, 1 )
ShapeRotate( $ColorPalleteSelector, $Disk, 90, 0, 0 )
ObjectTranslate( $ColorPalleteSelector, -12.5, $YColorPos, 0 )
SetPrint( $ColorPalleteSelector )

$Text = ObjectCreate( )
$SelectText = AddStrokeText( $Text, 0, 0, 0, 1, 1, 0.5, "Select a color and type 'ENTER'" )
ShapeScale( $Text, $SelectText, 0.0132, 0.02, 0.012 )
ShapeTranslate( $Text, $SelectText, -14, 16, 0 )
SetPrint( $Text )

$MainRotor = 0
$DirRotor = 0
$Heli = MakeHeli( 1, 1, 0.5, $MainRotor, $DirRotor )
SetPrint( $Heli )
ObjectRotate( $Heli, 0, -45, 0 )

$CurrSlot = 1
$SetColor = 0
Dim $RGBColor[3]
While 1
	Sleep( 50 )
	If _IsPressed( "25" ) Then
		If $CurrSlot > 1 Then
			$CurrSlot -= 1
			$SetColor = 1
		EndIf
	EndIf
	If _IsPressed( "27" ) Then
		If $CurrSlot < 6 Then
			$CurrSlot += 1
			$SetColor = 1
		EndIf
	EndIf
	If _IsPressed( "0D" ) Then
		ExitLoop
	EndIf
	If $SetColor = 1 Then
		If $CurrSlot = 1 Then
			Dim $RGBColor[3] = [1, 1, 0.5]
			ObjectTranslate( $ColorPalleteSelector, -12.5, $YColorPos, 0 )
		EndIf
		If $CurrSlot = 2 Then
			Dim $RGBColor[3] = [1, 1, 1]
			ObjectTranslate( $ColorPalleteSelector, -7.5, $YColorPos, 0 )
		EndIf
		If $CurrSlot = 3 Then
			Dim $RGBColor[3] = [0.5, 1, 0.5]
			ObjectTranslate( $ColorPalleteSelector, -2.5, $YColorPos, 0 )
		EndIf
		If $CurrSlot = 4 Then
			Dim $RGBColor[3] = [0.5, 0.5, 1]
			ObjectTranslate( $ColorPalleteSelector, 2.5, $YColorPos, 0 )
		EndIf
		If $CurrSlot = 5 Then
			Dim $RGBColor[3] = [1, 0.5, 0.5]
			ObjectTranslate( $ColorPalleteSelector, 7.5, $YColorPos, 0 )
		EndIf
		If $CurrSlot = 6 Then
			Dim $RGBColor[3] = [1, 0.7, 0.9]
			ObjectTranslate( $ColorPalleteSelector, 12.5, $YColorPos, 0 )
		EndIf
		
		ObjectDelete( $Heli )
		$Heli = MakeHeli( $RGBColor[0], $RGBColor[1], $RGBColor[2], $MainRotor, $DirRotor )
		SetPrint( $Heli )
		$SetColor = 0
		ObjectRotate( $Heli, 0, -45, 0 )
	EndIf
	SceneDraw( )
Wend
ObjectRotate( $Heli, 0, 0, 0 )

ObjectDelete( $MakeColorPallete )
ObjectDelete( $ColorPalleteSelector )
ObjectDelete( $Text )
ObjectDelete( $Plane )
ClearPrintBuffer( )

;======================================
;now starting game
;======================================
$CenterX = @DesktopWidth / 2
$CenterY = @DesktopHeight / 2

MouseMove( $CenterX, $CenterY, 0 )

SetPrint( $Heli )
$Plane = ObjectCreate( )
for $x=0 to 50
    for $z=0 to 50
		;AddCube( ObjId, Width, Height, Deph, Red, Green, Blue, Alpha )
		$Cube = AddCube( $Plane, 50, 0.5, 50, 0.2, random (0.6,0.8 ), 0.2, 1.0 )
		ShapeTranslate( $Plane, $Cube, $x*50 - 1000, -0.77, $z*50 - 1000 )
    next
next
SetPrint( $Plane )

SetCamera( 0, 20, 70, 0, 3, 0 )

$YForce = 0
$YPos = 0
$XPos = 0
$ZPos = 0
$Speed = 0.2
$Rotation = 0
$DirectionX = 0
$DirectionZ = 0
$Inercia = 0.2
$InerciaX = 0
$InerciaZ = 0
$ZLevel = 0

$EyeX = 0
$EyeZ = 0
$Cam = 0

$DeathZone = 60
$RotorY = 0
While 1
	$RotorY += 40
	If $RotorY >= 360 Then $RotorY -= 360
	
	If $Rotation >= 360 Then $Rotation -= 360
	If $Rotation < 0 Then $Rotation += 360
	SceneDraw( )
	
	Sleep( 20 )
	ObjectRotate( $Heli, 0, $Rotation + 90, $ZLevel )
	_Limiters( $XPos, $InerciaX )
	_Limiters( $ZPos, $InerciaZ )
	ObjectTranslate( $Heli, $XPos, $YPos, $ZPos )
	
	If $Cam = 1 Then
		_Movecam( 100, $EyeX, $EyeZ )
		SetCamera( $XPos + $EyeX, $YPos + 40, $EyeZ + $ZPos, $XPos, $YPos, $ZPos )
	Else
		SetCamera( 0, 40, 80, $XPos, $YPos, $ZPos )
	EndIf
	
	If WinActive ( $WinTitle ) Then
		$mouse = MouseGetPos( )
		if $YPos > 0 Then
			If $mouse[1] < $CenterY - $DeathZone Then
				_Move( -$Speed, $Rotation, $XPos, $ZPos, $DirectionX, $DirectionZ )
				$InerciaX += $DirectionX * $Inercia
				$InerciaZ += $DirectionZ * $Inercia
				$ZLevel = -10
			EndIf
			If $mouse[1] > $CenterY + $DeathZone Then
				_Move(  $Speed, $Rotation, $XPos, $ZPos, $DirectionX, $DirectionZ )
				$InerciaX += $DirectionX * $Inercia
				$InerciaZ += $DirectionZ * $Inercia
				$ZLevel = 10
			EndIf
			ObjectRotate( $Heli, 0, $Rotation + 90, $ZLevel / 2 )
			SceneDraw( )
		EndIf
		If $mouse[0] < $CenterX - $DeathZone Then
			$ControlSpeed =  int( ( $CenterX - $mouse[0] ) / ( $CenterX / 8 ) )
			$Rotation += $ControlSpeed + 1
		EndIf
		If $mouse[0] > $CenterX + $DeathZone Then
			$ControlSpeed = int( ( $mouse[0] - $CenterX ) / ( $CenterX / 8 ) )
			$Rotation -= $ControlSpeed + 1
		EndIf
		
		If _IsPressed("20") Then 
			$YForce = 0.5
		EndIf
		If _IsPressed("43") Then
			If $Cam = 1 Then
				$Cam = 0
			Else
				$Cam = 1
			EndIf
			Sleep( 100 )
		EndIf
	EndIf
	
	_Force( $YPos, $YForce )
	If $YPos <= 0 Then
		$InerciaX = $InerciaX / 3
		$InerciaZ = $InerciaZ / 3
	EndIf
	_ApplyInercia( $XPos, $InerciaX )
	_ApplyInercia( $ZPos, $InerciaZ )
	_AdjustLevel( $ZLevel )
	ObjectRotate( $MainRotor, 0, $RotorY, 0 )
Wend

Func _Limiters( ByRef $Pos, ByRef $Iner )
	Local $Lim = 500
	If $Pos > $Lim Then
		$Pos = $Lim
		$Iner = 0
	EndIf
	If $Pos < -$Lim Then
		$Pos = -$Lim
		$Iner = 0
	EndIf
EndFunc

;adapted from TestWorld by zerozshadow
Func _Movecam( $distance, ByRef $EyeX, ByRef $EyeZ )
    $EyeX = -cos((2*$pi/360)*($rotation+90))*$distance
    $EyeZ = sin((2*$pi/360)*($rotation+90))*$distance
EndFunc

;adapted from TestWorld by zerozshadow
Func _Move( $speedgo, $rotation, ByRef $XPos, ByRef $ZPos, ByRef $DirectionX, ByRef $DirectionZ )
    Local $movex= -cos((2*$pi/360)*($rotation+90))*$speedgo
    Local $movez= sin((2*$pi/360)*($rotation+90))*$speedgo
	$DirectionX = $movex
	$DirectionZ = $movez
;~     $XPos += $movex
;~     $ZPos += $movez
EndFunc

;adapted from TestWorld by zerozshadow
Func _Force( ByRef $pos, ByRef $force )
    $pos += $force
    $force -= 0.02
    if $force < -1 then
		$force = -1
	EndIf
    if $pos <= 0 then 
        $force = 0
		$pos = 0
    EndIf
EndFunc

Func _ApplyInercia( ByRef $pos, ByRef $inercia )
	Local $DecValue = 0.001
    $pos += $inercia
	If $inercia < 0 Then
		$inercia += $DecValue
	Else
		$inercia -= $DecValue
	EndIf
EndFunc

Func _AdjustLevel( ByRef $CurrLevel )
	If $CurrLevel > 0 Then
		$CurrLevel -= 1
	EndIf
	If $CurrLevel < 0 Then
		$CurrLevel += 1
	EndIf
EndFunc

Func MakeHeli( $Red, $Green, $Blue, ByRef $MainRotorId, ByRef $DirRotorId )
	Local $RetVal
	$RetVal = ObjectCreate( )
	
	Local $Cabin = AddSphere( $RetVal, 1, 1, 0, 1, 20, 9, $Red, $Green, $Blue, 1 )
	ShapeScale( $RetVal, $Cabin, 1, 1.2, 1 )
	ShapeRotate( $RetVal, $Cabin, 0, 0, 5 )
	TextureBind( $RetVal, $Cabin, "Cabin" )
	
	;----------------------
	;Corpo principal
	Local $MainAxis = AddCube( $RetVal, 1, 1.5, 0.3, 0, 0, 0, 1 )
	ShapeTranslate( $RetVal, $MainAxis, 0, 1.8, 0 )
	$MainAxis = AddCylinder( $RetVal, 0, 0, 0, 0.6, 0.6, 2, 20, 2, $Red, $Green, $Blue, 1 )
	ShapeRotate( $RetVal, $MainAxis, 90, 0, 0 )
	ShapeTranslate( $RetVal, $MainAxis, 0, 1.2, -1 )
	$MainAxis = AddPartialDisk( $RetVal, 0, 0, 0, 0, 0.6, 20, 2, 0, 360, $Red, $Green, $Blue, 1 )
	ShapeRotate( $RetVal, $MainAxis, -90, 0, 0 )
	ShapeTranslate( $RetVal, $MainAxis, 0, 1.2, -1 )
	$MainAxis = AddPartialDisk( $RetVal, 0, 0, 0, 0, 0.6, 20, 2, 0, 360, $Red, $Green, $Blue, 1 )
	ShapeRotate( $RetVal, $MainAxis, 90, 0, 0 )
	ShapeTranslate( $RetVal, $MainAxis, 0, 1.2, 1 )
	$MainAxis = AddCube( $RetVal, 3, 0.2, 0.3, 0, 0, 0, 1 )
	ShapeTranslate( $RetVal, $MainAxis, 0, 0.5, 0 )
	
	;----------------------
	;motor
	Local $ElectMotor = ObjectCreate( )
	SetToObject( $RetVal, $ElectMotor )
	AddCylinder( $ElectMotor, 0, 0, 0, 0.4, 0.4, 1.4, 20, 2, 0.7, 0.7, 0.7, 1 )
	AddCylinder( $ElectMotor, 0, 0.8, 0, 0.41, 0.41, 0.61, 20, 2, 0, 0, 0, 1 )
	AddPartialDisk( $ElectMotor, 0, 1.41, 0, 0, 0.41, 20, 2, 0, 360, 0, 0, 0, 1 )
	ObjectTranslate( $ElectMotor, -1.0, 0.6, 0 )
	
	;----------------------
	;cauda
	Local $Tail = ObjectCreate( )
	SetToObject( $RetVal, $Tail )
	Local $Tail_pt1 = AddCylinder( $Tail, 0, 0, 0, 0.1, 0.1, 6, 9, 2, 0, 0, 0, 1 )
	ShapeRotate( $Tail, $Tail_pt1, 0, 0, 90 )
	Local $Tail_pt2 = AddCylinder( $Tail, 0, 0, 0, 0.15, 0.15, 0.4, 9, 2, 0, 0, 0, 1 )
	ShapeRotate( $Tail, $Tail_pt2, 0, 90, 90 )
	ShapeTranslate( $Tail, $Tail_pt2, -6, 0, -0.3 )
	$Tail_pt2 = AddPartialDisk( $Tail, 0, 0, 0, 0, 0.15, 9, 2, 0, 360, 0, 0, 0, 1 )
	ShapeRotate( $Tail, $Tail_pt2, 90, 0, 0 )
	ShapeTranslate( $Tail, $Tail_pt2, -6, 0, -0.3 )
	
	;estabilizadores
	Local $Tail_Prf = AddCube( $Tail, 0.5, 0.01, 1.5, $Red, $Green, $Blue, 1 )
	ShapeTranslate( $Tail, $Tail_Prf, -5, 0, -0.75 )
	$Tail_Prf = AddCube( $Tail, 0.5, 0.01, 1.5, $Red, $Green, $Blue, 1 )
	ShapeRotate( $Tail, $Tail_Prf, -80, 0, 0 )
	ShapeTranslate( $Tail, $Tail_Prf, -3, -0.71, -0.1 )

	;direcional rotor
	$DirRotorId = ObjectCreate( )
	SetToObject( $Tail, $DirRotorId )
	AddCylinder( $DirRotorId, 0, 0.1, 0, 0.1, 0.1, 0.3, 9, 2, 0, 0, 0, 1 )
	AddSphere( $DirRotorId, 0, 0.3, 0, 0.2, 6, 3, 0, 0, 0, 1 )
	AddPartialDisk( $DirRotorId, 0, 0.3, 0, 0, 1.3, 20, 2, 0, 360, 0.1, 0.1, 0.1, 0.15 )
	ObjectRotate( $DirRotorId, 90, 0, 0 )
	ObjectTranslate( $DirRotorId, -6, 0, 0 )

	ObjectRotate( $Tail, 0, 0, -5 )
	ObjectTranslate( $Tail, -1.45, 0.5, 0 )

	;----------------------
	;gear
	Local $Gear = ObjectCreate( )
	SetToObject( $RetVal, $Gear )
	
	;ski fixer
	Local $Gear_fx = ObjectCreate( )
	Local $Gear_fx_sh = AddCube( $Gear_fx, 0.4, 0.01, 2, 0, 0, 0, 1 )
	AddCylinder( $Gear_fx, 0, 0, 0, 0.2, 0.2, 0.5, 9, 2, 0, 0, 0, 1 )
	$Gear_fx_sh = AddCube( $Gear_fx, 0.4, 0.01, 0.59, 0, 0, 0, 1 )
	ShapeRotate( $Gear_fx, $Gear_fx_sh, -70, 0, 0 )
	ShapeTranslate( $Gear_fx, $Gear_fx_sh, 0, -0.25, -1.1 )
	$Gear_fx_sh = AddCube( $Gear_fx, 0.4, 0.01, 0.59, 0, 0, 0, 1 )
	ShapeRotate( $Gear_fx, $Gear_fx_sh, 70, 0, 0 )
	ShapeTranslate( $Gear_fx, $Gear_fx_sh, 0, -0.25, 1.1 )
	
	;putting fixers
	Local $LegFx1 = ObjectCreate( )
	SetToObject( $LegFx1, $Gear_fx )
	ObjectTranslate( $LegFx1, -1, 0, 0 )
	SetToObject( $Gear, $LegFx1 )
	Local $LegFx2 = ObjectCreate( )
	SetToObject( $LegFx2, $Gear_fx )
	ObjectTranslate( $LegFx2, 1, 0, 0 )
	SetToObject( $Gear, $LegFx2 )
	
	;ski
	Local $Leg = ObjectCreate( )
	Local $Leg_pt1 = AddCylinder( $Leg, 0, 0, 0, 0.1, 0.1, 4.5, 9, 2, 0, 0, 0, 1 )
	ShapeRotate( $Leg, $Leg_pt1, 0, 0, -90 )
	ShapeTranslate( $Leg, $Leg_pt1, -2, -0.5, 0 )
	Local $Leg_pt2 = AddCylinder( $Leg, 0, 0, 0, 0.1, 0.1, 0.7, 9, 2, 0, 0, 0, 1 )
	ShapeRotate( $Leg, $Leg_pt2, 0, 0, -45 )
	ShapeTranslate( $Leg, $Leg_pt2, 2.47, -0.5, 0 )
	Local $Leg_pt2 = AddSphere( $Leg, 0, 0.7, 0, 0.1, 9, 9, $Red, $Green, $Blue, 1 )
	ShapeRotate( $Leg, $Leg_pt2, 0, 0, -45 )
	ShapeTranslate( $Leg, $Leg_pt2, 2.47, -0.5, 0 )
	
	;putting skis
	Local $Leg1 = ObjectCreate( )
	SetToObject( $Leg1, $Leg )
	ObjectTranslate( $Leg1, 0, 0, -1.2 )
	SetToObject( $Gear, $Leg1 )
	Local $Leg2 = ObjectCreate( )
	SetToObject( $Leg2, $Leg )
	ObjectTranslate( $Leg2, 0, 0, 1.2 )
	SetToObject( $Gear, $Leg2 )

	;----------------------
	;Main rotor
	$MainRotorId = ObjectCreate( )
	SetToObject( $RetVal, $MainRotorId )
	AddCylinder( $MainRotorId, 0, 1.3, 0, 0.1, 0.1, 2, 9, 2, 0, 0, 0, 1 )
	AddSphere( $MainRotorId, 0, 3.3, 0, 0.2, 6, 3, 0, 0, 0, 1 )
	AddPartialDisk( $MainRotorId, 0, 3.3, 0, 0, 5.5, 20, 2, 0, 360, 0.1, 0.1, 0.1, 0.15 )
	AddPartialDisk( $MainRotorId, 0, 3.4, 0, 0, 5.5, 20, 2, 0, 45, 0.2, 0.2, 0.2, 0.15 )
	AddPartialDisk( $MainRotorId, 0, 3.4, 0, 0, 5.5, 20, 2, 180, 45, 0.2, 0.2, 0.2, 0.15 )
	
	Return $RetVal
EndFunc

Func EndGame( )
	Exit
EndFunc