#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_outfile_type=a3x
#AutoIt3Wrapper_icon=PCInfo.ico
#AutoIt3Wrapper_Compression=4
#AutoIt3Wrapper_Res_Comment=PC Info Generator using WMI
#AutoIt3Wrapper_Res_Description=PC Information Generator
#AutoIt3Wrapper_Res_Fileversion=1.0.0.0
#AutoIt3Wrapper_Res_LegalCopyright=Vinu Felix.
#AutoIt3Wrapper_Res_Language=1033
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
#include "CompInfo.au3"
Dim $Processes, $Services, $aOS,$Processors,$drv

msgbox(64,"Welcome","I am about to gather info about this system" & @CRLF & "All data will be saved in this folder once completed" & @CRLF & "Press OK to start",10)


$file=FileOpen ("info.html",2)
If $file = -1 Then
    MsgBox(0, "Error", "Unable to open file to save info in current folder: " & @ScriptDir)
    Exit
EndIf
;setup file
FileWriteLine($file,"<html><body><font face=Arial size=-1><table width=100% border=1>")
FileWriteLine ($file,"<tr><td colpsan=4><b>SYSTEM INFO</b></td></tr>")
FileWriteLine($file,"<tr><td colspan=2><b>Server Name:</b></td><td colpsan=2>" &  @ComputerName & "</td></tr>")

FileWriteLine($file,"<tr><td colpsan=4><b>DRIVE(s) INFORMATION</b></td></tr>")
;Drive details
_ComputerGetDrives($drv,"ALL")
If NOT @error Then
    FileWriteLine($file, "<tr><td colpsan=4>Found <b>" & $drv[0][0] & "</b> drive(s)</td></tr>")
	FileWriteLine($file, "<tr><td ><b>DriveName</b></td><td><b>Total Space</b></td><td colpsan=2><b>Free Space</b></td></tr>")
    For $i = 1 to $drv[0][0] Step 1
        FileWriteLine($file,"<tr><td > " & $drv[$i][0] & "</td><td>" & Round($drv[$i][5] / 1024, 2) & "GB</td><td colspan=2>" & Round($drv[$i][4] / 1024, 2) & "GB</td> </tr>")
    Next
Else
	FileWriteLine($file,"<tr><td colpsan=4>Failed To enumerate drives. Could not fetch info !</td></tr>" )
EndIf
FileWriteLine($file,"<tr><td colpsan=4><b>PROCESS LIST</b></td></tr>")
;process list
$Processes = _ProcessListProperties()
If NOT @error Then
	FileWriteLine($file,"<tr><td><b>Process Name</b> </td><td><b>Binary</b>  </td><td><b>Memory</b> </td><td><b>CPU Usage</b> </td></tr>")
	
	For $i = 1 To $Processes[0][0] Step 1
		FileWriteLine($file,"<tr><td>" & $Processes[$i][0] & "</td><td>" & $Processes[$i][5]  & "</td><td>" & Round($Processes[$i][7]/1024)  & "KB</td><td>" & $Processes[$i][6] & "</td></tr>")
	
	Next 
Else
	FileWriteLine($file,"<tr><td colpsan=4>Failed To enumerate processes. Could not fetch info !</td></tr>" )	
EndIf

;Page File details
FileWriteLine($file, "<tr><td colpsan=4><b>PAGEFILE</b></td></tr>")
_ComputerGetOSs($aOS)
If NOT @error Then
	FileWriteLine($file,"<tr><td colpsan=4>Page File Size: <b>" & $aOS[1][56] & "</b></td></tr>")
Else
	FileWriteLine($file,"<tr><td colpsan=4>Failed To obtain Page File Info. Could not fetch info !</td></tr>")	
EndIf
;Processor details

FileWriteLine($file,"<tr><td colpsan=4><b>CPU-PROCESSOR(S)</b></td></tr>")
_ComputerGetProcessors($Processors)
If NOT @error Then
	For $i = 1 To $Processors[0][0] Step 1
		FileWriteLine($file,"<tr><td>Processor Name:</td><td><b>" & $Processors[$i][0] &  "</b></td><td>Load Percentage:</td><td> <b>" & $Processors[$i][21]& "</b></td></tr>")
	
	Next 
Else
	FileWriteLine($file,"<tr><td colpsan=4>Failed To enumerate Processors. Could not fetch info !</td></tr>" )	
EndIf
;Service Details
FileWriteLine($file,"<tr><td colpsan=4><b>SERVICES LIST</b></td></tr>")
_ComputerGetServices($Services)
If NOT @error Then
		FileWriteLine($file,"<tr><td colspan=2><b>Service Name</b></td><td colspan=2> <b>Status</b></td></tr>")

For $i = 1 To $Services[0][0] Step 1
		FileWriteLine($file,"<tr><td colspan=2>" & $Services[$i][7] &  "</td><td colspan=2>" & $Services[$i][17] & "</td></tr>")
	
	Next 
Else
	FileWriteLine($file,"<tr><td colpsan=4>Failed To enumerate processes. Could not fetch info !</td></tr>" )	
EndIf
FileWriteLine($file,"</table></font></body></html>")
FileClose($file)
msgbox(64,"Process Complete","All the information is saved in"& @CRLF & "Info.html"& @CRLF & "in the same folder" & @CRLF & "Press OK to launch file",10)
ShellExecute("info.html", "", @ScriptDir, "open")
