#include <file.au3>
#include <Array.au3>

Func ShowResults($CaseNo, $CaseDescription, $Results)
  MsgBox(0, _
    "Results - " & $CaseNo, _
    $CaseDescription & @LF & @LF & _ 
    $Results)
EndFunc

;; UTF-8 log files with BOM

Dim $aErrorLogFilesBOM
$aErrorLogFilesBOM = _FileListToArray(@ScriptDir, "BOM_*.log", 1)
If @Error=4 Then
  Exit
Else
  _ArraySort($aErrorLogFilesBOM)

  $CaseNo = "Case 1"
  $CaseDescription = _
  "UTF-8 with BOM, encoding auto-detected:" & @LF & @LF & _
  "  => FAILS: if 8-bit char contained, ignores all subsequent files!"
  $LoggedErrors = ""
  For $index = 1 to $aErrorLogFilesBOM[0]
    Local $filepath = @ScriptDir & "\" & $aErrorLogFilesBOM[$index]
    $ErrorLogFile = FileOpen($filepath, 0)
    $LoggedErrors = $LoggedErrors & FileRead($ErrorLogFile)
    FileClose($ErrorLogFile)
  Next
  ShowResults($CaseNo, $CaseDescription, $LoggedErrors)

  $CaseNo = "Case 2"
  $CaseDescription = _
  "UTF-8 with BOM, read as binary and decoded as UTF-8" & @LF & @LF & _
  "  => OK after removal of BOM"
  $LoggedErrors = ""
  For $index = 1 to $aErrorLogFilesBOM[0]
    Local $filepath = @ScriptDir & "\" & $aErrorLogFilesBOM[$index]
    $ErrorLogFile = FileOpen($filepath, 16)
    ; BOM needs to be skipped
    $LoggedErrors = $LoggedErrors & _
      BinaryToString(BinaryMid(FileRead($ErrorLogFile), 4), 4)
    FileClose($ErrorLogFile)
  Next
  ShowResults($CaseNo, $CaseDescription, $LoggedErrors)

EndIf

;; UTF-8 log files without BOM

Dim $aErrorLogFilesNoBOM
$aErrorLogFilesNoBOM = _FileListToArray(@ScriptDir, "NoBOM_*.log", 1)
If @Error=4 Then
  Exit
Else
  _ArraySort($aErrorLogFilesNoBOM)

  $CaseNo = "Case 3"
  $CaseDescription = _
  "UTF-8 without BOM, encoding auto-detected" & @LF & @LF & _
  "  => FAILS: wrongly interprets characters as ANSI (of course)"
  $LoggedErrors = ""
  For $index = 1 to $aErrorLogFilesNoBOM[0]
    Local $filepath = @ScriptDir & "\" & $aErrorLogFilesNoBOM[$index]
    $ErrorLogFile = FileOpen($filepath, 0)
    $LoggedErrors = $LoggedErrors & FileRead($ErrorLogFile)
    FileClose($ErrorLogFile)
  Next
  ShowResults($CaseNo, $CaseDescription, $LoggedErrors)

  $CaseNo = "Case 4"
  $CaseDescription = _
  "UTF-8 without BOM, read as binary and decoded as UTF-8" & @LF & @LF & _
  "  => OK in AutoIt V. 3.3 (but V. 3.2.12.1 interprets the characters as ANSI!)"
  $LoggedErrors = ""
  For $index = 1 to $aErrorLogFilesNoBOM[0]
    Local $filepath = @ScriptDir & "\" & $aErrorLogFilesNoBOM[$index]
    $ErrorLogFile = FileOpen($filepath, 16)
    $LoggedErrors = $LoggedErrors & _
      BinaryToString(FileRead($ErrorLogFile), 4)
    FileClose($ErrorLogFile)
  Next
  ShowResults($CaseNo, $CaseDescription, $LoggedErrors)

EndIf
