;~ #Include <GuiListView.au3>
#include <WindowsConstants.au3>
#Include <GUIConstantsEx.au3>
#Include <WinAPI.au3>
#Include <ListViewConstants.au3>
#Include <GuiImageList.au3>
#Include <string.au3>

Opt("GUIOnEventMode", 1)
$Debug_LV = 0

$Gui = GUICreate("Test Alpha", 750, 590, 191, 113, BitOR($WS_MAXIMIZEBOX,$WS_MINIMIZEBOX,$WS_SIZEBOX,$WS_THICKFRAME,$WS_SYSMENU,$WS_CAPTION))

    $hImage = _GUIImageList_Create(16, 16, 5, 3)
    _GUIImageList_AddIcon($hImage, @SystemDir & "\shell32.dll", 110)
    _GUIImageList_AddIcon($hImage, @SystemDir & "\shell32.dll", 131)
    _GUIImageList_AddIcon($hImage, @SystemDir & "\shell32.dll", 165)
    _GUIImageList_AddIcon($hImage, @SystemDir & "\shell32.dll", 168)
    _GUIImageList_AddIcon($hImage, @SystemDir & "\shell32.dll", 137)
    _GUIImageList_AddIcon($hImage, @SystemDir & "\shell32.dll", 146)


$ListView = GUICtrlCreateListView("text0                       |text1|text2|text3", 8, 120, 121*3, 431, BitOR($LVS_REPORT, $LVS_SHOWSELALWAYS), BitOR($LVS_EX_HEADERDRAGDROP, $LVS_EX_FULLROWSELECT,$LVS_EX_GRIDLINES,$LVS_EX_DOUBLEBUFFER,$LVS_EX_SUBITEMIMAGES))

_GUICtrlListView_InsertItem($ListView, "TestText", 1)

_GUICtrlListView_SetImageList($listview, $hImage, 1)

GUISetState(@SW_SHOW,$GUI)

GUISetOnEvent($GUI_EVENT_CLOSE, "Close",$GUI)

GUICtrlSetState($listview, $GUI_FOCUS)
Func Close()
	Exit
EndFunc

ConsoleWrite("-Start--Original UDF's ----" & @CRLF)
Sleep(2000)
_GUICtrlListView_SetItemCut($ListView, 0, True)
ConsoleWrite("SetItemCut: True, Result: "&_GUICtrlListView_GetItemState($ListView, 0, $LVIS_CUT) & @CRLF)
Sleep(2000)
_GUICtrlListView_SetItemCut($ListView, 0, False)
ConsoleWrite("SetItemCut: False, Result: "&_GUICtrlListView_GetItemState($ListView, 0, $LVIS_CUT) & @CRLF)
Sleep(2000)
_GUICtrlListView_SetItemDropHilited($ListView, 0, True)
ConsoleWrite("SetItemDropHilited: True, Result: "&_GUICtrlListView_GetItemState($ListView, 0, $LVIS_DROPHILITED) & @CRLF)
Sleep(2000)
_GUICtrlListView_SetItemDropHilited($ListView, 0, False)
ConsoleWrite("SetItemDropHilited: False, Result: "&_GUICtrlListView_GetItemState($ListView, 0, $LVIS_DROPHILITED) & @CRLF)
Sleep(2000)
_GUICtrlListView_SetItemFocused($ListView, 0, True)
ConsoleWrite("SetItemFocused: True, Result: "&_GUICtrlListView_GetItemState($ListView, 0, $LVIS_FOCUSED) & @CRLF)
Sleep(2000)
_GUICtrlListView_SetItemFocused($ListView, 0, False)
ConsoleWrite("SetItemFocused: False, Result: "&_GUICtrlListView_GetItemState($ListView, 0, $LVIS_FOCUSED) & @CRLF)
Sleep(2000)
ConsoleWrite("-End------------------------" & @CRLF)
_SendMessage(GUICtrlGetHandle($ListView), $LVM_DELETEALLITEMS)
Sleep(2000)

ConsoleWrite("-Start--Fixed UDF's ----" & @CRLF)
_GUICtrlListView_InsertItem($ListView, "TestText", 1)
Sleep(2000)
__GUICtrlListView_SetItemCut($ListView, 0, True)
ConsoleWrite("SetItemCut: True, Result: "&_GUICtrlListView_GetItemState($ListView, 0, $LVIS_CUT) & @CRLF)
Sleep(2000)
__GUICtrlListView_SetItemCut($ListView, 0, False)
ConsoleWrite("SetItemCut: False, Result: "&_GUICtrlListView_GetItemState($ListView, 0, $LVIS_CUT) & @CRLF)
Sleep(2000)
__GUICtrlListView_SetItemDropHilited($ListView, 0, True)
ConsoleWrite("SetItemDropHilited: True, Result: "&_GUICtrlListView_GetItemState($ListView, 0, $LVIS_DROPHILITED) & @CRLF)
Sleep(2000)
__GUICtrlListView_SetItemDropHilited($ListView, 0, False)
ConsoleWrite("SetItemDropHilited: False, Result: "&_GUICtrlListView_GetItemState($ListView, 0, $LVIS_DROPHILITED) & @CRLF)
Sleep(2000)
__GUICtrlListView_SetItemFocused($ListView, 0, True)
ConsoleWrite("SetItemFocused: True, Result: "&_GUICtrlListView_GetItemState($ListView, 0, $LVIS_FOCUSED) & @CRLF)
Sleep(2000)
__GUICtrlListView_SetItemFocused($ListView, 0, False)
ConsoleWrite("SetItemFocused: False, Result: "&_GUICtrlListView_GetItemState($ListView, 0, $LVIS_FOCUSED) & @CRLF)
Sleep(2000)
ConsoleWrite("-End------------------------" & @CRLF)




While 1
	Sleep(10)
WEnd





; #########################################################################
; #### Fixed UDF's using _GUICtrlListView_SetItemState in the right way ###
; #########################################################################

Func __GUICtrlListView_SetItemCut($hWnd, $iIndex, $fEnabled = True)
	Local $iState = 0

	If $fEnabled Then $iState = $LVIS_CUT
	Return _GUICtrlListView_SetItemState($hWnd, $iIndex, $iState, $LVIS_CUT)
EndFunc   ;==>_GUICtrlListView_SetItemCut


Func __GUICtrlListView_SetItemFocused($hWnd, $iIndex, $fEnabled = True)
	Local $iState = 0

	If $fEnabled Then $iState = $LVIS_FOCUSED
	Return _GUICtrlListView_SetItemState($hWnd, $iIndex, $iState, $LVIS_FOCUSED)
EndFunc   ;==>_GUICtrlListView_SetItemFocused


Func __GUICtrlListView_SetItemDropHilited($hWnd, $iIndex, $fEnabled = True)
	Local $iState = 0

	If $fEnabled Then $iState = $LVIS_DROPHILITED
	Return _GUICtrlListView_SetItemState($hWnd, $iIndex, $iState, $LVIS_DROPHILITED)
EndFunc   ;==>_GUICtrlListView_SetItemDropHilited


; ############################################################################
; #### Original UDF's using _GUICtrlListView_SetItemState in the wrong way ###
; ############################################################################

Func _GUICtrlListView_SetItemCut($hWnd, $iIndex, $fEnabled = True)
	Local $iStateMask = 0

	If $fEnabled Then $iStateMask = $LVIS_CUT
	Return _GUICtrlListView_SetItemState($hWnd, $iIndex, $LVIS_CUT, $iStateMask)
EndFunc   ;==>_GUICtrlListView_SetItemCut


Func _GUICtrlListView_SetItemFocused($hWnd, $iIndex, $fEnabled = True)
	Local $iStateMask = 0

	If $fEnabled Then $iStateMask = $LVIS_FOCUSED
	Return _GUICtrlListView_SetItemState($hWnd, $iIndex, $LVIS_FOCUSED, $iStateMask)
EndFunc   ;==>_GUICtrlListView_SetItemFocused


Func _GUICtrlListView_SetItemDropHilited($hWnd, $iIndex, $fEnabled = True)
	Local $iStateMask = 0

	If $fEnabled Then $iStateMask = $LVIS_DROPHILITED
	Return _GUICtrlListView_SetItemState($hWnd, $iIndex, $LVIS_DROPHILITED, $iStateMask)
EndFunc   ;==>_GUICtrlListView_SetItemDropHilited



; #################################################################################
; ### Other original UDF's using _GUICtrlListView_SetItemState in the right way ###
; #################################################################################

Func _GUICtrlListView_SetItemOverlayImage($hWnd, $iIndex, $iImage)
	Return _GUICtrlListView_SetItemState($hWnd, $iIndex, _GUICtrlListView_IndexToOverlayImageMask($iImage), $LVIS_OVERLAYMASK)
EndFunc   ;==>_GUICtrlListView_SetItemOverlayImage


Func _GUICtrlListView_SetItemStateImage($hWnd, $iIndex, $iImage)
	Return _GUICtrlListView_SetItemState($hWnd, $iIndex, BitShift($iImage, -12), $LVIS_STATEIMAGEMASK)
EndFunc   ;==>_GUICtrlListView_SetItemStateImage











; #################################################################################
; ### Other original UDF's for making this example run ###
; #################################################################################

Func _GUICtrlListView_SetItemState($hWnd, $iIndex, $iState, $iStateMask)
	Local $tItem

	$tItem = DllStructCreate($tagLVITEM)
	DllStructSetData($tItem, "Mask", $LVIF_STATE)
	DllStructSetData($tItem, "Item", $iIndex)
	DllStructSetData($tItem, "State", $iState)
	DllStructSetData($tItem, "StateMask", $iStateMask)
	Return _GUICtrlListView_SetItemEx($hWnd, $tItem) <> 0
EndFunc   ;==>_GUICtrlListView_SetItemState


Func _GUICtrlListView_SetItemEx($hWnd, ByRef $tItem)
	If $Debug_LV Then _GUICtrlListView_ValidateClassName($hWnd)
	Local $iItem, $pItem, $iBuffer, $pBuffer, $pMemory, $tMemMap, $pText, $iResult
	Local $fUnicode = _GUICtrlListView_GetUnicodeFormat($hWnd)

	$pItem = DllStructGetPtr($tItem)
	If IsHWnd($hWnd) Then
		$iItem = DllStructGetSize($tItem)
		$iBuffer = DllStructGetData($tItem, "TextMax")
		If $fUnicode Then $iBuffer *= 2
		$pBuffer = DllStructGetData($tItem, "Text")
		$pMemory = _MemInit($hWnd, $iItem + $iBuffer, $tMemMap)
		$pText = $pMemory + $iItem
		DllStructSetData($tItem, "Text", $pText)
		_MemWrite($tMemMap, $pItem, $pMemory, $iItem)
		If $pBuffer <> 0 Then _MemWrite($tMemMap, $pBuffer, $pText, $iBuffer)
		If $fUnicode Then
			$iResult = _SendMessage($hWnd, $LVM_SETITEMW, 0, $pMemory, 0, "wparam", "ptr")
		Else
			$iResult = _SendMessage($hWnd, $LVM_SETITEMA, 0, $pMemory, 0, "wparam", "ptr")
		EndIf
		_MemFree($tMemMap)
	Else
		If $fUnicode Then
			$iResult = GUICtrlSendMsg($hWnd, $LVM_SETITEMW, 0, $pItem)
		Else
			$iResult = GUICtrlSendMsg($hWnd, $LVM_SETITEMA, 0, $pItem)
		EndIf
	EndIf
	Return $iResult <> 0
EndFunc   ;==>_GUICtrlListView_SetItemEx


Func _GUICtrlListView_GetUnicodeFormat($hWnd)
	If $Debug_LV Then _GUICtrlListView_ValidateClassName($hWnd)
	If IsHWnd($hWnd) Then
		Return _SendMessage($hWnd, $LVM_GETUNICODEFORMAT) <> 0
	Else
		Return GUICtrlSendMsg($hWnd, $LVM_GETUNICODEFORMAT, 0, 0) <> 0
	EndIf
EndFunc   ;==>_GUICtrlListView_GetUnicodeFormat


Func _GUICtrlListView_InsertItem($hWnd, $sText, $iIndex = -1, $iImage = -1, $iParam = 0)
	If $Debug_LV Then _GUICtrlListView_ValidateClassName($hWnd)
	Local $iBuffer, $pBuffer, $tBuffer, $iItem, $pItem, $tItem, $pMemory, $tMemMap, $pText, $iMask, $iResult
	If $iIndex = -1 Then $iIndex = 999999999
	Local $fUnicode = _GUICtrlListView_GetUnicodeFormat($hWnd)

	$tItem = DllStructCreate($tagLVITEM)
	$pItem = DllStructGetPtr($tItem)
	DllStructSetData($tItem, "Param", $iParam)
	If $sText <> -1 Then
		$iBuffer = StringLen($sText) + 1
		If $fUnicode Then
			$iBuffer *= 2
			$tBuffer = DllStructCreate("wchar Text[" & $iBuffer & "]")
		Else
			$tBuffer = DllStructCreate("char Text[" & $iBuffer & "]")
		EndIf
		$pBuffer = DllStructGetPtr($tBuffer)
		DllStructSetData($tBuffer, "Text", $sText)
		DllStructSetData($tItem, "Text", $pBuffer)
		DllStructSetData($tItem, "TextMax", $iBuffer)
	Else
		DllStructSetData($tItem, "Text", -1)
	EndIf
	$iMask = BitOR($LVIF_TEXT, $LVIF_PARAM)
	If $iImage >= 0 Then $iMask = BitOR($iMask, $LVIF_IMAGE)
	DllStructSetData($tItem, "Mask", $iMask)
	DllStructSetData($tItem, "Item", $iIndex)
	DllStructSetData($tItem, "Image", $iImage)
	If IsHWnd($hWnd) Then
		If _WinAPI_InProcess($hWnd, $_lv_ghLastWnd) Or ($sText = -1) Then
			If $fUnicode Then
				$iResult = _SendMessage($hWnd, $LVM_INSERTITEMW, 0, $pItem, 0, "wparam", "ptr")
			Else
				$iResult = _SendMessage($hWnd, $LVM_INSERTITEMA, 0, $pItem, 0, "wparam", "ptr")
			EndIf
		Else
			$iItem = DllStructGetSize($tItem)
			$pMemory = _MemInit($hWnd, $iItem + $iBuffer, $tMemMap)
			$pText = $pMemory + $iItem
			DllStructSetData($tItem, "Text", $pText)
			_MemWrite($tMemMap, $pItem, $pMemory, $iItem)
			_MemWrite($tMemMap, $pBuffer, $pText, $iBuffer)
			If $fUnicode Then
				$iResult = _SendMessage($hWnd, $LVM_INSERTITEMW, 0, $pMemory, 0, "wparam", "ptr")
			Else
				$iResult = _SendMessage($hWnd, $LVM_INSERTITEMA, 0, $pMemory, 0, "wparam", "ptr")
			EndIf
			_MemFree($tMemMap)
		EndIf
	Else
		If $fUnicode Then
			$iResult = GUICtrlSendMsg($hWnd, $LVM_INSERTITEMW, 0, $pItem)
		Else
			$iResult = GUICtrlSendMsg($hWnd, $LVM_INSERTITEMA, 0, $pItem)
		EndIf
	EndIf
	Return $iResult
EndFunc   ;==>_GUICtrlListView_InsertItem



Func _GUICtrlListView_SetImageList($hWnd, $hHandle, $iType = 0)
	If $Debug_LV Then _GUICtrlListView_ValidateClassName($hWnd)
	Local $aType[3] = [$LVSIL_NORMAL, $LVSIL_SMALL, $LVSIL_STATE]

	If IsHWnd($hWnd) Then
		Return _SendMessage($hWnd, $LVM_SETIMAGELIST, $aType[$iType], $hHandle, 0, "wparam", "hwnd", "hwnd")
	Else
		Return GUICtrlSendMsg($hWnd, $LVM_SETIMAGELIST, $aType[$iType], $hHandle)
	EndIf
EndFunc   ;==>_GUICtrlListView_SetImageList


Func _GUICtrlListView_GetItemState($hWnd, $iIndex, $iMask)
	If $Debug_LV Then _GUICtrlListView_ValidateClassName($hWnd)
	If IsHWnd($hWnd) Then
		Return _SendMessage($hWnd, $LVM_GETITEMSTATE, $iIndex, $iMask)
	Else
		Return GUICtrlSendMsg($hWnd, $LVM_GETITEMSTATE, $iIndex, $iMask)
	EndIf
EndFunc   ;==>_GUICtrlListView_GetItemState