; #FUNCTION# ====================================================================================================================
; Name...........: _ScreenCapture_Capture
; Description ...: Captures a region of the screen
; Syntax.........: _ScreenCapture_Capture([$sFileName = ""[, $iLeft = 0[, $iTop = 0[, $iRight = -1[, $iBottom = -1[, $fCursor = True]]]]]])
; Parameters ....: $sFileName   - Full path and extension of the image file
;                  $iLeft       - X coordinate of the upper left corner of the rectangle
;                  $iTop        - Y coordinate of the upper left corner of the rectangle
;                  $iRight      - X coordinate of the lower right corner of the rectangle.  If this is  -1,  the  current  screen
;                  +width will be used.
;                  $iBottom     - Y coordinate of the lower right corner of the rectangle.  If this is  -1,  the  current  screen
;                  +height will be used.
;                  $fCursor     - If True the cursor will be captured with the image
; Return values .: Success - HBITMAP handle or NONE (See remarks). @error set to 0
;                  Failure - Returns 0 and @error set to error location.
;                  @error  - -1, -2, 1-7 capture failure location
; Author ........: Paul Campbell (PaulIA)
; Modified.......: rover
; Remarks .......: If FileName is not blank this function will capture the screen and save it to file. If FileName is blank, this
;                  function will capture the screen and return a HBITMAP handle to the bitmap image.  In this case, after you are
;                  finished with the bitmap you must call _WinAPI_DeleteObject to delete the bitmap handle.
;+
;                  Requires GDI+: GDI+ requires a redistributable for applications  that
;                  run on the Microsoft Windows NT 4.0 SP6, Windows 2000, Windows 98, and Windows Me operating systems.
; Related .......: _WinAPI_DeleteObject, _ScreenCapture_SaveImage
; Link ..........:
; Example .......: Yes
; ===============================================================================================================================
Func _ScreenCapture_Capture($sFileName = "", $iLeft = 0, $iTop = 0, $iRight = -1, $iBottom = -1, $fCursor = True)
	Local $iH, $iW, $hWnd, $hDDC, $hCDC, $hBMP, $aCursor, $aIcon, $hIcon, $iSCError = 0

	If $iRight = -1 Then $iRight = _WinAPI_GetSystemMetrics($__SCREENCAPTURECONSTANT_SM_CXSCREEN)
	If $iBottom = -1 Then $iBottom = _WinAPI_GetSystemMetrics($__SCREENCAPTURECONSTANT_SM_CYSCREEN)
	If $iRight < $iLeft Then Return SetError(-1, 0, 0)
	If $iBottom < $iTop Then Return SetError(-2, 0, 0)

	$iW = $iRight - $iLeft
	$iH = $iBottom - $iTop
	$hWnd = _WinAPI_GetDesktopWindow()
	If @error Then Return SetError(1, 0, 0)
	$hDDC = _WinAPI_GetDC($hWnd)
	If @error Then Return SetError(2, 0, 0)
	$hCDC = _WinAPI_CreateCompatibleDC($hDDC)
	If @error Then
		_WinAPI_ReleaseDC($hWnd, $hDDC)
		Return SetError(3, 0, 0)
	EndIf
	$hBMP = _WinAPI_CreateCompatibleBitmap($hDDC, $iW, $iH)
	If @error Or $hBMP = 0 Then
		_WinAPI_ReleaseDC($hWnd, $hDDC)
		_WinAPI_DeleteDC($hCDC)
		Return SetError(4, 0, 0)
	EndIf
	_WinAPI_SelectObject($hCDC, $hBMP)
	If @error Then
		_WinAPI_ReleaseDC($hWnd, $hDDC)
		_WinAPI_DeleteDC($hCDC)
		_WinAPI_DeleteObject($hBMP)
		Return SetError(5, 0, 0)
	EndIf
	_WinAPI_BitBlt($hCDC, 0, 0, $iW, $iH, $hDDC, $iLeft, $iTop, $__SCREENCAPTURECONSTANT_SRCCOPY)
	If @error Then
		_WinAPI_ReleaseDC($hWnd, $hDDC)
		_WinAPI_DeleteDC($hCDC)
		_WinAPI_DeleteObject($hBMP)
		Return SetError(6, 0, 0)
	EndIf

	If $fCursor Then
		$aCursor = _WinAPI_GetCursorInfo()
		If Not @error And $aCursor[1] = True Then
			$hIcon = _WinAPI_CopyIcon($aCursor[2])
			If Not @error And $hIcon <> 0 Then
				$aIcon = _WinAPI_GetIconInfo($hIcon)
				If Not @error And $aIcon[0] = True Then
					_WinAPI_DrawIcon($hCDC, $aCursor[3] - $aIcon[2] - $iLeft, $aCursor[4] - $aIcon[3] - $iTop, $hIcon)
					If $aIcon[4] <> 0 Then _WinAPI_DeleteObject($aIcon[4])
					If $aIcon[5] <> 0 Then _WinAPI_DeleteObject($aIcon[5])
				EndIf
				_WinAPI_DestroyIcon($hIcon)
			EndIf
		EndIf
	EndIf

	_WinAPI_ReleaseDC($hWnd, $hDDC)
	_WinAPI_DeleteDC($hCDC)
	If $sFileName = "" Then Return SetError(0, 0, $hBMP)

	_ScreenCapture_SaveImage($sFileName, $hBMP)
	If @error Then $iSCError = 7
	_WinAPI_DeleteObject($hBMP)
	SetError($iSCError, 0)
EndFunc   ;==>_ScreenCapture_Capture