;
; AutoIt Version: 3.3
; Language:       English
; Platform:       Win9x/NT
; Author:         Jonathan Bennett <jon at hiddensoft com>
; Author:         edited (20090701) by poebel <poebel at poebel net> for TextPad v5 and x64 systems (use EnvGet("ProgramFiles(x86)") instead of @ProgramFilesDir
;
; Script Function:
;	Syntax highlighting files installation.
;

; Prompt the user to run the script - use a Yes/No prompt (4 - see help file)
$answer = MsgBox(4, "TextPad v4/v5", "This script will attempt to automatically install syntax highlighting and clip library files for TextPad v4/v5.  Run?")
If $answer = 7 Then Exit


; Find and verify the installation directory

; Textpad v4 (x86)
If FileExists(@ProgramFilesDir & "\TextPad 4\") Then
 $installdir = @ProgramFilesDir & "\TextPad 4\"
 $textpad_version = "4"

; Textpad v4 (x64)
ElseIf FileExists(EnvGet("ProgramFiles(x86)") & "\TextPad 4\") Then
 $installdir = EnvGet("ProgramFiles(x86)") & "\TextPad 4\"
 $textpad_version = "5"

; Textpad v5 (x86)
ElseIf FileExists(@ProgramFilesDir & "\TextPad 5\") Then
 $installdir = @ProgramFilesDir & "\TextPad 5\"
 $textpad_version = "5"

; Textpad v5 (x64)
ElseIf FileExists(EnvGet("ProgramFiles(x86)") & "\TextPad 5\") Then
 $installdir = EnvGet("ProgramFiles(x86)") & "\TextPad 5\"
 $textpad_version = "5"

; Fail
Else
 Error("Unable to find TextPad.")
EndIf

If Not FileCopy("autoit_v3.syn", $installdir & "\system", 1) Then Error("Error installing the syntax files.")
If Not FileCopy("autoit_v3.tcl", $installdir & "\samples", 1) Then Error("Error installing the syntax files.")

; Now write the reg keys
RegWrite("HKEY_CURRENT_USER\Software\Helios\TextPad " & $textpad_version & "\Document Classes\AutoIt v3", "Type", "REG_DWORD", 2)
RegWrite("HKEY_CURRENT_USER\Software\Helios\TextPad " & $textpad_version & "\Document Classes\AutoIt v3", "Members", "REG_MULTI_SZ", "*.au3")
RegWrite("HKEY_CURRENT_USER\Software\Helios\TextPad " & $textpad_version & "\Document Classes\AutoIt v3", "Properties", "REG_BINARY", Binary("0x2a002e0061007500330000000000"))
RegWrite("HKEY_CURRENT_USER\Software\Helios\TextPad " & $textpad_version & "\Document Classes\AutoIt v3", "SyntaxProps", "REG_BINARY", Binary("0x01000000"))
RegWrite("HKEY_CURRENT_USER\Software\Helios\TextPad " & $textpad_version & "\Document Classes\AutoIt v3", "SyntaxFile", "REG_SZ", "autoit_v3.syn")
RegWrite("HKEY_CURRENT_USER\Software\Helios\TextPad " & $textpad_version & "\Document Classes\AutoIt v3", "WordChars", "REG_SZ", "_$")

$answer = MsgBox(4096+4, "TextPad v4/v5", "Installation complete!" & @LF & @LF & "Do you want to make it the default editor for AutoItV3 scripts ?")
If $answer = 7 Then Exit
RegWrite("HKEY_CLASSES_ROOT\AutoIt3Script\Shell\Edit\Command", "", "REG_SZ", '"' & $installdir & 'TextPad.exe" "%1"')

; End of script


Func Error($error_msg)
	MsgBox(4096, "Error", $error_msg & " Please try a manual installation.")
	Exit
EndFunc



