; #FUNCTION# ====================================================================================================================
; Name...........: _WinAPI_CreateSolidBitmap
; Description....: Creates a solid color bitmap
; Syntax.........: _WinAPI_CreateSolidBitmap($hWnd, $iColor, $iWidth, $iHeight, $fRGB)
; Parameters.....: $hWnd        - Handle to the window where the bitmap will be displayed
;                  $iColor      - The color of the bitmap, depends on the $fRGB value
;                  $iWidth      - The width of the bitmap
;                  $iHeight     - The height of the bitmap
;                  $fRGB        - Type of $iColor passed in, valid values:
;                  |0 - BGR
;                  |1 - RGB (Default)
; Return values..: Success      - Handle to the bitmap
;                  Failure      - 0 and sets the @error flag to non-zero
; Author.........: Paul Campbell (PaulIA)
; Modified.......: Yashied
; Remarks........: When you no longer need the bitmap, call the _WinAPI_DeleteObject() function to delete it.
; Related........: _WinAPI_CreateCompatibleBitmap
; Link...........:
; Example........:
; ===============================================================================================================================

Func _WinAPI_CreateSolidBitmap($hWnd, $iColor, $iWidth, $iHeight, $fRGB = 1)

	Local $tRect, $hBitmap, $hBrush, $hOld, $hDC, $hDestDC, $hDestSv

	$hDC = _WinAPI_GetDC($hWnd)
	$hDestDC = _WinAPI_CreateCompatibleDC($hDC)
	$hBitmap = _WinAPI_CreateCompatibleBitmap($hDC, $iWidth, $iHeight)
	$hOld = _WinAPI_SelectObject($hDestDC, $hBitmap)
	$tRect = DllStructCreate($tagRECT)
	DllStructSetData($tRect, 1, 0)
	DllStructSetData($tRect, 2, 0)
	DllStructSetData($tRect, 3, $iWidth)
	DllStructSetData($tRect, 4, $iHeight)
	If $fRGB Then
		$iColor = BitOR(BitAND($iColor, 0x00FF00), BitShift(BitAND($iColor, 0x0000FF), -16), BitShift(BitAND($iColor, 0xFF0000), 16))
	EndIf
	$hBrush = _WinAPI_CreateSolidBrush($iColor)
	_WinAPI_FillRect($hDestDC, DllStructGetPtr($tRect), $hBrush)
	If @error Then
		_WinAPI_DeleteObject($hBitmap)
		$hBitmap = 0
	EndIf
	_WinAPI_DeleteObject($hBrush)
	_WinAPI_ReleaseDC($hWnd, $hDC)
	_WinAPI_SelectObject($hDestDC, $hOld)
	_WinAPI_DeleteDC($hDestDC)
	Return SetError(($hBitmap = 0), 0, $hBitmap)
EndFunc   ;==>_WinAPI_CreateSolidBitmap
