#include <ScreenCapture.au3>

Global $hScreen, $hBitmap, $aMem, $tData

_GDIPlus_Startup()
$hScreen=_ScreenCapture_Capture("", 0, 0, -1, -1, False)
$hBitmap = _GDIPlus_BitmapCreateFromHBITMAP($hScreen)

For $i=1 To 50
    $tData = _GDIPlus_BitmapLockBits($hBitmap, 0, 0, _GDIPlus_ImageGetWidth($hBitmap), _GDIPlus_ImageGetHeight($hBitmap), $GDIP_ILMREAD, $GDIP_PXF24RGB)
    _GDIPlus_BitmapUnlockBits($hBitmap, $tData)
    Sleep(50)
    $aMem = MemGetStats()
    ConsoleWrite("original function; step " & $i & "; mem usage: " & $aMem[0] & @LF)
Next

ConsoleWrite(@LF)

For $i=1 To 50
    $tData = _GDIPlus_BitmapLockBits($hBitmap, 0, 0, _GDIPlus_ImageGetWidth($hBitmap), _GDIPlus_ImageGetHeight($hBitmap), $GDIP_ILMREAD, $GDIP_PXF24RGB)
    _GDIPlus_BitmapUnlockBits_($hBitmap, $tData)
    Sleep(50)
    $aMem = MemGetStats()
    ConsoleWrite("test function; step " & $i & "; mem usage: " & $aMem[0] & @LF)
Next

Func _GDIPlus_BitmapUnlockBits_($hBitmap, $tBitmapData)
    Local $aResult

    $aResult = DllCall($ghGDIPDll, "int", "GdipBitmapUnlockBits", "hwnd", $hBitmap, "ptr", DllStructGetPtr($tBitmapData)) ;Type ptr instead of int*
    If @error Then Return SetError(@error, @extended, False)
    Return SetError($aResult[0], 0, $aResult[0] = 0)
EndFunc   ;==>_GDIPlus_BitmapUnlockBits
