;===============================================================================
;
; Function Name:  _ArrayTotal()
; Description:    Returns an array containing the total value of all values held in an array.
; Author(s):      DBkaynor <doug at kaynor dot net>
;
;===============================================================================
Func _ArrayTotal(Const ByRef $avArray)
	If IsArray($avArray) Then
		Local $Total
		dim $Results[3]
		For $x In $avArray
			$Total += $x
		Next		
		return $Total
	Else
		SetError(1)
		Return ""
	EndIf
EndFunc   ;==>_ArrayAvg

;===============================================================================
;
; Function Name:  _ArrayAvg()
; Description:    Returns an array containing the total value of and the average of all values held in an array.
; Author(s):      DBkaynor <doug at kaynor dot net>
;
;===============================================================================
Func _ArrayAvg(Const ByRef $avArray)
	If IsArray($avArray) Then	
		return _ArrayTotal($avArray) / UBound($avArray)
	Else
		SetError(1)
		Return ""
	EndIf
EndFunc   ;==>_ArrayAvg
