#include <WinAPI.au3>

;Global Const $__WINAPCONSTANT_FORMAT_MESSAGE_FROM_SYSTEM = 0x1000
Global Const $__WINAPCONSTANT_FORMAT_MESSAGE_ALLOCATE_BUFFER = 0x100

Func _WinAPI_GetLastErrorMessageW()
    Local Const $iFlags = BitOR($__WINAPCONSTANT_FORMAT_MESSAGE_ALLOCATE_BUFFER, $__WINAPCONSTANT_FORMAT_MESSAGE_FROM_SYSTEM)
    Local $tBufferPtr = DllStructCreate("ptr")

    Local $aResult = DllCall("Kernel32.dll", "int", "FormatMessageW", _
        "dword", $iFlags, "ptr", 0, "dword", _WinAPI_GetLastError(), "dword", 0, _
        "ptr", DllStructGetPtr($tBufferPtr), "dword", 0, "ptr", 0)
    If @error Then Return SetError(@error, 0, "")

    Local $charCount = $aResult[0], $Text = ""
    Local $tBuffer, $pBuffer = DllStructGetData($tBufferPtr, 1)
    If $pBuffer Then
        If $charCount > 0 Then
            $tBuffer = DllStructCreate("wchar[" & ($charCount+1) & "]", $pBuffer)
            $Text = DllStructGetData($tBuffer, 1)
        EndIf
        _WinAPI_LocalFree($pBuffer)
    EndIf

    Return $Text
EndFunc