#include<Memory.au3>

Global Const $__Au3Obj_E_NOTIMPL = 0x80004001;
Global Const $__Au3Obj_S_OK = 0;
Global Const $__Au3Obj_E_NOINTERFACE = 0x80004002
Global Const $__AU3Obj_DISP_E_UNKNOWNNAME = 0x80020006
Global Const $__AU3Obj_DISP_E_EXCEPTION = 0x80020009

Global Const $__Au3Obj_vTable = DllStructCreate("ptr QueryInterface; ptr AddRef; ptr Release; ptr GetTypeInfoCount; ptr GetTypeInfo; ptr GetIDsOfNames; ptr Invoke;")
; set DllCallbacks
Dim $aCallbacks[8]
		$aCallbacks[1] = DllCallbackRegister("__Au3Obj_QueryInterface", "long", "ptr;dword;dword") ;QureyInterface
		$aCallbacks[2] = DllCallbackRegister("__Au3Obj_AddRef", "long", "ptr") ;Addref
		$aCallbacks[3] = DllCallbackRegister("__Au3Obj_Release", "long", "ptr") ;Release
		$aCallbacks[4] = DllCallbackRegister("__Au3Obj_GetTypeInfoCount", "long", "ptr;ptr")
		$aCallbacks[5] = DllCallbackRegister("__Au3Obj_GetTypeInfo", "long", "ptr;uint;int;ptr")
		$aCallbacks[6] = DllCallbackRegister("__Au3Obj_GetIDsOfNames", "long", "ptr;ptr;ptr;uint;int;ptr")
		$aCallbacks[7] = DllCallbackRegister("__Au3Obj_Invoke", "long", "ptr;int;ptr;int;ushort;ptr;ptr;ptr;ptr")
		For $i = 1 To 7
			DllStructSetData($__Au3Obj_vTable, $i, DllCallbackGetPtr($aCallbacks[$i]))
		Next

; In the end we still want the autoit object. This function converts a raw pointer to an autoit object
Func ConvertPtrToIDispatch($pIDispatch)
	; Author: monoceres
	; This would have been 10000x easier if autoit had supported the idispatch* type in dllstructs...
	; Fortunetely memcpy can copy the pointer into a idispatch*, lucky us.
	Local $aCall = DllCall("kernel32.dll", "none", "RtlMoveMemory", "idispatch*", 0, "ptr*", $pIDispatch, "dword", DllStructGetSize(DllStructCreate('ptr',1)))
	If @error Then Return SetError(1, 0, 0)
	Return $aCall[1]
EndFunc   ;==>ConvertPtrToIDispatch
Func __Au3Obj_QueryInterface($pObject, $iid, $ppvObject)
	; Actually Autoit is not calling this function, so leave it empty for testing ;)
	Return $__Au3Obj_E_NOINTERFACE
EndFunc   ;==>__Au3Obj_QueryInterface
Func __Au3Obj_AddRef($pObject)
	; Author: Prog@ndy
	Local $st = DllStructCreate("ptr;dword", $pObject)
	Local $iCount = DllStructGetData($st, 2) + 1
	DllStructSetData($st, 2, $iCount)
	Return $iCount
EndFunc   ;==>__Au3Obj_AddRef
Func __Au3Obj_Release($pObject)
	; Author: Prog@ndy
	Local $st = DllStructCreate("ptr;dword", $pObject)
	Local $iCount = DllStructGetData($st, 2) - 1
	If $iCount < 0 Then Return 0
	DllStructSetData($st, 2, $iCount)
	If $iCount = 0 Then ; delete Object
		_MemGlobalFree($pObject)
	EndIf
	Return $iCount
EndFunc   ;==>__Au3Obj_Release
Func __Au3Obj_GetTypeInfoCount($pObject, $pctinfo)
	; Author: Prog@ndy
	Return $__Au3Obj_E_NOTIMPL
EndFunc   ;==>__Au3Obj_GetTypeInfoCount
Func __Au3Obj_GetTypeInfo($pObject, $iTInfo, $lcid, $ppTInfo)
	; Author: Prog@ndy
	Return $__Au3Obj_E_NOTIMPL
EndFunc   ;==>__Au3Obj_GetTypeInfo
Func __Au3Obj_GetIDsOfNames($pObject, $riid, $rgszNames, $cNames, $lcid, $rgDispId)
	Return $__AU3Obj_DISP_E_UNKNOWNNAME
EndFunc   ;==>__Au3Obj_GetIDsOfNames
Func __Au3Obj_Invoke($pObject, $dispIdMember, $riid, $lcid, $wFlags, $pDispParams, $pVarResult, $pExcepInfo, $puArgErr)
	Return $__AU3Obj_DISP_E_EXCEPTION
EndFunc   ;==>__Au3Obj_Invoke


; construct object
Local $iSize = DllStructGetSize(DllStructCreate("ptr vTable; dword refcount;", 1))
Local $pMem = _MemGlobalAlloc($iSize, $GPTR) ; will be freed in Objectz::release
Local $tStruct = DllStructCreate("ptr vTable; dword refcount;", $pMem)
DllStructSetData($tStruct, 1, DllStructGetPtr($__Au3Obj_vTable))
$object = ConvertPtrToIDispatch($pMem)
OnAutoItExitRegister("__ReleaseObject")

;Test: Exit without releasing the object:
OnAutoItExitUnregister("__ReleaseObject")

Func __ReleaseObject()
	$object=0
EndFunc
