#Include <File.au3>
AdlibRegister( "Unexpected" )
$mytop = @DesktopHeight - 50 - 60
$myleft = (@DesktopWidth / 2) - 150

SplashTextOn ( "Mercury MasterLink Automatic Installation", "Please do not touch the mouse or keyboard until the installation is complete.", 400, 60 ,  $myleft, $mytop, -1, "", 10 )

global $OUTPUT
global $logfullpath


$OUTPUT = 0

if $CmdLine[0] >= 1 then
	$OUTPUT = 1

	$logfullpath = $CmdLine[1]
	
	$array = StringSplit($CmdLine[1], "\\")
	$logname = $array[$array[0]]
	$logpath = stringleft($logfullpath, stringlen($logfullpath) - stringlen($logname) - 1)
	
	; if ($logpath = "") then only a log name was supplied not the log path
	if ($logpath = "") or (fileexists($logpath)) then
		fileopen($logfullpath, 2)
		fileclose($logfullpath)
	else
		msgbox(1,"","Log path not found")
		exit(2)
	endif
endif

if $OUTPUT = 1 then _FileWriteLog($logfullpath, "Running MtrLnk32.Exe")
run("MtrLnk32.Exe")


; if I remove this
if $OUTPUT = 1 then _FileWriteLog($logfullpath, "Waiting for License Agreement window")
WaitForWindow("License Agreement", "")
send("{ENTER}")
; add
	; if winexists("License Agreement", "") then
	; 	winactivate("License Agreement", "")
	; 	send("{ENTER}")
	; EndIf
; to the Unexpected() function, the windows is found and dealt with but 
; then it times out on the next window.



if $OUTPUT = 1 then _FileWriteLog($logfullpath, "Waiting for Welcome window")
WaitForWindow("MasterLink32", "This installation program will install")
send("!n")

if $OUTPUT = 1 then _FileWriteLog($logfullpath, "Waiting for Registration window")
WaitForWindow("MasterLink32", "Please enter the name and company")
send("...")
send("{TAB}")
send("...")
Send("{TAB}")
Send("ML459")
send("!n")

if $OUTPUT = 1 then _FileWriteLog($logfullpath, "Waiting for Registration Confirmation window")
WaitForWindow("MasterLink32", "Please verify")
send("!n")

if $OUTPUT = 1 then _FileWriteLog($logfullpath, "Waiting for Select Destination window")
WaitForWindow("MasterLink32", "Select Destination")
send("!r")

if $OUTPUT = 1 then _FileWriteLog($logfullpath, "Waiting for Enter Destination window")
WaitForWindow("Select Destination", "")
send("C:\Programs\Mercury32")
send("{ENTER}")

sleep(5000)
send("!n")

sleep(10000)
if $OUTPUT = 1 then _FileWriteLog($logfullpath, "Waiting for Database window")
WaitForWindow("MasterLink32", "unable to locate a database")
send("!r")

if $OUTPUT = 1 then _FileWriteLog($logfullpath, "Waiting for Enter Destination window")
WaitForWindow("Select Destination", "")
send("C:\Programs\Mercury32\Data")
send("{ENTER}")

sleep(5000)
controlcommand("MasterLink32", "unable to locate a database", "[CLASS:Button; INSTANCE:6]", "Check", "")
send("!n")

if $OUTPUT = 1 then _FileWriteLog($logfullpath, "Waiting for Select ProgMan window")
WaitForWindow("MasterLink32", "Select ProgMan")
send("!n")

if $OUTPUT = 1 then _FileWriteLog($logfullpath, "Waiting for Ready to Install window")
WaitForWindow("MasterLink32", "Ready to Install")
send("!n")

if $OUTPUT = 1 then _FileWriteLog($logfullpath, "Waiting for Installation Completed window")
WaitForWindow("MasterLink32", "Installation Completed")
send("!f")

WinActivate("", "AppData\Roaming\Microsoft\Windows\Start Menu\Programs\Mercury32")
WinClose("Mercury32", "AppData\Roaming\Microsoft\Windows\Start Menu\Programs\Mercury32")

WinActivate("", "AppData\Roaming\Microsoft\Windows\Start Menu\Programs")
WinClose("Mercury32", "AppData\Roaming\Microsoft\Windows\Start Menu\Programs")

unexpected()

if $OUTPUT = 1 then _FileWriteLog($logfullpath, "Installation Complete. Return code = 0")
Exit(0)

Func unexpected()

if winexists("Install", "already exists") then
	winactivate("Install", "already exists")
	send("{ENTER}")
EndIf

if winexists("MasterLink32", "Setup found a Mercury32 database") then
	winactivate("MasterLink32", "Setup found a Mercury32 database")
	send("!n")
endif

EndFunc


Func Assert($n)
	If $n = 0 Then 
		if $OUTPUT = 1 then
			_FileWriteLog($logfullpath, "Window not found")
			_FileWriteLog($logfullpath, "Found window: (" & WinGetTitle("[ACTIVE]", "") & ")")
			_FileWriteLog($logfullpath, "Window text:" & WinGetText("[ACTIVE]", ""))
			_FileWriteLog($logfullpath, "Installation failed. Return code = 1")
		endif
		Exit(1)
	endif
EndFunc

; Wait for a window to exist, activate it, and wait for it to become active.
; If timeout expires while waiting, exit with a nonzero exit status.
Func WaitForWindow($title, $text="", $timeout=60)
    Assert(WinWait($title, $text, $timeout))
    WinActivate($title, $text)
EndFunc

