#include <Constants.au3>

Global $g_nExitCode = Main()
Exit $g_nExitCode

Func Main()
	If $CmdLine[0] Then
		Call($CmdLine[1])
		If @error Then MsgBox(4096 + 16, "Error", "Invalid function")
	Else
		Master()
	EndIf
EndFunc	; Main()

Func Master()
	Local $pid = RunSelf("Parent", $STDIN_CHILD + $STDERR_CHILD + $STDOUT_CHILD)
	ProcessWaitClose($pid)
	MsgBox(4096, "", "From Parent:" & @CRLF & StdoutRead($pid))
EndFunc	; Master()

Func Parent()
	ConsoleWrite("Parent!!!" & @CRLF)
	Local Const $sChildExe = @ScriptDir & "\Child.exe"
	If Not FileExists($sChildExe) Then Return MsgBox(4096 + 16, "Error", "Unable to find child executable")
	Local $pid = Run($sChildExe, @WorkingDir, @SW_SHOWNORMAL, $STDIN_CHILD + $STDERR_MERGED)
	ProcessWaitClose($pid)
	Local $s = StdoutRead($pid)
	MsgBox(4096, "", "From Child:" & @CRLF & $s)
	ConsoleWrite($s)
EndFunc	; Parent()

Func RunSelf($sCmdLine, $nStdio = 0, $sWorkingDir = @WorkingDir, $nShow = @SW_SHOWNORMAL)
	Local $sCmd
	If @Compiled Then
		$sCmd = @AutoItExe & " " & $sCmdLine
	Else
		$sCmd = @AutoItExe & ' /AutoIt3ExecuteScript "' & @ScriptFullPath & '" ' & $sCmdLine
	EndIf
	Return Run($sCmd, $sWorkingDir, $nShow, $nStdio)
EndFunc	; RunSelf()
