; Includes first! Must must must!
#include <GUIConstantsEx.au3>
#include <ListViewConstants.au3>
#Include <GuiListView.au3>
#include <StaticConstants.au3>
#include <WindowsConstants.au3>
#include <Array.au3>
#include <Misc.au3>


; Switch on the 'onEvent' notifications
Opt ("GUIOnEventMode", 1)


; Generate the GUI! Ahoy there.
Global $MainForm, $list_source, $list_target
$MainForm = GUICreate(" TEST! ", 517, 178)


; Source list box
$list_source = GUICtrlCreateListView("Title|Details", 13, 16, 240, 136, BitOR($LVS_REPORT,$LVS_SHOWSELALWAYS,$LVS_SORTASCENDING))


; Target list box
$list_target = GUICtrlCreateListView("Title|Details", 261, 16, 240, 136, BitOR($LVS_REPORT,$LVS_SHOWSELALWAYS,$LVS_SORTASCENDING))


; Populate box with some test stuff
For $x = 1 to 6
    GUICtrlCreateListViewItem( _makeJunkName() & "|" & _makeJunkName(), $list_source)
Next


; Handle GUI events
GUISetOnEvent($GUI_EVENT_PRIMARYDOWN, "_dragHandler")
GUISetOnEvent($GUI_EVENT_CLOSE,       "_formEvents")
GUISetOnEvent($GUI_EVENT_MINIMIZE,    "_formEvents")
GUISetOnEvent($GUI_EVENT_RESTORE,     "_formEvents")


; Show the form
GUISetState(@SW_SHOW)


; Main program loop
While 1
    ; Don't really do much in here at all...
WEnd


; Create a junk name for testing
Func _makeJunkName()
    Local $labelout = ''
    For $i = 1 to 10
        $labelout &= chr(Random(65,90,1))
    Next
    Return $labelout
EndFunc


; Function to handle drag and drop
Func _dragHandler()
    
    ; Define some stuff
    Local $source, $desc
    Local $cinfo =  GUIGetCursorInfo (WinGetHandle($MainForm))
    Local $direction = 0
    
    ; Check we are dragging from one or the other boxes
    If $cinfo[4] = $list_source OR $cinfo[4] = $list_target Then
        
        ; Are we moving from source to destination
        If $cinfo[4] = $list_source Then
            $direction = 1
        EndIf
        
        ; Or are we moving from destination to source
        If $cinfo[4] = $list_target Then
            $direction = 2
        EndIf

        ; Doublecheck we're pressing mouse button
        If _IsPressed(1) Then
            if $direction = 1 Then
                $selecteditems = _GUICtrlListView_GetSelectedCount($list_source);
            Else
                $selecteditems = _GUICtrlListView_GetSelectedCount($list_target);
            EndIf
            
            ; Check we actually have selected an item
            If $selecteditems >= 1 Then
                
                ; Wait for keypress!
                While _IsPressed(1)
                WEnd
                
                ; Get new position
                Local $newcinfo =  GUIGetCursorInfo (WinGetHandle($MainForm))
                
                ; If we were moving from source to destination and we ARE in the destination box
                If $direction = 1 And $newcinfo[4] = $list_target Then
                    ConsoleWrite("Moved " & $selecteditems & " items from source to destination" & @CRLF)
                    _GUICtrlListView_CopyItems ($list_source, $list_target, 1)
                EndIf
                
                ; If we are moving from destination to source and we ARE in source box
                If $direction = 2 And $newcinfo[4] = $list_source Then
                    ConsoleWrite("Moved " & $selecteditems & " items from destination to source" & @CRLF)
                    _GUICtrlListView_CopyItems ($list_target, $list_source, 1)
                EndIf

            EndIf

        EndIf
        
    EndIf
    
EndFunc


; Function to handle other form events
Func _formEvents()
    Select
        Case @GUI_CtrlId = $GUI_EVENT_CLOSE
            Exit
    EndSelect
EndFunc
