;; AUTOIT TARGET VERSION: Beta 3.2.11.1
;; Summary: Auto resize of GUICtrlCreateGraphic control notify area. (?)

#include <GuiConstantsEx.au3> ;; <-> (Gui Event Const)
#include <WindowsConstants.au3> ;; <-> (Gui Create Const)
#include <Constants.au3> ;; <-> ($COLOR_*)
#include <StaticConstants.au3> ;; <-> ($SS_BLACKFRAME)

Opt('MustDeclareVars', 1)
Opt("GUIOnEventMode", 0)

;~ Global $hGUI
Global Const $_X = 0
Global Const $_Y = 1
Global Const $_Margin = 10

_Main()

Func _Main()
	Local $hGUI = GUICreate('GUI_Main', 200, 200, -1, -1, BitOR($GUI_SS_DEFAULT_GUI, $WS_SIZEBOX))
	AddGraphControle($hGUI)
	AddFakeNotifyArea($hGUI)
	GUISetState(@SW_SHOW, $hGUI)
	GUI_Event($hGUI)
EndFunc   ;==>_Main

Func AddGraphControle($hGUI)
	Local $Size_A = WinGetClientSize($hGUI)
	Local $GRAP_ID = GUICtrlCreateGraphic(0 + $_Margin, 0 + $_Margin, $Size_A[$_X] - ($_Margin * 2), $Size_A[$_Y] - ($_Margin * 2))
	GUICtrlSetColor($GRAP_ID, $COLOR_BLUE)
	GUICtrlSetBkColor($GRAP_ID, $COLOR_WHITE)
	ConsoleWrite('+ $GRAP_ID = ' & $GRAP_ID & @CR)
EndFunc   ;==>AddGraphControle

Func AddFakeNotifyArea($hGUI)
	Local $Size_A = WinGetClientSize($hGUI)
	Local $LABEL_ID = GUICtrlCreateLabel('', 0 + $_Margin, 0 + $_Margin, $Size_A[$_X] - ($_Margin * 2), $Size_A[$_Y] - ($_Margin * 2))
	GUICtrlSetStyle($LABEL_ID, $SS_BLACKFRAME)
	GUICtrlSetState($LABEL_ID, $GUI_DISABLE)
	ConsoleWrite('+ $LABEL_ID = ' & $LABEL_ID & @CR)
EndFunc   ;==>AddFakeNotifyArea

Func GUI_Event($hGUI)
	Local $Msg_Cur
	Local $Msg_Last
	While 1
		$Msg_Cur = GUIGetMsg()
		If $Msg_Cur And ($Msg_Cur <> $Msg_Last) Then BD_GUIGetMsg($Msg_Cur, $Msg_Last) ;;
		Select
			Case $Msg_Cur = $GUI_EVENT_CLOSE ;; exit
				GUIDelete()
				Exit
		EndSelect
	WEnd
EndFunc   ;==>GUI_Event

Func BD_GUIGetMsg($msg_new, ByRef $Msg_Last)
	If ($msg_new = $Msg_Last) Then Return
	$Msg_Last = $msg_new
	Switch $msg_new
		Case $GUI_EVENT_MOUSEMOVE
			ConsoleWrite(' $msg_new = $GUI_EVENT_MOUSEMOVE[' & $msg_new & ']' & @CR)
		Case $GUI_EVENT_MINIMIZE
			ConsoleWrite(' $msg_new = $GUI_EVENT_MINIMIZE[' & $msg_new & ']' & @CR)
		Case $GUI_EVENT_RESTORE
			ConsoleWrite(' $msg_new = $GUI_EVENT_RESTORE[' & $msg_new & ']' & @CR)
		Case $GUI_EVENT_MAXIMIZE
			ConsoleWrite(' $msg_new = $GUI_EVENT_MAXIMIZE[' & $msg_new & ']' & @CR)
		Case $GUI_EVENT_PRIMARYDOWN
			ConsoleWrite(' $msg_new = $GUI_EVENT_PRIMARYDOWN[' & $msg_new & ']' & @CR)
		Case $GUI_EVENT_PRIMARYUP
			ConsoleWrite(' $msg_new = $GUI_EVENT_PRIMARYUP[' & $msg_new & ']' & @CR)
		Case $GUI_EVENT_SECONDARYDOWN
			ConsoleWrite(' $msg_new = $GUI_EVENT_SECONDARYDOWN[' & $msg_new & ']' & @CR)
		Case $GUI_EVENT_SECONDARYUP
			ConsoleWrite(' $msg_new = $GUI_EVENT_SECONDARYUP[' & $msg_new & ']' & @CR)
		Case $GUI_EVENT_RESIZED
			ConsoleWrite(' $msg_new = $GUI_EVENT_RESIZED[' & $msg_new & ']' & @CR)
		Case $GUI_EVENT_DROPPED
			ConsoleWrite(' $msg_new = $GUI_EVENT_DROPPED[' & $msg_new & ']' & @CR)
		Case $GUI_EVENT_PRIMARYDOWN
			ConsoleWrite(' $msg_new = $GUI_EVENT_PRIMARYDOWN[' & $msg_new & ']' & @CR)
		Case $GUI_EVENT_CLOSE
			ConsoleWrite(' $msg_new = $GUI_EVENT_CLOSE[' & $msg_new & ']' & @CR)
		Case Else
			ConsoleWrite(' $msg_new = (controle)[' & $msg_new & ']' & @CR)
	EndSwitch
EndFunc   ;==>BD_GUIGetMsg

;; EOF ;;