; #FUNCTION# =====================================================
; Name...........: __GUICtrlTab_ClickTab
; Description ...: Clicks a tab
; Syntax.........: _GUICtrlTab_ClickTab($hWnd, $iIndex[, $sButton = "left"[, $fMove = False[,
;               $iClicks = 1[, $iSpeed = 1]]]])
; Parameters ....: $hWnd        - Handle to control
;                 $iIndex     - Specifies the zero based index of the item
;                 $fButton   - Button to click with
;                 $fMove       - If True, the mouse will be moved.
;                          - If False, the mouse does not move.
;                 $iClicks   - Number of clicks
;                 $iSpeed     - Mouse movement speed
; Return values .:
; Author ........: Paul Campbell (PaulIA)
; Modified.......: Gary Frost (gafrost)
;               : PsaltyDS - Modified to use ControlClick() when $fMove = False so window
;                    does not have to be active
; Remarks .......:
; Related .......:
; Link ..........;
; Example .......; Yes
; ================================================================
Func __GUICtrlTab_ClickTab($hwnd, $iIndex, $sButton = "left", $fMove = False, $iClicks = 1, $iSpeed = 1)
    Local $iX, $iY, $tPoint, $tRect, $iMode, $aPos, $hWinParent, $avTabPos
    If $Debug_TAB Then _GUICtrlTab_ValidateClassName($hwnd)
    If Not IsHWnd($hwnd) Then $hwnd = GUICtrlGetHandle($hwnd)

    If Not $fMove Then
        ; Don't move mouse, use ControlClick()
        $hWinParent = _WinAPI_GetParent($hwnd)
        $avTabPos = _GUICtrlTab_GetItemRect($hwnd, $iIndex)
        $iX = $avTabPos[0] + (($avTabPos[2] - $avTabPos[0]) / 2)
        $iY = $avTabPos[1] + (($avTabPos[3] - $avTabPos[1]) / 2)
        ControlClick($hWinParent, "", $hwnd, $sButton, $iClicks, $iX, $iY)
    Else
        ; Original code to move mouse and click (requires active window)
        $tRect = _GUICtrlTab_GetItemRectEx($hwnd, $iIndex)
        $tPoint = _WinAPI_PointFromRect($tRect, True)
        $tPoint = _WinAPI_ClientToScreen($hwnd, $tPoint)
        _WinAPI_GetXYFromPoint($tPoint, $iX, $iY)
        $iMode = Opt("MouseCoordMode", 1)
        MouseClick($sButton, $iX, $iY, $iClicks, $iSpeed)
        Opt("MouseCoordMode", $iMode)
    EndIf
EndFunc ;==>__GUICtrlTab_ClickTab