; #FUNCTION# ====================================================================================================================
; Name...........: _GUICtrlTab_ActivateTab
; Description ...: Activates a tab by its index and sends all required messages
; Syntax.........: _GUICtrlTab_ActivateTab($hWnd, $iIndex)
; Parameters ....: $hWnd        - Handle to control
;                  $iIndex      - Specifies the zero based index of the item
; Return values .: Success      - The index of the previously selected tab
;                  Failure      - -1
; Author ........: Prog@ndy
; Modified.......:
; Remarks .......:
; Related .......:
; Link ..........;
; Example .......;
; ===============================================================================================================================
Func _GUICtrlTab_ActivateTab($hWnd, $iIndex)
    Local $nIndX, $hParent, $NMHDR, $iRet
    ; first, get Handle and CtrlID of TabControl
    If $hWnd = -1 Then $hWnd = GUICtrlGetHandle(-1)
    If IsHWnd($hWnd) Then
        $nIndX = DllCall("user32.dll", "int", "GetDlgCtrlID", "hwnd", $hWnd)
        $nIndX = $nIndX[0]
    Else
        $nIndX = $hWnd
        $hWnd = GUICtrlGetHandle($hWnd)
    EndIf
    ; then get Parent
    Local $hParent = DllCall("user32.dll", "hwnd", "GetParent", "hwnd", $hWnd)
    If @error Then Return SetError(1,0,-1)
    $hParent = $hParent[0]
    ; create Struct for the Messages
    $NMHDR = DllStructCreate("HWND hwndFrom; UINT_PTR idFrom; UINT code;")
    DllStructSetData($NMHDR, 1, $hWnd)
    DllStructSetData($NMHDR, 2, $nIndX)
    DllStructSetData($NMHDR, 3, $TCN_SELCHANGING)
    ; send first message
    _SendMessage($hParent, 0x4E, $nIndX, DllStructGetPtr($NMHDR))
    ; select TabItem
    $iRet = _GUICtrlTab_SetCurSel($hWnd, $iIndex)
    ; send second message
    DllStructSetData($NMHDR, 3, $TCN_SELCHANGE)
    _SendMessage($hParent, 0x4E, $nIndX, DllStructGetPtr($NMHDR))
    Return $iRet
EndFunc