#region Script Options ======================================================================================================
;** AUTOIT3 settings
#AutoIt3Wrapper_UseAnsi=N                       ;(Y/N) Use Ansi versions for AutoIt3a or AUT2EXEa. Default=N
#AutoIt3Wrapper_UseX64=N                        ;(Y/N) Use X64 versions for AutoIt3_x64 or AUT2EXE_x64. Default=N
#AutoIt3Wrapper_Version=P                       ;(B/P) Use Beta or Production for AutoIt3 and AUT2EXE. Default is P
#AutoIt3Wrapper_Run_Debug_Mode=N                ;(Y/N)Run Script with console debugging. Default=N
;===============================================================================================================
;** AUT2EXE settings
#AutoIt3Wrapper_Icon=icon.ico 					;Filename of the Ico file to use
#AutoIt3Wrapper_OutFile=SetDirTime.exe           ;Target exe/a3x filename.
#AutoIt3Wrapper_OutFile_Type=exe                ;a3x=small AutoIt3 file; exe=Standalone executable (Default)
#AutoIt3Wrapper_Compression=2                   ;Compression parameter 0-4 0=Low 2=normal 4=High. Default=2
#AutoIt3Wrapper_UseUpx=Y                        ;(Y/N) Compress output program.  Default=Y
#AutoIt3Wrapper_Change2CUI=Y                    ;(Y/N) Change output program to CUI in stead of GUI. Default=N
;===============================================================================================================
;** Target program Resource info
#AutoIt3Wrapper_Res_Comment=Set FileTime             ;Comment field
#AutoIt3Wrapper_Res_Description=Set FileTime recursively     ;Description field
#AutoIt3Wrapper_Res_Fileversion=0.1.0.5
#AutoIt3Wrapper_Res_FileVersion_AutoIncrement=Y  	;(Y/N/P)AutoIncrement FileVersion After Aut2EXE is finished. default=N
;                                   	            P=Prompt, Will ask at Compilation time if you want to increase the versionnumber
#AutoIt3Wrapper_Res_Language=2057	                ;Resource Language code . default 2057=English (United Kingdom)
#AutoIt3Wrapper_Res_LegalCopyright=Copyright  2010 Franck Grieder      ;Copyright field
#AutoIt3Wrapper_res_requestedExecutionLevel=None    	;None, asInvoker, highestAvailable or requireAdministrator   (default=None)
#AutoIt3Wrapper_Res_SaveSource=Y                 	;(Y/N) Save a copy of the Scriptsource in the EXE resources. default=N
;
#AutoIt3Wrapper_res_field=Made By|Franck Grieder
#AutoIt3Wrapper_res_field=Email|franck dot grieder at free dot fr
#AutoIt3Wrapper_res_field=AutoIt Version|%AutoItVer%
#AutoIt3Wrapper_res_field=Compile Date|%date% %time%
; Obfuscator
#AutoIt3Wrapper_Run_Obfuscator=Y                 ;(Y/N) Run Obfuscator before compilation. default=N
#obfuscator_parameters=/cs=0 /cn=0 /cf=0 /cv=0 /sf=1
;===============================================================================================================
; AU3Check settings
;~ #AutoIt3Wrapper_Run_AU3Check=                   ;(Y/N) Run au3check before compilation. Default=Y
;~ #AutoIt3Wrapper_AU3Check_Parameters=            ;Au3Check parameters
;~ #AutoIt3Wrapper_AU3Check_Stop_OnWarning=        ;(Y/N) N=Continue on Warnings.(Default) Y=Always stop on Warnings
;~ #AutoIt3Wrapper_PlugIn_Funcs=                   ;Define PlugIn function names separated by a Comma to avoid AU3Check errors
;===============================================================================================================
; cvsWrapper settings
#AutoIt3Wrapper_Run_cvsWrapper=V                 ;(Y/N/V) Run cvsWrapper to update the script source. default=N
;                                                 V=only when version is increased by #AutoIt3Wrapper_Res_FileVersion_AutoIncrement.
;~ #AutoIt3Wrapper_cvsWrapper_Parameters=          ; /NoPrompt  : Will skip the cvsComments prompt
;                                                 /Comments  : Text to added in the cvsComments. It can also contain the below variables.

;#AutoIt3Wrapper_run_after=copy "%out%" "C:\Program Files\AutoIt3\SciTE\SciTEConfig\*.*"
;#AutoIt3Wrapper_run_after=copy "%in%" "C:\Program Files\AutoIt3\SciTE\SciTEConfig\*.*"
#AutoIt3Wrapper_Add_Constants=n
$Prog="SetDirTime"
$FileTimeModified=@YEAR&@MON&@MDAY&@HOUR&@MIN&@SEC
$FileTimeModified = IniRead(@ScriptDir&"\"&$Prog&".INI","Config","YYYYMMDDHHMMSS",$FileTimeModified)
IniWrite(@ScriptDir&"\"&$Prog&".INI","Config","YYYYMMDDHHMMSS",$FileTimeModified)
Const $Modified = 0 ;Default
Const $Created = 1
Const $Accessed = 2
Global $Recurse = 1
$FileTimeModified = IniRead(@ScriptDir&"\"&$Prog&".INI","Config","Recurse",$Recurse)
IniWrite(@ScriptDir&"\"&$Prog&".INI","Config","Recurse",$Recurse)
If Ubound($CmdLine)>1 Then
	If FileSetTime($CmdLine[1], $FileTimeModified,$Modified,$Recurse) Then
		ConsoleWrite($FileTimeModified &" => "& $CmdLine[1]&@CRLF)
	Else
		ConsoleWrite("Error setting time  => "& $CmdLine[1]&@CRLF)
	EndIf
Else
	ConsoleWrite("Set 'Modified File Date Time' recursively"&@CRLF)
	ConsoleWrite("SetDirTime C:\TEMP\* set Modified time to all files to "&$FileTimeModified&@CRLF)
EndIf
