;OPTION Explicit
#include-once
#include <_os_file.au3>

;'##############################################################################
;'#
;'#   _os_TileUtilities.au3    SOURCECODE
;'#                                                                         
;'#
;'# MODULE DESCRIPTION:
;'#
;'#
;'#
;'# Orig Author: Roy B Kirby
;'# Orig     Date: Sep 21 2004
;'# History:
;'#
;'#        Sep 21 2004     Original Release
;'#
;'# Copyright (2004) Ordnance Survey All rights reserved.
;'##############################################################################
Global const $True = 1
Global Const $False = 0
Global $M_S_VALID_MILITARY_SQUARES = "HP,HT,HU,HW,HX,HY,HZ,NA,NB,NC,ND,NF,NG,NH,NJ,NK,NL,NM,NN,NO,NR,NS,NT,NU,NW,NX,NY,NZ,OV,SC,SD,SE,SH,SJ,SK,SM,SN,SO,SP,SR,SS,ST,SU,SV,SW,SX,SY,SZ,TA,TF,TG,TL,TM,TQ,TR,TV"

Global $M_S_VALID_500KM_SQUARES = "H,N,O,S,T"
Global $M_S_VALID_TILE_QUADRANTS = "NE,SE,SW,NW"

;7777777777777777777777777777777777777777777777777777777777777777777777
;For testing 
;7777777777777777777777777777777777777777777777777777777777777777777777
;~ DIM $STILEREF_IN = "TQ82"
;~ DIM $DSWCNREASTINGS_OUT = 0
;~ DIM $DSWCNRNORTHINGS_OUT = 0
;~ DIM $DNECNREASTINGS_OUT = 0
;~ DIM $DNECNRNORTHINGS_OUT = 0
;~ DIM $VOUTPUTTILESIZE_IN = 4

;~ 	$A = os_otu_GETTILEEXTENTS($STILEREF_IN, $DSWCNREASTINGS_OUT, $DSWCNRNORTHINGS_OUT, $DNECNREASTINGS_OUT, $DNECNRNORTHINGS_OUT, $VOUTPUTTILESIZE_IN)
;~ 	
;~ 	#REGION --- CODEWIZARD GENERATED CODE START ---
;~ ;MSGBOX FEATURES: TITLE=YES, TEXT=YES, BUTTONS=OK, ICON=NONE
;~ MSGBOX(0,"RESULTS","RETURN=" & $A & @CRLF & "SWCNRE=" & $DSWCNREASTINGS_OUT & @CRLF & "SWCNRN=" & $DSWCNRNORTHINGS_OUT & @CRLF & "NECNRE=" & $DNECNREASTINGS_OUT & @CRLF & "NECNRN=" & $DNECNRNORTHINGS_OUT )
;~ #ENDREGION --- CODEWIZARD GENERATED CODE END ---
;~ EXIT
;777777777777777777777777777777777777777777777777777777777777777777777777777777


Func _os_otu_GeneratListOfTiles($sContainerTile_In, $iTileSize_In, ByRef $asListOfTiles_Out)
Local $iContainerTileSize
Local $dContainerTileWidth
Local $dTileWidth
Local $dTileCentreEastings
Local $dTileCentreNorthings
Local $lNoOfTiles
Local $iNoOfRows
Local $iNoOfCols
Local $iRowIndex
Local $iColIndex
Local $lTileIndex
Local $iResult
Local $dSwCnrEastings
Local $dSwCnrNorthings
Local $dNeCnrEastings
Local $dNeCnrNorthings

    ProgressOn ( "Create List of Tiles", "Creating List")
    ProgressSet(2)

    $iContainerTileSize =_os_otu_IsValidTileName($sContainerTile_In)
    If $iTileSize_In > $iContainerTileSize Then
        Return(0)
    EndIf

    Select 
        Case $iContainerTileSize = 1
            $dContainerTileWidth = 500.00
        Case $iContainerTileSize = 2
            $dContainerTileWidth = 1000.00
        Case $iContainerTileSize = 3
            $dContainerTileWidth = 5000.00
        Case $iContainerTileSize = 4
            $dContainerTileWidth = 10000.00
        Case $iContainerTileSize = 5
            $dContainerTileWidth = 20000.00
        Case $iContainerTileSize = 6
            $dContainerTileWidth = 100000.00
        Case $iContainerTileSize = 7
            $dContainerTileWidth = 500000.00
        Case Else
            Exit
    EndSelect

    $iResult =_os_otu_GetTileExtents($sContainerTile_In, $dSwCnrEastings, $dSwCnrNorthings, $dNeCnrEastings, $dNeCnrNorthings, $iContainerTileSize)
	If Not $iResult Then
		Return 0
	EndIf

    Select 
        Case $iTileSize_In = 1
            $dTileWidth = 500.00
        Case $iTileSize_In = 2
            $dTileWidth = 1000.00
        Case $iTileSize_In = 3
            $dTileWidth = 5000.00
        Case $iTileSize_In = 4
            $dTileWidth = 10000.00
        Case $iTileSize_In = 5
            $dTileWidth = 20000.00
        Case $iTileSize_In = 6
            $dTileWidth = 100000.00
        Case $iTileSize_In = 7
            $dTileWidth = 500000.00
        Case $iTileSize_In = 10
            $dTileWidth = 2000.00
        Case Else
            Exit
    EndSelect

    $iNoOfRows = int($dContainerTileWidth / $dTileWidth)
    $iNoOfCols = int($iNoOfRows)
    $lNoOfTiles = $iNoOfRows * $iNoOfCols
    $lTileIndex = 0
    For $iColIndex = 1 To $iNoOfCols
		$dTileCentreEastings = $dSwCnrEastings + (($iColIndex * $dTileWidth) - ($dTileWidth / 2))
        For $iRowIndex = 1 To $iNoOfRows
			$dTileCentreNorthings = $dSwCnrNorthings + (($iRowIndex * $dTileWidth) - ($dTileWidth / 2))
			$asListOfTiles_Out[$lTileIndex] =_os_otu_GetTileNameForCoords($dTileCentreEastings, $dTileCentreNorthings, $iTileSize_In)
			$lTileIndex += 1
        Next 
        ProgressSet(($iColIndex/$iNoOfCols) * 100)
    Next

    ProgressOff()

    Return($lNoOfTiles)
EndFunc

Func _os_otu_GeneratListOfTilesEx($sContainerTile_In, $iTileOutSize_In)
Local $iContainerTileSize
Local $dContainerTileWidth
Local $dTileCentreEastings
Local $dTileCentreNorthings
Local $lNoOfTiles
Local $iNoOfRows
Local $iNoOfCols
Local $iRowIndex
Local $iColIndex
Local $lTileIndex
Local $iResult
Local $dSwCnrEastings
Local $dSwCnrNorthings
Local $dNeCnrEastings
Local $dNeCnrNorthings
Local $sTemptile
Local $dCheckWidth
Local $fFound = False

    $iContainerTileSize =_os_otu_IsValidTileName($sContainerTile_In)
	
;~ 	Switch $iTileInSize_In 
;~ 		case 10
;~ 			If $iContainerTileSize = 2 Then 
;~ 				$iContainerTileSize = $iTileInSize_In
;~ 			EndIf
;~ 		Case Else
;~ 	EndSwitch
;~ 	
;~     If $iTileOutSize_In > $iContainerTileSize And $iTileInSize_In <> 10 Then
;~         Return(0)
;~     EndIf

    Select 
        Case $iContainerTileSize = 1
            $dContainerTileWidth = 500.00
        Case $iContainerTileSize = 2
            $dContainerTileWidth = 1000.00
        Case $iContainerTileSize = 3
            $dContainerTileWidth = 5000.00
        Case $iContainerTileSize = 4
            $dContainerTileWidth = 10000.00
        Case $iContainerTileSize = 5
            $dContainerTileWidth = 20000.00
        Case $iContainerTileSize = 6
            $dContainerTileWidth = 100000.00
        Case $iContainerTileSize = 7
            $dContainerTileWidth = 500000.00
        Case $iContainerTileSize = 10
            $dContainerTileWidth = 2000.00
        Case Else
            Return 0
    EndSelect
	

    $iResult =_os_otu_GetTileExtents($sContainerTile_In, $dSwCnrEastings, $dSwCnrNorthings, $dNeCnrEastings, $dNeCnrNorthings, $iContainerTileSize)
	If Not $iResult Then
		Return 0
	EndIf
	
    Select 
        Case $iTileOutSize_In = 1
			$dCheckWidth = 250.00
        Case $iTileOutSize_In = 2
			$dCheckWidth = 500.00
        Case $iTileOutSize_In = 3
			$dCheckWidth = 2500.00
        Case $iTileOutSize_In = 4
			$dCheckWidth = 50000.00
        Case $iTileOutSize_In = 5
			$dCheckWidth = 100000.00
        Case $iTileOutSize_In = 6
		    $dCheckWidth = 50000.00
        Case $iTileOutSize_In = 7
		    $dCheckWidth = 250000.00
        Case $iTileOutSize_In = 10
			$dCheckWidth = 1000.00
        Case Else
			Return 0
    EndSelect

    $iNoOfRows = int($dContainerTileWidth / $dCheckWidth)
	If $iNoOfRows = 0 Then 
		$iNoOfRows = 1
		$dCheckWidth = $dContainerTileWidth
	EndIf
    $iNoOfCols = int($iNoOfRows)
    $lNoOfTiles = $iNoOfRows * $iNoOfCols
	Local $asListOfTiles[$lNoOfTiles + 1]
	$asListOfTiles[0] = $lNoOfTiles
    $lTileIndex = 1
    For $iColIndex = 1 To $iNoOfCols
		$dTileCentreEastings = $dSwCnrEastings + (($iColIndex * $dCheckWidth) - ($dCheckWidth / 2))
        For $iRowIndex = 1 To $iNoOfRows
			$dTileCentreNorthings = $dSwCnrNorthings + (($iRowIndex * $dCheckWidth) - ($dCheckWidth / 2))
			$sTemptile = _os_otu_GetTileNameForCoords($dTileCentreEastings, $dTileCentreNorthings, $iTileOutSize_In)
			$fFound = False
			For $i = 1 To $lTileIndex
				If $asListOfTiles[$i] = $sTemptile Then 
					$fFound = True
					ExitLoop
				EndIf
			Next
			If Not $fFound Then	
				$asListOfTiles[0] = $lTileIndex
				$asListOfTiles[$lTileIndex] = $sTemptile
				$lTileIndex += 1
			EndIf
        Next 
    Next

	Return $asListOfTiles

EndFunc

;'############################################################################
;'#
;'#    Func_os_otu_GetTileExtents()
;'#
;'# DESCRIPTION:
;'#
;'#        Calculates the coords of the South West and North East corners of
;'#        a tile name.The coords are calculated in meters.If the output tile
;'#        size is smaller than the input tile size then the input tile size
;'#        will be used.
;'#
;'# PARAMETERS:
;'#
;'#        (IN)    
;'#        $sTileRef_In As String         A valid OS tile referece to 
;'#        $vOutputTileSize_In As Variant An optional value to that allows the
;'#                                      extents of a different size of tile
;'#                                      to be returned if required.
;'#                                      For example if $sTileRef_In = "SU1234NW"
;'#                                      0 will return extents for "SU1234NW"
;'#                                      1 will return extents for "SU1234NW"
;'#                                      2 will return extents for "SU1234"
;'#                                      3 will return extents for "SU13SW"
;'#                                      4 will return extents for "SU13"
;'#                                      5 will return extents for "SU02"
;'#                                      6 will return extents for "SU"
;'#                                      7 will return extents for "S"
;'#        (Out)    
;'#        $dSwCnrEastings_Out As Double  The eastings of the SW corner in meters
;'#        $dSwCnrNorthings_Out As Double The northings of the SW corner in meters
;'#        $dNeCnrEastings_Out As Double  The eastings of the NE corner in meters
;'#        $dNeCnrNorthings_Out As Double The northings of the NE corner in meters
;'#
;'#        (Returns) As Integer          $True (-1) if sucessful
;'#                                      $False (0) if unsucessful
;'#
;'# ERRORS:
;'#
;'#        none
;'#
;'# Orig Author: Roy B Kirby
;'# Orig     Date: Sep 21, 2004
;'# History:
;'#
;'#        Sep 21, 2004    Original Release
;'#
;'############################################################################
Func _os_otu_GetTileExtents($sTileRef_In, ByRef $dSwCnrEastings_Out, ByRef $dSwCnrNorthings_Out, ByRef $dNeCnrEastings_Out, ByRef $dNeCnrNorthings_Out, $vOutputTileSize_In)
Local $sCharacter1           ;'the first letter of the tile name
Local $sCharacter2           ;'the second letter of the tile name
Local $sQuadrant             ;'the last 2 letters of the tile name
Local $iOutputTileSize       ;'the size of tile to calculate the extents for
Local $iInputTileSize        ;'the size of the input tile name
Local $sOutputTileName        ;'the name of the tile matching the output size
Local $sTileRef

    $dSwCnrEastings_Out = 0
    $dSwCnrNorthings_Out = 0
    $dNeCnrEastings_Out = 0
    $dNeCnrNorthings_Out = 0
    
    $sTileRef = StringUpper($sTileRef_In)
    
    ;'Check the suppliied tile name is valid
    $iInputTileSize =_os_otu_IsValidTileName($sTileRef_In)
	If Not $iInputTileSize Then Return SetError(1,0,False)
    $iOutputTileSize = $vOutputTileSize_In
   ;'Convert the input tile name to match the
	$sOutputTileName = $sTileRef
		 
    $sCharacter1 = StringUpper(StringLeft($sOutputTileName, 1))
    $sCharacter2 = StringUpper(StringMid($sOutputTileName, 2, 1))
    $sQuadrant = StringRight($sOutputTileName,2)
    Select
        Case $sCharacter1 = "S"
            $dSwCnrEastings_Out = 0
            $dSwCnrNorthings_Out = 0
        Case $sCharacter1 = "T"
            $dSwCnrEastings_Out = 500000.00
            $dSwCnrNorthings_Out = 0
        Case $sCharacter1 = "N"
            $dSwCnrEastings_Out = 0
            $dSwCnrNorthings_Out = 500000.00
        Case $sCharacter1 = "O"
            $dSwCnrEastings_Out = 500000.00
            $dSwCnrNorthings_Out = 500000.00
        Case $sCharacter1 = "H"
            $dSwCnrEastings_Out = 0
            $dSwCnrNorthings_Out = 1000000.00
        Case $sCharacter1 = "J"
            $dSwCnrEastings_Out = 500000.00
            $dSwCnrNorthings_Out = 1000000.00
        Case Else
            Return(0)
    EndSelect


    Select
        Case $sCharacter2 = "A"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 0
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 400000.00
        Case $sCharacter2 = "F"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 0
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 300000.00
        Case $sCharacter2 = "L"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 0
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 200000.00
        Case $sCharacter2 = "Q"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 0
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 100000.00
        Case $sCharacter2 = "V"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 0
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 0
        Case $sCharacter2 = "B"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 100000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 400000.00
        Case $sCharacter2 = "G"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 100000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 300000.00
        Case $sCharacter2 = "M"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 100000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 200000.00
        Case $sCharacter2 = "R"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 100000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 100000.00
        Case $sCharacter2 = "W"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 100000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 0
        Case $sCharacter2 = "C"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 200000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 400000.00
        Case $sCharacter2 = "H"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 200000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 300000.00
        Case $sCharacter2 = "N"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 200000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 200000.00
        Case $sCharacter2 = "S"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 200000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 100000.00
        Case $sCharacter2 = "X"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 200000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 0
        Case $sCharacter2 = "D"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 300000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 400000.00
        Case $sCharacter2 = "J"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 300000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 300000.00
        Case $sCharacter2 = "O"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 300000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 200000.00
        Case $sCharacter2 = "T"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 300000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 100000.00
        Case $sCharacter2 = "Y"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 300000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 0
        Case $sCharacter2 = "E"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 400000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 400000.00
        Case $sCharacter2 = "K"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 400000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 300000.00
        Case $sCharacter2 = "P"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 400000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 200000.00
        Case $sCharacter2 = "U"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 400000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 100000.00
        Case $sCharacter2 = "Z"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 400000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 0
        Case Else
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 0
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 0
    EndSelect

    
    Select
        Case $iOutputTileSize = 1
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + (StringMid($sOutputTileName,3,2) * 1000)
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + (StringMid($sOutputTileName,5,2) * 1000)
            Select
                Case $sQuadrant = "NW"
                      $dSwCnrEastings_Out = $dSwCnrEastings_Out + 0
                      $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 500
                Case $sQuadrant = "NE"
                      $dSwCnrEastings_Out = $dSwCnrEastings_Out + 500
                      $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 500
                Case $sQuadrant = "SE"
                      $dSwCnrEastings_Out = $dSwCnrEastings_Out + 500
                      $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 0
                Case Else 
                      $dSwCnrEastings_Out = $dSwCnrEastings_Out + 0
                      $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 0
            EndSelect
            $dNeCnrEastings_Out = $dSwCnrEastings_Out + 500
            $dNeCnrNorthings_Out = $dSwCnrNorthings_Out + 500
        Case $iOutputTileSize = 2
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + (StringMid($sOutputTileName,3,2) * 1000)
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + (StringMid($sOutputTileName,5,2) * 1000)
            $dNeCnrEastings_Out = $dSwCnrEastings_Out + 1000
            $dNeCnrNorthings_Out = $dSwCnrNorthings_Out + 1000
        Case $iOutputTileSize = 3
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + (StringMid($sOutputTileName,3,1) * 10000)
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + (StringMid($sOutputTileName,4,1) * 10000)
            Select
                Case $sQuadrant = "NW"
                      $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 5000
                Case $sQuadrant = "NE"
                      $dSwCnrEastings_Out = $dSwCnrEastings_Out + 5000
                      $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 5000
                Case $sQuadrant = "SE"
                      $dSwCnrEastings_Out = $dSwCnrEastings_Out + 5000
                Case Else 
                      $dSwCnrEastings_Out = $dSwCnrEastings_Out + 0
                      $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 0
            EndSelect
            $dNeCnrEastings_Out = $dSwCnrEastings_Out + 5000
            $dNeCnrNorthings_Out = $dSwCnrNorthings_Out + 5000
        Case $iOutputTileSize = 4
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + (StringMid($sOutputTileName,3,1) * 10000)
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + (StringMid($sOutputTileName,4,1) * 10000)
            $dNeCnrEastings_Out = $dSwCnrEastings_Out + 10000
            $dNeCnrNorthings_Out = $dSwCnrNorthings_Out + 10000
        Case $iOutputTileSize = 5
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + (StringMid($sOutputTileName,3,1) * 10000)
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + (StringMid($sOutputTileName,4,1) * 10000)
            $dNeCnrEastings_Out = $dSwCnrEastings_Out + 20000
            $dNeCnrNorthings_Out = $dSwCnrNorthings_Out + 20000
        Case $iOutputTileSize = 6
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 0
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 0
            $dNeCnrEastings_Out = $dSwCnrEastings_Out + 100000
            $dNeCnrNorthings_Out = $dSwCnrNorthings_Out + 100000
        Case $iOutputTileSize = 7
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 0
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 0
            $dNeCnrEastings_Out = $dSwCnrEastings_Out + 500000
            $dNeCnrNorthings_Out = $dSwCnrNorthings_Out + 500000
        Case $iOutputTileSize = 10
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + (StringMid($sOutputTileName,3,2) * 1000)
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + (StringMid($sOutputTileName,5,2) * 1000)
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 0
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 0
            $dNeCnrEastings_Out = $dSwCnrEastings_Out + 2000
            $dNeCnrNorthings_Out = $dSwCnrNorthings_Out + 2000
        Case Else
            Return(0)
    EndSelect


    Return($True)

EndFunc

Func _os_otu_GetTileExtentsEx($sTileRef_In, ByRef $dSwCnrEastings_Out, ByRef $dSwCnrNorthings_Out, ByRef $dNeCnrEastings_Out, ByRef $dNeCnrNorthings_Out, $vOutputTileSize_In)
Local $sCharacter1           ;'the first letter of the tile name
Local $sCharacter2           ;'the second letter of the tile name
Local $sQuadrant             ;'the last 2 letters of the tile name
Local $iOutputTileSize       ;'the size of tile to calculate the extents for
Local $iInputTileSize        ;'the size of the input tile name
Local $sOutputTileName        ;'the name of the tile matching the output size
Local $sTileRef

    $dSwCnrEastings_Out = 0
    $dSwCnrNorthings_Out = 0
    $dNeCnrEastings_Out = 0
    $dNeCnrNorthings_Out = 0
    
    $sTileRef = StringUpper($sTileRef_In)
    
    ;'Check the suppliied tile name is valid
    $iInputTileSize =_os_otu_IsValidTileName($sTileRef_In)
	If Not $iInputTileSize Then Return SetError(1,0,False)
    $iOutputTileSize = $vOutputTileSize_In
   ;'Convert the input tile name to match the
	$sOutputTileName = $sTileRef
		 
    $sCharacter1 = StringUpper(StringLeft($sOutputTileName, 1))
    $sCharacter2 = StringUpper(StringMid($sOutputTileName, 2, 1))
    $sQuadrant = StringRight($sOutputTileName,2)
    Select
        Case $sCharacter1 = "S"
            $dSwCnrEastings_Out = 0
            $dSwCnrNorthings_Out = 0
        Case $sCharacter1 = "T"
            $dSwCnrEastings_Out = 500000.00
            $dSwCnrNorthings_Out = 0
        Case $sCharacter1 = "N"
            $dSwCnrEastings_Out = 0
            $dSwCnrNorthings_Out = 500000.00
        Case $sCharacter1 = "O"
            $dSwCnrEastings_Out = 500000.00
            $dSwCnrNorthings_Out = 500000.00
        Case $sCharacter1 = "H"
            $dSwCnrEastings_Out = 0
            $dSwCnrNorthings_Out = 1000000.00
        Case $sCharacter1 = "J"
            $dSwCnrEastings_Out = 500000.00
            $dSwCnrNorthings_Out = 1000000.00
        Case Else
            Return(0)
    EndSelect


    Select
        Case $sCharacter2 = "A"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 0
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 400000.00
        Case $sCharacter2 = "F"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 0
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 300000.00
        Case $sCharacter2 = "L"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 0
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 200000.00
        Case $sCharacter2 = "Q"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 0
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 100000.00
        Case $sCharacter2 = "V"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 0
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 0
        Case $sCharacter2 = "B"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 100000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 400000.00
        Case $sCharacter2 = "G"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 100000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 300000.00
        Case $sCharacter2 = "M"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 100000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 200000.00
        Case $sCharacter2 = "R"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 100000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 100000.00
        Case $sCharacter2 = "W"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 100000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 0
        Case $sCharacter2 = "C"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 200000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 400000.00
        Case $sCharacter2 = "H"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 200000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 300000.00
        Case $sCharacter2 = "N"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 200000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 200000.00
        Case $sCharacter2 = "S"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 200000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 100000.00
        Case $sCharacter2 = "X"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 200000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 0
        Case $sCharacter2 = "D"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 300000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 400000.00
        Case $sCharacter2 = "J"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 300000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 300000.00
        Case $sCharacter2 = "O"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 300000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 200000.00
        Case $sCharacter2 = "T"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 300000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 100000.00
        Case $sCharacter2 = "Y"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 300000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 0
        Case $sCharacter2 = "E"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 400000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 400000.00
        Case $sCharacter2 = "K"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 400000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 300000.00
        Case $sCharacter2 = "P"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 400000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 200000.00
        Case $sCharacter2 = "U"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 400000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 100000.00
        Case $sCharacter2 = "Z"
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 400000.00
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 0
        Case Else
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 0
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 0
    EndSelect

    
    Select
        Case $iOutputTileSize = 1
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + (StringMid($sOutputTileName,3,2) * 1000)
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + (StringMid($sOutputTileName,5,2) * 1000)
            Select
                Case $sQuadrant = "NW"
                      $dSwCnrEastings_Out = $dSwCnrEastings_Out + 0
                      $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 500
                Case $sQuadrant = "NE"
                      $dSwCnrEastings_Out = $dSwCnrEastings_Out + 500
                      $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 500
                Case $sQuadrant = "SE"
                      $dSwCnrEastings_Out = $dSwCnrEastings_Out + 500
                      $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 0
                Case Else 
                      $dSwCnrEastings_Out = $dSwCnrEastings_Out + 0
                      $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 0
            EndSelect
            $dNeCnrEastings_Out = $dSwCnrEastings_Out + 500
            $dNeCnrNorthings_Out = $dSwCnrNorthings_Out + 500
        Case $iOutputTileSize = 2
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + (StringMid($sOutputTileName,3,2) * 1000)
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + (StringMid($sOutputTileName,5,2) * 1000)
            $dNeCnrEastings_Out = $dSwCnrEastings_Out + 1000
            $dNeCnrNorthings_Out = $dSwCnrNorthings_Out + 1000
        Case $iOutputTileSize = 3
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + (StringMid($sOutputTileName,3,1) * 10000)
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + (StringMid($sOutputTileName,4,1) * 10000)
            Select
                Case $sQuadrant = "NW"
                      $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 5000
                Case $sQuadrant = "NE"
                      $dSwCnrEastings_Out = $dSwCnrEastings_Out + 5000
                      $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 5000
                Case $sQuadrant = "SE"
                      $dSwCnrEastings_Out = $dSwCnrEastings_Out + 5000
                Case Else 
                      $dSwCnrEastings_Out = $dSwCnrEastings_Out + 0
                      $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 0
            EndSelect
            $dNeCnrEastings_Out = $dSwCnrEastings_Out + 5000
            $dNeCnrNorthings_Out = $dSwCnrNorthings_Out + 5000
        Case $iOutputTileSize = 4
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + (StringMid($sOutputTileName,3,1) * 10000)
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + (StringMid($sOutputTileName,4,1) * 10000)
            $dNeCnrEastings_Out = $dSwCnrEastings_Out + 10000
            $dNeCnrNorthings_Out = $dSwCnrNorthings_Out + 10000
        Case $iOutputTileSize = 5
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + (StringMid($sOutputTileName,3,1) * 10000)
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + (StringMid($sOutputTileName,4,1) * 10000)
            $dNeCnrEastings_Out = $dSwCnrEastings_Out + 20000
            $dNeCnrNorthings_Out = $dSwCnrNorthings_Out + 20000
        Case $iOutputTileSize = 6
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 0
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 0
            $dNeCnrEastings_Out = $dSwCnrEastings_Out + 100000
            $dNeCnrNorthings_Out = $dSwCnrNorthings_Out + 100000
        Case $iOutputTileSize = 7
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 0
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 0
            $dNeCnrEastings_Out = $dSwCnrEastings_Out + 500000
            $dNeCnrNorthings_Out = $dSwCnrNorthings_Out + 500000
        Case $iOutputTileSize = 10
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + (StringMid($sOutputTileName,3,2) * 1000)
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + (StringMid($sOutputTileName,5,2) * 1000)
            $dSwCnrEastings_Out = $dSwCnrEastings_Out + 0
            $dSwCnrNorthings_Out = $dSwCnrNorthings_Out + 0
            $dNeCnrEastings_Out = $dSwCnrEastings_Out + 2000
            $dNeCnrNorthings_Out = $dSwCnrNorthings_Out + 2000
        Case Else
            Return(0)
    EndSelect


    Return($True)

EndFunc

;'############################################################################
;'#
;'#    Sub_os_otu_IsValidTileName()
;'#
;'# DESCRIPTION:
;'#
;'#        Checks that the supplied tile name is capable of being parsed to 
;'#        enable the extent coords to be calculated elsewhere are stored in.
;'#
;'# PARAMETERS:
;'#
;'#        (IN)    
;'#        $sTileName As String,          The tile name to be checked
;'#
;'#        (Out)
;'#        none
;'#        
;'#        (Returns) As Integer          One of the following values          
;'#                                      0 = The tilename is not valid 
;'#                                      1 = The tilename is a valid 500m by 
;'#                                          500m tile reference
;'#                                      2 = The tilename is a valid 1000m by 
;'#                                          1000m tile reference
;'#                                      3 = The tilename is a valid 5Km by 
;'#                                          5Km tile reference
;'#                                      4 = The tilename is a valid 10Km by 
;'#                                          Km tile reference
;'#                                      5 = The tilename is a valid 20Km by 
;'#                                          20Km tile reference
;'#                                      6 = The tilename is a valid 100Km by 
;'#                                          100Km tile reference
;'#                                      7 = The tilename is a valid 500Km by 
;'#                                          500Km tile reference
;'#
;'#
;'#
;'# ERRORS:
;'#
;'#        Generates a script command failure if the information can not be 
;'#        sucessfully retreaved
;'#
;'# Orig Author: Roy B Kirby
;'# Orig     Date: Sep 21, 2004
;'# History:
;'#
;'#        Sep 21, 2004    Original Release
;'#
;'############################################################################
Func _os_otu_IsValidTileName($sTileName_In)
	
	Select
		Case StringRegExp($sTileName_In,"(^(?i:[HNOST][A-HJ-Z])(?:[0-9]{4}(?i:NW|NE|SW|SE))$)")
			Return(1)
		Case StringRegExp($sTileName_In,"(^(?i:[HNOST][A-HJ-Z])(?:[0-9]{4})$)")
			Return(2)
		Case StringRegExp($sTileName_In,"(^(?i:[HNOST][A-HJ-Z])(?:[0-9]{2}(?i:NW|NE|SW|SE))$)")
			Return(3)
		Case StringRegExp($sTileName_In,"(^(?i:[HNOST][A-HJ-Z])(?:[02468]{2})$)")
			Return(5)
		Case StringRegExp($sTileName_In,"(^(?i:[HNOST][A-HJ-Z])(?:[0-9]{2})$)")
			Return(4)
		Case StringRegExp($sTileName_In,"(^(?i:[HNOST][A-HJ-Z])$)")
			Return(6)
		Case StringRegExp($sTileName_In,"(^(?i:[HNOST])$)")
			Return(7)
		Case Else
			Return(0)
	EndSelect

EndFunc

;'############################################################################
;'#
;'#    Func_os_otu_GetTileNameForCoords()
;'#
;'# DESCRIPTION:
;'#
;'#        Gets the alphanumeric tile name that the coords supplied fall in
;'#
;'# PARAMETERS:
;'#
;'#        (IN)    
;'#        $dEastings_In As Double
;'#        $dNorthings_In As Double
;'#        $iTileSize_In As Integer
;'#
;'#        (Out)    
;'#        none
;'#
;'#        (Returns) As String           The tile name the coords fall in. The 
;'#                                      scale of the tile name depends on the
;'#                                      value of $iTileSize_In
;'#                                      For example
;'#                                      1 = "SU1234NW"
;'#                                      2 = "SU1234"
;'#                                      3 = "SU13NW"
;'#                                      4 = "SU13"
;'#                                      5 = "SU02"
;'#                                      6 = "SU"
;'#                                      7 = "S"
;'#
;'# ERRORS:
;'#
;'#        Returns "" if unable to determine a valid tile name
;'#
;'# Orig Author: Roy B Kirby
;'# Orig     Date: Sep 21, 2004
;'# History:
;'#
;'#        Sep 21, 2004    Original Release
;'#
;'############################################################################
Func _os_otu_GetTileNameForCoords($dEastings_In, $dNorthings_In, $iTileSize_In)
Local $asNg1[2][3]
Local $asNg2[5][5]
Local $asQuad[2][2]
Local $sEast
Local $sNorth
Local $iE1
Local $iN1
Local $iE2
Local $iN2
Local $iQE
Local $iQN
Local $sTileName
Local $sE
Local $sN

    $asNg1[0][0] = "S"
    $asNg1[1][0] = "T"
    $asNg1[0][1] = "N"
    $asNg1[1][1] = "O"
    $asNg1[0][2] = "H"
    $asNg1[1][2] = "J"

    $asNg2[0][0] = "V"
    $asNg2[0][1] = "Q"
    $asNg2[0][2] = "L"
    $asNg2[0][3] = "F"
    $asNg2[0][4] = "A"
    $asNg2[1][0] = "W"
    $asNg2[1][1] = "R"
    $asNg2[1][2] = "M"
    $asNg2[1][3] = "G"
    $asNg2[1][4] = "B"
    $asNg2[2][0] = "X"
    $asNg2[2][1] = "S"
    $asNg2[2][2] = "N"
    $asNg2[2][3] = "H"
    $asNg2[2][4] = "C"
    $asNg2[3][0] = "Y"
    $asNg2[3][1] = "T"
    $asNg2[3][2] = "O"
    $asNg2[3][3] = "J"
    $asNg2[3][4] = "D"
    $asNg2[4][0] = "Z"
    $asNg2[4][1] = "U"
    $asNg2[4][2] = "P"
    $asNg2[4][3] = "K"
    $asNg2[4][4] = "E"
    $asQuad[0][0] = "SW"
    $asQuad[0][1] = "NW"
    $asQuad[1][0] = "SE"
    $asQuad[1][1] = "NE"


    $sEast = StringFormat("%010.3f",$dEastings_In)
    $sNorth = StringFormat("%011.3f",$dNorthings_In)
    
    $iE1 = Int($dEastings_In / 500000)
    $iN1 = Int($dNorthings_In / 500000)

    $iE2 = Int((($dEastings_In - (500000 * $iE1)) / 100000))
    $iN2 = Int((($dNorthings_In - (500000 * $iN1)) / 100000))

    Select
        Case $iTileSize_In = 1
            $sE = String(StringMid($sEast, 2, 2))
            $sN = String(StringMid($sNorth, 3, 2))
            $iQE = Int(StringMid($sEast, 4, 3) / 500)
            $iQN = Int(StringMid($sNorth, 5, 3) / 500)
            $sTileName = $asNg1[$iE1][$iN1] & $asNg2[$iE2][$iN2] & $sE & $sN & $asQuad[$iQE][$iQN]
        Case $iTileSize_In = 2
            $sE = String(StringMid($sEast, 2, 2))
            $sN = String(StringMid($sNorth, 3, 2))
            $sTileName = $asNg1[$iE1][$iN1] & $asNg2[$iE2][$iN2] & $sE & $sN
        Case $iTileSize_In = 3
            $sE = String(StringMid($sEast, 2, 1))
            $sN = String(StringMid($sNorth, 3, 1))
            $iQE = Int(StringMid($sEast, 3, 4) / 5000)
            $iQN = Int(StringMid($sNorth, 4, 4) / 5000)
            $sTileName = $asNg1[$iE1][$iN1] & $asNg2[$iE2][$iN2] & $sE & $sN & $asQuad[$iQE][$iQN]
        Case $iTileSize_In = 4
            $sE = String(StringMid($sEast, 2, 1))
            $sN = String(StringMid($sNorth, 3, 1))
            $sTileName = $asNg1[$iE1][$iN1] & $asNg2[$iE2][$iN2] & $sE & $sN
        Case $iTileSize_In = 5
            $sE = String(Int(StringMid($sEast, 2, 1) / 2) * 2)
            $sN = String(Int(StringMid($sNorth, 3, 1) / 2) * 2)
            $sTileName = $asNg1[$iE1][$iN1] & $asNg2[$iE2][$iN2] & $sE & $sN
        Case $iTileSize_In = 6
            $sTileName = $asNg1[$iE1][$iN1] & $asNg2[$iE2][$iN2]
        Case $iTileSize_In = 7
            $sTileName = $asNg1[$iE1][$iN1]
        Case $iTileSize_In = 10
            $sE = String(StringMid($sEast, 2, 2))
            $sN = String(StringMid($sNorth, 3, 2))
            $sTileName = $asNg1[$iE1][$iN1] & $asNg2[$iE2][$iN2] & StringFormat("%02s",Int($sE / 2) * 2) & StringFormat("%02s",Int($sN / 2) * 2)
        Case Else
            $sTileName = ""
    EndSelect
    
    Return($sTileName )

EndFunc

Func _os_otu_GetTileRefFromFileName($Path_In)
Local $sRegExPattern = "(?i:[HNOST][A-HJ-Z])(?:(?:[0-9]{4}(?i:NW|NE|SW|SE))|(?:[0-9]{4})|(?:[0-9]{2}(?i:NW|NE|SW|SE))|(?:[02468]{2}))"
Local $TileRef = ""
Local $szDrive, $szDir, $szFName, $szExt
Local $FilePartsIn = 0

	_PathSplit($Path_In, $szDrive, $szDir, $szFName, $szExt)
	$FilePartsIn = StringRegExp($szFName, $sRegExPattern, 2)
	If IsArray($FilePartsIn) Then 
		$TileRef = $FilePartsIn[0]
	EndIf
	
	Return($TileRef)
	
EndFunc

Func _os_otu_ListCollarTiles($sTileName, $RootFolder = "", $TreeSize = 4)
Local $dSwCnrEastings = 0
Local $dSwCnrNorthings = 0
Local $dNeCnrEastings = 0
Local $dNeCnrNorthings = 0
Local $TileSize = 0
Local $Coords[24][2]
Local $TileList[1] = [0]
Local $i
Local $TreeTile
Local $sTile = $sTileName
Local $xmin = 99999999
Local $xmax = -99999999
Local $ymin = 99999999
Local $ymax = -99999999
Local $Increment = 0
Local $ix = 1

	$TileSize =_os_otu_IsValidTileName($sTile)
	If _os_otu_GetTileExtents($sTile, $dSwCnrEastings, $dSwCnrNorthings, $dNeCnrEastings, $dNeCnrNorthings, $TileSize) Then
		Switch $TileSize
			Case 1
				$Coords[0][0] = 4
			Case 2
				$Coords[0][0] = 8
			Case 3
				$Coords[0][0] = 20
			Case Else
		EndSwitch
	EndIf		
	; Southern Edge
	$xmin = $dSwCnrEastings - 250.00
	$xmax = $dNeCnrEastings + 250.00
	$ymin = $dSwCnrNorthings - 250.00
	$ymax = $dNeCnrNorthings + 250.00
	$Increment = 0
	$ix = 1
	 While $ix <= $Coords[0][0]
		$Increment += 500
		; Western Edge
		$Coords[$ix][0] = ($xmin ) 
		$Coords[$ix][1] = ($ymin + $Increment ) 
		$ix += 1
		; Northern Edge
		$Coords[$ix][0] = ($xmin + $Increment ) 
		$Coords[$ix][1] = ($ymax) 
		$ix += 1
		; Eastern Edge
		$Coords[$ix][0] = ($xmax) 
		$Coords[$ix][1] = ($ymin + $Increment ) 
		$ix += 1
		; Southern Edge
		$Coords[$ix][0] = ($xmin + $Increment ) 
		$Coords[$ix][1] = ($ymin)
		$ix += 1
	WEnd	
	Local $EdgeTile = ""
	Local $j
	For $ix = 1 To 4 
		For $i = $ix To $Coords[0][0] Step 4
			For $j = 1 To 3 
				$EdgeTile =_os_otu_GetTileNameForCoords($Coords[$i][0], $Coords[$i][1], $j)
				If $RootFolder <> "" Then
					$TreeTile =_os_otu_GetTileNameForCoords($Coords[$i][0], $Coords[$i][1], $TreeSize)
					$EdgeTile =_os_otu_GetTileNameForCoords($Coords[$i][0], $Coords[$i][1], $j)
					If StringLen($TreeTile) = 4 Then
						$EdgeTile = $RootFolder & StringLeft($TreeTile,2) & "\" & StringRight($TreeTile,2) & "\" & $EdgeTile
					Else
						$EdgeTile = $RootFolder & $TreeTile & "\" & $EdgeTile
					EndIf
				Else
					$EdgeTile =_os_otu_GetTileNameForCoords($Coords[$i][0], $Coords[$i][1], $j)
				EndIf
				If _ArraySearch ($TileList, $EdgeTile, 1, 0, 0, False) = -1 Then
					_ArrayAdd($TileList, $EdgeTile)
					$TileList[0] += 1
				EndIf
				
			Next
		Next
	Next
	_ArraySort($TileList,0,1)
	Return($TileList)
EndFunc	

Func _os_otu_GetTreeDir($sTileName, $RootFolder = "", $TreeSize = 4)
Local $dSwCnrEastings = 0
Local $dSwCnrNorthings = 0
Local $dNeCnrEastings = 0
Local $dNeCnrNorthings = 0
Local $TileSize = 0
Local $TreeTile
Local $Path = ""
Local $sTile = $sTileName

	$TileSize = _os_otu_IsValidTileName($sTile)
	If _os_otu_GetTileExtents($sTile, $dSwCnrEastings, $dSwCnrNorthings, $dNeCnrEastings, $dNeCnrNorthings, $TileSize) Then
		$TreeTile = _os_otu_GetTileNameForCoords($dSwCnrEastings + 250, $dSwCnrNorthings + 250, $TreeSize)
		If StringLen($TreeTile) = 4 Then
			$Path = StringLeft($TreeTile,2) & "\" & StringRight($TreeTile,2) & "\"
		Else
			$Path = $TreeTile & "\"
		EndIf
	EndIf
	If $RootFolder <> "" Then
		$Path = _os_PathNormalise($RootFolder) & $Path
	EndIf
	
	Return($Path)

EndFunc