#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Icon=Boss1.ICO
#AutoIt3Wrapper_Outfile=AutoTestManager.exe
#AutoIt3Wrapper_Compression=4
#AutoIt3Wrapper_Res_Comment=This tool is used to sequence multiple test jobs.
#AutoIt3Wrapper_Res_Description=AutoIt Test Manager
#AutoIt3Wrapper_Res_Fileversion=0.8.2990.1
#AutoIt3Wrapper_Res_FileVersion_AutoIncrement=p
#AutoIt3Wrapper_Res_LegalCopyright=Roy Kirby 2008
#AutoIt3Wrapper_Res_SaveSource=y
#AutoIt3Wrapper_Res_Field=AutoIt Version|%AutoItVer%
#AutoIt3Wrapper_Res_Field=Author|Roy B Kirby
#AutoIt3Wrapper_Res_Field=Email|roykirby@lineone.net
#AutoIt3Wrapper_Res_Field=Product Name|Auto Test Runner
#AutoIt3Wrapper_Res_Field=Product Version|0.8
#AutoIt3Wrapper_Res_Field=AutoIt Version|%AutoItVer%
#AutoIt3Wrapper_Res_Field=Compile Date|%date% %time%
#AutoIt3Wrapper_Au3Check_Stop_OnWarning=Y
#AutoIt3Wrapper_Au3Check_Parameters=-q -d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#AutoIt3Wrapper_Run_Before=MKDIR "%scriptdir%\Release"
#AutoIt3Wrapper_Run_After=copy "%out%" "%scriptdir%\Release\%scriptfile%.%fileversion%.exe"
#AutoIt3Wrapper_Run_After=copy "%in%" "%scriptdir%\Release\%scriptfile%.%fileversion%.au3"
#AutoIt3Wrapper_Run_After=copy "%out%" "%scriptdir%\Release
#AutoIt3Wrapper_Run_Tidy=y
#Tidy_Parameters=/tc 0 /gd /sci 0 /sdp"'\WinMerge\WinMerge.exe' '%new%' '%old%'"
#AutoIt3Wrapper_Run_Obfuscator=y
#Obfuscator_Parameters=/striponly
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Run_Debug_Mode=N

;#AutoIt3Wrapper_PlugIn_Funcs=
#cs Introduction
	Script Name:AutoTestManager
	Purpose:This tool is used to sequence multiple automated tesing jobs.
	Similar to Rational Test Manager.
#ce
#Region ### Set Options
Opt("WinWaitDelay", 100)
Opt("WinTitleMatchMode", 4)
Opt("WinDetectHiddenText", 1)
Opt("MouseCoordMode", 2)
Opt("MustDeclareVars", 1)
#EndRegion ### Set Options
#Region Declare
Global Const $AT_ROOT_DIR = "H:\AtuoItTestControl"
Global $g_nMsg = 0
Global $g_fDEBUG = False
Global $g_fRun = False
Global $g_fAllJobsDone = False
Global $g_fProcessing = False
Global $g_sTaskType = ''
Global $g_sJobControlFolder = ''
Global $g_sStartDateTime = ''
Global $g_sStopDateTime = ''
Global $g_sTestRunID = ''
Global $sTitle = StringLeft(@ScriptName, StringInStr(@ScriptName, ".") - 1)
Global $GUI_frmMainCaption = $sTitle & " - Ver " & FileGetVersion(@ScriptFullPath)
Global $g_aStatusBarParts[2] = [350, -1]
Global $g_aStatusBarPartsText[2] = ["Ready", ""]
Global $hWndStartDate = 0
Global $hWndStopDate = 0
Global $g_iSleep = 10
Global $g_Computers_Status[250][5]
Global $g_hDB = 0
Global $g_aStatusBarParts[3] = [150, 440, -1]
Global $g_aStatusBarPartsText[3] = ["Ready", "", "000:00:00"]
Global $g_aComputers = 0
Global $g_sRunStartTime = ''
Global $g_iPercentDone = 0
Global $g_iStatus, $g_aResult, $g_iRows, $g_iColumns
#EndRegion Declare

#Region Includes
#include <_os_File.au3>
#include <_os_TileUtilities.au3>
#include <ButtonConstants.au3>
#include <Date.au3>
#include <SQLite.au3>
#include <SQLite.dll.au3>
#include <WindowsConstants.au3>
#include <GUIConstantsEx.au3>
#include <GuiListView.au3>
#include <GuiStatusBar.au3>
#include <ProgressConstants.au3>
#EndRegion Includes

#Region ### START Koda GUI section ### Form=X:\AutoIt3Data\Scripts\AutoTest\AutoTestManager\Gui_frmMain.kxf
Global $Gui_frmMain = GUICreate($GUI_frmMainCaption, 495, 468, 451, 151)
Global $Gui_tab = GUICtrlCreateTab(5, 5, 486, 437)
Global $Gui_tab0 = GUICtrlCreateTabItem("Topo93 Comp")
Global $Gui_tab0_lblJob = GUICtrlCreateLabel("Test Job", 10, 40, 100, 17)
Global $Gui_tab0_edtTestJob = GUICtrlCreateInput("", 110, 38, 350, 21)
Global $Gui_tab0_lblDataRootV1 = GUICtrlCreateLabel("V1 Data Root Dir", 10, 65, 100, 17)
Global $Gui_tab0_edtDataRootV1 = GUICtrlCreateInput("", 110, 63, 350, 21)
Global $Gui_tab0_btnBrowseV1 = GUICtrlCreateButton("...", 463, 63, 21, 21, BitOR($BS_CENTER, $BS_VCENTER, $BS_FLAT))
Global $Gui_tab0_lblDataRootV2 = GUICtrlCreateLabel("V2 Data Root Dir", 10, 90, 100, 17)
Global $Gui_tab0_edtDataRootV2 = GUICtrlCreateInput("", 110, 88, 350, 21)
Global $Gui_tab0_btnBrowseV2 = GUICtrlCreateButton("...", 463, 88, 21, 21, BitOR($BS_CENTER, $BS_VCENTER, $BS_FLAT))
Global $Gui_tab0_lblStrumapPrm = GUICtrlCreateLabel("PRM config File", 10, 115, 100, 17)
Global $Gui_tab0_edtStrumapPrm = GUICtrlCreateInput("", 110, 113, 350, 21)
Global $Gui_tab0_btnBrowsePrm = GUICtrlCreateButton("...", 463, 113, 21, 21, BitOR($BS_CENTER, $BS_VCENTER, $BS_FLAT))
Global $Gui_tab0_lblStrumapVer = GUICtrlCreateLabel("Strumap Ver", 200, 140, 80, 17)
Global $Gui_tab0_cboStrumapVer = GUICtrlCreateCombo("", 260, 138, 85, 25)
Global $Gui_tab0_lblTopo96Ext = GUICtrlCreateLabel("Topo96 Ext", 10, 140, 100, 17)
Global $Gui_tab0_cboTopo96Ext = GUICtrlCreateCombo("", 110, 138, 65, 25)
Global $Gui_tab0_lblTopo93V1Ext = GUICtrlCreateLabel("Topo93 V1 Ext", 10, 165, 100, 17)
Global $Gui_tab0_cboTopo93V1Ext = GUICtrlCreateCombo("", 110, 163, 65, 25)
Global $Gui_tab0_lblTopo93V2Ext = GUICtrlCreateLabel("Topo93 V2 Ext", 10, 190, 100, 17)
Global $Gui_tab0_cboTopo93V2Ext = GUICtrlCreateCombo("", 110, 188, 65, 25)
Global $Gui_tab0_chkCreatePhseudo = GUICtrlCreateCheckbox("Create Pseudo", 370, 140, 100, 17)
Global $Gui_tab0_chkUseGeoComp = GUICtrlCreateCheckbox("Use GeoComp", 370, 157, 100, 17)
Global $Gui_tab0_chkSaveSbz = GUICtrlCreateCheckbox("Save SBZ Files", 370, 174, 100, 17)
Global $Gui_tab0_chkClassifyErr = GUICtrlCreateCheckbox("Classify Errors", 370, 191, 100, 17)
Global $Gui_tab0_btnStopPCs = GUICtrlCreateButton("Stop Selected PCs", 380, 405, 100, 30, $BS_FLAT)
Global $Gui_tab0_btnRun = GUICtrlCreateButton("Run", 10, 405, 100, 30, $BS_FLAT)
Global $Gui_tab0_btnClose = GUICtrlCreateButton("Close", 134, 405, 100, 30, $BS_FLAT)
Global $Gui_tab0_MyButton3 = GUICtrlCreateButton("MyButton3", 258, 405, 100, 30, $BS_FLAT)
Global $Gui_tab0_lsvComputers = GUICtrlCreateListView("", 10, 220, 475, 178, BitOR($GUI_SS_DEFAULT_LISTVIEW, $LVS_SORTASCENDING), BitOR($WS_EX_CLIENTEDGE, $LVS_EX_CHECKBOXES, $LVS_EX_GRIDLINES, $LVS_EX_FULLROWSELECT))
Global $Gui_tab0_hListView = ControlGetHandle($GUI_frmMainCaption, "", $Gui_tab0_lsvComputers)
_GUICtrlListView_AddColumn($Gui_tab0_hListView, "Computers", 100)
_GUICtrlListView_AddColumn($Gui_tab0_hListView, "Job", 100)
_GUICtrlListView_AddColumn($Gui_tab0_hListView, "Status", 95)
_GUICtrlListView_AddColumn($Gui_tab0_hListView, "Started", 115)
_GUICtrlListView_AddColumn($Gui_tab0_hListView, "Time", 60)
GUICtrlCreateTabItem("")
Global $Gui_tab1 = GUICtrlCreateTabItem("MasterMap Comp")
GUICtrlCreateTabItem("")
Global $Gui_tab2 = GUICtrlCreateTabItem("ITN Validate")
GUICtrlCreateTabItem("")
Global $GUI_stbStatusBar = _GUICtrlStatusBar_Create($Gui_frmMain, $g_aStatusBarParts, $g_aStatusBarPartsText)
Global $Gui_pgbProgress = GUICtrlCreateProgress(0, 0, -1, -1, $PBS_SMOOTH)
Global $g_hProgress = GUICtrlGetHandle($Gui_pgbProgress)
_GUICtrlStatusBar_SetMinHeight($GUI_stbStatusBar, 20)
_GUICtrlStatusBar_EmbedControl($GUI_stbStatusBar, 1, $g_hProgress)

_Settings_Read()
GUISetState(@SW_SHOW)
#EndRegion ### START Koda GUI section ### Form=X:\AutoIt3Data\Scripts\AutoTest\AutoTestManager\Gui_frmMain.kxf
Global $tLastChecked = TimerInit()
Global $iLastDBCheck = TimerInit()
While 1
	$g_nMsg = GUIGetMsg()
	Switch $g_nMsg
		Case $GUI_EVENT_CLOSE
			_Settings_Save()
			Exit
		Case $Gui_tab0_btnClose
			_Settings_Save()
			Exit
		Case $Gui_tab0_btnRun
			$g_fRun = False
			If Not (_Initialise() = 1) Then ContinueLoop
			If Not (_Database_Start() = 1) Then ContinueLoop
			If Not (_Database_Initialise() = 1) Then ContinueLoop
			If Not (_Computers_Clean() = 1) Then ContinueLoop
			$g_sRunStartTime = _NowCalc()
			$g_fRun = True
		Case $Gui_tab0_MyButton3
			$g_iStatus = _SQLite_GetTable2d($g_hDB, "SELECT * FROM JOB_CONTROL ORDER BY FILE_SIZE DESC;", $g_aResult, $g_iRows, $g_iColumns)
			If $g_iStatus = $SQLITE_OK Then
				_ArrayDisplay($g_aResult, "Results")
				$g_iStatus = 1
			EndIf
	EndSwitch
	
	If $g_fRun And TimerDiff($tLastChecked) > 2500 Then
		$g_aComputers = _ScanFor_ComputersOnline($g_sJobControlFolder)
		_Process_ComputersOnline($g_aComputers)
		$g_aComputers = _ScanFor_ComputersOffline($g_sJobControlFolder)
		_Process_ComputersOffline($g_aComputers)
		$g_aComputers = _ScanFor_JobsAborted($g_sJobControlFolder)
		_Process_JobsAborted($g_aComputers)
		$g_aComputers = _ScanFor_JobsCompleted($g_sJobControlFolder)
		_Process_JobsCompleted($g_aComputers)
		$g_aComputers = _ScanFor_JobRequests($g_sJobControlFolder)
		_Process_JobRequests($g_aComputers)
		$g_aComputers = _ScanFor_JobsRunning($g_sJobControlFolder)
		_Process_JobsRunning($g_aComputers)
		If $g_fAllJobsDone Then
			_Process_Results($g_sJobControlFolder, $g_Computers_Status)
			$g_fRun = False
		EndIf
		_GUICtrlStatusBar_SetText($GUI_stbStatusBar, _RuninngTime($g_sRunStartTime), 2)
		If TimerDiff($iLastDBCheck) > 120000 Then
			$g_iPercentDone = _PercentDone()
			$iLastDBCheck = TimerInit()
		EndIf
		_GUICtrlStatusBar_SetText($GUI_stbStatusBar, "Percentage Done " & $g_iPercentDone)
		$tLastChecked = TimerInit()
	EndIf
WEnd


Func _Computers_Clean()
	Local $sFolder = $g_sJobControlFolder & "\Computers"
	Local $asFileList[1] = [0]
	Local $sFilePattern
	Local $iState = 1
	For $i = 1 To 7
		Switch $i
			Case 1
				$sFilePattern = "_RunningJob.atj"
			Case 2
				$sFilePattern = "_CompletedJob.atj"
			Case 3
				$sFilePattern = "_NextJob.atj"
			Case 4
				$sFilePattern = "_NoMoreJobs.atj"
			Case 6
				$sFilePattern = "_Stop.atj"
			Case 6
				$sFilePattern = "_Aborted.atj"
			Case Else
				$sFilePattern = "_RequestJob.atj"
		EndSwitch
		ReDim $asFileList[1]
		$asFileList[0] = 0
		$asFileList = _os_FilesListInTree($sFolder, $asFileList, 0, $sFilePattern)
		For $iFile = 1 To $asFileList[0]
			FileDelete($asFileList[$iFile])
		Next
	Next
	Return $iState
EndFunc   ;==>_Computers_Clean
Func _Database_Initialise()
	Local $sIniFile = $g_sJobControlFolder & "\config.ini"
	Local $iStatus = 1
	Local $aResult = 0
	Local $iRows = 0
	Local $iColumns = 0
	Local $sTile = ''
	Local $sSQL = ''
;~ 	Local $sTable = "JOB_CONTROL"
	Local $aRow
	Local $iJobCount = 0
	Local $iJobCompletedCount = 0
	Local $iMsgBoxAnswer
	Local $fFullRun = True
	Local $iFileSize = 0
	Local $sJobList[1] = [0]
	Local $sMsg = ''
	
	_GUICtrlStatusBar_SetText($GUI_stbStatusBar, "Checking database")
	$sSQL = "SELECT Count(FILE) FROM JOB_CONTROL"
	_SQLite_QuerySingleRow($g_hDB, $sSQL, $aRow) ; Select single row and single field !
	If $iStatus = $SQLITE_OK Then
		If IsArray($aRow) Then $iJobCount = $aRow[0]
		If $iJobCount > 0 Then
			$sSQL = "SELECT Count(END_TIME) FROM JOB_CONTROL WHERE END_TIME = NULL"
			_SQLite_QuerySingleRow($g_hDB, $sSQL, $aRow) ; Select single row and single field !
			If $iStatus <> $SQLITE_OK Then
				Return SetError(@error, 0, 0)
			EndIf
			If IsArray($aRow) Then $iJobCompletedCount = $aRow[0]
			If $iJobCount > $iJobCompletedCount Then
				$sMsg = "This Job has previously been Run and " & $iJobCompletedCount & " out of " & $iJobCount & " Tests completed." & @CRLF & "Click Yes - to complete previous run" & @CRLF & "Click No - to deltete previous run and run all tests again." & @CRLF & "Click Cancel - to exit without any changes."

;~ 				$sMsg = "This Job has previously been Run and " _
;~ 						 & $iJobCompletedCount & " out of " & $iJobCount & " Tests completed." & @CRLF _
;~ 						 & "Click Yes - to complete previous run" & @CRLF _
;~ 						 & "Click No - to deltete previous run and run all tests again." & @CRLF _
;~ 						 & "Click Cancel - to exit without any changes."
				#Region --- CodeWizard generated code Start ---
				;MsgBox features: Title=Yes, Text=Yes, Buttons=Yes, No, and Cancel, Default Button=Third, Icon=Question, Modality=System Modal, Miscellaneous=Top-most attribute
				$iMsgBoxAnswer = MsgBox(266787, "AutoTestManager - Info", $sMsg)
				Select
					Case $iMsgBoxAnswer = 6 ;Yes
						$fFullRun = False
					Case $iMsgBoxAnswer = 7 ;No
						$fFullRun = True
					Case $iMsgBoxAnswer = 2 ;Cancel
						Return 10
				EndSelect
				#EndRegion --- CodeWizard generated code Start ---
			ElseIf $iJobCount > 0 Then
				$sMsg = "This Job has previously been Run and completed" & @CRLF & "Do you want to overwrite the previous run and run the tests again?"
				#Region --- CodeWizard generated code Start ---
				;MsgBox features: Title=Yes, Text=Yes, Buttons=Yes and No, Default Button=Second, Icon=Question, Modality=System Modal, Miscellaneous=Top-most attribute
				$iMsgBoxAnswer = MsgBox(266532, "AutoTestManager - Info", "")
				Select
					Case $iMsgBoxAnswer = 6 ;Yes
						$fFullRun = True
					Case $iMsgBoxAnswer = 7 ;No
						Return 10
				EndSelect
				#EndRegion --- CodeWizard generated code Start ---
			EndIf
		EndIf
	EndIf

	If $fFullRun Then
		Local $sDataDir = IniRead($sIniFile, "SETTINGS", "V1CITFDataRootDir", "")
		If $sDataDir = '' Then
			#Region --- CodeWizard generated code Start ---
			;MsgBox features: Title=Yes, Text=Yes, Buttons=OK, Icon=Critical, Modality=System Modal, Miscellaneous=Top-most attribute
			MsgBox(266256, "AutoTestManager - Error", "V1CITFDataRootDir path has not been set. ")
			#EndRegion --- CodeWizard generated code Start ---
			Return 10
		EndIf
		Local $sDataExt = IniRead($sIniFile, "SETTINGS", "V0FileExtention", "citf")
		$sDataDir = _os_PathNormalise($sDataDir)
		Local $sFilePattern = ''
		If StringLeft($sDataExt, 1) <> "." Then
			$sFilePattern = "*." & $sDataExt
		Else
			$sFilePattern = "*" & $sDataExt
		EndIf
		
		_GUICtrlStatusBar_SetText($GUI_stbStatusBar, "Searching for files")
		$sJobList = _ScanFor_JobsToDo($sDataDir, $sFilePattern)
		_GUICtrlStatusBar_SetText($GUI_stbStatusBar, "Loading database")

		$sSQL = "DROP TABLE IF EXISTS JOB_CONTROL"
		$iStatus = _SQLite_Exec($g_hDB, $sSQL)
		$sSQL = "CREATE TABLE IF NOT EXISTS JOB_CONTROL ( FILE TEXT UNIQUE, FILE_SIZE INTEGER, TILE TEXT, COMPUTER TEXT, START_TIME TEXT, END_TIME TEXT, TIME_TAKEN TEXT, SYNTAX_CITF TEXT, SYNTAX_NTF TEXT, Q1_CREATED TEXT, SYNTAX_Q1 TEXT, SYNTAX_Q2 TEXT, NO_FEATURES INTEGER, NO_DIFF INTEGER, RESULT TEXT, ERROR TEXT )"


;~ 		$sSQL = "CREATE TABLE IF NOT EXISTS JOB_CONTROL" & _
;~ 				" (" & _
;~ 				" FILE TEXT UNIQUE," & _
;~ 				" FILE_SIZE INTEGER," & _
;~ 				" TILE TEXT," & _
;~ 				" COMPUTER TEXT," & _
;~ 				" START_TIME TEXT," & _
;~ 				" END_TIME TEXT," & _
;~ 				" TIME_TAKEN TEXT," & _
;~ 				" SYNTAX_CITF TEXT," & _
;~ 				" SYNTAX_NTF TEXT," & _
;~ 				" Q1_CREATED TEXT," & _
;~ 				" SYNTAX_Q1 TEXT," & _
;~ 				" SYNTAX_Q2 TEXT," & _
;~ 				" NO_FEATURES INTEGER," & _
;~ 				" NO_DIFF INTEGER," & _
;~ 				" RESULT TEXT," & _
;~ 				" ERROR TEXT )"
		$iStatus = _SQLite_Exec($g_hDB, $sSQL)
		If $iStatus <> $SQLITE_OK Then
			Return SetError(@error, 0, 0)
		EndIf
		$sSQL = "BEGIN TRANSACTION"
		$iStatus = _SQLite_Exec($g_hDB, $sSQL)
		For $i = 1 To $sJobList[0]
			$sTile = _os_otu_GetTileRefFromFileName($sJobList[$i])
			$iFileSize = FileGetSize($sJobList[$i])
			$sSQL = "INSERT OR REPLACE INTO JOB_CONTROL (FILE,FILE_SIZE,TILE) VALUES('" & $sJobList[$i] & "','" & $iFileSize & "','" & $sTile & "')"
			$iStatus = _SQLite_Exec($g_hDB, $sSQL)
		Next
		$sSQL = "END TRANSACTION"
		$iStatus = _SQLite_Exec($g_hDB, $sSQL)
		$sSQL = "CREATE INDEX IF NOT EXISTS IDX_FILE_SIZE ON JOB_CONTROL ( FILE_SIZE DESC )"
		$iStatus = _SQLite_Exec($g_hDB, $sSQL)
		$sSQL = "CREATE INDEX IF NOT EXISTS IDX_COMPUTER ON JOB_CONTROL ( COMPUTER )"
		$iStatus = _SQLite_Exec($g_hDB, $sSQL)
		$sSQL = "CREATE INDEX IF NOT EXISTS IDX_END_TIME ON JOB_CONTROL ( END_TIME ASC )"
		$iStatus = _SQLite_Exec($g_hDB, $sSQL)
	Else
		$sSQL = "UPDATE JOB_CONTROL SET " & _
				" COMPUTER = NULL," & _
				" START_TIME = NULL," & _
				" END_TIME = NULL," & _
				" TIME_TAKEN = NULL," & _
				" SYNTAX_CITF = NULL," & _
				" SYNTAX_NTF = NULL," & _
				" Q1_CREATED = NULL," & _
				" SYNTAX_Q1 = NULL," & _
				" SYNTAX_Q2 = NULL," & _
				" NO_FEATURES = NULL," & _
				" NO_DIFF = NULL," & _
				" RESULT = NULL," & _
				" ERROR = NULL )" & _
				" WHERE COMPUTER NOT NULL AND END_TIME = NULL"
		$iStatus = _SQLite_Exec($g_hDB, $sSQL)
	EndIf

	$sSQL = "SELECT * FROM JOB_CONTROL ORDER BY FILE_SIZE DESC;"
	$iStatus = _SQLite_GetTable2d($g_hDB, $sSQL, $aResult, $iRows, $iColumns)
	If $iStatus = $SQLITE_OK Then
		$iStatus = 1
	EndIf
	_GUICtrlStatusBar_SetText($GUI_stbStatusBar, "Database ready")
	Return $iStatus
EndFunc   ;==>_Database_Initialise

Func _Database_Start()
	Local $iStatus = 1
	Local $sDatabase = $g_sJobControlFolder & "\AutoTestControl.db"
	
	_GUICtrlStatusBar_SetText($GUI_stbStatusBar, "Starting SQLite")
	
	_SQLite_Startup()
	If @error > 0 Then
		MsgBox(16, "SQLite Error", "SQLite.dll Can't be Loaded!")
		$iStatus = 0
	EndIf
	$g_hDB = _SQLite_Open($sDatabase)
	If @error > 0 Then
		MsgBox(16, "SQLite Error", "Can't Load Database!")
		$iStatus = 0
	EndIf
	Return $iStatus
EndFunc   ;==>_Database_Start

Func _Database_Stop()
	_SQLite_Close($g_hDB)
	_SQLite_Shutdown()
EndFunc   ;==>_Database_Stop

Func _Initialise()
	Local $aSettings[13][2]
	Local $sIniFile = ''
	Local $iStatus = 1

	_GUICtrlStatusBar_SetText($GUI_stbStatusBar, "Initialising")

	$g_sJobControlFolder = _os_PathNormalise($AT_ROOT_DIR) & GUICtrlRead($Gui_tab0_edtTestJob)
	$aSettings[0][0] = 12
	$aSettings[1][0] = "createPSEUDO"
	$aSettings[1][1] = "N"
	If BitAND(GUICtrlRead($Gui_tab0_chkCreatePhseudo), $GUI_CHECKED) Then $aSettings[1][1] = "Y"
	$aSettings[2][0] = "createSbz"
	$aSettings[2][1] = "N"
	If BitAND(GUICtrlRead($Gui_tab0_chkSaveSbz), $GUI_CHECKED) Then $aSettings[2][1] = "Y"
	$aSettings[3][0] = "parameterfile"
	$aSettings[3][1] = "C:\OsStrumap\CFG\PHOENIXCITF\phoenixCITF.prm"
	If GUICtrlRead($Gui_tab0_edtStrumapPrm) <> '' Then $aSettings[3][1] = GUICtrlRead($Gui_tab0_edtStrumapPrm)
	$aSettings[4][0] = "useGEOCOMP"
	$aSettings[4][1] = "Y"
	If BitAND(GUICtrlRead($Gui_tab0_chkUseGeoComp), $GUI_CHECKED) Then $aSettings[4][1] = "Y"
	$aSettings[5][0] = "useStrumapVersion"
	$aSettings[5][1] = "2.0.2977.0"
	If GUICtrlRead($Gui_tab0_cboStrumapVer) <> '' Then $aSettings[5][1] = GUICtrlRead($Gui_tab0_cboStrumapVer)
	$aSettings[6][0] = "V0FileExtention"
	$aSettings[6][1] = "citf"
	If GUICtrlRead($Gui_tab0_cboTopo96Ext) <> '' Then $aSettings[6][1] = GUICtrlRead($Gui_tab0_cboTopo96Ext)
	$aSettings[7][0] = "V1CITFDataRootDir"
	$aSettings[7][1] = ""
	If GUICtrlRead($Gui_tab0_edtDataRootV1) <> '' Then $aSettings[7][1] = GUICtrlRead($Gui_tab0_edtDataRootV1)
	$aSettings[8][0] = "V1FileExtention"
	$aSettings[8][1] = "q1"
	If GUICtrlRead($Gui_tab0_cboTopo93V1Ext) <> '' Then $aSettings[8][1] = GUICtrlRead($Gui_tab0_cboTopo93V1Ext)
	$aSettings[9][0] = "V1ResultsRootDir"
	$aSettings[9][1] = _os_FileGetFolder($aSettings[7][1]) & "\Result\V1"
	$aSettings[10][0] = "V2CITFDataRootDir"
	$aSettings[10][1] = ""
	If GUICtrlRead($Gui_tab0_edtDataRootV2) <> '' Then $aSettings[10][1] = GUICtrlRead($Gui_tab0_edtDataRootV2)
	$aSettings[11][0] = "V2FileExtention"
	$aSettings[11][1] = "q2"
	If GUICtrlRead($Gui_tab0_cboTopo93V2Ext) <> '' Then $aSettings[11][1] = GUICtrlRead($Gui_tab0_cboTopo93V2Ext)
	$aSettings[12][0] = "V2ResultsRootDir"
	$aSettings[12][1] = _os_FileGetFolder($aSettings[7][1]) & "\Result\V2"

	$sIniFile = $g_sJobControlFolder & "\config.ini"
	If Not DirCreate($g_sJobControlFolder) Then $iStatus = 0
	If Not DirCreate($g_sJobControlFolder & "\Computers") Then $iStatus = 0
	If Not DirCreate($g_sJobControlFolder & "\Logs") Then $iStatus = 0
	If Not DirCreate($aSettings[9][1]) Then $iStatus = 0
	If Not DirCreate($aSettings[12][1]) Then $iStatus = 0
	If Not IniWriteSection($sIniFile, "SETTINGS", $aSettings, 1) Then $iStatus = 0
	Return $iStatus
EndFunc   ;==>_Initialise

Func _PercentDone()
	Local $iRval, $aResult, $iRows, $iColumns
	Local $iToDo, $iDone
	Local $sSQLAll = "SELECT Count(*) FROM JOB_CONTROL"
	Local $sSQLDone = "SELECT Count(*) FROM JOB_CONTROL WHERE END_TIME NOT NULL"
	$iRval = _SQLite_GetTable2d($g_hDB, $sSQLAll, $aResult, $iRows, $iColumns)
	If $iRval <> $SQLITE_OK Then $iToDo = 0
	If $iRows Then
		$iToDo = $aResult[$iRows][$iColumns - 1]
	EndIf
	$iRval = _SQLite_GetTable2d($g_hDB, $sSQLDone, $aResult, $iRows, $iColumns)
	If $iRval <> $SQLITE_OK Then $iDone = 0
	If $iRows Then
		$iDone = $aResult[$iRows][$iColumns - 1]
	EndIf
	If $iToDo > 0 Then
		Return StringFormat("%0.2f%%", (($iDone / $iToDo) * 100))
	Else
		Return StringFormat("%0.2f%%", 100)
	EndIf
EndFunc   ;==>_PercentDone

Func _Process_ComputersOnline(ByRef $aComputers)
	Local $iItem = -1
	Local $hWnd = $Gui_tab0_hListView
	Local $sItemText = ''
	Local $fFound = False
	Local $iItemCount = 0
	For $iPC = 1 To $aComputers[0]
		$iItem = _GUICtrlListView_FindText($hWnd, $aComputers[$iPC], -1, False, True)
		ConsoleWrite('@@ Debug(' & @ScriptLineNumber & ') : $iItem = ' & $iItem & @CRLF & '>Error code: ' & @error & @CRLF) ;### Debug Console
		If $iItem < 0 Then
			$iItem = _GUICtrlListView_AddItem($hWnd, $aComputers[$iPC])
			_GUICtrlListView_AddSubItem($hWnd, $iItem, "", 1) ; Job / Tile
			_GUICtrlListView_AddSubItem($hWnd, $iItem, "Unknown", 2) ; Status
			_GUICtrlListView_AddSubItem($hWnd, $iItem, "00:00:00", 3) ; Elapsed Time
			_GUICtrlListView_AddSubItem($hWnd, $iItem, "00:00:00", 4) ; Elapsed Time
		EndIf
	Next
	
	$iItemCount = _GUICtrlListView_GetItemCount($hWnd)
	ConsoleWrite('@@ Debug(' & @ScriptLineNumber & ') : $iItemCount = ' & $iItemCount & @CRLF & '>Error code: ' & @error & @CRLF) ;### Debug Console
	$iItem = $iItemCount - 1
	ConsoleWrite('@@ Debug(' & @ScriptLineNumber & ') : $iItem = ' & $iItem & @CRLF & '>Error code: ' & @error & @CRLF) ;### Debug Console
	While $iItem >= 0
		$sItemText = _GUICtrlListView_GetItemText($hWnd, $iItem)
		ConsoleWrite('@@ Debug(' & @ScriptLineNumber & ') : $iItem = ' & $iItem & @CRLF & '>Error code: ' & @error & @CRLF) ;### Debug Console
		ConsoleWrite('@@ Debug(' & @ScriptLineNumber & ') : $sItemText = ' & $sItemText & @CRLF & '>Error code: ' & @error & @CRLF) ;### Debug Console
		$fFound = False
		For $i = 1 To $aComputers[0]
			If $sItemText = $aComputers[$i] Then
				ConsoleWrite('@@ Debug(' & @ScriptLineNumber & ') : $sItemText = ' & $sItemText & @CRLF & '>Error code: ' & @error & @CRLF) ;### Debug Console
				ConsoleWrite('@@ Debug(' & @ScriptLineNumber & ') : $aComputers[$i] = ' & $aComputers[$i] & @CRLF & '>Error code: ' & @error & @CRLF) ;### Debug Console
				$fFound = True
				ExitLoop
			EndIf
		Next
		If Not $fFound Then
			If _GUICtrlListView_DeleteItem($hWnd, $iItem) Then
				$iItem -= 1
			EndIf
		EndIf
		$iItem -= 1
	WEnd
	
EndFunc   ;==>_Process_ComputersOnline

Func _Process_ComputersOffline(ByRef $aComputers)
	Local $iItem = -1
	Local $hWnd = $Gui_tab0_hListView
;~ 	Local $sItemText = ''
;~ 	Local $fFound = False
	For $iPC = 1 To $aComputers[0]
		$iItem = _GUICtrlListView_FindText($hWnd, $aComputers[$iPC], -1, False, True)
		If $iItem >= 0 Then
			_GUICtrlListView_SetItem($hWnd, "", $iItem, 1); Job / Tile
			_GUICtrlListView_SetItem($hWnd, "Off Line", $iItem, 2) ; Status
			_GUICtrlListView_SetItem($hWnd, "00:00:00", $iItem, 3) ; Elapsed Time
			_GUICtrlListView_SetItem($hWnd, "00:00:00", $iItem, 3) ; Elapsed Time
		EndIf
	Next
EndFunc   ;==>_Process_ComputersOffline

Func _Process_JobRequests(ByRef $aComputers)
;~ 	Local $sJobFile = ''
;~ 	Local $aRow = 0
	Local $sSQL = "SELECT FILE, TILE, FILE_SIZE, START_TIME FROM JOB_CONTROL WHERE START_TIME IS NULL ORDER BY FILE_SIZE DESC LIMIT "
	Local $sSQL_REQ = ''
	Local $sSQL_CMD = ''
	Local $sFile = ''
	Local $hFile = 0
;~ 	Local $hQuery = 0
	Local $aResult, $iRows, $iColumns, $iRval
	Local $iItem = -1
	Local $hWnd = $Gui_tab0_hListView
;~ 	Local $sItemText = ''
;~ 	Local $fFound = False

	;Update Display
	For $iPC = 1 To $aComputers[0]
		$iItem = _GUICtrlListView_FindText($hWnd, $aComputers[$iPC], -1, False, True)
		If $iItem >= 0 Then
			_GUICtrlListView_SetItem($hWnd, "", $iItem, 1) ; tile
			_GUICtrlListView_SetItem($hWnd, "Job Requested", $iItem, 2) ; Status
			_GUICtrlListView_SetItem($hWnd, "00:00:00", $iItem, 3) ; Start Time
			_GUICtrlListView_SetItem($hWnd, "00:00:00", $iItem, 4) ; Elapsed Time
		EndIf
	Next

	$sSQL_REQ = $sSQL & $aComputers[0] + 10 & ";"
	$iRval = _SQLite_GetTable2d($g_hDB, $sSQL_REQ, $aResult, $iRows, $iColumns)
;~ 	_ArrayDisplay($aResult)
	For $i = 1 To $aComputers[0]
		If $iRval = $SQLITE_OK And IsArray($aResult) Then
			If $aResult[$i][1] <> '' Then
				$sFile = $g_sJobControlFolder & "\Computers\" & $aComputers[$i] & "\_NextJob.atj"
				$hFile = FileOpen($sFile, 2)
				FileWriteLine($hFile, $aResult[$i][0])
				FileWriteLine($hFile, $aResult[$i][1])
				FileClose($hFile)
				$sSQL_CMD = "UPDATE JOB_CONTROL SET COMPUTER =  '" & $aComputers[$i] & "',START_TIME = '" & _NowCalc() & "' WHERE TILE = '" & $aResult[$i][1] & "';"
				_SQLite_Exec($g_hDB, $sSQL_CMD)
				$sFile = $g_sJobControlFolder & "\Computers\" & $aComputers[$i] & "\_RequestJob.atj"
				FileDelete($sFile)
				$iItem = _GUICtrlListView_FindText($hWnd, $aComputers[$i], -1, False, True)
				If $iItem >= 0 Then
					_GUICtrlListView_SetItem($hWnd, $aResult[$i][1], $iItem, 1) ; tile
					_GUICtrlListView_SetItem($hWnd, "Job Allocated", $iItem, 2) ; Status
					_GUICtrlListView_SetItem($hWnd, _NowCalc(), $iItem, 3) ; Start Time
					_GUICtrlListView_SetItem($hWnd, "00:00:00", $iItem, 4) ; Elapsed Time
				EndIf
			Else
				$sFile = $g_sJobControlFolder & "\Computers\" & $aComputers[$i] & "\_NoMoreJobs.atj"
				_FileCreate($sFile)
				$sFile = $g_sJobControlFolder & "\Computers\" & $aComputers[$i] & "\_RequestJob.atj"
				FileDelete($sFile)
			EndIf
		Else ;No more jobs
			$sFile = $g_sJobControlFolder & "\Computers\" & $aComputers[$i] & "\_NoMoreJobs.atj"
			_FileCreate($sFile)
			$sFile = $g_sJobControlFolder & "\Computers\" & $aComputers[$i] & "\_RequestJob.atj"
			FileDelete($sFile)
		EndIf
	Next
EndFunc   ;==>_Process_JobRequests

Func _Process_JobsAborted(ByRef $aComputers)
	Local $iItem = -1
	Local $hWnd = $Gui_tab0_hListView
;~ 	Local $sItemText = ''
;~ 	Local $fFound = False
;~ 	Local $sFile = ''
	
	For $iPC = 1 To $aComputers[0]
		$iItem = _GUICtrlListView_FindText($hWnd, $aComputers[$iPC], -1, False, True)
		If $iItem >= 0 Then
			_GUICtrlListView_SetItem($hWnd, "Job Aborted", $iItem, 2) ; Status
			_GUICtrlListView_SetItem($hWnd, "00:00:00", $iItem, 3) ; Elapsed Time
			_GUICtrlListView_SetItem($hWnd, "00:00:00", $iItem, 4) ; Elapsed Time
		EndIf
	Next
EndFunc   ;==>_Process_JobsAborted

Func _Process_JobsCompleted(ByRef $aComputers)
	Local $iItem = -1
	Local $hWnd = $Gui_tab0_hListView
;~ 	Local $sItemText = ''
;~ 	Local $fFound = False
	Local $aResults
	Local $aParts
	Local $sSQL = "UPDATE JOB_CONTROL SET "
	Local $sWhere = ''
	Local $sDateTime = ''
	Local $sFile = ''
	Local $iStatus = 0

	For $iPC = 1 To $aComputers[0]
		$iItem = _GUICtrlListView_FindText($hWnd, $aComputers[$iPC], -1, False, True)
		If $iItem >= 0 Then
			$sDateTime = _GUICtrlListView_GetItemText($hWnd, $iItem, 4)
			_GUICtrlListView_SetItem($hWnd, "Completed", $iItem, 2) ; Status
			_GUICtrlListView_SetItem($hWnd, "00:00:00", $iItem, 3) ; Elapsed Time
			_GUICtrlListView_SetItem($hWnd, "00:00:00", $iItem, 4) ; Elapsed Time
		EndIf
		$sFile = $g_sJobControlFolder & "\Computers\" & $aComputers[$iPC] & "\_CompletedJob.atj"
		_FileReadToArray($sFile, $aResults)
		If IsArray($aResults) Then
			For $i = 1 To $aResults[0]
				$aParts = StringSplit($aResults[$i], "|")
				If IsArray($aParts) Then
					Switch $aParts[1]
						Case 'COMPUTER'
							If $sWhere = '' Then
								$sWhere = ' WHERE COMPUTER = "' & $aParts[2] & '"'
							Else
								$sWhere &= ' AND COMPUTER = "' & $aParts[2] & '"'
							EndIf
						Case 'TILE'
							If $sWhere = '' Then
								$sWhere = ' WHERE TILE = "' & $aParts[2] & '"'
							Else
								$sWhere &= ' AND TILE = "' & $aParts[2] & '"'
							EndIf
						Case 'SYNTAX_CITF'
							$sSQL &= 'SYNTAX_CITF = "' & $aParts[2] & '",'
						Case 'SYNTAX_NTF'
							$sSQL &= 'SYNTAX_NTF = "' & $aParts[2] & '",'
						Case 'Q1_CREATED'
							$sSQL &= 'Q1_CREATED = "' & $aParts[2] & '",'
						Case 'SYNTAX_Q1'
							$sSQL &= 'SYNTAX_Q1 = "' & $aParts[2] & '",'
						Case 'SYNTAX_Q2'
							$sSQL &= 'SYNTAX_Q2 = "' & $aParts[2] & '",'
						Case 'NO_FEATURES'
							$sSQL &= 'NO_FEATURES = ' & $aParts[2] & ','
						Case 'NO_DIFF'
							$sSQL &= 'NO_DIFF = ' & $aParts[2] & ','
						Case 'RESULT'
							$sSQL &= 'RESULT = "' & $aParts[2] & '",'
						Case 'MESSAGE'
							$sSQL &= 'ERROR = "' & $aParts[2] & '",'
					EndSwitch
				EndIf
			Next
			$sSQL &= ' END_TIME = "' & _NowCalc() & '",'
			$sSQL &= ' TIME_TAKEN = "' & $sDateTime & '"'
			$sSQL &= $sWhere
			$iStatus = _SQLite_Exec($g_hDB, $sSQL)
			If $iStatus Then
				; TODO:
			EndIf
			FileDelete($sFile)
		Else
;~ 			'MESSAGE = No Results were returned from test runner'
			FileDelete($sFile)
		EndIf
	Next
EndFunc   ;==>_Process_JobsCompleted

Func _Process_JobsRunning(ByRef $aComputers)
	Local $iItem = -1
	Local $hWnd = $Gui_tab0_hListView
;~ 	Local $sItemText = ''
;~ 	Local $fFound = False
	Local $sDateTime = ''
	
	For $iPC = 1 To $aComputers[0]
		$iItem = _GUICtrlListView_FindText($hWnd, $aComputers[$iPC], -1, False, True)
		If $iItem >= 0 Then
			_GUICtrlListView_SetItem($hWnd, "Job Running", $iItem, 2) ; Status
			$sDateTime = _GUICtrlListView_GetItemText($hWnd, $iItem, 3)
			_GUICtrlListView_SetItem($hWnd, _RuninngTime($sDateTime), $iItem, 4) ; Elapsed Time
		EndIf
	Next
EndFunc   ;==>_Process_JobsRunning

Func _Process_Results(ByRef $sJobFolder, ByRef $aComputers)
	;TODO:
	If IsArray($aComputers) Then
		Return ($sJobFolder <> '')
	Else
		Return -1
	EndIf
EndFunc   ;==>_Process_Results

Func _RuninngTime($sDateTime)
	Local $iSeconds
	Local $iH, $iM, $iS
	
	$iSeconds = _DateDiff("s", $sDateTime, _NowCalc())
	$iH = Int($iSeconds / 3600)
	$iSeconds -= ($iH * 3600)
	$iM = Int($iSeconds / 60)
	$iSeconds -= ($iM * 60)
	$iS = Int($iSeconds)
	Return StringFormat("%0i:%02i:%02i", $iH, $iM, $iS)
EndFunc   ;==>_RuninngTime

Func _ScanFor_ComputersOnline(ByRef $sJobFolder)
	Local $asFileList[1] = [0]
;~ 	Local $aComputer = ''
	Local $aTemp

	_GUICtrlStatusBar_SetText($GUI_stbStatusBar, "Cheking for PCs")
	
	$asFileList = _os_FoldersListInTree($sJobFolder & "\Computers", $asFileList, 0, "*")
	For $i = 1 To $asFileList[0]
		$aTemp = StringSplit($asFileList[$i], '\')
		If IsArray($aTemp) Then $asFileList[$i] = $aTemp[$aTemp[0]]
	Next
	Return $asFileList
EndFunc   ;==>_ScanFor_ComputersOnline

Func _ScanFor_ComputersOffline(ByRef $sJobFolder)
	Local $asFileList[1] = [0]
;~ 	Local $aComputer = ''
	Local $aTemp

	_GUICtrlStatusBar_SetText($GUI_stbStatusBar, "Cheking for PCs")

	$asFileList = _os_FilesListInTree($sJobFolder & "\Computers", $asFileList, 0, "_Offline.atj")
	For $i = 1 To $asFileList[0]
		$aTemp = StringSplit($asFileList[$i], '\')
		If IsArray($aTemp) Then $asFileList[$i] = $aTemp[$aTemp[0] - 1]
	Next
	Return $asFileList
EndFunc   ;==>_ScanFor_ComputersOffline

Func _ScanFor_JobRequests(ByRef $sJobFolder)
	Local $asFileList[1] = [0]
;~ 	Local $aComputer = ''
	Local $aTemp
	
	_GUICtrlStatusBar_SetText($GUI_stbStatusBar, "Cheking for Job Requests")

	$asFileList = _os_FilesListInTree($sJobFolder & "\Computers", $asFileList, 0, "_RequestJob.atj")
	For $i = 1 To $asFileList[0]
		$aTemp = StringSplit($asFileList[$i], '\')
		If IsArray($aTemp) Then $asFileList[$i] = $aTemp[$aTemp[0] - 1]
	Next
	Return $asFileList
EndFunc   ;==>_ScanFor_JobRequests

Func _ScanFor_JobsAborted(ByRef $sJobFolder)
	Local $asFileList[1] = [0]
;~ 	Local $aComputer = ''
	Local $aTemp
	
	_GUICtrlStatusBar_SetText($GUI_stbStatusBar, "Cheking for Aborted Jobs")
	
	$asFileList = _os_FilesListInTree($sJobFolder & "\Computers", $asFileList, 0, "_Aborted.atj")
	For $i = 1 To $asFileList[0]
		$aTemp = StringSplit($asFileList[$i], '\')
		If IsArray($aTemp) Then $asFileList[$i] = $aTemp[$aTemp[0] - 1]
	Next
	Return $asFileList
EndFunc   ;==>_ScanFor_JobsAborted

Func _ScanFor_JobsCompleted(ByRef $sJobFolder)
	Local $asFileList[1] = [0]
;~ 	Local $aComputer = ''
	Local $aTemp

	_GUICtrlStatusBar_SetText($GUI_stbStatusBar, "Cheking for Completed Jobs")
	
	$asFileList = _os_FilesListInTree($sJobFolder & "\Computers", $asFileList, 0, "_CompletedJob.atj")
;~ 	_ArrayDisplay($asFileList,"JobsCompleted")
	For $i = 1 To $asFileList[0]
		$aTemp = StringSplit($asFileList[$i], '\')
		If IsArray($aTemp) Then $asFileList[$i] = $aTemp[$aTemp[0] - 1]
	Next
	Return $asFileList
EndFunc   ;==>_ScanFor_JobsCompleted

Func _ScanFor_JobsRunning(ByRef $sJobFolder)
	Local $asFileList[1] = [0]
;~ 	Local $aComputer = ''
	Local $aTemp

	_GUICtrlStatusBar_SetText($GUI_stbStatusBar, "Cheking for Running Jobs")
	
	$asFileList = _os_FilesListInTree($sJobFolder & "\Computers", $asFileList, 0, "_RunningJob.atj")
	For $i = 1 To $asFileList[0]
		$aTemp = StringSplit($asFileList[$i], '\')
		If IsArray($aTemp) Then $asFileList[$i] = $aTemp[$aTemp[0] - 1]
	Next
	Return $asFileList
EndFunc   ;==>_ScanFor_JobsRunning

Func _ScanFor_JobsToDo($sJobFolder_In, $sFilePattern_In)
	Local $asFileList[1] = [0]

	$asFileList = _os_FilesListInTree($sJobFolder_In, $asFileList, 0, $sFilePattern_In)
	
	Return $asFileList
EndFunc   ;==>_ScanFor_JobsToDo

Func _Settings_Read()
	Local $sValue = ''
	GUICtrlSetData($Gui_tab0_edtTestJob, IniRead(@ScriptDir & "\" & $sTitle & ".ini", "LAST_JOB", "TestJob", ""))
	GUICtrlSetData($Gui_tab0_edtDataRootV1, IniRead(@ScriptDir & "\" & $sTitle & ".ini", "LAST_JOB", "DataRootV1", ""))
	GUICtrlSetData($Gui_tab0_edtDataRootV2, IniRead(@ScriptDir & "\" & $sTitle & ".ini", "LAST_JOB", "DataRootV2", ""))
	GUICtrlSetData($Gui_tab0_edtStrumapPrm, IniRead(@ScriptDir & "\" & $sTitle & ".ini", "LAST_JOB", "StrumapPrm", ""))
	$sValue = IniRead(@ScriptDir & "\" & $sTitle & ".ini", "LAST_JOB", "Topo96Ext", "")
	GUICtrlSetData($Gui_tab0_cboTopo96Ext, "citf|ctf", $sValue)
	$sValue = IniRead(@ScriptDir & "\" & $sTitle & ".ini", "LAST_JOB", "Topo93V1Ext", "")
	GUICtrlSetData($Gui_tab0_cboTopo93V1Ext, "q1|v1", $sValue)
	$sValue = IniRead(@ScriptDir & "\" & $sTitle & ".ini", "LAST_JOB", "Topo93V2Ext", "")
	GUICtrlSetData($Gui_tab0_cboTopo93V2Ext, "q2|v2", $sValue)
	$sValue = IniRead(@ScriptDir & "\" & $sTitle & ".ini", "LAST_JOB", "StrumapVer", "")
	GUICtrlSetData($Gui_tab0_cboStrumapVer, "2.0.2981.1", $sValue)
EndFunc   ;==>_Settings_Read

Func _Settings_Save()
	IniWrite(@ScriptDir & "\" & $sTitle & ".ini", "LAST_JOB", "TestJob", GUICtrlRead($Gui_tab0_edtTestJob))
	IniWrite(@ScriptDir & "\" & $sTitle & ".ini", "LAST_JOB", "DataRootV1", GUICtrlRead($Gui_tab0_edtDataRootV1))
	IniWrite(@ScriptDir & "\" & $sTitle & ".ini", "LAST_JOB", "DataRootV2", GUICtrlRead($Gui_tab0_edtDataRootV2))
	IniWrite(@ScriptDir & "\" & $sTitle & ".ini", "LAST_JOB", "StrumapPrm", GUICtrlRead($Gui_tab0_edtStrumapPrm))
	IniWrite(@ScriptDir & "\" & $sTitle & ".ini", "LAST_JOB", "Topo96Ext", GUICtrlRead($Gui_tab0_cboTopo96Ext))
	IniWrite(@ScriptDir & "\" & $sTitle & ".ini", "LAST_JOB", "Topo93V1Ext", GUICtrlRead($Gui_tab0_cboTopo93V1Ext))
	IniWrite(@ScriptDir & "\" & $sTitle & ".ini", "LAST_JOB", "Topo93V2Ext", GUICtrlRead($Gui_tab0_cboTopo93V2Ext))
	IniWrite(@ScriptDir & "\" & $sTitle & ".ini", "LAST_JOB", "StrumapVer", GUICtrlRead($Gui_tab0_cboStrumapVer))
EndFunc   ;==>_Settings_Save

Func _Status_Update($hWnd, ByRef $aComputers)
	If $hWnd > 0 Then Return 1
	If Not IsArray($aComputers) Then Return 1
EndFunc   ;==>_Status_Update