#include-once
#include <file.au3>
#include <array.au3>
#include <GuiStatusBar.au3>
Global $recursion = 0
;========================================================================================================
;
; Function Name:    _os_FilesListInFolder($path_In, $filePattern_In, $FileList_In )
; Description:      Generate a list of files that match the $filePattern supplied
; Parameter(s):
;     $path_In            The path to the folder to be searched
;     $filePattern_In     The file pattern to search for e.g "*.txt"
;     $FileList_In        Array containing the list of matching files. Files are appened to the array. It
;                         is up to the user to empty the array before calling this function if only files
;						  from a single folder are required
;                         $FileList_In[0] contains the number of files in array 1 to ...
; Requirement(s):   None.
; Return Value(s):  Array with files form folder appended.
; Author(s):        Roy Kirby
;
; Notes:            None.
;
;========================================================================================================
Func _os_FilesListInFolder($sPath_In, $sFilePattern_In, $asFileList_In)
	Local $sFilename
	Local $iSearch
	Local $sFile

	$sPath_In = _os_PathNormalise($sPath_In)
	$sFilename = $sPath_In & $sFilePattern_In
	$iSearch = FileFindFirstFile($sFilename)
	If $iSearch <> -1 Then
		While 1
			$sFile = FileFindNextFile($iSearch)
			If @error Then ExitLoop
			If $sFile <> "."  And $sFile <> ".."  Then
				_ArrayAdd($asFileList_In, $sPath_In & $sFile)
				$asFileList_In[ 0 ] += 1
			EndIf
		WEnd
	EndIf
	; Close the search handle
	FileClose($iSearch)

	Return ($asFileList_In)
EndFunc   ;==>_os_FilesListInFolder


;========================================================================================================
;
; Function Name:    _os_PathNormalise($Path_In)
; Description:      Add a backslash to the end of path if it does not already exist
; Parameter(s):
;     $Path_In   The path to be modified
;
; Requirement(s):   None.
; Return Value(s):  Path with '\' appended.
; Author(s):        Roy Kirby
;
; Notes:            None.
;
;========================================================================================================
Func _os_PathNormalise($Path_In)
	If StringRight($Path_In, 1) <> "\"  Then
		$Path_In = $Path_In & "\" 
	EndIf
	Return $Path_In
EndFunc   ;==>_os_PathNormalise


;========================================================================================================
;
; Function Name:   	_os_PathDeNormalise($Path_In)
; Description:      Removes any backslash from the end of path if it exists
; Parameter(s):
;     $Path_In   The path to be modified
;
; Requirement(s):   None.
; Return Value(s):  Path with '\' removed
; Author(s):        Roy Kirby
;
; Notes:            None.
;
;========================================================================================================
Func _os_PathDeNormalise($Path_In)
	If StringRight($Path_In, 1) = "\"  Then
		$Path_In = StringLeft($Path_In, StringLen($Path_In) - 1)
	EndIf
	Return $Path_In
	
EndFunc   ;==>_os_PathDeNormalise

Func _os_FilesListInTree($sPath_In, ByRef $asFileList_In, $StatusBarCtrlID_In = 0, $Pattern_In = "*.*", $bIsRegEx = False, $bIncludeHidden = True, $bIncludedSystem = True, $sExcludePattern = '')
	Local $sAttrib
	Local $sFilePattern
	Local $iSearch
	Local $sFile
	Local $aFolder_List[1]
	Local $iMaxFiles = UBound($asFileList_In) - 1

	If StringLeft($Pattern_In, 1) = "*"  Then $bIsRegEx = False
	;	$recursion += 1
	If Not IsArray($asFileList_In) Then
		Dim $asFileList_In[1]
		$asFileList_In[0] = 0
		$iMaxFiles = UBound($asFileList_In) - 1
	EndIf
	_ArrayAdd($aFolder_List, $sPath_In)
	$aFolder_List[0] = 1
	$aFolder_List = _os_FoldersListInTree($sPath_In, $aFolder_List, 0, "*", False, False, $sExcludePattern)
	For $iFolder = 1 To $aFolder_List[0]
		$sPath_In = _os_PathNormalise($aFolder_List[$iFolder])

		If $StatusBarCtrlID_In Then
			_GUICtrlStatusBar_SetText($StatusBarCtrlID_In, "Searching..." & StringRight($sPath_In, 15))
		EndIf
		
		If $bIsRegEx Then
			$sFilePattern = $sPath_In & "*.*" 
		Else
			$sFilePattern = $sPath_In & $Pattern_In
		EndIf
		$iSearch = FileFindFirstFile($sFilePattern)
		If $iSearch <> -1 Then
			While 1
				$sFile = FileFindNextFile($iSearch)
				If @error Then ExitLoop
				If $bIsRegEx Then
					If Not StringRegExp($sFile, $Pattern_In) Then ContinueLoop
				EndIf
				If $sFile <> "."  And $sFile <> ".."  Then
					$sAttrib = FileGetAttrib($sPath_In & $sFile)
					If Not StringInStr($sAttrib, "D") Then
						If $bIncludeHidden = False Then
							If StringInStr($sAttrib, "H") Then ContinueLoop
						EndIf
						If $bIncludedSystem = False Then
							If StringInStr($sAttrib, "S") Then ContinueLoop
						EndIf
						If $sExcludePattern <> '' Then
							If StringRegExp($sFile, $sExcludePattern) Then ContinueLoop
						EndIf
						$asFileList_In[ 0 ] += 1
						If $asFileList_In[ 0 ] > $iMaxFiles Then
							$iMaxFiles += 10000
							ReDim $asFileList_In[$iMaxFiles]
						EndIf
						$asFileList_In[$asFileList_In[0]] = $sPath_In & $sFile
					EndIf
				EndIf
			WEnd
		EndIf
		; Close the search handle
		FileClose($iSearch)
		If $StatusBarCtrlID_In <> 0 Then
		EndIf
	Next
	;	$recursion -= 1
	ReDim $asFileList_In[$asFileList_In[0] + 1]
	Return ($asFileList_In)
EndFunc   ;==>_os_FilesListInTree

Func _os_FoldersListInTree($sPath_In, ByRef $asFolderList_In, $StatusBarCtrlID = 0, $Pattern = "*.*", $bIncludeHidden = True, $bIncludedSystem = True, $sExcludePattern = '')
	Local $sAttrib
	Local $sFilePattern
	Local $iSearch
	Local $sFile
	Local $iMaxFolders = UBound($asFolderList_In) - 1
	ConsoleWrite('@@ Debug(' & @ScriptLineNumber & ') : $iMaxFolders = ' & $iMaxFolders & @crlf & '>Error code: ' & @error & @crlf) ;### Debug Console
	$recursion += 1
	ConsoleWrite('@@ Debug(' & @ScriptLineNumber & ') : $recursion = ' & $recursion & @crlf & '>Error code: ' & @error & @crlf) ;### Debug Console
	
	If Not IsArray($asFolderList_In) Then
		Dim $asFolderList_In[1]
		$asFolderList_In[0] = 1
		_ArrayAdd($asFolderList_In, $sPath_In)
		$iMaxFolders = UBound($asFolderList_In) - 1
		ConsoleWrite('@@ Debug(' & @ScriptLineNumber & ') : $iMaxFolders = ' & $iMaxFolders & @crlf & '>Error code: ' & @error & @crlf) ;### Debug Console
	EndIf
	
	If $StatusBarCtrlID Then
		_GUICtrlStatusBar_SetText($StatusBarCtrlID, "Searching..." & StringRight($sPath_In, 15))
	EndIf

	$sPath_In = _os_PathNormalise($sPath_In)
	$sFilePattern = $sPath_In & $Pattern
	$iSearch = FileFindFirstFile($sFilePattern)
	If $iSearch <> -1 Then
		While 1
			$sFile = FileFindNextFile($iSearch)
			If @error Then ExitLoop
			If $sFile <> "."  And $sFile <> ".."  Then
				$sAttrib = FileGetAttrib($sPath_In & $sFile)
				If StringInStr($sAttrib, "D") Then
					If $bIncludeHidden = False Then
						If StringInStr($sAttrib, "H") Then ContinueLoop
					EndIf
					If $bIncludedSystem = False Then
						If StringInStr($sAttrib, "S") Then ContinueLoop
					EndIf
					If $sExcludePattern <> '' Then
						If StringRegExp($sFile, $sExcludePattern) Then ContinueLoop
					EndIf
					$asFolderList_In[ 0 ] += 1
					ConsoleWrite('@@ Debug(' & @ScriptLineNumber & ') : $asFolderList_In[ 0 ] = ' & $asFolderList_In[ 0 ] & @crlf & '>Error code: ' & @error & @crlf) ;### Debug Console
					If $asFolderList_In[ 0 ] > $iMaxFolders Then
						$iMaxFolders += 10000
						ConsoleWrite('@@ Debug(' & @ScriptLineNumber & ') : $iMaxFolders = ' & $iMaxFolders & @crlf & '>Error code: ' & @error & @crlf) ;### Debug Console
						ReDim $asFolderList_In[$iMaxFolders]
	ConsoleWrite('@@ Debug(' & @ScriptLineNumber & ') : UBound($asFolderList_In) = ' & UBound($asFolderList_In) & @crlf & '>Error code: ' & @error & @crlf) ;### Debug Console
					EndIf
	ConsoleWrite('@@ Debug(' & @ScriptLineNumber & ') : $asFolderList_In[0] = ' & $asFolderList_In[0] & @crlf & '>Error code: ' & @error & @crlf) ;### Debug Console
	ConsoleWrite('@@ Debug(' & @ScriptLineNumber & ') : UBound($asFolderList_In) = ' & UBound($asFolderList_In) & @crlf & '>Error code: ' & @error & @crlf) ;### Debug Console
					$asFolderList_In[$asFolderList_In[0]] = $sPath_In & $sFile
;~ 					_ArrayAdd($asFolderList_In, $sPath_In & $sFile)
					_os_FoldersListInTree($sPath_In & $sFile, $asFolderList_In, $StatusBarCtrlID, $Pattern, $bIncludeHidden, $bIncludedSystem, $sExcludePattern)
				EndIf
			EndIf
		WEnd
	EndIf
	; Close the search handle
	FileClose($iSearch)
	$recursion -= 1
	ConsoleWrite('@@ Debug(' & @ScriptLineNumber & ') : $recursion = ' & $recursion & @crlf & '>Error code: ' & @error & @crlf) ;### Debug Console
	ConsoleWrite('@@ Debug(' & @ScriptLineNumber & ') : UBound($asFolderList_In) = ' & UBound($asFolderList_In) & @crlf & '>Error code: ' & @error & @crlf) ;### Debug Console
	If $recursion < 1 Then
		ReDim $asFolderList_In[$asFolderList_In[0] + 1]
	EndIf
	ConsoleWrite('@@ Debug(' & @ScriptLineNumber & ') : UBound($asFolderList_In) = ' & UBound($asFolderList_In) & @crlf & '>Error code: ' & @error & @crlf) ;### Debug Console
	Return ($asFolderList_In)
EndFunc   ;==>_os_FoldersListInTree


;========================================================================================================
;
; Function Name:   	_os_FileGetParentFolder($Path_In)
; Description:      Removes the last folder or filename from the path
;     $Path_In   The path to be modified
;
; Requirement(s):   None.
; Return Value(s):  Truncated path
; Author(s):        Roy Kirby
;
; Notes:            None.
;
;========================================================================================================
Func _os_FileGetParentFolder($sPath_In)
	Local $sDrive, $sDir, $sFName, $sExt
	Local $sFolder = ''

	_PathSplit($sPath_In, $sDrive, $sDir, $sFName, $sExt)
	$sFolder = _PathMake($sDrive, $sDir, '', '')
	$sFolder = StringLeft($sFolder, StringInStr($sFolder, '\', 1, -2))
	
	Return $sFolder
EndFunc   ;==>_os_FileGetParentFolder

;========================================================================================================
;
; Function Name:   	_os_FileGetFolder($Path_In)
; Description:      Removes the last folder or filename from the path
;     $Path_In   The path to be modified
;
; Requirement(s):   None.
; Return Value(s):  Truncated path
; Author(s):        Roy Kirby
;
; Notes:            None.
;
;========================================================================================================
Func _os_FileGetFolder($sPath_In)
	Local $sDrive, $sDir, $sFName, $sExt
	Local $sFolder = ''

	_PathSplit($sPath_In, $sDrive, $sDir, $sFName, $sExt)
	$sFolder = _PathMake($sDrive, $sDir, '', '')
	$sFolder = StringLeft($sFolder, StringInStr($sFolder, '\', 1, -1))
	
	Return $sFolder
EndFunc   ;==>_os_FileGetFolder

;========================================================================================================
;
; Function Name:   	_os_FileNameGetRoot($Path_In)
; Description:      Removes the extention and path from filename
; Parameter(s):
;     $Path_In   The filename to find the root of
;
; Requirement(s):   None.
; Return Value(s):  Root filename
; Author(s):        Roy Kirby
;
; Notes:            Example:
;					_os_FileNameGetRoot("C:\data\myfile.dat")
;					would return
;					"myfile"
;
;========================================================================================================
Func _os_FileNameGetRoot($sPath_In)
	Local $sDrive, $sDir, $sFName, $sExt
	;	Local $asPathParts = 0

	_PathSplit($sPath_In, $sDrive, $sDir, $sFName, $sExt)

	Return $sFName
EndFunc   ;==>_os_FileNameGetRoot



;========================================================================================================
;
; Function Name:   	_os_FileNameGetExt($Path_In)
; Description:      Returns the extention of the filename
; Parameter(s):
;     $Path_In   The filename to find the extention of
;
; Requirement(s):   None.
; Return Value(s):  Extention of filename
; Author(s):        Roy Kirby
;
; Notes:            Example:
;					_os_FileNameGetRoot("C:\data\myfile.dat")
;					would return
;					"dat"
;
;========================================================================================================
Func _os_FileNameGetExt($sPath_In)
	Local $sDrive, $sDir, $sFName, $sExt
	;	Local $asPathParts = 0

	_PathSplit($sPath_In, $sDrive, $sDir, $sFName, $sExt)

	Return $sExt
EndFunc   ;==>_os_FileNameGetExt

;========================================================================================================
;
; Function Name:   	_os_FileNameGet($Path_In)
; Description:      Returns the filename from the path
; Parameter(s):
;     $Path_In   The path including filename to extract filename from
;
; Requirement(s):   None.
; Return Value(s):  filename
; Author(s):        Roy Kirby
;
; Notes:            Example:
;					_os_FileNameGetRoot("C:\data\myfile.dat")
;					would return
;					"myfile.dat"
;
;========================================================================================================
Func _os_FileNameGet($sPath_In)
	Local $sDrive, $sDir, $sFName, $sExt
	;	Local $asPathParts = 0

	_PathSplit($sPath_In, $sDrive, $sDir, $sFName, $sExt)

	Return _PathMake('', '', $sFName, $sExt)
	;Return $sFName & "." & $sExt
EndFunc   ;==>_os_FileNameGet


;========================================================================================================
;
; Function Name:   	_os_FileNameChangeExt($Path_In, $sNewExt_In)
; Description:      changes the extention of the filename
; Parameter(s):
;     $Path_In   The filename to find the extention of
;     $sNewExt   The new file extention to replace the existing one
;
; Requirement(s):   None.
; Return Value(s):  Filename with new extention
; Author(s):        Roy Kirby
;
; Notes:            Example:
;					_os_FileNameGetRoot("C:\data\myfile.dat", "ini")
;					would return
;					"C:\data\myfile.ini"
;
;========================================================================================================
Func _os_FileNameChangeExt($sPath_In, $sNewExt_In)
	Local $sDrive, $sDir, $sFName, $sExt
	Local $sNewFilename = ''

	_PathSplit($sPath_In, $sDrive, $sDir, $sFName, $sExt)
	$sNewFilename = _PathMake($sDrive, $sDir, $sFName, $sNewExt_In)

	Return $sNewFilename
EndFunc   ;==>_os_FileNameChangeExt


Func _os_FileRegExpReplace($sFile_In, $sSearchPattern, $sRepaceWith)
	Local $sFileContents = FileRead($sFile_In)
	Local $sTemp = ''
	Local $hFile = 0
	$sTemp = StringRegExpReplace($sFileContents,$sSearchPattern,$sRepaceWith)
	$hFile = FileOpen($sFile_In,2)
	FileWrite($hFile,$sTemp)
	FileClose($hFile)
EndFunc