#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_icon=WhatIE.ico
#AutoIt3Wrapper_outfile=WhatIE.exe
#AutoIt3Wrapper_Compression=4
#AutoIt3Wrapper_Res_Fileversion=0.0.0.40
#AutoIt3Wrapper_Res_Fileversion_AutoIncrement=y
#AutoIt3Wrapper_Res_Language=1033
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****

Global Const $debug = False
Opt("MustDeclareVars", 1)
Opt("TrayAutoPause", 0)
Opt("TrayMenuMode", 0)
Opt("TrayIconHide", 0)

#include <OneInstance.au3>

_ConfigInitialize()

#include <GuiToolBar.au3>
Global $MaxWaitTime = 5 * 60 * 1000
Global $SleepTime = 500
Global $databasefile = "\\serverx\sharey\WhatIE.db"
_WaitForHibun()

#include <SQLite.au3>
#include <SQLite.dll.au3>

_WaitForDatabase()

Global $sSQliteDll = _SQLite_Startup()
Global $sSQLiteDB = _SQLite_Open($databasefile)

Global $iepath, $iever, $splitver, $major, $minor, $revision, $build, $sql, $err, $query
Global $attempt = 0

$iepath = RegRead("HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\IE Setup\Setup", "Path") & "\iexplore.exe"
$iepath = StringReplace($iepath, "%programfiles%", EnvGet("programfiles"))
$iever = FileGetVersion(FileGetLongName($iepath))
$splitver = StringSplit($iever, ".")
$major = "0"
$minor = "0"
$revision = "0"
$build = "0"
If $splitver[0] > 0 Then
	$major = $splitver[1]
	If $splitver[0] > 1 Then
		$minor = $splitver[2]
		If $splitver[0] > 2 Then
			$revision = $splitver[3]
			If $splitver[0] > 3 Then
				$build = $splitver[4]
			EndIf
		EndIf
	EndIf
EndIf
Do
	$attempt += 1
	If _DataExists(@ComputerName) Then
		$query = "UPDATE OR REPLACE iever SET "
		$query &= "path = '" & $iepath & "', "
		$query &= "major = '" & $major & "', "
		$query &= "minor = '" & $minor & "', "
		$query &= "revision = '" & $revision & "', "
		$query &= "build = '" & $build & "', "
		$query &= "WHERE (hostname='" & StringLower(@ComputerName) & "');"
	Else
		$query = "INSERT OR REPLACE INTO iever VALUES ("
		$query &= "'" & StringLower(@ComputerName) & "', "
		$query &= "'" & $iepath & "', "
		$query &= "'" & $major & "', "
		$query &= "'" & $minor & "', "
		$query &= "'" & $revision & "', "
		$query &= "'" & $build & "');"
	EndIf
	$sql = _SQLite_Exec($sSQLiteDB, $query)
	$err = @error
Until (Not $err) Or ($attempt = 3)
If $err Then MsgBox(48, @ScriptName, "Error writing to database:  " & $err & "[" & $sql & "]" & @CRLF & "Please report these numbers to the Help Desk", 5)
Exit

Func _DataExists($host)
	Local $h = StringLower($host)
	Local $res = _SQLite_Exec($sSQLiteDB, "SELECT * FROM iever WHERE hostname=" & $h)
	If $res = $SQLITE_OK Then
		Return True
	Else
		Return False
	EndIf
EndFunc   ;==>_DataExists

Func _WaitForHibun()
	Local $iSystray_IconText
	Local $doneloop = False
	Local $waittime = 0
	Local $HibunPath = RegRead("HKEY_LOCAL_MACHINE\SOFTWARE\HITACHI\HIBUN-AE\0801\PathName", "Path00")
	If Not StringRight($HibunPath, 1) = "\" Then $HibunPath &= "\"
	Do
		Sleep($SleepTime)
		$waittime += $SleepTime
		If $waittime > $MaxWaitTime Then $doneloop = True
		$iSystray_IconText = Get_Systray_IconText("HIBUN AE Server")
		If StringInStr($iSystray_IconText, "- Connected") > 0 Then $doneloop = True
	Until $doneloop
EndFunc   ;==>_WaitForHibun

Func _WaitForDatabase()
	Local $doneloop = False
	Local $waittime = 0
	Do
		Sleep($SleepTime)
		$waittime += $SleepTime
		If $waittime > $MaxWaitTime Then $doneloop = True
		If FileExists($databasefile) Then $doneloop = True
	Until $doneloop
	If Not FileExists($databasefile) Then
		MsgBox(48, "Prescript", "Unable to locate database" & @CRLF & "Please notify the Help Desk",5)
	EndIf
EndFunc   ;==>_WaitForDatabase

Func Get_Systray_IconText($sToolTipTitle)
	; Find systray handle
	Local $hSystray_Handle = ControlGetHandle('[Class:Shell_TrayWnd]', '', '[Class:ToolbarWindow32;Instance:1]')
	If @error Then
		Return ""
	EndIf
	; Get systray item count
	Local $iSystray_ButCount = _GUICtrlToolbar_ButtonCount($hSystray_Handle)
	If $iSystray_ButCount = 0 Then
		Return ""
	EndIf
	; Look for wanted tooltip
	Local $iSystray_ButtonNumber
	For $iSystray_ButtonNumber = 0 To $iSystray_ButCount - 1
		Local $sText = _GUICtrlToolbar_GetButtonText($hSystray_Handle, $iSystray_ButtonNumber)
		If StringInStr($sText, $sToolTipTitle) = 1 Then Return $sText
	Next
	Return SetError(1, 0, "")
EndFunc   ;==>Get_Systray_IconText

Func _ConfigInitialize()
	If @OSVersion = "WIN_2003" Then Exit
	OnAutoItExitRegister("_ConfigDestroy")

	Global $MyName = StringLeft(@ScriptFullPath, StringInStr(@ScriptFullPath, ".", 0, -1) - 1)
	$MyName = StringRight($MyName, StringLen($MyName) - StringInStr($MyName, "\", 0, -1))
EndFunc   ;==>_ConfigInitialize

Func _ConfigDestroy()
	_SQLite_Close()
	_SQLite_Shutdown()
EndFunc   ;==>_ConfigDestroy