#include <Misc.au3>
#include <GUIConstantsEx.au3>
#include <GuiListView.au3>
#include <WindowsConstants.au3>

Local $hGUI, $hLV, $iIndex
Local $fUnicode = False
If _Singleton("TestLV", 1) Then $fUnicode = True

If $fUnicode Then
 $hGUI = GUICreate("TestLV (Unicode)", 400, 400)
Else
 $hGUI = GUICreate("TestLV (ASCII)", 400, 400)
EndIf
$hLV = _GUICtrlListView_Create($hGUI, "Header 1|Header 2|Header 3", 10, 10, 380, 380)
_GUICtrlListView_SetExtendedListViewStyle($hLV, $LVS_EX_FULLROWSELECT)
_GUICtrlListView_SetUnicodeFormat($hLV, $fUnicode)

_GUICtrlListView_BeginUpdate($hLV)
 For $i = 0 To 9
  $iIndex = _GUICtrlListView_InsertItem($hLV, "Item " & $i*3+1)
  For $j = 1 To 2
   _GUICtrlListView_AddSubItem($hLV, $iIndex, "Item " & $i*3+$j+1, $j)
  Next
 Next
_GUICtrlListView_EndUpdate($hLV)
GUISetState()
GUIRegisterMsg($WM_NOTIFY, "WM_NOTIFY")

Do
Until GUIGetMsg() = $GUI_EVENT_CLOSE

_GUICtrlListView_Destroy($hLV)
GUIDelete()

Func WM_NOTIFY($hWnd, $iMsg, $iwParam, $ilParam)
  Local $hWndFrom, $iIDFrom, $iCode, $tNMHDR, $hWndListView
  Local $tInfo, $iIndex

  $tNMHDR = DllStructCreate($tagNMHDR, $ilParam)
  $hWndFrom = HWnd(DllStructGetData($tNMHDR, "hWndFrom"))
  $iIDFrom = DllStructGetData($tNMHDR, "IDFrom")
  $iCode = DllStructGetData($tNMHDR, "Code")
  Switch $hWndFrom
    Case $hLV
      Switch $iCode
        Case $NM_CLICK
            $tInfo = DllStructCreate($tagNMITEMACTIVATE, $ilParam)
		    $iIndex = DllStructGetData($tInfo, "Index")

            If $iIndex <> -1 Then _
              MsgBox(0x40, "Item Text", _GUICtrlListView_GetItemText($hLV, $iIndex))
        EndSwitch
    EndSwitch
    Return $GUI_RUNDEFMSG
EndFunc