#RequireAdmin
#include <GuiConstantsEx.au3>
#include <EventLog.au3>
#Include <Date.au3>
#Include <Array.au3>


;Requerido por el script de enviar email
#Include<file.au3>
Global $oMyRet[2]
Global $oMyError = ObjEvent("AutoIt.Error", "MyErrFunc")
;fin

global $ultima_comprobacion ;almacena fecha y hora del ultimo evento comprobado
Global $log ;listbox donde se va registrando la actividad del script
Global $contador = 0 ;cuando llega a 100 vacila el listbox log
Global $conf_servidor ;Almacena la direccion del servidor SMTP leida de config.ini
Global $conf_de_nombre ;Almacena el nombre del remitente leida de config.ini
Global $conf_de ;Almacena la direccion de correo de remitente leida de config.ini
Global $conf_para ;Almacena el destinatario de las alertas leida de config.ini
Global $conf_login ;Almacena el login para el servidor smtp leida de config.ini
Global $conf_pass ;Almacena la pass para el servidor smtp leida de config.ini
Global $conf_periodicidad;Almacena cada cuanto se debe leer el registro de Eventos
Global $error ;Error generado duranta la comprobacion con regexp en la carga de configuracion
Global $conf_seleccionados_origen[100] ;Almacena todos los origenes seleccionado
Global $conf_seleccionados_id[100]
Global $tipo_seleccion
Global $n_registro_ultimo_evento = "" ;almacena n registro del ultimo evento comprobado y se complementa con ultima_comprobacion para no comprobar 2 veces un evento

Func escribir_ultima($ultima) ;Escribe la fecha y hora de la ultima comprobacion realizada para la proxima vez que se arranque partir de ahi
	$file = FileOpen(@ScriptDir & "\ultima.ini", 2)
	FileWriteLine($file, "Ultima=" &$ultima)
	FileClose($file)
EndFunc

Func construir_arrays_errores($lista)
	$par_id_origen = StringSplit($lista, "|") ;la variable lista contiene todos las id y origenes leidos desde config.ini los cuales estas separados por "|"
	$tope = UBound($par_id_origen) - 1 ;Tamo array
	For $i = 1 to $tope
		$temp = StringSplit($par_id_origen[$i], ",") ;se divide por la coma cada par de la lista para separar en id y origen
		$conf_seleccionados_origen[$i] = $temp[1]
		$conf_seleccionados_id[$i] = $temp[2]
	Next
EndFunc
	

Func ler_configuracion();lee ultima.ini y config.ini
	$ok = True
	If (FileExists(@ScriptDir & "\ultima.ini")) Then ;Comprueba si se puede leer corretamente ultima.ini. en caso de error no se detendria el script se continuaria con al hora actual
		$file_conf = FileOpen(@ScriptDir & "\ultima.ini")
		$line = FileReadLine($file_conf)
		If (Not(StringRegExp($line, "^Ultima=20[0-9][0-9]/[0-1][0-9]/[0-3][0-9]\s[0-2][0-9]:[0-5][0-9]:[0-5][0-9]$", 0))) Then
			$ultima_comprobacion = _NowCalc()
			$ok = False
		Else
			$valor_leido = StringSplit($line, "=")
			$ultima_comprobacion = $valor_leido[2]
		EndIf
		FileClose($file_conf)
	Else 
		$ok = false
		$ultima_comprobacion = _NowCalc()
	EndIf
	
	If (Not($ok)) Then ;Si no existe ultima.ini o tiene una sintaxis incorrecta se ultiliza la hora actual advirtiendo de ello
		escribir_ultima($ultima_comprobacion)
		MsgBox(0, "Advertencia", "'Ultima.ini' no cumple '^Ultima=20[0-9][0-9]/[0-1][0-9]/[0-3][0-9]\s[0-2][0-9]:[0-5][0-9]:[0-5][0-9]$', se monitorizaran los registros desde ahora")
		$ok = True
	EndIf
	
	;Proceso de lectura de configuracion. Se va leyendo linea por linea config.ini para establecer los valores de config. el fichero debe estar en el orden de lectura ya que en caso contrario 
	;daria error la comprobacion mediante regexp. en ese momento finaliza el script devolviendo la advertencia encontrada
	$file_conf = FileOpen(@ScriptDir & "\config.ini")
	
	$error = "Servidor_SMTP=.*"
	$line = FileReadLine($file_conf)
	If (Not(StringRegExp($line, "^Servidor_SMTP=.*", 0))) Then return False	
	$valor_leido = StringSplit($line, "=")
	$conf_servidor = $valor_leido[2] ;en todos los casos el valor de la variable es el resultado de partir la linea y quedarse con la parte derecha excepto en los errores omitidos que requiere un analis mas profundo
	
	$error = "^Nombre_Remitente=.*"
	$line = FileReadLine($file_conf)
	If (Not(StringRegExp($line, "^Nombre_Remitente=.*", 0))) Then return False	
	$valor_leido = StringSplit($line, "=")
	$conf_de_nombre = $valor_leido[2]
	
	$error = "^Cuenta_Remitente=.*"
	$line = FileReadLine($file_conf)
	If (Not(StringRegExp($line, "^Cuenta_Remitente=.*", 0))) Then return False	
	$valor_leido = StringSplit($line, "=")
	$conf_de = $valor_leido[2]
	
	$error = "^Destinatario=.*"
	$line = FileReadLine($file_conf)
	If (Not(StringRegExp($line, "^Destinatario=.*", 0))) Then return False	
	$valor_leido = StringSplit($line, "=")
	$conf_para = $valor_leido[2]
	
	$error = "^Login=.*"
	$line = FileReadLine($file_conf)
	If (Not(StringRegExp($line, "^Login=.*", 0))) Then return False	
	$valor_leido = StringSplit($line, "=")
	$conf_login = $valor_leido[2]
	
	$error = "^Password=.*"
	$line = FileReadLine($file_conf)
	If (Not(StringRegExp($line, "^Password=.*", 0))) Then return False	
	$valor_leido = StringSplit($line, "=")
	$conf_pass = $valor_leido[2]
	
	$error = "^Tipo_seleccion=(omitir|solo)$"
	$line = FileReadLine($file_conf)
	If (Not(StringRegExp($line, "^Tipo_seleccion=(omitir|solo)$", 0))) Then return False
	$valor_leido = StringSplit($line, "=")
	$tipo_seleccion = $valor_leido[2]
	
	$error = "^Errores_seleccionados=.*"
	$line = FileReadLine($file_conf)
	If (Not(StringRegExp($line, "^Errores_seleccionados=.*", 0))) Then return False
	$valor_leido = StringSplit($line, "=")
	construir_arrays_errores($valor_leido[2]) ;se encarga de generar los array necesrio para la consulta de errores omitidos
	
	$error = "^Periodo=.*"
	$line = FileReadLine($file_conf)
	If (Not(StringRegExp($line, "^Periodo=.*", 0))) Then return False	
	$valor_leido = StringSplit($line, "=")
	$conf_periodicidad = $valor_leido[2]
	
	;MsgBox(0, "", $valor_leido[2])
	FileClose($file_conf)
	return($ok)
EndFunc

Func notificar($evento, $hora)
	$asunto = $evento[8] & "de " & $evento[10] & " en " & @ComputerName
	$mensaje = "Hora: " & _DateTimeFormat($hora, 0) & @LF
	$mensaje &= "Tipo: " & $evento[8] & @LF
	$mensaje &= "Id  : " & $evento[6] & @LF 
	$mensaje &= "Orig: " & $evento[10] & @LF 
	$mensaje &= "Desc: " & $evento[13] & @LF 	
	enviar_eMail($conf_servidor, $conf_de_nombre, $conf_de, $conf_para, $asunto, $mensaje, $conf_login, $conf_pass)
	MsgBox(0, "" , $asunto & @LF & $evento[13])
EndFunc

Func debese_notificar($evento)
	Return True
EndFunc

Func tipo_evento($tipo,  $hora_evento, $evento) ;En Funcion del evento recogido actuareos de una forma u otra. esta funcion es la encargada de decidir que hacer
	$valor = ""
	$nada_grave = True ;si durante un periodo de comprobacion no hay nada grave en el listbox de log se muestra que no pasado nada, con esta variable se controla que no haya errores
	Switch $tipo
		Case 1
			$valor = "Error"
			$nada_grave = False
			GUICtrlSetData($log, _Now() & "--> " & $hora_evento & " " & $valor & ": " & $evento[10] & " " & $evento[13]  & "; ")
			If (debese_notificar($evento)) Then notificar($evento, $hora_evento)
		Case 2
			$valor = "Advertencia"
		Case 4
			$valor = "Informacion"
			If (debese_notificar($evento)) Then notificar($evento, $hora_evento)
		Case 8
			$valor = "Auditoria Exitosa"
		Case 16
			$valor = "Fallo Auditoria"
		case Else
			$valor = $tipo & "otro"
			$nada_grave = False
			GUICtrlSetData($log, _Now() & "--> " & $hora_evento & " " & $valor & ": " & $evento[10] & " " & $evento[13]  & "; ")
	EndSwitch
	GUICtrlSetData($log, _Now() & "--> " & $hora_evento & " " & $valor & "; ")
	Return $nada_grave
EndFunc

Func convertir_en_dateTime($fecha, $time) ;al hacer la consulta de la hora del evento la devuelve como am pm por ello hay que conver el formato para poder comparar con _NowCalc()
	$date = ""
	$hora = StringMid($time, 1,2)
	$minuto_segundo = StringMid($time, 4,5)
	$am_pm = StringMid($time, 10,2)
	$dia = StringMid($fecha, 4,2)
	$mes = StringMid($fecha, 1,2)
	$ano = StringMid($fecha, 7,4)
	if ($am_pm == "PM") Then
		$hora = $hora + 12
	EndIf
	$date = $ano & "/" & $mes & "/" & $dia & " " & $hora & ":" & $minuto_segundo
	Return $date
EndFunc

Func ler_registros() ;funcion que se encarga de leer en el visor de sucesos los eventos del periodo indicado
	
	$continuar = True ;conrtrola cuando tiene que parar de leer registros
	$hEventLog = _EventLog__Open("", "System")
	$nada_grave = True ;controla si no ha habido errores en el periodo comprobado
	$contador += 1 ;contador que controla cuando se vacia listbox Log
	$ultima_comprobacion_temp = ""
	if ($contador == 100) Then
		$contador = 0
		GUICtrlSetData($log, "")
	EndIf
	GUICtrlSetData($log, _Now() & "--> " & " Compbrobando...")
	
	$aEvent = _EventLog__Read($hEventLog, True, False) ;lee los suecesos. el true hace que la siguiente lectura sea el suceso posterior al leido (hace que sea secuencial) el false indica orden mas reciente al mas antiguo por el 
	$hora_evento = convertir_en_dateTime($aEvent[2], $aEvent[3])
	$ultima_comprobacion_temp =	$hora_evento ;almacena la fecha del ultimo evento en el viso de sucesos que pasara posteriormente a ser el valor de ultima_comprobacion
	$n_registro_ultimo_evento_temp = $aEvent[1] ;se utiliza para cercionarse que un evento no ha sido visto ya complementando con ultima_comprobacion
	While ($continuar) ;proceso de lectura de registro. puede terminar por que no hay mas registros que leer o porque los siguiente corresponden a un periodo anterior al que se esta leyendo(ultima_comprobacion)

		;MsgBox(0, "", $hora_evento & " " & $ultima_comprobacion & (_DateDiff( 's',$hora_evento, $ultima_comprobacion)))
		If ($aEvent[0]) Then ;$aEvent[0]== false es que no hay mas registros para leer
			If (_DateDiff( 's',$hora_evento, $ultima_comprobacion) > 0 Or $aEvent[1] == $n_registro_ultimo_evento) Then 
				;Si la diferencia de tiempo del evento comprobado con respecto a la ultima comprobacion es mayor de $periodicidad_segs(indicado en config.ini)
				;quiere decir que ese evento esta leido
				$ultima_comprobacion = $ultima_comprobacion_temp
				$n_registro_ultimo_evento = $n_registro_ultimo_evento_temp
				escribir_ultima($ultima_comprobacion)
				$continuar = False
			Else ;Son los errores sin comprobar
				If ($nada_grave) Then ;mientras que no haya ningun error nada grave actauliza su valor, una vez que haya un error deja de cambiar para asi no mostrar en el listbox log la notificacion de que no paso nada
				$nada_grave = tipo_evento($aEvent[7],  $hora_evento, $aEvent);comprobamos que tipo de evento es para realizar una u otra accion
				Else
					tipo_evento($aEvent[7],  $hora_evento, $aEvent)
				EndIf
				$aEvent = _EventLog__Read($hEventLog, True, False);la primera lectura se hace fuera del bucle para almenar los datos de ultimo evento en la lista ya que si se hicera en el bucle se machacaria
				$hora_evento = convertir_en_dateTime($aEvent[2], $aEvent[3])
			EndIf
		Else
			$continuar = False
		EndIf
	WEnd
	If ($nada_grave) Then 
		GUICtrlSetData($log, _Now() & "--> " & "Ningun Error en los ultimos Eventos")
	EndIf
	GUICtrlSetData($log, _Now() & "--> " & "Siguiente comprobacion en " & ($conf_periodicidad / 60) & " minuto(s)")
	_EventLog__Close($hEventLog)

EndFunc

Func enviar_eMail($servidor, $de_nombre, $de, $para, $asunto, $mensaje, $login, $pass)
	;MsgBox(0, "", $servidor & $de_nombre & $de & $para & $asunto & $mensaje & $login & $pass) 
	;##################################
	; Variables
	;##################################
	$SmtpServer = $servidor             ; address for the smtp-server to use - REQUIRED
	$FromName = $de_nombre                      ; name from who the email was sent
	$FromAddress = $de ; address from where the mail should come
	$ToAddress = $para   ; destination address of the email - REQUIRED
	$Subject =$asunto                  ; subject from the email - can be anything you want it to be
	$Body = $mensaje                              ; the messagebody from the mail - can be left blank but then you get a blank mail
	$AttachFiles = ""                       ; the file(s) you want to attach seperated with a ; (Semicolon) - leave blank if not needed
	$CcAddress = ""       ; address for cc - leave blank if not needed
	$BccAddress = ""     ; address for bcc - leave blank if not needed
	$Importance = "Normal"                  ; Send message priority: "High", "Normal", "Low"
	$Username = $login                    ; username for the account used from where the mail gets sent - REQUIRED
	$Password = $pass                 ; password for the account used from where the mail gets sent - REQUIRED
	$IPPort = 25                            ; port used for sending the mail
	$ssl = 0                                ; enables/disables secure socket layer sending - put to 1 if using httpS
	;~ $IPPort=465                          ; GMAIL port used for sending the mail
	;~ $ssl=1                               ; GMAILenables/disables secure socket layer sending - put to 1 if using httpS

	;##################################
	; Script
	;##################################
	
	$rc = _INetSmtpMailCom($SmtpServer, $FromName, $FromAddress, $ToAddress, $Subject, $Body, $AttachFiles, $CcAddress, $BccAddress, $Importance, $Username, $Password, $IPPort, $ssl)
	If @error Then
		MsgBox(0, "Error sending message", "Error code:" & @error & "  Description:" & $rc)
	EndIf
	;
EndFunc

; The UDF
Func _INetSmtpMailCom($s_SmtpServer, $s_FromName, $s_FromAddress, $s_ToAddress, $s_Subject = "", $as_Body = "", $s_AttachFiles = "", $s_CcAddress = "", $s_BccAddress = "", $s_Importance="Normal", $s_Username = "", $s_Password = "", $IPPort = 25, $ssl = 0)
	Local $objEmail = ObjCreate("CDO.Message")
    $objEmail.From = '"' & $s_FromName & '" <' & $s_FromAddress & '>'
    $objEmail.To = $s_ToAddress
    Local $i_Error = 0
    Local $i_Error_desciption = ""
    If $s_CcAddress <> "" Then $objEmail.Cc = $s_CcAddress
    If $s_BccAddress <> "" Then $objEmail.Bcc = $s_BccAddress
    $objEmail.Subject = $s_Subject
    If StringInStr($as_Body, "<") And StringInStr($as_Body, ">") Then
        $objEmail.HTMLBody = $as_Body
    Else
        $objEmail.Textbody = $as_Body & @CRLF
    EndIf
    If $s_AttachFiles <> "" Then
        Local $S_Files2Attach = StringSplit($s_AttachFiles, ";")
        For $x = 1 To $S_Files2Attach[0]
            $S_Files2Attach[$x] = _PathFull($S_Files2Attach[$x])
;~          ConsoleWrite('@@ Debug : $S_Files2Attach[$x] = ' & $S_Files2Attach[$x] & @LF & '>Error code: ' & @error & @LF) ;### Debug Console
            If FileExists($S_Files2Attach[$x]) Then
                ConsoleWrite('+> File attachment added: ' & $S_Files2Attach[$x] & @LF)
                $objEmail.AddAttachment($S_Files2Attach[$x])
            Else
                ConsoleWrite('!> File not found to attach: ' & $S_Files2Attach[$x] & @LF)
                SetError(1)
                Return 0
            EndIf
        Next
    EndIf
    $objEmail.Configuration.Fields.Item ("http://schemas.microsoft.com/cdo/configuration/sendusing") = 2
    $objEmail.Configuration.Fields.Item ("http://schemas.microsoft.com/cdo/configuration/smtpserver") = $s_SmtpServer
    If Number($IPPort) = 0 then $IPPort = 25
    $objEmail.Configuration.Fields.Item ("http://schemas.microsoft.com/cdo/configuration/smtpserverport") = $IPPort
    ;Authenticated SMTP
    If $s_Username <> "" Then
        $objEmail.Configuration.Fields.Item ("http://schemas.microsoft.com/cdo/configuration/smtpauthenticate") = 1
        $objEmail.Configuration.Fields.Item ("http://schemas.microsoft.com/cdo/configuration/sendusername") = $s_Username
        $objEmail.Configuration.Fields.Item ("http://schemas.microsoft.com/cdo/configuration/sendpassword") = $s_Password
    EndIf
    If $ssl Then
        $objEmail.Configuration.Fields.Item ("http://schemas.microsoft.com/cdo/configuration/smtpusessl") = True
    EndIf
    ;Update settings
    $objEmail.Configuration.Fields.Update
    ; Set Email Importance
    Switch $s_Importance
        Case "High"
            $objEmail.Fields.Item ("urn:schemas:mailheader:Importance") = "High"
        Case "Normal"
            $objEmail.Fields.Item ("urn:schemas:mailheader:Importance") = "Normal"
        Case "Low"
            $objEmail.Fields.Item ("urn:schemas:mailheader:Importance") = "Low"
    EndSwitch
    $objEmail.Fields.Update
    ; Sent the Message
    $objEmail.Send
    If @error Then
        SetError(2)
        Return $oMyRet[1]
    EndIf
    $objEmail=""
EndFunc   ;==>_INetSmtpMailCom
;
;
; Com Error Handler
Func MyErrFunc()
    $HexNumber = Hex($oMyError.number, 8)
    $oMyRet[0] = $HexNumber
    $oMyRet[1] = StringStripWS($oMyError.description, 3)
    ConsoleWrite("### COM Error !  Number: " & $HexNumber & "   ScriptLine: " & $oMyError.scriptline & "   Description:" & $oMyRet[1] & @LF)
    SetError(1); something to check for when this function returns
    Return
EndFunc   ;==>MyErrFunc

Func principal()
	Local $msg
	GUICreate("My GUI", 720, 300) ; will create a dialog box that when displayed is centered
	$log = GUICtrlCreateList("", 10, 50, 700, 190)
	GUICtrlCreateLabel("Log Monitoreo Eventos de Sistema", 160, 5, 600, 30)
	GUICtrlSetFont(-1, 20)
	GUISetState(@SW_SHOW) ; will display an empty dialog box

	$periodicidad_Msegs = $conf_periodicidad * 1000
	ler_registros()
	$h_inicial = TimerInit()
	While 1
		$msg = GUIGetMsg()
		If(TimerDiff($h_inicial) >= $periodicidad_Msegs) Then
			ler_registros()
			$h_inicial = TimerInit()
		EndIf
		If $msg = $GUI_EVENT_CLOSE Then ExitLoop
	WEnd
	GUIDelete()
EndFunc

If (ler_configuracion()) Then
	principal()
Else
	MsgBox(0, "Error", "Error de configuracion en  config.ini no coincide " & $error)
EndIf

