; 'Help' layout
Global $gui_width = 700
Global $gui_height = 500
Global $gui_topmargin = 5
Global $gui_sidemargin = 10
Global $gui_bottommargin = 55
Global $gui_okbuttonwidth = 100
Global $gui_okbuttonheight = 30
Global $gui_winbkcolor = 0xFFFFD8

#include <GUIConstantsEx.au3>
#include <EditConstants.au3>
#include <WindowsConstants.au3>
#include <StaticConstants.au3>
#Include <Array.au3>
#Include <String.au3>
#Include <GuiRichEdit.au3>
OnAutoItExitRegister("CleanExit")

Global $gui_winhandle = -1

$text =_StringRepeat("ABCDEFG abcdefg ",500)

$text = "{\rtf1\ansi\deff0 {\colortbl;\red0\green0\blue0;\red255\green0\blue0;}This line is the default color\line\cf2\tab This line is red and has a tab before it\line\cf1\page This line is the default color and the first line on page 2}"

; create GUI styles
$winstyle = $WS_CAPTION + $WS_SIZEBOX + $WS_MAXIMIZEBOX
$ctrlstyle = $ES_AUTOVSCROLL + $WS_VSCROLL + $ES_MULTILINE + $ES_READONLY

; create GUI window
$gui_win = GUICreate("Classic Quick Launch:  Help", $gui_width, $gui_height, -1, -1, $winstyle)
GUISetBkColor($gui_winbkcolor)
; "help" textbox, focus it, go to top (ctrl-home)
$gui_textbox = _GUICtrlRichEdit_Create($gui_win, $text, $gui_sidemargin, $gui_topmargin, $gui_width - 2 * $gui_sidemargin, $gui_height - $gui_topmargin - $gui_bottommargin, $ctrlstyle)

; --------------- Adding the line below crashes AutoIt. Commenting it out doesn't ----------
_GUICtrlRichEdit_StreamFromFile($gui_textbox, "C:\Users\Temp user\Desktop\QL RC 1.02\Help-en.rtf")

GUICtrlSetState($gui_textbox, $GUI_FOCUS)
Send("^{HOME}")
; version/build label
GUICtrlCreateLabel("Build:   1234.5", $gui_sidemargin + 8, $gui_height - 20, ($gui_width - $gui_okbuttonwidth)/2 - 60)
GUICtrlSetColor(-1, 0xff0000)
; "ok" button
$gui_okbutton = GUICtrlCreateButton("OK", ($gui_width - $gui_okbuttonwidth)/2, $gui_height - ($gui_topmargin + $gui_bottommargin)/2 - $gui_okbuttonheight/2, $gui_okbuttonwidth, $gui_okbuttonheight)

; display it and loop while checking GUI signals
; Written this way to allow other buttons in future
GUISetState(@SW_SHOW, $gui_win)
While 1
	$msg = GUIGetMsg()
	Select
		Case $msg = $gui_okbutton Or $msg = $GUI_EVENT_CLOSE
			ExitLoop
	EndSelect
	Sleep(10)
WEnd

; close and leave help
GUIDelete()



Exit


Func CleanExit()
	; Re-enable input first whatever the reason
	BlockInput(0)
	; Destroy any rich text GUI used for HELP/INFO, if it exists - this is important (Help:_GUICtrlRichEdit_Destroy)
	If WinExists($gui_winhandle) Then _GUICtrlRichEdit_Destroy($gui_winhandle)
	; And exit
	Exit
EndFunc
