Func _StringInsert($s_String, $s_InsertString, $i_Position)
	Local $i_Length

	If ($s_String = "") Or (Not IsString($s_String)) Then
		Return SetError(1, 0, $s_String) ; Source string empty / not a string
	ElseIf ($s_InsertString = "") Or (Not IsString($s_InsertString)) Then
		Return SetError(2, 0, $s_String) ; Insert string empty / not a string
	Else
		$i_Length = StringLen($s_String) ; Take a note of the length of the source string
		If (Abs($i_Position) > $i_Length) Or (Not IsInt($i_Position)) Then
			Return SetError(3, 0, $s_String) ; Invalid position
		EndIf
	EndIf

	; @CHANGED START : 2012-04-04 aMarCruz
	; Test <0 here to catch pos 0 with negative offset (ex. if $i_Length=5 and $i_Position=-5)
	If $i_Position < 0 Then
		$i_Position = $i_Length + $i_Position
	EndIf

	; If $i_Position at start of string
	If $i_Position = 0 Then
		Return $s_InsertString & $s_String ; Just add them up :) Easy :)
	EndIf
	Return StringLeft($s_String, $i_Position) & $s_InsertString & StringRight($s_String, $i_Length - $i_Position)
	; @CHANGED END


EndFunc   ;==>_StringInsert
