$String = "'she's all 'that' I,wAnt(" & '1st "disk" of 2)'
ConsoleWrite('@@ Debug(' & @ScriptLineNumber & ') : _StringTitleCase($String) = ' & _StringTitleCase($String) & @crlf & '>Error code: ' & @error & @crlf) ;### Debug Console

; #FUNCTION# ====================================================================================================================
; Name...........: _StringTitleCase
; Description ...: Changes a string to title case
; Syntax.........: _StringTitleCase($s_String)
; Parameters ....: $s_String - Input string
; Return values .: Success - Returns titlecased string.
;                  Failure - Returns "".
; Author ........: Jos van der Zande <jdeb at autoitscript dot com>
; Modified.......: BrewManNH
; Remarks .......: This function will capitalize the first character of every word. Modified _StringProper to a titlecase
;                  function instead of a Proper function. Not Unicode compatible.
; Related .......: _StringProper
; Link ..........:
; Example .......: Yes
; ===============================================================================================================================
Func _StringTitleCase($s_String) ; modified _StringProper function, correctly capitalizes after ' and numbers
	Local $iX = 0
	Local $CapNext = 1
	Local $s_nStr = ""
	Local $s_CurChar
	For $iX = 1 To StringLen($s_String)
		$s_CurChar = StringMid($s_String, $iX, 1)
		Select
			Case $CapNext = 1
				If StringRegExp($s_CurChar, "[a-zA-Z\xC0-\xFF0-9]") Then
					$s_CurChar = StringUpper($s_CurChar)
					$CapNext = 0
				EndIf
			Case Not StringRegExp($s_CurChar, "[a-zA-Z\xC0-\xFF'0-9]")
				$CapNext = 1
			Case Else
				$s_CurChar = StringLower($s_CurChar)
		EndSelect
		$s_nStr &= $s_CurChar
	Next
	Return $s_nStr
EndFunc   ;==>_TitleCaseString
