#include <Date.au3>
#include <Array.au3>

Opt("MustDeclareVars", 1)

; --- MainVar-Deklaration ---
#region MainVar-Deklaration
; Fr SSDPdiscover
Global $MyCollectedResponses ; Array with the collected Responses
Global $MyTimeToSearch = 15 * 1000 ; time to search in ticks
Global $MySendInterval = 3 * 1000; each x ticks the ssdp-discover will be sent
Global $MyResultDatei = ".\ssdp-discover-result.txt"
Global $MyTemp, $MyError, $MyReturn
#endregion MainVar-Deklaration


; --- Main ---
#region Main
; -- SSDP Discxover via UPnP --
$MyReturn = SSDPdiscover_V1($MyCollectedResponses, $MyTimeToSearch, $MySendInterval)
$MyError = @error
If $MyError <> 0 Then
	$MyTemp = "SSDPdiscover failed!" & @CRLF & @CRLF
	Switch $MyError
		Case 0
			; nix
		Case 1
			$MyTemp &= "UDPOpen-error"
		Case 2
			$MyTemp &= "UDPSend-error"
		Case 3
			$MyTemp &= "UDPRecv-error"
		Case 4
			$MyTemp &= "UDPBind-error"
	EndSwitch
	MsgBox(0, "error:", $MyTemp)
	Exit
EndIf

If IsArray($MyCollectedResponses) Then
	_ArrayDisplay($MyCollectedResponses)
Else
	MsgBox(0, "error", "no responses")
EndIf

Exit
#endregion Main



; --- Funktionsdefinitionen ---
#region Funktionsdefinitionen
; Function that performs a UPnP ssdp-discover and writes the results into an array.
; In addition, the IP addresses of the devices are written in a second array.
; V1: Receive-Socket = Send-Socket. Works on XP (independed how many networkcards are installed) and Win 7 only, when all network cards, exclude 1, are disabled in the device manager
; Error:
;   0  =  no Error
;   1  =  UDPOpen-error
;   2  =  UDPSend-error
;   3  =  UDPRecv-error
;   4  =  UDPBind-error
Func SSDPdiscover_V1(ByRef $ResponsesArray, $TicksToSearch = 10000, $SendIntervalInTicks = 1000)

	; --- UPnP-Kommando ---
	Local Const $UPnPcmd = _
			'M-SEARCH * HTTP/1.1' & @CRLF & _
			'ST:upnp:rootdevice' & @CRLF & _
			'MX: 10' & @CRLF & _
			'MAN: "ssdp:discover"' & @CRLF & _
			'HOST: 239.255.255.250:1900' & @CRLF & _
			@CRLF
	Local $UPNPsendSocket, $UPNPreceiveSocket
	Local $SendCounter = 0, $ReceiveCounter = 0
	Local $ReceiveData
	Local $StartTimeoutTimer, $UsedTimeoutTicks ; Timeout-Timer
	Local $StartSendTimer, $UsedSendTicks ; Send-Timer
	Local $OldRemainSeconds = -99, $RemainSeconds
	Local $return = 1, $error = 0

	; Arrays "lschen"
	$ResponsesArray = ""

	; UPnP-Kommando ausgeben
	ConsoleWrite(@CRLF)
	ConsoleWrite("UPnP-Kommando:" & @CRLF)
	ConsoleWrite($UPnPcmd & @CRLF)

	; UDP starten
	UDPStartup()

	; - Sender -
	;    $array[1] contains the real socket, $array[2] contains the specified IP address and $array[3] contains the port
	$UPNPsendSocket = UDPOpen("239.255.255.250", 1900)
	ConsoleWrite("SendSocket: real socket: " & $UPNPsendSocket[1] & ", IP-address: " & $UPNPsendSocket[2] & ", port: " & $UPNPsendSocket[3] & @CRLF & @CRLF)
	; _ArrayDisplay($UPNPsendSocket)
	If $UPNPsendSocket[0] == -1 Or $UPNPsendSocket[0] == 0 Then ; documentation is somewhat vague
		; Error 1
		Return SetError(1, 0, 0)
	EndIf

	; - Empfnger -
	; Socket mu der gleiche sein, sonst geht es nicht. Allerdings funktioniert es nicht auf Win 7-Rechnern mit mehreren Netzwerkkarten :-(
	$UPNPreceiveSocket = $UPNPsendSocket

	; Timer setzen
	$StartTimeoutTimer = TimerInit() ; Timeout-Timer
	$StartSendTimer = -99 ; Notlsung, kann man schner programmieren

	While 1

		; SenderPause berechnen
		If $StartSendTimer = -99 Then
			; Timer wurde bisher noch nicht gesetzt, daher UsedTicks setzen
			$UsedSendTicks = $SendIntervalInTicks + 10
		Else
			; Berechnen
			$UsedSendTicks = TimerDiff($StartSendTimer)
		EndIf

		; Senden
		If $UsedSendTicks > $SendIntervalInTicks Then
			$SendCounter += 1
			ConsoleWrite("UPnP Send Count Nr " & $SendCounter & @CRLF & @CRLF)
			UDPSend($UPNPsendSocket, $UPnPcmd)
			If @error <> 0 Then
				$error = 2
				$return = 0
				ExitLoop
			EndIf
			; reset timer
			$StartSendTimer = TimerInit()
		EndIf

		; kurze Pause (nach dem Senden)
		Sleep(100)

		; Empfangen
		$ReceiveData = UDPRecv($UPNPreceiveSocket, 1024)
		If @error <> 0 Then
			$error = 3
			$return = 0
			ExitLoop
		EndIf
		If $ReceiveData <> "" Then
			$ReceiveCounter += 1
			ConsoleWrite("-------------------- Received Response " & $ReceiveCounter & ":" & " --------------------" & @CRLF)
			ConsoleWrite($ReceiveData & @CRLF)
			; Wenn neue Responds, dann hinzuggen
			If AddItemToArray($ResponsesArray, $ReceiveData, 1) > 0 Then
				ConsoleWrite("+> added" & @CRLF & @CRLF)
			Else
				ConsoleWrite("-> still available" & @CRLF & @CRLF)
			EndIf
		EndIf

		; Verbrauchte Zeit ermitteln
		$UsedTimeoutTicks = TimerDiff($StartTimeoutTimer)
		; Wenn die Zeit verstrichen ist, dann raus
		If $UsedTimeoutTicks >= $TicksToSearch Then
			ExitLoop
		Else
			; Restsekunden berechnen und als TrayTip ausgeben
			$RemainSeconds = Ceiling(($TicksToSearch - $UsedTimeoutTicks) / 1000)
			If $RemainSeconds <> $OldRemainSeconds Then
				TrayTip("SSDP-Discover", "Search for devices via UPnP (" & $RemainSeconds & " seconds)... ", 5, 1)
				$OldRemainSeconds = $RemainSeconds
			EndIf
		EndIf
	WEnd

	; TrayTip schliessen
	TrayTip("", "", 0)

	; Socket schliessen
	UDPCloseSocket($UPNPsendSocket)
	UDPCloseSocket($UPNPreceiveSocket)

	; UDP beenden
	UDPShutdown()

	; Sortieren
	If IsArray($ResponsesArray) Then _ArraySort($ResponsesArray, 0, 1)

	; Wenn error vorhanden, dann error zurckliefern
	If $error > 0 Then
		; error zurckliefern
		Return SetError($error, 0, $return)
	Else
		; Normaler Return
		Return $return
	EndIf

EndFunc   ;==>SSDPdiscover_V1




; Funktion, die ein Item an das Array (mit Zelle) hinzufgt und dabei den Counter in Zelle 0 um eins erhht
; Ist das Array noch leer, wird es angelegt. Es wird der Counter zurckgeliefert
; Wenn $OnlyIfNew = 1, dann wird vorher geschaut, ob es schon im Array vorhanden ist
Func AddItemToArray(ByRef $ArrayWithCounterCell, $value, $OnlyIfNew = 0) ; Fgt zum Array ein Item hinzu und erhht den Wert in Zelle 0. Ist das Array leer, wird eines erzeugt

	; Schauen, ob es ein Array ist. Wenn nicht, dann wird es angelegt und der Wert hinzugefgt
	If IsArray($ArrayWithCounterCell) Then
		; es ist ein Array
		; ggf. schauen, ob es bereits enthalten ist
		If $OnlyIfNew == 1 Then
			; Raus, wenn es bereist enthalten ist, also grer als 0
			If _ArraySearch($ArrayWithCounterCell, $value, 1) > 0 Then
				Return 0
			EndIf
		EndIf

		; Element hinzufgen
		Local $ret = _ArrayAdd($ArrayWithCounterCell, $value)
		; wenn ungleich -1 dann den Counter erhhen
		If $ret <> -1 Then
			; um 1 erhhren in Zelle 0
			Local $Count = $ArrayWithCounterCell[0] + 1
			$ArrayWithCounterCell[0] = $Count
			; Index, also Count zurckliefern
			Return $Count
		Else
			Return -1
		EndIf
	Else
		; Es ist kein Array, daher erzeugen und Wert hinzufgen
		Dim $ArrayWithCounterCell[2]
		$ArrayWithCounterCell[0] = 1
		$ArrayWithCounterCell[1] = $value
		Return 1
	EndIf

EndFunc   ;==>AddItemToArray
#endregion Funktionsdefinitionen