#Include <GUIConstantsEx.au3>
#Include <TreeViewConstants.au3>
#Include <WindowsConstants.au3>
#Include <StructureConstants.au3>

Opt("GUICloseOnESC",  0)
Opt("GUIOnEventMode", 1)

; MAIN GUI ---------------------------------------------------------------------
Global $GUIMain_iWidth  = 300
Global $GUIMain_iHeight = 200

Global $GUIMain = GUICreate(@AutoItVersion, $GUIMain_iWidth, $GUIMain_iHeight)
GUISetOnEvent($GUI_EVENT_CLOSE, "mainExit", $GUIMain)
GUISetState(@SW_SHOW, $GUIMain)

Global $GUIMain_TreeView = GUICtrlCreateTreeView(5, 5, $GUIMain_iWidth - 10, $GUIMain_iHeight - 10, $TVS_HASBUTTONS + $TVS_HASLINES + $TVS_LINESATROOT + $TVS_DISABLEDRAGDROP + $TVS_SHOWSELALWAYS + $TVS_NONEVENHEIGHT, $WS_EX_CLIENTEDGE)
Global $GUIMain_TreeView_hWnd = GUICtrlGetHandle($GUIMain_TreeView)
GUICtrlCreateTreeViewItem("SUBKEY", GUICtrlCreateTreeViewItem("ROOT", $GUIMain_TreeView))

; CHILD GUI --------------------------------------------------------------------
Global $GUIChild_iWidth  = 150
Global $GUIChild_iHeight = 75

Global $GUIChild = GUICreate("Child", $GUIChild_iWidth, $GUIChild_iHeight, Default, Default, $WS_OVERLAPPEDWINDOW, Default, $GUIMain)
GUISetOnEvent($GUI_EVENT_CLOSE, "childHide", $GUIChild)

; EVENT FUNCTIONS --------------------------------------------------------------
Func childHide()
	GUISetState(@SW_HIDE, $GUIChild)
EndFunc

Func childShow()
	WinMove($GUIChild, "", Default, Default)
	GUISetState(@SW_SHOW, $GUIChild)
EndFunc

Func mainExit()
	Exit
EndFunc

; WM_NOTIFY HANDLER ------------------------------------------------------------
GUIRegisterMsg($WM_NOTIFY, "WM_NOTIFY")

Func WM_NOTIFY($hWnd, $Msg, $wParam, $lParam)
	Local $tNMHDR = DllStructCreate($tagNMHDR, $lParam)

	Switch DllStructGetData($tNMHDR, "hWndFrom")
		Case $GUIMain_TreeView_hWnd
			Switch DllStructGetData($tNMHDR, "Code")
				Case $NM_DBLCLK
					Return 1 + childShow()
			EndSwitch
	EndSwitch

	Return $GUI_RUNDEFMSG
EndFunc

; WM_GETMINMAXINFO HANDLER -----------------------------------------------------
GUIRegisterMsg($WM_GETMINMAXINFO, "WM_GETMINMAXINFO")

Func WM_GETMINMAXINFO($hWnd, $vMsg, $wParam, $lParam)
	Return $GUI_RUNDEFMSG
EndFunc

; MAIN LOOP --------------------------------------------------------------------
While 1
	Sleep(1000)
WEnd
