#AutoIt3Wrapper_Version=Prod		; (=beta/prod)
#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>
#include <ButtonConstants.au3>


Global $width=700, $height=580
Global $styles[4][2] = [[0, "Default"], [$BS_LEFT, "Left"], [$BS_CENTER, "Center"], [$BS_RIGHT, "Right"] ]


_Main()

Func _Main()

    Local $msg, $ids

    GUICreate("Demo", $width, $height, 50, 10, $WS_POPUP+$WS_SYSMENU)
    GUISetBkColor(0x000000)
    GUISetFont (10, 500)

    $ids = CreateButtons (False, False, "Create",                                       "Correct")
    $ids = CreateButtons (False, True,  "Create; SetColour",                            "Left/Right wrong 3.3.8.1;     Center/Right wrong 3.3.12.0/3.3.13.19")
    $ids = CreateButtons (True, False,  "Create; ChangeStyle",                          "Correct")
    $ids = CreateButtons (True, True,   "Create; ChangeStyle; SetColour",               "Left/Right wrong 3.3.8.1;     Center/Right wrong 3.3.12.0/3.3.13.19")


    GUICtrlSetDefBkColor(0x004040)
    GUICtrlSetDefColor(0xFFFFFF)
    $ids = CreateButtons (False, False, "SetDefColour; Create",                         "Left/Right wrong 3.3.8.1;     Center/Right wrong 3.3.12.0/3.3.13.19")
    $ids = CreateButtons (False, True,  "SetDefColour; Create; SetColour",              "Left/Right wrong 3.3.8.1;     Center/Right wrong 3.3.12.0/3.3.13.19")
    $ids = CreateButtons (True, False,  "SetDefColour; Create; ChangeStyle",            "Colours wrong 3.3.8.1/3.3.12.0/3.3.13.19")
    $ids = CreateButtons (True, True,   "SetDefColour; Create; ChangeStyle; SetColour", "Left/Right wrong 3.3.8.1;     Center/Right wrong 3.3.12.0/3.3.13.19")


    GUISetState()
    $msg = 0

    While $msg <> $GUI_EVENT_CLOSE
        $msg = GUIGetMsg ()
        If $msg > 0 Then ExitLoop
    WEnd

    GUIDelete()

    Exit
EndFunc   ;==>_Main


Func CreateButtons ( $fChgStyle, $fChgColour, $sDesc, $sResult )

    Local $gx=8, $dx=Int($width/UBound($styles)),  $bw=$dx-2*$gx
    Local $gy=3, $dy=Int($height/8), $bh=Int (($dy-5*$gy)/3)
    Local $ids[4]
    Static $y=0

    $y += $gy*2
    GUICtrlCreateButton ( $sDesc & @LF & $sResult, $gx, $y, $width-2*$gx, 2*$bh, $BS_MULTILINE )
    GUICtrlSetBkColor ( -1, 0x000000 )
    GUICtrlSetColor   ( -1, 0xffffff )

    $y += 2*$bh+$gy
    For $i = 0 To UBound($styles)-1
        $ids[$i] = GUICtrlCreateButton ( $styles[$i][1],  $gx+$i*$dx, $y, $bw, $bh, $styles[$i][0] )
        If $fChgStyle  Then GUICtrlSetStyle   ( $ids[$i], $Styles[$i][0] )
        If $fChgColour Then GUICtrlSetBkColor ( $ids[$i], 0x005020 )
    Next

    $y += $bh+$gy*2
EndFunc   ;==>CreateButtons
