; #FUNCTION# ====================================================================================================================
; Name...........: _ArrayTranspose
; Description ...: Transposes a 2D array (swaps rows and columns)
; Syntax.........: _ArrayTranspose(ByRef $avArray)
; Parameters ....: $avArray - Array to modify
; Return values .: Success - 1
;                  Failure - 0, sets @error
;                  |1 - $avArray is not a 2D array
; Author ........: jchd
; Modified.......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: Yes
; ===============================================================================================================================
Func _ArrayTranspose(ByRef $avArray)
    If UBound($avArray, 0) <> 2 Then Return SetError(1, 0, 0)

	Local $vElement, $iDim_1 = UBound($avArray, 1), $iDim_2 = UBound($avArray, 2), $iDim_Max = $iDim_2
	If $iDim_1 > $iDim_2 Then $iDim_Max = $iDim_1

    ReDim $avArray[$iDim_Max][$iDim_Max]
    For $i = 0 To $iDim_Max - 2
        For $j = $i + 1 To $iDim_Max - 1
            $vElement = $avArray[$i][$j]
            $avArray[$i][$j] = $avArray[$j][$i]
            $avArray[$j][$i] = $vElement
        Next
    Next
    ReDim $avArray[$iDim_2][$iDim_1]
	Return 1
EndFunc