; right click on gui to bring up context Menu.
; right click on the "ok" button to bring up a controll specific context menu.

#include <GUIConstantsEx.au3>
#include <ButtonConstants.au3>
#include <MsgBoxConstants.au3>


Example()

Func Example()
	GUICreate("My GUI Context Menu", 300, 200)

	Local $contextmenu = GUICtrlCreateContextMenu()

	Local $newsubmenu = GUICtrlCreateMenu("new", $contextmenu)
	GUICtrlCreateMenuItem("text", $newsubmenu)

	Local $button = GUICtrlCreateButton("OK", 100, 100, 70, 20)
	Local $buttoncontext = GUICtrlCreateContextMenu($button)
	local $MenuAbout = GUICtrlCreateMenuItem("About button", $buttoncontext)

	local $MenuOpen = GUICtrlCreateMenuItem("Open", $contextmenu)
	local $MenuSave = GUICtrlCreateMenuItem("Save", $contextmenu)
	GUICtrlCreateMenuItem("", $contextmenu) ; separator

	local $MenuInfo = GUICtrlCreateMenuItem("Info", $contextmenu)

	GUISetState()

	; Run the GUI until the dialog is closed
	While 1
		Local $msg = GUIGetMsg()

		If $msg = $GUI_EVENT_CLOSE Then ExitLoop
		If $msg = $MenuAbout Then MsgBox($MB_SYSTEMMODAL, "Menu Selected", 'About')
		If $msg = $MenuOpen Then MsgBox($MB_SYSTEMMODAL, "Menu Selected", 'Open')
		If $msg = $MenuSave Then MsgBox($MB_SYSTEMMODAL, "Menu Selected", 'Save')
		If $msg = $MenuInfo Then MsgBox($MB_SYSTEMMODAL, "Menu Selected", 'Info')
	WEnd
	GUIDelete()
EndFunc   ;==>Example
