; I am the server, start me first!

#include <MsgBoxConstants.au3>
#include <FileConstants.au3>

Example()

Func Example()
    TCPStartup()

    OnAutoItExitRegister("OnAutoItExit")

    Local $iError = 0

    Local $sIPAddress = "127.0.0.1"
    Local $iPort = 65432

    Local $iListenSocket = TCPListen($sIPAddress, $iPort, 100)

    If @error Then
        $iError = @error
        MsgBox(BitOR($MB_SYSTEMMODAL, $MB_ICONHAND), "", "Server:" & @CRLF & "Could not listen, Error code: " & $iError)
        Return False
    EndIf

    Local $iSocket = 0

    Do
        $iSocket = TCPAccept($iListenSocket)

        If @error Then
            $iError = @error
            MsgBox(BitOR($MB_SYSTEMMODAL, $MB_ICONHAND), "", "Server:" & @CRLF & "Could not accept the incoming connection, Error code: " & $iError)
            Return False
        EndIf
    Until $iSocket <> -1

    TCPCloseSocket($iListenSocket)

    Local $iFileSize = 0, $hFile = 0, $iOffset = 0, $bData = ""
    Local Const $i4KiB = 4096

    #region Added
    Local $aFilePath[3] = ["test1.txt", "test2.txt", "test3.txt"]

    For $i = 0 To UBound($aFilePath) - 1
        #endregion Added
        $iFileSize = FileGetSize($aFilePath[$i])

        $hFile = FileOpen($aFilePath[$i], $FO_BINARY)

        Do
            FileSetPos($hFile, $iOffset, $FILE_BEGIN)

            TCPSend($iSocket, FileRead($hFile, $i4KiB))

            If @error Then
                $iError = @error
                TCPCloseSocket($iSocket)
                MsgBox(BitOR($MB_SYSTEMMODAL, $MB_ICONHAND), "", "Server:" & @CRLF & "Could not send the data, Error code: " & $iError)
                Return False
            EndIf

            $iOffset += $i4KiB
        Until $iOffset >= $iFileSize

        FileClose($hFile)

        TCPSend($iSocket, @CRLF & "{EOF}")
FileWriteLine("toto.txt", "[" & @MIN & ":" & @MSEC & "]serv: send EOF")

;~         MsgBox($MB_SYSTEMMODAL, "", "Server:" & @CRLF & "File sent.")

        #region Added
        Do
            $bData = TCPRecv($iSocket, 9, 1) ; 9 = Length of: @CRLF{EOFOK}
            If @error Then
                $iError = @error
FileWriteLine("toto.txt", "[" & @MIN & ":" & @MSEC & "]serv: error")
                MsgBox(BitOR($MB_SYSTEMMODAL, $MB_ICONHAND), "", "Server:" & @CRLF & "Connection lost, Error code: " & $iError)
                Return False
            EndIf

            If BinaryLen($bData) = 0 Then
                Sleep(10) ; Avoid High CPU usage.
                ContinueLoop
            EndIf
        Until BinaryToString($bData) = @CRLF & "{EOFOK}"
FileWriteLine("toto.txt", "[" & @MIN & ":" & @MSEC & "]serv: recv EOFOK")

        ; Reset variables that needs to be reseted.
        $iOffset = 0
    Next

    TCPSend($iSocket, @CRLF & "{EOT}") ; EOT stands for End Of Transfer (this is a code, choose what you want).
    #endregion Added

    TCPCloseSocket($iSocket)
EndFunc   ;==>Example

Func OnAutoItExit()
    TCPShutdown()
EndFunc   ;==>OnAutoItExit