; I am the client, start me after the server!

#include <MsgBoxConstants.au3>
#include <FileConstants.au3>

Example()

Func Example()
    TCPStartup()

    OnAutoItExitRegister("OnAutoItExit")

    Local $sIPAddress = "127.0.0.1"
    Local $iPort = 65432

    Local $iSocket = TCPConnect($sIPAddress, $iPort)
    Local $iError = 0

    If @error Then
        $iError = @error
        MsgBox(BitOR($MB_SYSTEMMODAL, $MB_ICONHAND), "", "Client:" & @CRLF & "Could not connect, Error code: " & $iError)
        Return False
    EndIf

    Local $hFile = 0

    Local Const $i4KiB = 4096, $bEOF = Binary(@CRLF & "{EOF}"), $iEOFLen = BinaryLen($bEOF)

    Local $bData = ""

    Local $iDataLen = 0

    Local $fEOFReached = False

    #region Added
    Local $bData2 = ""

    Local $aFilePath[3] = ["test1[2].txt", "test2[2].txt", "test3[2].txt"]

    For $i = 0 To UBound($aFilePath) -1
        #endregion Added
        $hFile = FileOpen($aFilePath[$i], BitOR($FO_BINARY, $FO_OVERWRITE))

        Do
            #region Added
            If $bData2 <> "" Then
                $bData = $bData2
                $bData2 = ""
            Else
                #endregion Added
                $bData = TCPRecv($iSocket, $i4KiB, 1)

                If @error Then
                    $iError = @error
                    MsgBox(BitOR($MB_SYSTEMMODAL, $MB_ICONHAND), "", "Client:" & @CRLF & "Connection lost, Error code: " & $iError)
                    Return False
                EndIf
            EndIf
            $iDataLen = BinaryLen($bData)

            If $iDataLen = 0 Then ContinueLoop

            If BinaryMid($bData, 1 + $iDataLen - $iEOFLen, $iEOFLen) = $bEOF Then
                $bData = BinaryMid($bData, 1, $iDataLen - $iEOFLen)

                $fEOFReached = True
            EndIf

            FileWrite($hFile, $bData)
        Until $fEOFReached

        FileClose($hFile)

        TCPSend($iSocket, @CRLF & "{EOFOK}") ; Tell the server the file is successfuly received.
FileWriteLine("toto.txt", "[" & @MIN & ":" & @MSEC & "]client: send EOFOK")

        Do
            $bData2 = TCPRecv($iSocket, $i4KiB, 1)
            ; If an error occured - the server is not sending more files - display a message and return True
            If @error Then
FileWriteLine("toto.txt", "[" & @MIN & ":" & @MSEC & "]client: error?")

                TCPCloseSocket($iSocket)
                MsgBox($MB_SYSTEMMODAL, "", "Client:" & @CRLF & "Files received.")
                Return True
            EndIf

            Sleep(10) ; Avoid high CPU usage.
        Until BinaryLen($bData2) > 0

        ; Reset variables that needs to be reseted.
        $fEOFReached = False
    Next

    TCPCloseSocket($iSocket)
EndFunc   ;==>Example

Func OnAutoItExit()
    TCPShutdown()
EndFunc   ;==>OnAutoItExit