#include <GuiConstantsEx.au3>
#include <WindowsConstants.au3>
#include <GuiListView.au3>
#include <HeaderConstants.au3>
#include <WinAPI.au3>

; The 0-based column to be disabled
Global $iFix_Col
Global $hOld_WndProc
; Get new WndProc hamdle and pointer
Global $hNew_WndProc = DllCallbackRegister("_New_LVHdr_Proc", "lresult", "hwnd;uint;wparam;lparam")
Global $pNew_WndProc = DllCallbackGetPtr($hNew_WndProc)
; To save old WndProc handle
Global $hOld_WndProc

_Main()

Func _Main()
	Local Const $hGUI = GUICreate("ListView Fix Column Width", 400, 300)

	Local Const $cListView = GUICtrlCreateListView("Column 0|Column 1|Column 2|Column 3", 10, 10, 380, 220)
	GUICtrlCreateListViewItem("0|1|2|3", $cListView)

	Global $hLVHdr = _GUICtrlListView_GetHeader($cListView)

	$cButton = GUICtrlCreateButton("Test", 10, 250, 80, 30)

	GUISetState()

	; Prevent resizing of column 1
	$iFix_Col = 1

	; Prevent drag resize
	GUIRegisterMsg($WM_NOTIFY, "_WM_NOTIFY")

	; SubClass LV Header
	$hOld_WndProc = _WinAPI_SetWindowLong($hLVHdr, $GWL_WNDPROC, $pNew_WndProc)
	ConsoleWrite("Old proc: 0x" & Hex($hOld_WndProc, 8) & @CRLF)

	; Loop until user exits
	While 1
		Switch GUIGetMsg()
			Case $GUI_EVENT_CLOSE
				Exit
			Case $cButton
				ConsoleWrite("Pressed" & @CRLF)
		EndSwitch
	WEnd

	GUIDelete($hGUI)
EndFunc   ;==>_Main

Func _WM_NOTIFY($hWnd, $iMsg, $wParam, $lParam)

	; Get details of message
	Local $tNMHEADER = DllStructCreate($tagNMHEADER, $lParam)
	; Look for header resize code
	$iCode = DllStructGetData($tNMHEADER, "Code")
	Switch $iCode
		Case $HDN_BEGINTRACKW
			; Now get column being resized
			Local $iCol = DllStructGetData($tNMHEADER, "Item")
			If $iCol = $iFix_Col Then
				; Prevent resizing
				Return True
			Else
				; Allow resizing
				Return False
			EndIf
	EndSwitch

EndFunc   ;==>_WM_NOTIFY

Func _New_LVHdr_Proc($hWnd, $iMsg, $wParam, $lParam)

	Switch $iMsg
		Case $WM_SETCURSOR
			Return True
	EndSwitch

	; Now call previous WndProc and complete the chain
	Return _WinAPI_CallWindowProc($hOld_WndProc, $hWnd, $iMsg, $wParam, $lParam)
	;Return CallWindowProc($hOld_WndProc, $hWnd, $iMsg, $wParam, $lParam)
EndFunc   ;==>_New_LVHdr_Proc

Func CallWindowProc($lpPrevWndFunc, $hWnd, $Msg, $wParam, $lParam)
	Return DllCall("user32.dll", "lresult", "CallWindowProc", "ptr", $lpPrevWndFunc, "hwnd", $hWnd, "uint", $Msg, "wparam", $wParam, "lparam", $lParam)[0]
EndFunc   ;==>CallWindowProc