#include <MsgBoxConstants.au3>

Example()

Func Example()
	TCPStartup()

	OnAutoItExitRegister("OnAutoItExit")

	Local $sIPAddress = "127.0.0.1"
	Local $iPort = 65432

	Local $iListenSocket = TCPListen($sIPAddress, $iPort, 100)
	Local $iError = 0

	If @error Then
		$iError = @error
		MsgBox(BitOR($MB_SYSTEMMODAL, $MB_ICONHAND), "", "Server: Could not listen, Error code: " & $iError)
		Return False
	EndIf

	Local $iSocket = 0
	Do
		$iSocket = TCPAccept($iListenSocket)

		If @error Then
			$iError = @error
			MsgBox(BitOR($MB_SYSTEMMODAL, $MB_ICONHAND), "", "Server: Could not accept the incoming connection, Error code: " & $iError)
			Return False
		EndIf
	Until $iSocket <> -1

;~ 	TCPCloseSocket($iListenSocket)

	MsgBox(0, "", "Hello !")

	TCPCloseSocket($iSocket)
EndFunc   ;==>Example

Func OnAutoItExit()
	TCPShutdown()
EndFunc   ;==>OnAutoItExit
