#include <MsgBoxConstants.au3>

Example()

Func Example()
	TCPStartup()

	OnAutoItExitRegister("OnAutoItExit")

	Local $sIPAddress = "127.0.0.1"
	Local $iPort = 65432

	Local $iSocket = TCPConnect($sIPAddress, $iPort)
	Local $iError = 0

	If @error Then
		$iError = @error
		MsgBox(BitOR($MB_SYSTEMMODAL, $MB_ICONHAND), "", "Client:" & @CRLF & "Could not connect, Error code: " & $iError)
		Return False
	EndIf

	Local $sData = ""

	Do
		$sData = TCPRecv($iSocket, 7)

		If @error Then
			$iError = @error

			Local $aRet = DllCall("Ws2_32.dll", "int", "WSAGetLastError")

			MsgBox(BitOR($MB_SYSTEMMODAL, $MB_ICONHAND), "", "Client:" & @CRLF & "Connection lost, Error code: " & $iError & _
					@CRLF & "WSAError: " & $aRet[0])
			Return False
		EndIf
	Until $sData = "{READY}"

	MsgBox($MB_SYSTEMMODAL, "", "Client:" & @CRLF & "Success.")

	TCPCloseSocket($iSocket)
EndFunc   ;==>Example

Func OnAutoItExit()
	TCPShutdown()
EndFunc   ;==>OnAutoItExit
